/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.planning.ISOPFacade;
import com.kingdee.eas.mm.planning.SOPEditModeEnum;
import com.kingdee.eas.mm.planning.SOPFacadeFactory;
import com.kingdee.eas.mm.planning.SOPPeriod;
import com.kingdee.eas.mm.planning.SOPPlannedTypeEnum;
import com.kingdee.eas.mm.planning.SOPSysParams;
import com.kingdee.eas.mm.planning.client.AbstractSopPlanTranferFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class SopPlanTranferFilterUI
extends AbstractSopPlanTranferFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(SopPlanTranferFilterUI.class);
    private SOPPeriod[] periodItem = null;
    private SOPPeriod sopWeekPeriod = null;
    private SOPPeriod sopMonthPeriod = null;
    private SOPSysParams sysParams = null;
    private int wPeriod = 1;
    private int mPeriod = 1;
    private String storageOrgUnitId;
    private CustomerParams cp = null;

    public SOPSysParams getSysParams() {
        return this.sysParams;
    }

    public SopPlanTranferFilterUI() throws Exception {
        this.prmtStorageOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageItemQuery");
        this.prmtStorageOrgUnit.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                SopPlanTranferFilterUI.this.prmtStorageOrgUnit_dataChanged(eventObj);
            }
        });
        this.prmtMatFrom.setEditFormat("$number");
        this.prmtMatFrom.setDisplayFormat("$name");
        this.prmtMatFrom.setCommitFormat("$number");
        this.prmtMatFrom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                SopPlanTranferFilterUI.this.objectWillShow(e);
            }
        });
        this.prmtMatTo.setEditFormat("$number");
        this.prmtMatTo.setDisplayFormat("$name");
        this.prmtMatTo.setCommitFormat("$number");
        this.prmtMatTo.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                SopPlanTranferFilterUI.this.objectWillShow(e);
            }
        });
        this.cmbEditMode.removeAllItems();
        this.cmbEditMode.addItems(new Object[]{SOPEditModeEnum.MONTHLY, SOPEditModeEnum.WEEKLY});
        this.cmbPlanType.removeAllItems();
        this.cmbPlanType.addItems(new Object[]{SOPPlannedTypeEnum.PRODUCT_PLAN, SOPPlannedTypeEnum.SALEPLAN});
        UIHelper.registerBizMaterialForSOPF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMatFrom, (OrgUnitInfo)((StorageOrgUnitInfo)this.getMainBizOrgF7().getValue()));
        UIHelper.registerBizMaterialForSOPF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMatTo, (OrgUnitInfo)((StorageOrgUnitInfo)this.getMainBizOrgF7().getValue()));
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement element = new SingleFilterElement("materialFrom", (Component)this.prmtMatFrom);
        element.setCompareType(CompareType.GREATER_EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("materialTo", (Component)this.prmtMatTo);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        MMUtils.filterRangF7Helper((Component)this.prmtMatFrom, (Component)this.prmtMatTo);
        element = new SingleFilterElement("storageOrgUnit", (Component)this.prmtStorageOrgUnit);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        this.getFilterManager().setMainOrgElement((FilterElement)element, this.getPropertyOfMainBizOrg());
        element = new SingleFilterElement("periodBegin", (Component)this.tfPeriod);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("periodCount", (Component)this.spnPeriodCount);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("planType", (Component)this.cmbPlanType);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("chkDeleteReq", (Component)this.chkDeleteReq);
        element.setCompareType(CompareType.EQUALS);
        elements.add((FilterElement)element);
        element = new SingleFilterElement("editMode", (Component)this.cmbEditMode);
        element.setCompareType(CompareType.LESS_EQUALS);
        elements.add((FilterElement)element);
        this.f7Manager.registerContextChangeF7(this.prmtMatFrom, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.prmtMatTo, "storageOrgUnit.id");
        this.getFilterManager().setElement((FilterElement)elements);
        this.prmtSupplyStorageOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery");
        this.prmtSupplyStorageOrgUnit.setEditFormat("$number");
        this.prmtSupplyStorageOrgUnit.setDisplayFormat("$name");
        this.prmtSupplyStorageOrgUnit.setCommitFormat("$number");
        this.prmtSupplyStorageOrgUnit.setEnabledMultiSelection(true);
        EntityViewInfo orgUnitView = new EntityViewInfo();
        FilterInfo orgFilterInfo = new FilterInfo();
        orgFilterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Integer(1), CompareType.EQUALS));
        orgUnitView.setFilter(orgFilterInfo);
        this.prmtSupplyStorageOrgUnit.setEntityViewInfo(orgUnitView);
    }

    private void prmtStorageOrgUnit_dataChanged(DataChangeEvent eventObj) {
        ISOPFacade iSopFacade = null;
        try {
            iSopFacade = SOPFacadeFactory.getRemoteInstance();
            String storageOrgUnitID = null;
            if (this.getUIContext().get("org") != null) {
                storageOrgUnitID = this.getUIContext().get("org").toString();
            } else {
                if (this.getMainBizOrgF7().getValue() == null) {
                    return;
                }
                storageOrgUnitID = this.getMainBizOrgF7().getValue() instanceof FullOrgUnitInfo ? ((FullOrgUnitInfo)this.getMainBizOrgF7().getValue()).getId().toString() : ((StorageOrgUnitInfo)this.getMainBizOrgF7().getValue()).getId().toString();
            }
            if (!storageOrgUnitID.equals(this.storageOrgUnitId)) {
                this.storageOrgUnitId = storageOrgUnitID;
                this.sysParams = iSopFacade.getSOPSysParams(storageOrgUnitID);
                if (this.sysParams == null) {
                    MsgBox.showInfo((String)this.getSOPResource("THE_OQG_HAS_NOT_PAREMS"));
                    SysUtil.abort();
                }
                if (this.sysParams.getSOPTransferAverage()) {
                    this.chkDeleteReq.setEnabled(false);
                } else {
                    this.chkDeleteReq.setEnabled(true);
                }
                this.sopMonthPeriod = iSopFacade.getCurrentPeriod(SOPEditModeEnum.MONTHLY, this.storageOrgUnitId);
                this.sopWeekPeriod = iSopFacade.getCurrentPeriod(SOPEditModeEnum.WEEKLY, this.storageOrgUnitId);
                this.mPeriod = this.sysParams.getSOPMonthHorizon();
                this.wPeriod = this.sysParams.getSOPWeekHorizon();
                this.periodItem = this.sopMonthPeriod.forwardPeriods(this.mPeriod);
                this.cmbPeriodBegin.removeAllItems();
                this.cmbPeriodBegin.addItems((Object[])this.periodItem);
                this.cmbPeriodBegin.setSelectedItem((Object)this.periodItem[0]);
                this.setDefaultPeriods();
                this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.MONTHLY);
                this.setSpinnerMaxMin((JSpinner)this.spnPeriodCount, 1, this.mPeriod);
                this.cmbPlanType.setSelectedItem((Object)SOPPlannedTypeEnum.PRODUCT_PLAN);
                this.tfPeriod.setText(((SOPPeriod)this.cmbPeriodBegin.getSelectedItem()).toString());
                return;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setDefaultPeriods() {
        this.setSpinnerMaxMin((JSpinner)this.spnPeriodCount, 1, this.mPeriod);
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.cmbEditMode.setSelectedItem((Object)SOPEditModeEnum.MONTHLY);
        this.cmbPlanType.setSelectedItem((Object)SOPPlannedTypeEnum.PRODUCT_PLAN);
        this.prmtSupplyStorageOrgUnit.setValue(null);
        this.setDefaultPeriods();
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.getMainBizOrg(), (OrgType)OrgType.Storage, (String)"mm_soptransfer");
    }

    private void setSpinnerMaxMin(JSpinner spinner, int min, int max) {
        SpinnerModel model = spinner.getModel();
        if (model instanceof SpinnerNumberModel && max >= min) {
            ((SpinnerNumberModel)model).setValue(new Integer(1));
            ((SpinnerNumberModel)model).setMaximum(new Integer(max));
            ((SpinnerNumberModel)model).setMinimum(new Integer(min));
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getViewPermission() {
        return "mm_soptransfer";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.client.PlanningResource", (String)strKey);
    }

    public String getSOPResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.planning.SOPResource", (String)strKey);
    }

    private void cmbEditMode_Change(ItemEvent e) {
        if (e.getItem().equals((Object)SOPEditModeEnum.MONTHLY)) {
            if (this.sopMonthPeriod == null) {
                return;
            }
            this.periodItem = this.sopMonthPeriod.forwardPeriods(this.mPeriod);
            this.setSpinnerMaxMin((JSpinner)this.spnPeriodCount, 1, this.mPeriod);
        } else if (e.getItem().equals((Object)SOPEditModeEnum.WEEKLY)) {
            if (this.sopWeekPeriod == null) {
                return;
            }
            this.periodItem = this.sopWeekPeriod.forwardPeriods(this.wPeriod);
            this.setSpinnerMaxMin((JSpinner)this.spnPeriodCount, 1, this.wPeriod);
        }
        this.cmbPeriodBegin.removeAllItems();
        this.cmbPeriodBegin.addItems((Object[])this.periodItem);
        this.tfPeriod.setText(((SOPPeriod)this.cmbPeriodBegin.getSelectedItem()).toString());
    }

    private void cmbPeriodBegin_Change(ItemEvent e) {
        if (this.cmbPeriodBegin.getSelectedItem() != null) {
            this.tfPeriod.setText(((SOPPeriod)this.cmbPeriodBegin.getSelectedItem()).toString());
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setSpinnerMaxMin((JSpinner)this.spnPeriodCount, 1, this.mPeriod);
        this.cmbEditMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SopPlanTranferFilterUI.this.cmbEditMode_Change(e);
            }
        });
        this.cmbPeriodBegin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SopPlanTranferFilterUI.this.cmbPeriodBegin_Change(e);
            }
        });
        this.cmbPeriodBegin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SopPlanTranferFilterUI.this.cmbEditMode.getSelectedItem() == null) {
                    return;
                }
                if (SopPlanTranferFilterUI.this.cmbPeriodBegin.getSelectedItem() == null) {
                    return;
                }
                int horizon = SopPlanTranferFilterUI.this.wPeriod;
                if (SOPEditModeEnum.MONTHLY.equals(SopPlanTranferFilterUI.this.cmbEditMode.getSelectedItem())) {
                    horizon = SopPlanTranferFilterUI.this.mPeriod;
                }
                int selectIndex = SopPlanTranferFilterUI.this.cmbPeriodBegin.getSelectedIndex();
                SopPlanTranferFilterUI.this.spnPeriodCount.setValue((Object)new Integer(horizon - selectIndex));
                SopPlanTranferFilterUI.this.setSpinnerMaxMin((JSpinner)SopPlanTranferFilterUI.this.spnPeriodCount, 1, horizon - selectIndex);
            }
        });
        SCMClientUtils.setMainBizOrgF7((KDBizPromptBox)this.getMainBizOrg(), (OrgType)OrgType.Storage, (String)"mm_sopprodplan_view");
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
        SOPEditModeEnum editmode = null;
        if (Integer.parseInt(this.cp.getCustomerParam("cmbEditMode").toString()) == 20) {
            editmode = SOPEditModeEnum.MONTHLY;
        }
        if (Integer.parseInt(this.cp.getCustomerParam("cmbEditMode").toString()) == 10) {
            editmode = SOPEditModeEnum.WEEKLY;
        }
        StorageOrgUnitInfo info = new StorageOrgUnitInfo();
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        info.setId(unitInfo.getId());
        info.setName(unitInfo.getName());
        info.setNumber(unitInfo.getNumber());
        this.prmtStorageOrgUnit.setValue((Object)info);
        SOPPeriod selectePeriod = new SOPPeriod();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.cp.getDate("selectePeriod.beginDate"));
        selectePeriod.setBeginDate(calendar);
        calendar.setTime(this.cp.getDate("selectePeriod.endDate"));
        selectePeriod.setEndDate(calendar);
        selectePeriod.setNumber(this.cp.getInt("selectePeriod.number"));
        selectePeriod.setYear(this.cp.getInt("selectePeriod.year"));
        selectePeriod.setParamMonthStartDay(this.cp.getInt("selectePeriod.paramMonthStartDay"));
        selectePeriod.setType(editmode);
        this.cmbPeriodBegin.setSelectedItem((Object)selectePeriod);
        this.spnPeriodCount.setValue((Object)new Integer(this.cp.getInt("spnPeriodCount")));
        this.prmtSupplyStorageOrgUnit.setValue(null);
    }

    public RptParams getCustomCondition() {
        RptParams pp = super.getCustomCondition();
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        SOPPeriod selectePeriod = (SOPPeriod)this.cmbPeriodBegin.getSelectedItem();
        pp.putDate("selectePeriod.beginDate", selectePeriod.getBeginDate().getTime());
        pp.putDate("selectePeriod.endDate", selectePeriod.getEndDate().getTime());
        pp.putInt("selectePeriod.year", selectePeriod.getYear());
        pp.putInt("selectePeriod.number", selectePeriod.getNumber());
        pp.putInt("selectePeriod.paramMonthStartDay", selectePeriod.getParamMonthStartDay());
        pp.putInt("spnPeriodCount", ((Integer)this.spnPeriodCount.getValue()).intValue());
        return pp;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public boolean verify() {
        String orgToNum = this.prmtStorageOrgUnit.getText();
        if (this.prmtStorageOrgUnit.getData() == null && orgToNum != null && orgToNum.trim().length() > 0) {
            try {
                OrgUnitInfo orgReq = OrgUnitUtils.getOrgUnitInfoByNum(null, (String)orgToNum);
                StorageOrgUnitInfo storageOrg = new StorageOrgUnitInfo();
                storageOrg.setId(orgReq.getId());
                storageOrg.setName(orgReq.getName());
                storageOrg.setNumber(orgReq.getNumber());
                this.prmtStorageOrgUnit.setData((Object)storageOrg);
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)SopPlanTranferFilterUI.getResource("CANNOT_ALLOW_STORAGEORGUNIT_ISNULL"));
            return false;
        }
        if (this.sysParams == null) {
            MsgBox.showError((String)this.getSOPResource("THE_OQG_HAS_NOT_PAREMS"));
            return false;
        }
        return super.verify();
    }

    private void checkMainOrg(SelectorEvent e) {
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.report.PlannerResource.INPUT_STORAGOR"));
            e.setCanceled(true);
        }
    }

    protected String getPermissionItem(String status) {
        return "mm_sopprodplan_view";
    }

    protected void setMainBizOrgF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        String permissionItem = this.getPermissionItem(this.getOprtState());
        if (permissionItem != null) {
            iProducer.getModel().setPermissionItem(permissionItem);
        }
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
    }

    public void clear() {
        super.clear();
        this.setMyDefaultValue();
    }

    private CoreBaseInfo getf7DefaultValue(ICoreBase factory, String voId) {
        CoreBaseInfo vo = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)voId));
            view.setFilter(filter);
            CoreBaseCollection colEntity = factory.getCollection(view);
            if (colEntity.size() > 0) {
                vo = colEntity.get(0);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return vo;
    }

    protected void setMyDefaultValue() {
        try {
            SOPPlannedTypeEnum planType;
            IMaterial matEntity;
            CoreBaseInfo mat;
            String matId;
            SOPPeriod sopPeriod;
            SOPEditModeEnum editMode;
            String storageOrgUnitId = (String)this.getUIContext().get("org");
            if (storageOrgUnitId != null) {
                IStorageOrgUnit ctrlEntity = StorageOrgUnitFactory.getRemoteInstance();
                this.prmtStorageOrgUnit.setValue((Object)this.getf7DefaultValue((ICoreBase)ctrlEntity, storageOrgUnitId));
                this.prmtStorageOrgUnit.setEnabled(false);
            }
            if ((editMode = (SOPEditModeEnum)((Object)this.getUIContext().get("sopeditmode"))) != null) {
                this.cmbEditMode.setSelectedItem((Object)editMode);
                this.cmbEditMode.setEnabled(false);
            }
            if ((sopPeriod = (SOPPeriod)this.getUIContext().get("periodFrom")) != null) {
                if (editMode.equals((Object)SOPEditModeEnum.MONTHLY)) {
                    if (this.sopMonthPeriod.toNumber() < sopPeriod.toNumber()) {
                        this.cmbPeriodBegin.setSelectedItem((Object)sopPeriod);
                    } else {
                        this.cmbPeriodBegin.setSelectedItem((Object)this.sopMonthPeriod);
                    }
                } else if (this.sopWeekPeriod.toNumber() < sopPeriod.toNumber()) {
                    this.cmbPeriodBegin.setSelectedItem((Object)sopPeriod);
                } else {
                    this.cmbPeriodBegin.setSelectedItem((Object)this.sopWeekPeriod);
                }
            }
            if ((matId = (String)this.getUIContext().get("matFrom")) != null && (mat = this.getf7DefaultValue((ICoreBase)(matEntity = MaterialFactory.getRemoteInstance()), matId)) != null) {
                this.prmtMatFrom.setValue((Object)mat);
                this.prmtMatTo.setValue((Object)mat);
            }
            if ((planType = (SOPPlannedTypeEnum)((Object)this.getUIContext().get("PlanType"))) != null) {
                this.cmbPlanType.setSelectedItem((Object)planType);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void objectWillShow(SelectorEvent e) {
        StorageOrgUnitInfo orgInfo = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if ("".equalsIgnoreCase(this.prmtStorageOrgUnit.getText().trim())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.report.PlannerResource.INPUT_STORAGOR"));
            e.setCanceled(true);
            return;
        }
        EntityViewInfo v = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("StorageOrgUnit.id", (Object)orgInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Inventory.status", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        v.setFilter(filter);
        if (e.getSource().equals(this.prmtMatFrom)) {
            this.prmtMatFrom.setEntityViewInfo(v);
        } else if (e.getSource().equals(this.prmtMatTo)) {
            this.prmtMatTo.setEntityViewInfo(v);
        }
    }
}

