/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.SOPException;
import com.kingdee.eas.mm.planning.SopPlanTranferLogFactory;
import com.kingdee.eas.mm.planning.client.AbstractSopPlanTranferLogUI;
import com.kingdee.eas.mm.planning.client.SopPlanTranferLogFilterUI;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.SortUtil;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SopPlanTranferLogUI
extends AbstractSopPlanTranferLogUI {
    private static final Logger logger = CoreUIObject.getLogger(SopPlanTranferLogUI.class);
    private CommonQueryDialog commonQueryDialog;
    private OrgUnitCollection authorizedMainOrgs = null;
    private static final String TB_MATERIAL_NUMBER = "material.number";
    private static final String[] KDT_DATES = new String[]{"reqDate", "transferDate"};

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return SopPlanTranferLogFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.checkPermissionItem();
        super.onLoad();
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionRemove.setEnabled(false);
        this.actionView.setVisible(false);
        this.actionView.setEnabled(false);
        this.tblMain.getColumn("reqDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getColumn("transferDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            this.commonQueryDialog.setWidth(450);
            this.commonQueryDialog.setHeight(320);
            try {
                ISCMFilter iFilter = this.getFilterUI();
                ((SopPlanTranferLogFilterUI)iFilter).getUIContext().putAll(this.getUIContext());
                if (this.getBOTPViewStatus() == 1) {
                    iFilter.setBOTPFilter((Map)this.getBOTPMap());
                }
                iFilter.setIsSupportMultiOrgs(true);
                iFilter.setContextObject((Object)this.getUIContext());
                iFilter.setAuthorizedMainOrgs(this.getDefaultMainBizOrg());
                this.commonQueryDialog.addUserPanel((KDPanel)iFilter);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.commonQueryDialog;
    }

    protected ISCMFilter getFilterUI() throws Exception {
        return new SopPlanTranferLogFilterUI();
    }

    protected HashMap getBOTPMap() {
        return (HashMap)this.getUIContext().get("BTPEDITPARAMETER");
    }

    protected OrgUnitCollection getDefaultMainBizOrg() {
        if (this.authorizedMainOrgs == null) {
            this.authorizedMainOrgs = new OrgUnitCollection();
            try {
                OrgUnitInfo[] mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), this.getMainBizOrgType(), this.getViewPermissionItem());
                if (mainOrgs != null && mainOrgs.length > 0) {
                    mainOrgs = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, (boolean)true);
                    for (int i = 0; i < mainOrgs.length; ++i) {
                        this.authorizedMainOrgs.add(mainOrgs[i]);
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return this.authorizedMainOrgs;
    }

    protected String getViewPermissionItem() {
        return "mm_sopPlanTransferLog_view";
    }

    protected void execQuery() {
        FilterInfo filterInfo = this.mainQuery.getFilter();
        FilterInfo newFilterInfo = new FilterInfo();
        for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
            FilterItemInfo itemInfo = filterInfo.getFilterItems().get(i);
            if (itemInfo.getPropertyName().equals("saleAndProductType") || itemInfo.getPropertyName().equals("saleType") || itemInfo.getPropertyName().equals("productType")) {
                if (!itemInfo.getCompareValue().equals("true")) continue;
                if (itemInfo.getPropertyName().equals("saleType")) {
                    newFilterInfo.getFilterItems().add(new FilterItemInfo("planType", (Object)new Integer(1), CompareType.EQUALS));
                    continue;
                }
                if (!itemInfo.getPropertyName().equals("productType")) continue;
                newFilterInfo.getFilterItems().add(new FilterItemInfo("planType", (Object)new Integer(2), CompareType.EQUALS));
                continue;
            }
            if (itemInfo.getPropertyName().equals("CU.id")) continue;
            newFilterInfo.getFilterItems().add(itemInfo);
        }
        this.mainQuery.setFilter(newFilterInfo);
        super.execQuery();
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private void checkPermissionItem() throws BOSException, SOPException {
        ObjectUuidPK storagePk;
        boolean havePermission = false;
        if (this.getUIContext().get("org") != null) {
            storagePk = new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("org").toString()));
        } else {
            StorageOrgUnitInfo storage = SysContext.getSysContext().getCurrentStorageUnit();
            if (storage == null) {
                throw new SOPException(SOPException.NO_PERMISSIONS);
            }
            storagePk = new ObjectUuidPK(storage.getId());
        }
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        try {
            ipermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)storagePk, this.getViewPermissionItem());
            havePermission = true;
        }
        catch (EASBizException e) {
            havePermission = false;
        }
        if (!havePermission) {
            throw new SOPException(SOPException.NO_PERMISSION);
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{TB_MATERIAL_NUMBER};
        return locateNames;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.tblMain.getViewManager().getFreezeCol() <= 0) {
            KDTableUtils.setDefaultFreezeCol((KDTable)this.tblMain, (int)8);
        }
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
    }
}

