/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.PlanVersionSetInfo;
import com.kingdee.eas.mm.common.util.EditTableUtil;
import com.kingdee.eas.mm.planning.client.AbstractSupplyBillListUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.im.inv.client.StockTransferBillEditUI;
import com.kingdee.eas.scm.im.inv.client.TransferOrderBillEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurOrderEditUI;
import com.kingdee.eas.scm.sm.pur.client.PurRequestEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class SupplyBillListUI
extends AbstractSupplyBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(SupplyBillListUI.class);
    private static final String TB_ID = "billID";
    private static final String TB_BILLTYPE = "billType";
    private static final String[] KDT_DATES = new String[]{"usedDate", "deliveryDate", "adviseDeliveryDate", "adviseDate"};

    public void onShow() throws Exception {
        super.onShow();
        EditTableUtil.formatColDate((KDTable)this.tblMain, (String[])KDT_DATES);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String[] getQtyColumns() throws Exception {
        return new String[]{"qty", "totalReceiptQty", "intendReceiptQty", "adjustQty"};
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        IRow selectedRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (selectedRow == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        String id = (String)selectedRow.getCell(TB_ID).getValue();
        int billType = ((BizEnumValueDTO)selectedRow.getCell(TB_BILLTYPE).getValue()).getInt();
        String uiName = null;
        uiContext.put((Object)"ID", (Object)id);
        switch (billType) {
            case 30: {
                uiName = PurRequestEditUI.class.getName();
                break;
            }
            case 40: {
                uiName = PurOrderEditUI.class.getName();
                break;
            }
            case 50: {
                uiName = TransferOrderBillEditUI.class.getName();
                break;
            }
            case 60: {
                uiName = StockTransferBillEditUI.class.getName();
                break;
            }
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        PlanVersionSetInfo planVersionSetInfo = (PlanVersionSetInfo)this.getUIContext().get("planVersion");
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        this.prmptPlanVersion.setValue((Object)planVersionSetInfo);
        this.prmptStorageOrgUnit.setValue((Object)storageOrgUnitInfo);
        this.tblMain.getSelectManager().setSelectMode(2);
        SCMClientUtils.setTableColumnsFormat((KDTable)this.tblMain, (String[])this.getQtyColumns(), (String)"%{0.##########}f");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExport.setText("");
    }

    protected FilterInfo getDefaultFilterForQuery() {
        PlanVersionSetInfo planVersionSetInfo = (PlanVersionSetInfo)this.getUIContext().get("planVersion");
        StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)this.getUIContext().get("storageOrgUnit");
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        items.add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        items.add(new FilterItemInfo("planVersion.id", (Object)planVersionSetInfo.getId().toString(), CompareType.EQUALS));
        return filterInfo;
    }
}

