/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.planning.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialLeadTimeTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BDStatusEnum;
import com.kingdee.eas.mm.basedata.ClassTeamCollection;
import com.kingdee.eas.mm.basedata.ClassTeamFactory;
import com.kingdee.eas.mm.basedata.ClassTeamInfo;
import com.kingdee.eas.mm.basedata.IProductTransactionType;
import com.kingdee.eas.mm.basedata.LineSchedulingModelCollection;
import com.kingdee.eas.mm.basedata.LineSchedulingModelFactory;
import com.kingdee.eas.mm.basedata.LineSchedulingModelInfo;
import com.kingdee.eas.mm.basedata.ProductLineChangingCollection;
import com.kingdee.eas.mm.basedata.ProductLineChangingFactory;
import com.kingdee.eas.mm.basedata.ProductLineChangingInfo;
import com.kingdee.eas.mm.basedata.ProductLineCollection;
import com.kingdee.eas.mm.basedata.ProductLineFactory;
import com.kingdee.eas.mm.basedata.ProductLineInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryInfo;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefEntryRuleEntryCollection;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefFactory;
import com.kingdee.eas.mm.basedata.ProductLinePAllotDefInfo;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeCollection;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeFactory;
import com.kingdee.eas.mm.basedata.ProductTransactionTypeInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMConstant;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.planning.IPlannedOrder;
import com.kingdee.eas.mm.planning.LineCapabilityInfo;
import com.kingdee.eas.mm.planning.PLChooseEntryInfo;
import com.kingdee.eas.mm.planning.PLSConstant;
import com.kingdee.eas.mm.planning.PLSEntryInfo;
import com.kingdee.eas.mm.planning.PlanOrderEntryInfo;
import com.kingdee.eas.mm.planning.PlannedOrderFactory;
import com.kingdee.eas.mm.planning.PlannedOrderTypeEnum;
import com.kingdee.eas.mm.planning.SchedulingException;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PLSUtil {
    static final long MILLISECONDS_PER_DAY = 86400000L;

    public static Timestamp constructDate(Date date, Time time) {
        Calendar oldCa = Calendar.getInstance();
        Calendar newCa = Calendar.getInstance();
        oldCa.setTime(date);
        newCa.setTime(time);
        oldCa.set(11, newCa.get(11));
        oldCa.set(12, newCa.get(12));
        oldCa.set(13, newCa.get(13));
        oldCa.set(14, newCa.get(14));
        return new Timestamp(oldCa.getTimeInMillis());
    }

    public static Timestamp getDateByLeadTime(Timestamp date, int timeUnit, int leadTime) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(timeUnit, leadTime);
        return new Timestamp(ca.getTimeInMillis());
    }

    public static Timestamp setDateTime(Date date, int dateType) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        if (dateType == 0) {
            ca.set(11, 0);
            ca.set(12, 0);
            ca.set(13, 0);
            ca.set(14, 0);
        } else {
            ca.set(11, 23);
            ca.set(12, 59);
            ca.set(13, 59);
            ca.set(14, 999);
        }
        return new Timestamp(ca.getTimeInMillis());
    }

    public static Timestamp setTimestamp(Timestamp t) {
        Calendar ca = Calendar.getInstance();
        ca.setTimeInMillis(t.getTime());
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return new Timestamp(ca.getTimeInMillis());
    }

    public static Date setDate(Date t) {
        Calendar ca = Calendar.getInstance();
        ca.setTimeInMillis(t.getTime());
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return new Date(ca.getTimeInMillis());
    }

    public static Timestamp constructDate(Timestamp workDate, Time time, boolean isSpan) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        cal.setTime(workDate);
        if (isSpan) {
            cal.add(5, 1);
        }
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static BigDecimal getConstraintQty(BigDecimal qty) throws EASBizException {
        if (qty.compareTo(PLSConstant.MAXQTY) >= 0) {
            throw new SchedulingException(SchedulingException.NUMERICOUT_LARGE);
        }
        if (qty.compareTo(new BigDecimal("0")) > 0 && qty.compareTo(PLSConstant.MINQTY) < 0) {
            throw new SchedulingException(SchedulingException.NUMERICOUT_MINI);
        }
        return qty;
    }

    public static void initSortManager(KDTable detailTable, boolean isSort) {
        KDTSortManager sortManager = new KDTSortManager(detailTable);
        sortManager.setSortAuto(isSort);
        sortManager.setClickCount(1);
        detailTable.setSortMange(sortManager);
        for (int i = 0; i < detailTable.getColumnCount(); ++i) {
            detailTable.getColumn(i).setSortable(isSort);
        }
    }

    public static LineSchedulingModelInfo getLineSchedulingModelForServer(Context ctx, StorageOrgUnitInfo storageOrgUnit) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("priorityModel.*"));
        entityViewInfo.setSelector(selectorItemCollection);
        LineSchedulingModelCollection lineSchedulingModelCollection = LineSchedulingModelFactory.getLocalInstance((Context)ctx).getLineSchedulingModelCollection(entityViewInfo);
        if (lineSchedulingModelCollection != null && lineSchedulingModelCollection.size() > 0) {
            return lineSchedulingModelCollection.get(0);
        }
        throw new SchedulingException(SchedulingException.NOMODEL, new Object[]{storageOrgUnit.getName()});
    }

    public static LineSchedulingModelInfo getLineSchedulingModelForClient(Context ctx, StorageOrgUnitInfo storageOrgUnit) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnit.getId().toString(), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("priorityModel.*"));
        entityViewInfo.setSelector(selectorItemCollection);
        LineSchedulingModelCollection lineSchedulingModelCollection = LineSchedulingModelFactory.getRemoteInstanceWithObjectContext((Context)ctx).getLineSchedulingModelCollection(entityViewInfo);
        if (lineSchedulingModelCollection != null && lineSchedulingModelCollection.size() > 0) {
            return lineSchedulingModelCollection.get(0);
        }
        throw new SchedulingException(SchedulingException.NOMODEL, new Object[]{storageOrgUnit.getName()});
    }

    public static ProductLinePAllotDefEntryCollection getProductLinePAllotDefForClient(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.material.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.ruleEntrys.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.ruleEntrys.productLine.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.ruleEntrys.productLine.workshop.*"));
        ProductLinePAllotDefInfo productLinePAllotDefInfo = ProductLinePAllotDefFactory.getRemoteInstanceWithObjectContext((Context)ctx).getProductLinePAllotDefInfo((IObjectPK)new ObjectUuidPK(id), selectorItemCollection);
        if (productLinePAllotDefInfo == null || !productLinePAllotDefInfo.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            throw new SchedulingException(SchedulingException.NOALLOTDEF);
        }
        ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection = productLinePAllotDefInfo.getEntrys();
        if (productLinePAllotDefEntryCollection != null && productLinePAllotDefEntryCollection.size() > 0) {
            for (ProductLinePAllotDefEntryInfo productLinePAllotDefEntryInfo : productLinePAllotDefEntryCollection) {
                ProductLinePAllotDefEntryRuleEntryCollection ruleEntryCollection = productLinePAllotDefEntryInfo.getRuleEntrys();
                if (ruleEntryCollection != null && ruleEntryCollection.size() != 0) continue;
                throw new SchedulingException(SchedulingException.NOALLOTDEFENTRY, new Object[]{productLinePAllotDefInfo.getName()});
            }
        } else {
            throw new SchedulingException(SchedulingException.NOALLOTDEFENTRY, new Object[]{productLinePAllotDefInfo.getName()});
        }
        return productLinePAllotDefEntryCollection;
    }

    public static ProductLinePAllotDefEntryCollection getProductLinePAllotDefForServer(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.material.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.materialPlan.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.ruleEntrys.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.ruleEntrys.productLine.*"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.ruleEntrys.productLine.workshop.*"));
        ProductLinePAllotDefInfo productLinePAllotDefInfo = ProductLinePAllotDefFactory.getLocalInstance((Context)ctx).getProductLinePAllotDefInfo((IObjectPK)new ObjectUuidPK(id), selectorItemCollection);
        if (productLinePAllotDefInfo == null || !productLinePAllotDefInfo.getStatus().equals((Object)BDStatusEnum.APPROVE)) {
            throw new SchedulingException(SchedulingException.NOALLOTDEF);
        }
        ProductLinePAllotDefEntryCollection productLinePAllotDefEntryCollection = productLinePAllotDefInfo.getEntrys();
        if (productLinePAllotDefEntryCollection != null && productLinePAllotDefEntryCollection.size() > 0) {
            for (ProductLinePAllotDefEntryInfo productLinePAllotDefEntryInfo : productLinePAllotDefEntryCollection) {
                ProductLinePAllotDefEntryRuleEntryCollection ruleEntryCollection = productLinePAllotDefEntryInfo.getRuleEntrys();
                if (ruleEntryCollection != null && ruleEntryCollection.size() != 0) continue;
                throw new SchedulingException(SchedulingException.NOALLOTDEFENTRY, new Object[]{productLinePAllotDefInfo.getName()});
            }
        } else {
            throw new SchedulingException(SchedulingException.NOALLOTDEFENTRY, new Object[]{productLinePAllotDefInfo.getName()});
        }
        return productLinePAllotDefEntryCollection;
    }

    public static SCMEntryDataVO getMmuPrecisionForServer(Context ctx, StorageOrgUnitInfo storageOrgUnit, MaterialInfo[] materialInfos, MeasureUnitInfo[] unitInfos, MeasureUnitInfo[] baseUnitInfos) throws EASBizException, BOSException {
        SCMEntryDataVO vo = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        vo.setMainOrgType(OrgType.Storage);
        vo.setMainOrg((OrgUnitInfo)storageOrgUnit);
        vo.setMaterialInfos(materialInfos);
        vo.setMeasureUnitInfos(unitInfos);
        vo.setBaseMeasureUnitInfos(baseUnitInfos);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(vo);
        return voResult;
    }

    public static SCMEntryDataVO loadComplexDataForServer(Context ctx, StorageOrgUnitInfo storageOrgUnit, MaterialInfo[] materials) throws EASBizException, BOSException {
        SCMEntryDataVO vo = new SCMEntryDataVO();
        SCMEntryDataVO voResult = new SCMEntryDataVO();
        int n = materials.length;
        StorageOrgUnitInfo[] storageOrgUnits = new StorageOrgUnitInfo[n];
        for (int i = 0; i < n; ++i) {
            storageOrgUnits[i] = storageOrgUnit;
        }
        vo.setIsLoadingMaterialPlan(true);
        vo.setIsLoadingMaterialInventory(true);
        vo.setMaterialInfos(materials);
        vo.setStorageOrgUnitInfos(storageOrgUnits);
        voResult = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadComplexData(vo);
        return voResult;
    }

    public static Map getProductLineMapForServer(Context ctx, Set keySet) throws BOSException, EASBizException {
        HashMap<String, ProductLineInfo> productLineMap = new HashMap<String, ProductLineInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)keySet, CompareType.INCLUDE));
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("workshop.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("unit.*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("classTeam.*"));
        entityViewInfo.setFilter(filterInfo);
        ProductLineCollection lineCol = ProductLineFactory.getLocalInstance((Context)ctx).getProductLineCollection(entityViewInfo);
        if (lineCol != null && lineCol.size() > 0) {
            int n = lineCol.size();
            for (int i = 0; i < n; ++i) {
                ProductLineInfo productLineInfo = lineCol.get(i);
                productLineMap.put(productLineInfo.getId().toString(), productLineInfo);
            }
        }
        return productLineMap;
    }

    public static Map getClassTeamMapForServer(Context ctx, Set keySet) throws BOSException, EASBizException {
        HashMap<String, ClassTeamInfo> classTeamMap = new HashMap<String, ClassTeamInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)keySet, CompareType.INCLUDE));
        entityViewInfo.getSelector().add(new SelectorItemInfo("*"));
        entityViewInfo.getSelector().add(new SelectorItemInfo("entrys.*"));
        entityViewInfo.setFilter(filterInfo);
        ClassTeamCollection classTeamCol = ClassTeamFactory.getLocalInstance((Context)ctx).getClassTeamCollection(entityViewInfo);
        if (classTeamCol != null && classTeamCol.size() > 0) {
            int n = classTeamCol.size();
            for (int i = 0; i < n; ++i) {
                ClassTeamInfo classTeamInfo = classTeamCol.get(i);
                classTeamMap.put(classTeamInfo.getId().toString(), classTeamInfo);
            }
        }
        return classTeamMap;
    }

    public static Map getMaterialMapForServer(Context ctx, Set keySet) throws BOSException, EASBizException {
        HashMap<String, MaterialInfo> materialMap = new HashMap<String, MaterialInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)keySet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(entityViewInfo);
        if (materialCol != null && materialCol.size() > 0) {
            int n = materialCol.size();
            for (int i = 0; i < n; ++i) {
                MaterialInfo materialInfo = materialCol.get(i);
                materialMap.put(materialInfo.getId().toString(), materialInfo);
            }
        }
        return materialMap;
    }

    public static Map getTrackNumMapForServer(Context ctx, Set keySet) throws BOSException, EASBizException {
        HashMap<String, TrackNumberInfo> trackNumMap = new HashMap<String, TrackNumberInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)keySet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        TrackNumberCollection trackNumCol = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection(entityViewInfo);
        if (trackNumCol != null && trackNumCol.size() > 0) {
            int n = trackNumCol.size();
            for (int i = 0; i < n; ++i) {
                TrackNumberInfo trackNumberInfo = trackNumCol.get(i);
                trackNumMap.put(trackNumberInfo.getId().toString(), trackNumberInfo);
            }
        }
        return trackNumMap;
    }

    public static Map getUnitMapForServer(Context ctx, Set keySet) throws BOSException, EASBizException {
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)keySet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        MeasureUnitCollection unitCol = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(entityViewInfo);
        if (unitCol != null && unitCol.size() > 0) {
            int n = unitCol.size();
            for (int i = 0; i < n; ++i) {
                MeasureUnitInfo unitInfo = unitCol.get(i);
                unitMap.put(unitInfo.getId().toString(), unitInfo);
            }
        }
        return unitMap;
    }

    public static Map getSaleOrderMapForServer(Context ctx, Set keySet) throws BOSException, EASBizException {
        HashMap<String, SaleOrderInfo> saleOrderMap = new HashMap<String, SaleOrderInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)keySet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SaleOrderCollection saleOrderCol = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderCollection(entityViewInfo);
        if (saleOrderCol != null && saleOrderCol.size() > 0) {
            int n = saleOrderCol.size();
            for (int i = 0; i < n; ++i) {
                SaleOrderInfo saleOrderInfo = saleOrderCol.get(i);
                saleOrderMap.put(saleOrderInfo.getId().toString(), saleOrderInfo);
            }
        }
        return saleOrderMap;
    }

    public static String[] getLineChangingIdsForClient(Context ctx, String allotDefId) throws BOSException, EASBizException {
        String[] ids = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("productLinePAll.id", (Object)allotDefId, CompareType.EQUALS));
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.setFilter(filterInfo);
        ProductLineChangingCollection col = ProductLineChangingFactory.getRemoteInstanceWithObjectContext((Context)ctx).getProductLineChangingCollection(entityViewInfo);
        if (col != null && col.size() > 0) {
            ids = new String[col.size()];
            int n = col.size();
            for (int i = 0; i < n; ++i) {
                ProductLineChangingInfo info = col.get(i);
                ids[i] = info.getId().toString();
            }
        }
        return ids;
    }

    public static ProductLineChangingInfo getProductLineChanging(Context ctx, String orgUnitID, String lineAllocateID, String productLineID) throws BOSException, EASBizException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("productLinePAll.id", (Object)lineAllocateID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("productLine.id", (Object)productLineID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(20), CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("productLine.id"));
        selectorItemCollection.add(new SelectorItemInfo("productLine.number"));
        selectorItemCollection.add(new SelectorItemInfo("productLine.name"));
        selectorItemCollection.add(new SelectorItemInfo("entrys.*"));
        entityViewInfo.setSelector(selectorItemCollection);
        ProductLineChangingCollection productLineChangingCollection = ProductLineChangingFactory.getLocalInstance((Context)ctx).getProductLineChangingCollection(entityViewInfo);
        if (productLineChangingCollection != null && productLineChangingCollection.size() > 0) {
            return productLineChangingCollection.get(0);
        }
        return null;
    }

    public static Comparator getPOComparator() throws BOSException, EASBizException {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                PlanOrderEntryInfo pOEntry1 = (PlanOrderEntryInfo)o1;
                PlanOrderEntryInfo pOEntry2 = (PlanOrderEntryInfo)o2;
                if (pOEntry1.getBeginDate().compareTo(pOEntry2.getBeginDate()) != 0) {
                    return pOEntry1.getBeginDate().compareTo(pOEntry2.getBeginDate());
                }
                if (pOEntry1.getMaterial().getNumber().compareTo(pOEntry2.getMaterial().getNumber()) != 0) {
                    return pOEntry1.getMaterial().getNumber().compareTo(pOEntry2.getMaterial().getNumber());
                }
                if (pOEntry1.getQty().compareTo(pOEntry2.getQty()) != 0) {
                    return pOEntry2.getQty().compareTo(pOEntry1.getQty());
                }
                if (pOEntry1.getSourceBillNumber() != null && pOEntry2.getSourceBillNumber() != null && pOEntry1.getSourceBillNumber().compareTo(pOEntry2.getSourceBillNumber()) != 0) {
                    return pOEntry1.getSourceBillNumber().compareTo(pOEntry2.getSourceBillNumber());
                }
                return 0;
            }
        };
    }

    public static Comparator getPLCComparator() throws BOSException, EASBizException {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                PLChooseEntryInfo pLCEntry1 = (PLChooseEntryInfo)o1;
                PLChooseEntryInfo pLCEntry2 = (PLChooseEntryInfo)o2;
                if (pLCEntry1.getProductLine().getNumber().compareTo(pLCEntry2.getProductLine().getNumber()) != 0) {
                    return pLCEntry1.getProductLine().getNumber().compareTo(pLCEntry2.getProductLine().getNumber());
                }
                if (pLCEntry1.getPriorityLevel() != pLCEntry2.getPriorityLevel()) {
                    return pLCEntry1.getPriorityLevel().compareTo(pLCEntry2.getPriorityLevel());
                }
                if (pLCEntry1.getBeginDate().compareTo(pLCEntry2.getBeginDate()) != 0) {
                    return pLCEntry1.getBeginDate().compareTo(pLCEntry2.getBeginDate());
                }
                if (pLCEntry1.getMaterial().getNumber().compareTo(pLCEntry2.getMaterial().getNumber()) != 0) {
                    return pLCEntry1.getMaterial().getNumber().compareTo(pLCEntry2.getMaterial().getNumber());
                }
                if (pLCEntry1.getQty().compareTo(pLCEntry2.getQty()) != 0) {
                    return pLCEntry2.getQty().compareTo(pLCEntry1.getQty());
                }
                if (pLCEntry1.getSourceBillNumber() != null && pLCEntry2.getSourceBillNumber() != null) {
                    if (pLCEntry1.getSourceBillNumber().compareTo(pLCEntry2.getSourceBillNumber()) != 0) {
                        return pLCEntry1.getSourceBillNumber().compareTo(pLCEntry2.getSourceBillNumber());
                    }
                    return 0;
                }
                if (pLCEntry1.getSourceBillNumber() != null && pLCEntry2.getSourceBillNumber() == null) {
                    return -1;
                }
                if (pLCEntry1.getSourceBillNumber() == null && pLCEntry2.getSourceBillNumber() != null) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static Comparator getPLSComparator() throws BOSException, EASBizException {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                PLSEntryInfo pLSEntry1 = (PLSEntryInfo)o1;
                PLSEntryInfo pLSEntry2 = (PLSEntryInfo)o2;
                if (pLSEntry1.getProductLine().getNumber().compareTo(pLSEntry2.getProductLine().getNumber()) != 0) {
                    return pLSEntry1.getProductLine().getNumber().compareTo(pLSEntry2.getProductLine().getNumber());
                }
                if (pLSEntry1.getBeginDate().compareTo(pLSEntry2.getBeginDate()) != 0) {
                    return pLSEntry1.getBeginDate().compareTo(pLSEntry2.getBeginDate());
                }
                if (pLSEntry1.getProOrder().compareTo(pLSEntry2.getProOrder()) != 0) {
                    return pLSEntry1.getProOrder().compareTo(pLSEntry2.getProOrder());
                }
                if (pLSEntry1.getMaterial().getNumber().compareTo(pLSEntry2.getMaterial().getNumber()) != 0) {
                    return pLSEntry1.getMaterial().getNumber().compareTo(pLSEntry2.getMaterial().getNumber());
                }
                if (pLSEntry1.getQty().compareTo(pLSEntry2.getQty()) != 0) {
                    return pLSEntry2.getQty().compareTo(pLSEntry1.getQty());
                }
                if (pLSEntry1.getSourceBillNumber() != null && pLSEntry2.getSourceBillNumber() != null) {
                    if (pLSEntry1.getSourceBillNumber().compareTo(pLSEntry2.getSourceBillNumber()) != 0) {
                        return pLSEntry1.getSourceBillNumber().compareTo(pLSEntry2.getSourceBillNumber());
                    }
                    return 0;
                }
                return 0;
            }
        };
    }

    public static Comparator getLineCapComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                LineCapabilityInfo lineCap1 = (LineCapabilityInfo)o1;
                LineCapabilityInfo lineCap2 = (LineCapabilityInfo)o2;
                if (lineCap1.getWorkDate().compareTo(lineCap2.getWorkDate()) != 0) {
                    return lineCap1.getWorkDate().compareTo(lineCap2.getWorkDate());
                }
                return lineCap1.getBeginTime().compareTo(lineCap2.getBeginTime());
            }
        };
    }

    public static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    public static String formatTimestamp(Timestamp dateTime) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(dateTime);
    }

    public static String formatDate(Date dateTime) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(dateTime);
    }

    public static BigDecimal calcDateSpan(Timestamp beginDate, Timestamp endDate) {
        return new BigDecimal((endDate.getTime() - beginDate.getTime()) / 86400000L);
    }

    public static Date getPlannedEndDate(PlannedOrderTypeEnum orderType, MaterialPlanInfo plan, Date startDate, BigDecimal qty) throws EASBizException, BOSException {
        Date rst = null;
        int changeDays = 0;
        if (MaterialLeadTimeTypeEnum.CHANGEBATCHTYPE.equals((Object)plan.getLeadTimeType())) {
            int changeBatch = plan.getChangeBatch();
            BigDecimal changeBatchQty = new BigDecimal(String.valueOf(changeBatch));
            int changeLeadTime = plan.getChangeLeadTime();
            BigDecimal changeLeadTimeQty = new BigDecimal(String.valueOf(changeLeadTime));
            if (qty == null) {
                qty = MMConstant.BIGDECIMAL_ZERO;
            }
            BigDecimal changeDayQty = qty.multiply(changeLeadTimeQty).divide(changeBatchQty, 0, 0);
            changeDays = changeDayQty.intValue();
        }
        int days = plan.getProduceLeadTime() + plan.getForwardProcessTime() + plan.getBackwardProcessTime() + changeDays;
        if (PlannedOrderTypeEnum.FABRICATED.equals((Object)orderType) || PlannedOrderTypeEnum.STOCKTRANSFER.equals((Object)orderType)) {
            rst = PLSUtil.getWorkDate(plan.getOrgUnit().getId().toString(), startDate, days);
        } else if (PlannedOrderTypeEnum.PURCHASE.equals((Object)orderType)) {
            long dateTime = startDate.getTime();
            long daysTime = (long)days * 86400000L;
            long newDateTime = dateTime + daysTime;
            rst = new Date(newDateTime);
            rst = PLSUtil.getWorkDate(plan.getOrgUnit().getId().toString(), rst, 0);
        }
        return rst;
    }

    public static Date getAvalibleDate(String storageOrgUnitId, Date endDate, int recevingLeadTime) throws EASBizException, BOSException {
        Date rst = PLSUtil.getWorkDate(storageOrgUnitId, endDate, recevingLeadTime);
        return rst;
    }

    private static Date getWorkDate(String storageOrgUnitId, Date dateVal, int days) throws BOSException, EASBizException {
        IPlannedOrder po = PlannedOrderFactory.getRemoteInstance();
        Date rstDate = po.getValidateCalendar(storageOrgUnitId, dateVal, days);
        return rstDate;
    }

    public static ProductTransactionTypeInfo getProductTransactionType(String storageOrgUnitId, String materialId, String dempId) throws BOSException {
        if (MMUtils.isEmptyString((String)storageOrgUnitId) || MMUtils.isEmptyString((String)materialId)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        Integer status = new Integer(20);
        filter.getFilterItems().add(new FilterItemInfo("productTranType.status", (Object)status, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("productTranType.id");
        selectorColl.add("productTranType.name");
        selectorColl.add("productTranType.number");
        view.setSelector(selectorColl);
        MaterialPlanCollection coll = MaterialPlanFactory.getRemoteInstance().getMaterialPlanCollection(view);
        MaterialPlanInfo plan = null;
        if (coll != null && coll.size() > 0) {
            plan = coll.get(0);
            return plan.getProductTranType();
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)storageOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)status, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE, CompareType.EQUALS));
        String standerBizTypeId = "vGXRx5fFSsCYz9Zv7CzzgyQHQ1w=";
        filter.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)standerBizTypeId, CompareType.EQUALS));
        FilterInfo filterBak = (FilterInfo)filter.clone();
        filter.getFilterItems().add(new FilterItemInfo("adminDepartment.id", (Object)dempId, CompareType.EQUALS));
        view.setFilter(filter);
        selectorColl = new SelectorItemCollection();
        selectorColl.add("id");
        selectorColl.add("name");
        selectorColl.add("number");
        view.setSelector(selectorColl);
        IProductTransactionType iptt = ProductTransactionTypeFactory.getRemoteInstance();
        ProductTransactionTypeCollection pttColl = iptt.getProductTransactionTypeCollection(view);
        if (pttColl != null && pttColl.size() > 0) {
            return pttColl.get(0);
        }
        view = new EntityViewInfo();
        filterBak.getFilterItems().add(new FilterItemInfo("adminDepartment.id", null, CompareType.EQUALS));
        view.setFilter(filterBak);
        view.setSelector(selectorColl);
        pttColl = iptt.getProductTransactionTypeCollection(view);
        ProductTransactionTypeInfo rst = null;
        if (pttColl != null && pttColl.size() > 0) {
            rst = pttColl.get(0);
        }
        return rst;
    }
}

