/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project;

import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.mm.project.ProjectCalendarEntryCollection;
import com.kingdee.eas.mm.project.ProjectCalendarEntryInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public class ProjectCalendarUtils {
    public static final int EVERYMONTH = 0;
    public static final int LASTDAY = 99;

    public static boolean isLastDayOfMonth(Date currdate) {
        boolean isYes = false;
        int lastDay = 1;
        Calendar cal = Calendar.getInstance();
        cal.setTime(currdate);
        int currDay = cal.get(5);
        int month = cal.get(2);
        int year = cal.get(1);
        lastDay = month == 0 || month == 2 || month == 4 || month == 6 || month == 7 || month == 9 || month == 11 ? 31 : (month == 3 || month == 5 || month == 8 || month == 10 ? 30 : (year % 4 == 0 || year % 400 == 0 && year % 100 != 0 ? 29 : 28));
        if (currDay == lastDay) {
            isYes = true;
        }
        return isYes;
    }

    public static void setSeriesDayWorkDateType(int seq, int seriesDay, ProjectCalendarEntryCollection fCEntryColl) {
        int size = fCEntryColl.size();
        for (int j = seq; j < seq + seriesDay; ++j) {
            if (j >= size) {
                return;
            }
            ProjectCalendarEntryInfo entryInfo = fCEntryColl.get(j);
            entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
        }
    }

    public static ProjectCalendarEntryCollection getProjectCalendarEntrys(int seasonNo, int dayNo, ProjectCalendarEntryCollection fCEntryColl) {
        ProjectCalendarEntryCollection entrys = new ProjectCalendarEntryCollection();
        int month = 0;
        int seasonSeq = 0;
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < fCEntryColl.size(); ++i) {
            ProjectCalendarEntryInfo entryInfo = fCEntryColl.get(i);
            cal.setTime(entryInfo.getWorkDate());
            month = cal.get(2) + 1;
            seasonSeq = month % 3;
            if (seasonSeq == 0) {
                seasonSeq = 3;
            }
            if (seasonSeq != seasonNo) continue;
            if (dayNo == 99) {
                boolean isLastDay = ProjectCalendarUtils.isLastDayOfMonth(entryInfo.getWorkDate());
                if (!isLastDay) continue;
                entrys.add(entryInfo);
                continue;
            }
            int day = cal.get(5);
            if (day != dayNo) continue;
            entrys.add(entryInfo);
        }
        return entrys;
    }

    public static void setFCEInfoWorkDateType(int monthRule, int dayRule, int seriesDay, ProjectCalendarEntryInfo entryInfo, ProjectCalendarEntryCollection fCEntryColl) {
        Calendar cal = Calendar.getInstance();
        int currDay = 0;
        int currMonth = 0;
        if (monthRule == 0) {
            if (dayRule == 99) {
                boolean isLastDay = ProjectCalendarUtils.isLastDayOfMonth(entryInfo.getWorkDate());
                if (isLastDay) {
                    entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                    int seq = entryInfo.getSeq();
                    ProjectCalendarUtils.setSeriesDayWorkDateType(seq, seriesDay, fCEntryColl);
                }
            } else {
                cal.setTime(entryInfo.getWorkDate());
                currDay = cal.get(5);
                if (dayRule == currDay) {
                    entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                    ProjectCalendarUtils.setSeriesDayWorkDateType(entryInfo.getSeq(), seriesDay, fCEntryColl);
                }
            }
        } else {
            boolean isLastDay;
            cal.setTime(entryInfo.getWorkDate());
            currDay = cal.get(5);
            currMonth = cal.get(2) + 1;
            if (dayRule == currDay && monthRule == currMonth) {
                entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                ProjectCalendarUtils.setSeriesDayWorkDateType(entryInfo.getSeq(), seriesDay, fCEntryColl);
            }
            if (dayRule == 99 && (isLastDay = ProjectCalendarUtils.isLastDayOfMonth(entryInfo.getWorkDate())) && monthRule == currMonth) {
                entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                int seq = entryInfo.getSeq();
                ProjectCalendarUtils.setSeriesDayWorkDateType(seq, seriesDay, fCEntryColl);
            }
        }
    }

    public static ProjectCalendarEntryCollection getFCEntrysByWeek(int monthRule, int dayRule, ProjectCalendarEntryCollection fCEntryColl) {
        ProjectCalendarEntryCollection entrys = new ProjectCalendarEntryCollection();
        int month = 0;
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < fCEntryColl.size(); ++i) {
            ProjectCalendarEntryInfo entryInfo = fCEntryColl.get(i);
            cal.setTime(entryInfo.getWorkDate());
            month = cal.get(2) + 1;
            int dayOfWeek = cal.get(7);
            if (dayOfWeek != dayRule) continue;
            if (monthRule == 0) {
                entrys.add(entryInfo);
                continue;
            }
            if (monthRule != month) continue;
            entrys.add(entryInfo);
        }
        return entrys;
    }

    public static ProjectCalendarEntryCollection getFCEntrysBySean(int monthRule, int dayRule, ProjectCalendarEntryCollection fCEntryColl) {
        ProjectCalendarEntryCollection entrys = new ProjectCalendarEntryCollection();
        int month = 0;
        int seasonSeq = 0;
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < fCEntryColl.size(); ++i) {
            boolean isLastDay;
            int day;
            ProjectCalendarEntryInfo entryInfo = fCEntryColl.get(i);
            cal.setTime(entryInfo.getWorkDate());
            month = cal.get(2) + 1;
            seasonSeq = month % 3;
            if (seasonSeq == 0) {
                seasonSeq = 3;
            }
            if ((day = cal.get(5)) == dayRule) {
                if (monthRule == 0) {
                    entrys.add(entryInfo);
                    continue;
                }
                if (monthRule != seasonSeq) continue;
                entrys.add(entryInfo);
                continue;
            }
            if (dayRule != 99 || !(isLastDay = ProjectCalendarUtils.isLastDayOfMonth(entryInfo.getWorkDate()))) continue;
            if (monthRule == 0) {
                entrys.add(entryInfo);
                continue;
            }
            if (monthRule != seasonSeq) continue;
            entrys.add(entryInfo);
        }
        return entrys;
    }

    public static void setWorkDateSeq(int seq, int workSeq, ProjectCalendarEntryCollection fcEntryColl) {
        int monthSeq = 1;
        int weekSeq = 1;
        Date currDate = null;
        for (int i = 0; i < fcEntryColl.size(); ++i) {
            ProjectCalendarEntryInfo entryInfo = fcEntryColl.get(i);
            entryInfo.setSeq(seq + i);
            Date workDate = entryInfo.getWorkDate();
            if (currDate != null) {
                boolean isSameWeek;
                boolean isSameMonth = ProjectCalendarUtils.isSameMonth(currDate, workDate);
                if (!isSameMonth) {
                    ++monthSeq;
                }
                if (!(isSameWeek = ProjectCalendarUtils.isSameWeek(currDate, workDate))) {
                    ++weekSeq;
                }
                entryInfo.setMonthSeq(monthSeq);
                entryInfo.setWeekSeq(weekSeq);
                currDate = workDate;
            } else {
                currDate = workDate;
                entryInfo.setMonthSeq(monthSeq);
                entryInfo.setWeekSeq(weekSeq);
            }
            entryInfo.setYearSeq(1);
            int workDateType = entryInfo.getDateType().getValue();
            if (workDateType == 1) {
                entryInfo.setWorkDateSeq(workSeq);
                entryInfo.setNextWorkDaySeq(workSeq + 1);
                entryInfo.setPreWorkDaySeq(workSeq - 1);
                ++workSeq;
                continue;
            }
            entryInfo.setWorkDateSeq(0);
            entryInfo.setNextWorkDaySeq(workSeq);
            entryInfo.setPreWorkDaySeq(workSeq - 1);
        }
    }

    public static Date clearTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        date = cal.getTime();
        return date;
    }

    public static void setDateTypeByFCalendarEntry(Date date, int dateType, ProjectCalendarEntryCollection fcEntryColl) {
        Iterator it = fcEntryColl.iterator();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        while (it.hasNext()) {
            ProjectCalendarEntryInfo entryInfo = (ProjectCalendarEntryInfo)it.next();
            cal.setTime(entryInfo.getWorkDate());
            int yy = cal.get(1);
            int mm = cal.get(2);
            int dd = cal.get(5);
            if (yy != year || mm != month || dd != day) continue;
            entryInfo.setDateType(WorkDateTypeEnum.getEnum((int)dateType));
            break;
        }
    }

    public static void setWorkDateType(WorkDateTypeEnum dateType, ProjectCalendarEntryCollection entrys) {
        if (dateType == null || entrys == null) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            ProjectCalendarEntryInfo entryInfo = entrys.get(i);
            entryInfo.setDateType(dateType);
        }
    }

    public static void reGenEntrySeq(ProjectCalendarEntryCollection entrys) {
        if (entrys == null) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            ProjectCalendarEntryInfo entryInfo = entrys.get(i);
            entryInfo.setSeq(i + 1);
        }
    }

    public static boolean isDateTrue(int month, int day) {
        boolean isYes = false;
        if (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) {
            if (day >= 1 && day <= 31) {
                isYes = true;
            }
        } else if (month == 4 || month == 6 || month == 9 || month == 11) {
            if (day >= 1 && day <= 30) {
                isYes = true;
            }
        } else if (month == 2 && day >= 1 && day <= 28) {
            isYes = true;
        }
        return isYes;
    }

    public static boolean isSameMonth(Date date, Date comDate) {
        boolean isSame = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int currYear = cal.get(1);
        int currMOnth = cal.get(2);
        cal.setTime(comDate);
        int comYear = cal.get(1);
        int comMonth = cal.get(2);
        if (currYear == comYear && currMOnth == comMonth) {
            isSame = true;
        }
        return isSame;
    }

    public static boolean isSameYear(Date date, Date comDate) {
        boolean isSame = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int currYear = cal.get(1);
        cal.setTime(comDate);
        int comYear = cal.get(1);
        if (currYear == comYear) {
            isSame = true;
        }
        return isSame;
    }

    public static boolean isSameWeek(Date date, Date comDate) {
        boolean isSame = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int currYear = cal.get(1);
        int currWeek = cal.get(3);
        int noWeek = cal.get(7);
        cal.setTime(comDate);
        int comYear = cal.get(1);
        int comWeek = cal.get(3);
        int comNoWeek = cal.get(7);
        if (currYear == comYear && currWeek == comWeek) {
            isSame = true;
        } else {
            cal.add(5, -1);
            comYear = cal.get(1);
            if (currYear == comYear && noWeek == comNoWeek - 1) {
                isSame = true;
            }
        }
        return isSame;
    }
}

