/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project;

import com.kingdee.eas.mm.project.MonthPlanConst;
import com.kingdee.eas.mm.project.Peroid;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ProjectPeroidData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map peroidData;
    private String taskTemplateId;
    private String projectId;
    private String storageOrgUnitId;
    private int precision;
    private String monthPlanId;
    private Peroid peroid;
    private final String ENTRYID = "entryId";
    private final String QTY = "qty";

    public ProjectPeroidData(String projectId, String taskTemplateId, String storageOrgUnitId, int precision) {
        this.projectId = projectId;
        this.taskTemplateId = taskTemplateId;
        this.storageOrgUnitId = storageOrgUnitId;
        this.precision = precision;
    }

    public Map getPeroidData() {
        if (this.peroidData == null) {
            this.peroidData = new HashMap();
        }
        return this.peroidData;
    }

    public void setPeriodData(Map peroidData) {
        this.peroidData = peroidData;
    }

    public String getTaskTemplateId() {
        return this.taskTemplateId;
    }

    public void setTaskTemplateId(String taskTemplateId) {
        this.taskTemplateId = taskTemplateId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getMonthPlanId() {
        return this.monthPlanId;
    }

    public void setMonthPlanId(String monthPlanId) {
        this.monthPlanId = monthPlanId;
    }

    public Peroid getPeroid() {
        return this.peroid;
    }

    public String getStorageOrgUnitId() {
        return this.storageOrgUnitId;
    }

    public void setStorageOrgUnitId(String storageOrgUnitId) {
        this.storageOrgUnitId = storageOrgUnitId;
    }

    public void setPeriod(Peroid peroid) {
        this.peroid = peroid;
    }

    public BigDecimal calTotalQty() {
        if (this.peroidData == null) {
            this.peroidData = new HashMap();
        }
        BigDecimal totalQty = MonthPlanConst.ZERO;
        BigDecimal qty = null;
        Iterator it = this.peroidData.values().iterator();
        Map data = null;
        while (it.hasNext()) {
            data = (Map)it.next();
            qty = (BigDecimal)data.get("qty");
            totalQty = totalQty.add(qty);
        }
        return totalQty;
    }

    public void addQty(Peroid period, BigDecimal qty) {
        if (this.peroidData == null) {
            this.peroidData = new HashMap();
        }
        Map<String, BigDecimal> data = null;
        BigDecimal zero = new BigDecimal("0");
        zero.setScale(this.precision);
        if (this.peroidData.containsKey(period.toString())) {
            data = (Map)this.peroidData.get(period.toString());
            BigDecimal totalQty = (BigDecimal)data.get("qty");
            totalQty = zero.add(totalQty).add(qty);
            data.put("qty", totalQty);
            data.put("entryId", (BigDecimal)((Object)period.getMonthPlanEntryId()));
            this.peroidData.put(period.toString(), data);
        } else {
            data = new HashMap();
            qty = zero.add(qty);
            data.put("qty", qty);
            data.put("entryId", (BigDecimal)((Object)period.getMonthPlanEntryId()));
            this.peroidData.put(period.toString(), data);
        }
    }

    public BigDecimal getQty(Peroid period) {
        Map data = (Map)this.peroidData.get(period.toString());
        if (data == null) {
            return null;
        }
        return (BigDecimal)data.get("qty");
    }

    public String getEntryId(Peroid period) {
        Map data = (Map)this.peroidData.get(period.toString());
        if (data == null) {
            return null;
        }
        return (String)data.get("entryId");
    }
}

