/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.mm.common.MMBaseInfo;
import com.kingdee.eas.mm.project.ProjectFeedBackInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.BatchExecuteParams;
import com.kingdee.eas.scm.common.action.TableSelectionHelper;
import java.math.BigDecimal;

public class SaveCostActionProxy
extends ActionProxy {
    private static final Class[] SAVECOST_TYPE = new Class[]{IObjectValue.class, IObjectPK.class};
    private String flag = "";
    private static final long serialVersionUID = -3512384010147118951L;

    public SaveCostActionProxy(BatchActionEnum bizAction, ItemAction action, String actionMethod, String flag) {
        super(action, actionMethod, bizAction);
        this.flag = flag;
    }

    public SaveCostActionProxy(ItemAction action, String actionMethod, ActionLevelEnum level, BatchActionEnum bizAction) {
        super(action, actionMethod, level, bizAction);
    }

    protected BatchExecuteParams initBatchExecuteParams(IBizCtrl bizInterface, BatchSelectionEntries selectionEntry) {
        KDTable tblmain = ((TableSelectionHelper)this.getActionManager().getTableSelectionHelper()).getTblMain();
        BatchExecuteParams batchParams = new BatchExecuteParams(this.getBizAction(), this.getActionManager().getClzIBizFactory(this.getLevel()), this.getActionMethod(), SAVECOST_TYPE, selectionEntry, this.getActionManager().getContextType(), bizInterface.getType());
        ObjectUuidPK objectPk = null;
        for (int i = 0; i < selectionEntry.getEntries().size(); ++i) {
            MMBaseInfo objValue;
            BatchSelectionEntry entry = selectionEntry.get(i);
            if (entry.getResult() == ActionResultEnum.ERROR) continue;
            IRow row = tblmain.getRow(entry.getRowNum());
            String tblId = row.getCell("id").getValue().toString();
            if (!entry.getId().equals(tblId)) continue;
            BOSUuid bosUuid = BOSUuid.read((String)entry.getId());
            objectPk = new ObjectUuidPK(bosUuid);
            if (this.flag.equals("ProjectTaskInfo")) {
                objValue = new ProjectTaskInfo();
                objValue.setId(bosUuid);
                objValue.setTotalCost(new BigDecimal(row.getCell("totalCost").getValue() != null ? row.getCell("totalCost").getValue().toString() : "0"));
                objValue.setUnitCost(new BigDecimal(row.getCell("unitCost").getValue() != null ? row.getCell("unitCost").getValue().toString() : "0"));
                batchParams.newParamsEntry().add((Object)objValue).add((Object)objectPk);
                continue;
            }
            if (!this.flag.equals("ProjectFeedBackInfo")) continue;
            objValue = new ProjectFeedBackInfo();
            objValue.setId(bosUuid);
            objValue.setActTotalCost(new BigDecimal(row.getCell("totalCost").getValue() != null ? row.getCell("totalCost").getValue().toString() : "0"));
            objValue.setActUnitCost(new BigDecimal(row.getCell("unitCost").getValue() != null ? row.getCell("unitCost").getValue().toString() : "0"));
            ProjectTaskInfo projectTask = new ProjectTaskInfo();
            if (row.getCell("projectTask.id").getValue() != null) {
                BOSUuid taskUuid = BOSUuid.read((String)row.getCell("projectTask.id").getValue().toString());
                projectTask.setId(taskUuid);
            }
            ProjectInfo project = new ProjectInfo();
            BOSUuid projectUuid = BOSUuid.read((String)row.getCell("project.id").getValue().toString());
            project.setId(projectUuid);
            objValue.setProjectTask(projectTask);
            objValue.setProject(project);
            batchParams.newParamsEntry().add((Object)objValue).add((Object)objectPk);
        }
        return batchParams;
    }
}

