/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMExtend2FacadeFactory;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.BOM2WBSFacadeFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.client.AbstractBOM2WBSUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class BOM2WBSUI
extends AbstractBOM2WBSUI {
    private static final Logger logger = CoreUIObject.getLogger(BOM2WBSUI.class);
    private StorageOrgUnitInfo storageOrg = null;
    private ProjectInfo project = null;
    private ProjectTaskInfo parentTask = null;
    private TrackNumberInfo trackNum = null;
    private MaterialInfo material = null;
    private BomInfo bom = null;
    private MeasureUnitInfo unit = null;
    private BigDecimal qty = null;
    protected F7ContextManager f7Manager = null;
    private boolean isTemplate = false;
    private DataChangeListener projectChangedListener = null;
    private DataChangeListener parentChangedListener = null;
    private DataChangeListener materialChangedListener = null;
    private DataChangeListener trackNumChangedListener = null;

    public void onLoad() throws Exception {
        String strTemplate = (String)this.getUIContext().get("UIClassParam");
        this.isTemplate = this.toBoolean(strTemplate);
        if (this.f7Manager == null) {
            this.f7Manager = new F7ContextManager((Component)((Object)this), this.getMainBizOrgType());
        }
        super.onLoad();
        this.initOwnF7();
        this.prmtStorageOrgUnit.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)this.getPermissionItem()));
        this.setTitle();
        this.changeF7Context();
        this.txtQty.setMinimumValue((Comparable)new BigDecimal("0"));
        this.txtQty.setMaximumValue((Comparable)new BigDecimal("10000000000000"));
        this.txtQty.setRemoveingZeroInDispaly(false);
        this.txtQty.setNegatived(false);
        this.txtQty.setHorizontalAlignment(4);
        this.txtQty.setValue((Object)new BigDecimal("0"));
        this.txtQty.setPrecision(0);
    }

    @Override
    public void loadFields() {
        this.removeActionListener();
        super.loadFields();
        this.initActionListener();
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        this.registBizMaterialF74ETO();
        if (oldOrgId == null || oldOrgId != null && !oldOrgId.equalsIgnoreCase(newOrgId)) {
            this.prmtProject.setValue(null);
            this.prmtParent.setValue(null);
            this.prmtMaterial.setValue(null);
            this.prmtBom.setValue(null);
            this.txtQty.setValue(null);
            this.changeF7Context();
        }
        this.loadFields();
    }

    private void changeF7Context() {
        this.f7Manager.setMainOrgContext(this.getMainOrgContext());
        this.f7Manager.changeF7Context(this.getUIContext());
    }

    private void removeActionListener() {
        if (this.projectChangedListener != null) {
            this.prmtProject.removeDataChangeListener(this.projectChangedListener);
        }
        if (this.parentChangedListener != null) {
            this.prmtParent.removeDataChangeListener(this.parentChangedListener);
        }
        if (this.materialChangedListener != null) {
            this.prmtMaterial.removeDataChangeListener(this.materialChangedListener);
        }
        if (this.trackNumChangedListener != null) {
            this.prmtTrackNum.removeDataChangeListener(this.trackNumChangedListener);
        }
    }

    private void initActionListener() {
        this.projectChangedListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent paramDataChangeEvent) {
                Object oldValue = paramDataChangeEvent.getOldValue();
                Object newValue = paramDataChangeEvent.getNewValue();
                if (newValue == null) {
                    return;
                }
                if (!SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue)) {
                    return;
                }
                ProjectInfo project = (ProjectInfo)newValue;
                BOM2WBSUI.this.removeActionListener();
                BOM2WBSUI.this.prmtParent.setValue(null);
                BOM2WBSUI.this.prmtTrackNum.setValue(null);
                BOM2WBSUI.this.initActionListener();
                BOM2WBSUI.this.txtQty.setValue((Object)project.getQty());
                BOM2WBSUI.this.getBOM();
            }
        };
        this.prmtProject.addDataChangeListener(this.projectChangedListener);
        this.parentChangedListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent paramDataChangeEvent) {
                Object oldValue = paramDataChangeEvent.getOldValue();
                Object newValue = paramDataChangeEvent.getNewValue();
                if (newValue == null) {
                    return;
                }
                if (!SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue)) {
                    return;
                }
                ProjectTaskInfo parent = (ProjectTaskInfo)newValue;
                BOM2WBSUI.this.txtQty.setValue((Object)parent.getQty());
            }
        };
        this.prmtParent.addDataChangeListener(this.parentChangedListener);
        this.materialChangedListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent paramDataChangeEvent) {
                Object oldValue = paramDataChangeEvent.getOldValue();
                Object newValue = paramDataChangeEvent.getNewValue();
                if (newValue == null) {
                    BOM2WBSUI.this.removeActionListener();
                    BOM2WBSUI.this.prmtBom.setValue(null);
                    BOM2WBSUI.this.txtQty.setPrecision(0);
                    BOM2WBSUI.this.prmtUnit.setValue(null);
                    BOM2WBSUI.this.initActionListener();
                    return;
                }
                if (!SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue)) {
                    return;
                }
                MaterialInfo mInfo = (MaterialInfo)newValue;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mInfo.getId().toString()));
                view.setFilter(filter);
                try {
                    BomCollection boms = BomFactory.getRemoteInstance().getBomCollection(view);
                    BOM2WBSUI.this.removeActionListener();
                    MeasureUnitInfo baseUnit = ((MaterialInfo)newValue).getBaseUnit();
                    int precision = 0;
                    try {
                        precision = ProjectUtil.getPrecisionByMaterialInfo((MaterialInfo)newValue, baseUnit);
                    }
                    catch (EASBizException e) {
                        BOM2WBSUI.this.handUIException(e);
                    }
                    catch (BOSException e) {
                        BOM2WBSUI.this.handUIException(e);
                    }
                    if (boms.size() > 0) {
                        BOM2WBSUI.this.prmtBom.setValue((Object)boms.get(0));
                    }
                    BOM2WBSUI.this.txtQty.setPrecision(precision);
                    BOM2WBSUI.this.prmtUnit.setValue((Object)mInfo.getBaseUnit());
                    BOM2WBSUI.this.initActionListener();
                }
                catch (BOSException e) {
                    BOM2WBSUI.this.handUIException(e);
                }
                BOM2WBSUI.this.getBOM();
            }
        };
        this.prmtMaterial.addDataChangeListener(this.materialChangedListener);
        this.trackNumChangedListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent paramDataChangeEvent) {
                Object newValue;
                Object oldValue = paramDataChangeEvent.getOldValue();
                if (!SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = paramDataChangeEvent.getNewValue()))) {
                    return;
                }
                BOM2WBSUI.this.getBOM();
            }
        };
        this.prmtTrackNum.addDataChangeListener(this.trackNumChangedListener);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    private void initOwnF7() {
        ProjectUtil.setMainBizOrgF7(this.prmtStorageOrgUnit, this.getPermissionItem());
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        HashSet<Integer> taskStatus = new HashSet<Integer>();
        taskStatus.add(new Integer(4));
        taskStatus.add(new Integer(2));
        taskStatus.add(new Integer(60));
        taskStatus.add(new Integer(5));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProject, status, this.isTemplate, null);
        this.setProjectTaskF7(null, this.prmtProject, null, this.prmtParent, taskStatus, null);
        this.registBizMaterialF74ETO();
        UIHelper.registerTrackNumberF7ForEdit((KDBizPromptBox)this.prmtStorageOrgUnit, null, (KDBizPromptBox)this.prmtProject, (KDBizPromptBox)this.prmtTrackNum, (boolean)false);
        this.registBOMF7();
    }

    private void registBizMaterialF74ETO() {
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.prmtStorageOrgUnit.getData();
        String orgId = "";
        orgId = orgInfo == null ? "null" : orgInfo.getId().toString();
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterial, (OrgUnitInfo)orgInfo);
        EntityViewInfo view = this.prmtMaterial.getEntityViewInfo();
        StringBuffer sqlBuf = new StringBuffer("");
        sqlBuf.append("select FMaterialID from T_BD_MaterialPlan t0 inner join T_BD_ManufactureStrategy t1 ");
        sqlBuf.append("on t0.FManufactureStrategyID = t1.FID where t1.FID in('");
        sqlBuf.append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
        sqlBuf.append("') and t0.fstatus = 1 AND t0.FOrgUnit = '");
        sqlBuf.append(orgId);
        sqlBuf.append("'");
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)sqlBuf.toString(), CompareType.INNER);
        String mask = "(" + view.getFilter().getMaskString() + ") AND #" + (view.getFilter().getFilterItems().size() - 1);
        view.getFilter().getFilterItems().add(filterItem);
        if (view.getFilter().getMaskString() != null) {
            view.getFilter().setMaskString(mask);
        }
        this.prmtMaterial.setEntityViewInfo(view);
        this.prmtMaterial.setDisplayFormat("$name$");
    }

    private void registBOMF7() {
        this.prmtBom.setQueryInfo("com.kingdee.eas.mm.basedata.app.F7BomQuery");
        this.prmtBom.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                BOM2WBSUI.this.prmtBom.setEntityViewInfo(BOM2WBSUI.this.getTaskEntityViewInfo(BOM2WBSUI.this.prmtMaterial));
                BOM2WBSUI.this.prmtBom.getQueryAgent().resetRuntimeEntityView();
            }
        });
        this.prmtBom.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                BOM2WBSUI.this.prmtBom.setEntityViewInfo(BOM2WBSUI.this.getTaskEntityViewInfo(BOM2WBSUI.this.prmtMaterial));
                BOM2WBSUI.this.prmtBom.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    private EntityViewInfo getTaskEntityViewInfo(KDBizPromptBox materialBox) {
        Object material = materialBox.getData();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (material == null) {
            keys.add("null");
        } else if (material != null && material instanceof MaterialInfo) {
            keys.add(((MaterialInfo)material).getId().toString());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", keys, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private String getPermissionItem() {
        return "mm_projecttask_bom2wbs";
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String errorString;
        super.actionSubmit_actionPerformed(e);
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "PLEASE_CHOOSE_ORG"));
            SysUtil.abort();
            return;
        }
        this.storageOrg = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        if (this.prmtProject.getValue() == null) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "PLEASE_CHOOSE_PROJECT"));
            SysUtil.abort();
            return;
        }
        this.project = (ProjectInfo)this.prmtProject.getValue();
        if (this.prmtMaterial.getValue() == null) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "MATERIAL_CANT_NULL"));
            SysUtil.abort();
            return;
        }
        this.material = (MaterialInfo)this.prmtMaterial.getValue();
        if (this.prmtBom.getValue() == null) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "BOM_CANT_NULL"));
            SysUtil.abort();
            return;
        }
        this.bom = (BomInfo)this.prmtBom.getValue();
        if (this.txtQty.getBigDecimalValue().equals(new BigDecimal("0"))) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "NUMBER_GREATER_0"));
            SysUtil.abort();
            return;
        }
        this.qty = this.txtQty.getBigDecimalValue();
        if (this.prmtParent.getValue() != null) {
            this.parentTask = (ProjectTaskInfo)this.prmtParent.getValue();
        }
        this.trackNum = (TrackNumberInfo)this.prmtTrackNum.getValue();
        this.unit = (MeasureUnitInfo)this.prmtUnit.getValue();
        HashMap<String, Object> inParam = new HashMap<String, Object>();
        inParam.put("PARENT", this.parentTask);
        inParam.put("PROJECT", this.project);
        inParam.put("BOMID", this.bom.getId().toString());
        inParam.put("STORAGEORG", this.storageOrg);
        inParam.put("QTY", this.qty);
        inParam.put("MATERIAL", this.material);
        inParam.put("UNIT", this.unit);
        inParam.put("ISTEMP", new Boolean(this.isTemplate));
        inParam.put("FORWARD", new Boolean(this.kdrFoward.isSelected()));
        if (this.trackNum != null) {
            inParam.put("TRACKNUM", this.trackNum.getId().toString());
        }
        if (StringUtils.isEmpty((String)(errorString = BOM2WBSFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).bom2wbs(inParam)))) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "BOM2WBS_SUCCESS"));
            this.destroyWindow();
        } else {
            String erroTitle = EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource.BOM2WBS_ERRO");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)erroTitle, (String)errorString, (int)0);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    private boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    private void setTitle() {
        if (this.isTemplate) {
            this.setUITitle(ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "BOM2WBS_TEMP"));
        } else {
            this.setUITitle(ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "BOM2WBS"));
        }
    }

    private void getBOM() {
        String pid = null;
        String tid = null;
        String sid = null;
        String mid = null;
        if (this.prmtProject.getValue() != null) {
            pid = ((ProjectInfo)this.prmtProject.getValue()).getId().toString();
        }
        if (this.prmtTrackNum.getValue() != null) {
            tid = ((TrackNumberInfo)this.prmtTrackNum.getValue()).getId().toString();
        }
        if (this.prmtStorageOrgUnit.getValue() != null) {
            sid = ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString();
        }
        if (this.prmtMaterial.getValue() != null) {
            mid = ((MaterialInfo)this.prmtMaterial.getValue()).getId().toString();
        }
        try {
            if (mid != null && sid != null) {
                BomInfo bominfo = BOMExtend2FacadeFactory.getRemoteInstance().getBomByTrcAndPrjID(mid, pid, tid, sid);
                this.prmtBom.setValue((Object)bominfo);
            }
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    public void setProjectTaskF7(final KDBizPromptBox storageOrgUnitBox, final KDBizPromptBox projectBoxFrom, final KDBizPromptBox projectBoxTo, final KDBizPromptBox taskBox, final HashSet status, SelectorItemCollection userSelector) {
        taskBox.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectTaskQuery");
        SelectorItemCollection selectors = null;
        selectors = userSelector == null ? new SelectorItemCollection() : userSelector;
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("taskType.id"));
        selectors.add(new SelectorItemInfo("taskType.number"));
        selectors.add(new SelectorItemInfo("taskType.name"));
        taskBox.setSelectorCollection(selectors);
        taskBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                taskBox.setEntityViewInfo(BOM2WBSUI.this.getProjectTaskF7EntityView(storageOrgUnitBox, projectBoxFrom, projectBoxTo, status));
                taskBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
        taskBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                taskBox.setEntityViewInfo(BOM2WBSUI.this.getProjectTaskF7EntityView(storageOrgUnitBox, projectBoxFrom, projectBoxTo, status));
                taskBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    public EntityViewInfo getProjectTaskF7EntityView(KDBizPromptBox storageOrgUnitBox, KDBizPromptBox projectBoxFrom, KDBizPromptBox projectBoxTo, HashSet status) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (storageOrgUnitBox != null && storageOrgUnitBox.getValue() != null) {
            OrgUnitInfo mainOrg = (OrgUnitInfo)storageOrgUnitBox.getValue();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)mainOrg.getId().toString(), CompareType.EQUALS));
        }
        ProjectInfo project = null;
        if (projectBoxTo == null && projectBoxFrom != null || projectBoxTo != null && projectBoxFrom == null) {
            project = projectBoxTo == null ? (ProjectInfo)projectBoxFrom.getData() : (ProjectInfo)projectBoxTo.getData();
            String projectId = "null";
            if (project != null) {
                projectId = project.getId().toString();
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectId));
        } else if (projectBoxTo != null && projectBoxFrom != null) {
            ProjectInfo projectFrom = (ProjectInfo)projectBoxFrom.getData();
            ProjectInfo projectTo = (ProjectInfo)projectBoxFrom.getData();
            String projectNumFrom = "null";
            String projectNumTo = "null";
            if (projectFrom != null) {
                projectNumFrom = projectFrom.getNumber();
            }
            if (projectTo != null) {
                projectNumTo = projectTo.getNumber();
            }
            if (!projectNumFrom.equalsIgnoreCase("null")) {
                filterInfo.getFilterItems().add(new FilterItemInfo("project.number", (Object)projectNumFrom, CompareType.GREATER_EQUALS));
            }
            if (!projectNumTo.equalsIgnoreCase("null")) {
                filterInfo.getFilterItems().add(new FilterItemInfo("project.number", (Object)projectNumTo, CompareType.LESS_EQUALS));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("wbsNumber", null, CompareType.NOTEQUALS));
        if (status != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.INCLUDE));
        }
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }
}

