/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.project.client.AbstractDocumentFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class DocumentFilterUI
extends AbstractDocumentFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DocumentFilterUI.class);
    private DataChangeListener stotageDataChanged = null;
    private DataChangeListener projectDataChanged = null;

    public void onLoad() throws Exception {
        this.setIsSupportMultiOrgs(true);
        super.onLoad();
        HashSet<Integer> hset = new HashSet<Integer>();
        hset.add(new Integer(4));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProjectF, hset, false, null);
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, DocumentFilterUI.getResource("STORAGEORGUNIT")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        SingleFilterElement titlte = new SingleFilterElement("titlte", (Component)this.txtTitlte);
        elements.add((FilterElement)titlte);
        SingleFilterElement projectnumber = new SingleFilterElement("project.number", (Component)this.prmtProjectF);
        elements.add((FilterElement)projectnumber);
        SingleFilterElement number = new SingleFilterElement("number", (Component)this.prmtNumberF);
        elements.add((FilterElement)number);
        SingleFilterElement helperCode = new SingleFilterElement("helperCode", (Component)this.txtHelperCodeF);
        elements.add((FilterElement)helperCode);
        this.getFilterManager().setElement((FilterElement)elements);
        ProjectUtil.setDocumentF7(this.prmtProjectF, this.prmtNumberF);
        this.kDSave.setSelected(true);
        this.kDAudit.setSelected(true);
        this.kDDisable.setSelected(true);
        this.addListener();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (!flag) {
            return flag;
        }
        if (!(this.kDSave.isSelected() || this.kDAudit.isSelected() || this.kDDisable.isSelected())) {
            MsgBox.showInfo((String)DocumentFilterUI.getResource("NEED_STATUS"));
            flag = false;
        }
        return flag;
    }

    protected String getViewPermission() {
        return "mm_project_documentView";
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public FilterInfo getFilterInfo() {
        HashSet<Integer> set = new HashSet<Integer>();
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        FilterInfo filter2 = new FilterInfo();
        String textname = this.txtTitlte.getText();
        String projectNumber = this.prmtProjectF.getText();
        String docNumber = this.prmtNumberF.getText();
        if (!"".equals(textname.trim())) {
            filter2.getFilterItems().add(new FilterItemInfo("titlte", (Object)("%" + textname + "%"), CompareType.LIKE));
        }
        if (!"".equals(projectNumber.trim()) && projectNumber.split(",").length <= 1) {
            filter2.getFilterItems().add(new FilterItemInfo("project.number", (Object)("%" + projectNumber + "%"), CompareType.LIKE));
        }
        if (!"".equals(docNumber.trim())) {
            filter2.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + docNumber + "%"), CompareType.LIKE));
        }
        FilterInfo filter1 = filterInfo;
        filterInfo = new FilterInfo();
        for (int i = 0; i < filter1.getFilterItems().size(); ++i) {
            if (filter1.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("titlte") || filter1.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("project.number") || filter1.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("number")) continue;
            filterInfo.getFilterItems().add(filter1.getFilterItems().get(i));
        }
        try {
            filterInfo.mergeFilter(filter2, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (this.kDSave.isSelected()) {
            set.add(new Integer(1));
        }
        if (this.kDAudit.isSelected()) {
            set.add(new Integer(4));
        }
        if (this.kDDisable.isSelected()) {
            set.add(new Integer(50));
        }
        if (set.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.DocumentResource", (String)strKey);
    }

    private void addListener() {
        this.stotageDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    DocumentFilterUI.this.prmtProjectF.setValue(null);
                    DocumentFilterUI.this.prmtNumberF.setValue(null);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.stotageDataChanged);
        this.projectDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    DocumentFilterUI.this.prmtNumberF.setValue(null);
                }
            }
        };
        this.prmtProjectF.addDataChangeListener(this.projectDataChanged);
    }

    private void removeListener() {
        if (this.stotageDataChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.stotageDataChanged);
        }
        if (this.projectDataChanged != null) {
            this.prmtProjectF.removeDataChangeListener(this.projectDataChanged);
        }
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        super.loadData(entityViewInfo);
        this.addListener();
    }
}

