/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.IUILifeCycleListener;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.framework.client.attachMent.AttachMentHelper;
import com.kingdee.eas.mm.project.DocumentAttatchmentCollection;
import com.kingdee.eas.mm.project.DocumentAttatchmentInfo;
import com.kingdee.eas.mm.project.DocumentCollection;
import com.kingdee.eas.mm.project.DocumentFactory;
import com.kingdee.eas.mm.project.DocumentInfo;
import com.kingdee.eas.mm.project.ProjectGroupInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.client.AbstractDocumentListUI;
import com.kingdee.eas.mm.project.client.DocumentEditUI;
import com.kingdee.eas.mm.project.client.DocumentFilterUI;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class DocumentListUI
extends AbstractDocumentListUI {
    private static final Logger logger = CoreUIObject.getLogger(DocumentListUI.class);
    DocumentCollection docCollection = null;
    KDTMouseListener mouseListener = null;
    DocumentFilterUI documentfilter = new DocumentFilterUI();
    private FilterInfo mainFilter;

    public DocumentListUI() throws Exception {
        this.tblMain.setEditable(false);
        this.tblEntries.setEditable(false);
    }

    protected String getEditUIName() {
        return DocumentEditUI.class.getName();
    }

    protected ISCMFilter getFilterUI() throws Exception {
        return this.documentfilter;
    }

    protected String getViewPermissionItem() {
        return "mm_project_documentView";
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.removeButton();
        this.addNewColumn();
        this.removeListerner();
        this.addListerner();
    }

    public SelectorItemCollection getDocumentSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("titlte"));
        sic.add(new SelectorItemInfo("helperCode"));
        sic.add(new SelectorItemInfo("attachCount"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("entries.name"));
        sic.add(new SelectorItemInfo("entries.description"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        return sic;
    }

    private void addListerner() {
        this.mouseListener = new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (DocumentListUI.this.tblEntries.getRow(e.getRowIndex()) == null) {
                    return;
                }
                try {
                    if (e.getColIndex() != -1 && DocumentListUI.this.tblEntries.getColumn(e.getColIndex()).getKey().equals(DocumentListUI.this.getEntriesName() + "." + "attacheMentId")) {
                        DocumentListUI.this.showSubAttacheMent(null);
                    }
                }
                catch (Exception e1) {
                    DocumentListUI.this.handUIException(e1);
                }
            }
        };
        this.tblEntries.addKDTMouseListener(this.mouseListener);
    }

    private void removeListerner() {
        if (this.mouseListener != null) {
            this.tblEntries.removeKDTMouseListener(this.mouseListener);
        }
    }

    public void addNewColumn() {
        IColumn column = null;
        String entryIdName = this.getEntriesPKName();
        column = this.tblEntries.getColumn(entryIdName);
        if (column == null) {
            return;
        }
        int columnIndex = column.getColumnIndex();
        columnIndex = columnIndex <= 0 ? 1 : --columnIndex;
        column = this.tblEntries.addColumn(columnIndex);
        column.setKey(this.getEntriesName() + "." + "attacheMentId");
        column.setWidth(100);
        this.tblEntries.getHeadRow(0).getCell(1).setValue((Object)DocumentListUI.getDocumentResource("ATTATCHMENT"));
        column.getStyleAttributes().setLocked(true);
    }

    protected void attachMentDataFill(int firstIndex, int lastIndex, String flag) {
        boolean entryAttach = this.tblEntries.getColumn(this.getEntriesName() + "." + "attacheMentId") == null;
        Icon image = EASResource.getIcon((String)"imgBill_icon_4");
        ArrayList<String> entryIdList = new ArrayList<String>();
        String entryPkName = this.getEntriesPKName();
        for (int r = firstIndex; r <= lastIndex; ++r) {
            Object entryPkValue;
            if (entryAttach || (entryPkValue = this.tblEntries.getRow(r).getCell(entryPkName).getValue()) == null) continue;
            entryIdList.add(entryPkValue.toString());
        }
        Collection entryCol = null;
        try {
            if (!entryAttach && (flag.equals("ALL") || flag.equals("ENTRY")) && entryIdList.size() > 0) {
                IRowSet entryRowSet = AttachMentHelper.getRowAttachment((Object[])entryIdList.toArray(), (int)Integer.MAX_VALUE);
                entryCol = entryRowSet.toCollection(1);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        boolean exist = false;
        for (int r = firstIndex; r <= lastIndex; ++r) {
            if (entryCol == null) continue;
            Object value = this.tblEntries.getRow(r).getCell(this.getEntriesPKName()).getValue();
            exist = value != null ? entryCol.contains(value.toString()) : false;
            ICell attachCell = this.tblEntries.getRow(r).getCell(this.getEntriesName() + "." + "attacheMentId");
            if (exist) {
                attachCell.setValue((Object)image);
                continue;
            }
            attachCell.setValue(null);
        }
    }

    protected final IUILifeCycleListener addAttatchListener(final String type) {
        UILifeCycleImp lifeCycleListener = new UILifeCycleImp(){

            public void onDestroyWindow(UILifeCycleEvent event) {
                ICell attachCell;
                int[] selectRows;
                String attachType = type;
                if (attachType == null) {
                    attachType = "ENTRY";
                }
                if ((selectRows = KDTableUtil.getSelectedRows((KDTable)DocumentListUI.this.tblEntries)) == null || selectRows.length == 0) {
                    return;
                }
                if (attachType.equals("ENTRY") && (attachCell = DocumentListUI.this.tblEntries.getRow(selectRows[0]).getCell(DocumentListUI.this.getEntriesName() + "." + "attacheMentId")) != null) {
                    DocumentListUI.this.attachMentDataFill(selectRows[0], selectRows[0], "ENTRY");
                }
            }
        };
        return lifeCycleListener;
    }

    protected void showSubAttacheMent(AttachmentUIContextInfo info) {
        if (info == null) {
            this.checkSelected();
            this.subKeyFieldName = this.getEntriesPKName();
            String id = ListUiHelper.getSelectedKeyValue((int[])KDTableUtil.getSelectedRows((KDTable)this.tblEntries), (KDTable)this.tblEntries, (String)"entries.id");
            if (id == null) {
                return;
            }
            info = new AttachmentUIContextInfo();
            info.setBoID(id);
            this.subKeyFieldName = null;
        }
        if (info != null) {
            info.setEdit(false);
            info.setListener(this.addAttatchListener("ENTRY"));
            AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
            acm.showAttachmentListUIByBoID((Object)this, info);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.tblEntries.removeRows();
        int[] rowCount = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int rowNumber = 0; rowNumber < rowCount.length; ++rowNumber) {
            IRow irow = this.tblMain.getRow(rowCount[rowNumber]);
            DocumentInfo docInfo = null;
            if (this.docCollection == null) continue;
            for (int i = 0; i < this.docCollection.size(); ++i) {
                docInfo = this.docCollection.get(i);
                if (irow == null || !irow.getCell("id").getValue().toString().equals(docInfo.getId().toString())) continue;
                this.BindingData(docInfo);
            }
        }
        if (this.tblEntries.getRowCount() > 0) {
            this.attachMentDataFill(0, this.tblEntries.getRowCount() - 1, "ALL");
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        EntityViewInfo entityViewInfo = this.mainQuery;
        if (entityViewInfo != null) {
            if (entityViewInfo.getFilter() == null) {
                this.abort();
            }
            entityViewInfo.setSelector(this.getDocumentSelectors());
            this.docCollection = DocumentFactory.getRemoteInstance().getDocumentCollection(entityViewInfo);
            this.tblEntries.removeRows();
            entityViewInfo.setSelector(this.getSelectors());
        }
    }

    private void BindingData(DocumentInfo docInfo) throws Exception {
        DocumentAttatchmentCollection docEntriesConllection = docInfo.getEntries();
        for (int i = 0; i < docEntriesConllection.size(); ++i) {
            IRow entriesRow = this.tblEntries.addRow();
            DocumentAttatchmentInfo docEntries = docEntriesConllection.get(i);
            entriesRow.getCell("number").setValue((Object)docInfo.getNumber());
            entriesRow.getCell("title").setValue((Object)docInfo.getTitlte());
            entriesRow.getCell("entries.id").setValue((Object)docEntries.getId());
            entriesRow.getCell("entries.seq").setValue((Object)new Integer(docEntries.getSeq()));
            entriesRow.getCell("entries.name").setValue((Object)docEntries.getName());
            entriesRow.getCell("entries.description").setValue((Object)docEntries.getDescription());
        }
    }

    protected void initBatchInterface() {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, DocumentFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "storageOrgUnit.id");
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DocumentFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    public static String getDocumentResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.DocumentResource", (String)strKey);
    }

    @Override
    protected boolean isTemplate() {
        return false;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.mainFilter = this.mainQuery.getFilter();
    }

    @Override
    public void selectedProject(ProjectInfo project) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)project.getId().toString(), CompareType.EQUALS));
        for (int i = 0; i < this.mainFilter.getFilterItems().size(); ++i) {
            String pname = this.mainFilter.getFilterItems().get(i).getPropertyName();
            if (!pname.equalsIgnoreCase("baseStatus") && !pname.equalsIgnoreCase("storageOrgUnit.number")) continue;
            filter.getFilterItems().add(this.mainFilter.getFilterItems().get(i));
        }
        try {
            this.mainQuery.setFilter(filter);
            this.refreshList();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void selectedGroup(ProjectGroupInfo projectGroup) {
        FilterInfo filter = new FilterInfo();
        boolean isHasProject = false;
        if (projectGroup.getParent() == null) {
            filter = this.mainFilter;
        } else {
            StringBuffer projectSql = new StringBuffer();
            projectSql.append("select FID from T_MM_Project where FGROUPID in ");
            projectSql.append("(select FID from T_MM_ProjectGroup where FPARENTID = '");
            projectSql.append(projectGroup.getId().toString());
            projectSql.append("') ");
            projectSql.append("or  FGROUPID = '");
            projectSql.append(projectGroup.getId().toString());
            projectSql.append("' ");
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectSql.toString(), CompareType.INNER));
            for (int i = 0; i < this.mainFilter.getFilterItems().size(); ++i) {
                String pname = this.mainFilter.getFilterItems().get(i).getPropertyName();
                if (!pname.equalsIgnoreCase("baseStatus") && !pname.equalsIgnoreCase("storageOrgUnit.number")) continue;
                filter.getFilterItems().add(this.mainFilter.getFilterItems().get(i));
            }
        }
        try {
            this.mainQuery.setFilter(filter);
            this.refreshList();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

