/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.mm.project.client.AbstractGraphicOptionsUI;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOption;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class GraphicOptionsUI
extends AbstractGraphicOptionsUI {
    private static final Logger logger = CoreUIObject.getLogger(GraphicOptionsUI.class);
    GPOptionGroup[] myGroups;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnOk.setIcon(EASResource.getIcon((String)"imgTbtn_selectcompany"));
        this.btnOk.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.myGroups = (GPOptionGroup[])this.getUIContext().get("myGroups");
        for (int i = 0; this.myGroups != null && i < this.myGroups.length; ++i) {
            GPOptionGroup group = this.myGroups[i];
            GPOption[] options = group.getOptions();
            for (int m = 0; options != null && m < options.length; ++m) {
                GPOption option = options[m];
                String id = option.getID();
                String value = option.getPersistentValue();
                if (value == null) continue;
                if (id.equals("showTodayLine")) {
                    this.checkToday.setSelected(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (id.equals("showProjectDates")) {
                    this.checkDisStartEnd.setSelected(Boolean.valueOf(value).booleanValue());
                    continue;
                }
                if (id.equals("taskLabelUp")) {
                    this.setSelect(this.combUp, value);
                    continue;
                }
                if (id.equals("taskLabelDown")) {
                    this.setSelect(this.combDown, value);
                    continue;
                }
                if (id.equals("taskLabelLeft")) {
                    this.setSelect(this.combLeft, value);
                    continue;
                }
                if (id.equals("taskLabelRight")) {
                    this.setSelect(this.combRight, value);
                    continue;
                }
                if (id.equals("newTaskDefaultColor")) {
                    Color color = new Color(Integer.parseInt(value.substring(1), 16));
                    this.colorNewTask.setColor(color);
                    continue;
                }
                if (!id.equals("chart.weekend_alpha_rendering")) continue;
                if (value.equals("chart.weekend_alpha_rendering.100")) {
                    this.combWeekend.setSelectedIndex(0);
                    continue;
                }
                if (value.equals("chart.weekend_alpha_rendering.75")) {
                    this.combWeekend.setSelectedIndex(1);
                    continue;
                }
                if (value.equals("chart.weekend_alpha_rendering.50")) {
                    this.combWeekend.setSelectedIndex(2);
                    continue;
                }
                if (value.equals("chart.weekend_alpha_rendering.25")) {
                    this.combWeekend.setSelectedIndex(3);
                    continue;
                }
                if (!value.equals("chart.weekend_alpha_rendering.0")) continue;
                this.combWeekend.setSelectedIndex(4);
            }
        }
        this.colorNewTask.setEnabled(false);
    }

    public void setSelect(KDComboBox obj, String select) {
        if (select.equals("id")) {
            obj.setSelectedIndex(1);
        } else if (select.equals("taskDates")) {
            obj.setSelectedIndex(2);
        } else if (select.equals("length")) {
            obj.setSelectedIndex(4);
        } else if (select.equals("name")) {
            obj.setSelectedIndex(3);
        } else if (select.equals("advancement")) {
            obj.setSelectedIndex(5);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; this.myGroups != null && i < this.myGroups.length; ++i) {
            GPOptionGroup group = this.myGroups[i];
            group.lock();
            GPOption[] options = group.getOptions();
            for (int m = 0; options != null && m < options.length; ++m) {
                GPOption option = options[m];
                String id = option.getID();
                if (id.equals("showTodayLine")) {
                    option.loadPersistentValue(this.checkToday.isSelected() + "");
                    continue;
                }
                if (id.equals("showProjectDates")) {
                    option.loadPersistentValue(this.checkDisStartEnd.isSelected() + "");
                    continue;
                }
                if (id.equals("taskLabelUp")) {
                    option.loadPersistentValue(this.getSelect(this.combUp));
                    continue;
                }
                if (id.equals("taskLabelDown")) {
                    option.loadPersistentValue(this.getSelect(this.combDown));
                    continue;
                }
                if (id.equals("taskLabelLeft")) {
                    option.loadPersistentValue(this.getSelect(this.combLeft));
                    continue;
                }
                if (id.equals("taskLabelRight")) {
                    option.loadPersistentValue(this.getSelect(this.combRight));
                    continue;
                }
                if (id.equals("newTaskDefaultColor")) {
                    String color = Integer.toHexString(this.colorNewTask.getColor().getRGB());
                    if (color.length() > 6) {
                        color = color.substring(color.length() - 6);
                    } else if (color.length() < 6) {
                        while (color.length() < 6) {
                            color = "0" + color;
                        }
                    }
                    option.loadPersistentValue("#" + color);
                    continue;
                }
                if (!id.equals("chart.weekend_alpha_rendering")) continue;
                if (this.combWeekend.getSelectedIndex() == 0) {
                    option.loadPersistentValue("chart.weekend_alpha_rendering.100");
                } else if (this.combWeekend.getSelectedIndex() == 1) {
                    option.loadPersistentValue("chart.weekend_alpha_rendering.75");
                }
                if (this.combWeekend.getSelectedIndex() == 2) {
                    option.loadPersistentValue("chart.weekend_alpha_rendering.50");
                }
                if (this.combWeekend.getSelectedIndex() == 3) {
                    option.loadPersistentValue("chart.weekend_alpha_rendering.25");
                }
                if (this.combWeekend.getSelectedIndex() != 4) continue;
                option.loadPersistentValue("chart.weekend_alpha_rendering.0");
            }
            group.commit();
        }
        this.disposeUIWindow();
    }

    String getSelect(KDComboBox obj) {
        String rtn = "";
        if (obj.getSelectedIndex() == 0) {
            rtn = "";
        } else if (obj.getSelectedIndex() == 1) {
            rtn = "id";
        } else if (obj.getSelectedIndex() == 2) {
            rtn = "taskDates";
        } else if (obj.getSelectedIndex() == 3) {
            rtn = "name";
        } else if (obj.getSelectedIndex() == 4) {
            rtn = "length";
        } else if (obj.getSelectedIndex() == 5) {
            rtn = "advancement";
        }
        return rtn;
    }
}

