/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.project.ProcessProjectWeekendEnum;
import com.kingdee.eas.mm.project.client.AbstractHolidayEditUI;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ModifyStandDate;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class HolidayEditUI
extends AbstractHolidayEditUI {
    private static final Logger logger = CoreUIObject.getLogger(HolidayEditUI.class);
    GanttProject project;
    Collection publicHolidays;
    boolean dataChange = false;
    boolean dateError = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.publicHolidays = (Collection)this.getUIContext().get("publicHolidays");
        this.project = (GanttProject)this.getUIContext().get("project");
        this.initTable();
        this.initSelect();
        this.dataChange = false;
    }

    public void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDeleteLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnOk.setIcon(EASResource.getIcon((String)"imgTbtn_selectcompany"));
        this.btnOk.setEnabled(true);
        this.btnAddLine.setEnabled(true);
        this.btnDeleteLine.setEnabled(true);
    }

    public void initTable() {
        this.kDTable1.checkParsed();
        this.kDTable1.getColumn("date").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this.kDTable1.getColumn("date").setWidth(160);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor(new KDDatePicker());
        this.kDTable1.getColumn("date").setEditor((ICellEditor)cellEditor);
        Date stand = ModifyStandDate.getStandDate();
        for (Date d : this.publicHolidays) {
            IRow row = this.kDTable1.addRow();
            row.getCell("date").setValue((Object)d);
        }
        this.kDTable1.addKDTEditListener(new KDTEditListener(){

            public void editStarting(KDTEditEvent e) {
            }

            public void editStarted(KDTEditEvent e) {
            }

            public void editValueChanged(KDTEditEvent e) {
            }

            public void editStopping(KDTEditEvent e) {
            }

            public void editStopped(KDTEditEvent e) {
                Object obj;
                if (e.getValue() != null) {
                    if (!e.getValue().equals(e.getOldValue())) {
                        HolidayEditUI.this.dataChange = true;
                    }
                } else if (e.getOldValue() != null) {
                    HolidayEditUI.this.dataChange = true;
                }
                if ((obj = e.getValue()) instanceof Date) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(5, -1);
                    if (((Date)obj).before(calendar.getTime())) {
                        HolidayEditUI.this.dateError = true;
                        MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_HolidayMustAfterToday"));
                        HolidayEditUI.this.kDTable1.getCell(e.getRowIndex(), e.getColIndex()).setValue(e.getOldValue());
                    }
                }
            }

            public void editCanceled(KDTEditEvent e) {
            }
        });
        this.week0.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.dataChange = true;
                if (HolidayEditUI.this.week0.isSelected()) {
                    HolidayEditUI.this.week1.setSelected(false);
                    HolidayEditUI.this.week2.setSelected(false);
                    HolidayEditUI.this.week3.setSelected(false);
                    HolidayEditUI.this.week4.setSelected(false);
                    HolidayEditUI.this.week5.setSelected(false);
                    HolidayEditUI.this.week6.setSelected(false);
                    HolidayEditUI.this.week7.setSelected(false);
                }
            }
        });
        this.week1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.setCheckEnable();
            }
        });
        this.week2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.setCheckEnable();
            }
        });
        this.week3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.setCheckEnable();
            }
        });
        this.week4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.setCheckEnable();
            }
        });
        this.week5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.setCheckEnable();
            }
        });
        this.week6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.setCheckEnable();
            }
        });
        this.week7.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                HolidayEditUI.this.setCheckEnable();
            }
        });
    }

    boolean checkDate() {
        int count = this.kDTable1.getRowCount();
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < count; ++i) {
            if (this.kDTable1.getCell(i, 1).getValue() == null) {
                MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_DayCantNull"));
                this.kDTable1.getEditManager().editCellAt(count - 1, 1);
                return false;
            }
            set.add(this.kDTable1.getCell(i, 1).getValue());
        }
        if (count > set.size()) {
            MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_ExistHoliday"));
            this.kDTable1.getEditManager().editCellAt(count - 1, 1);
            return false;
        }
        return true;
    }

    void setCheckEnable() {
        if (!(this.week7.isSelected() || this.week6.isSelected() || this.week5.isSelected() || this.week4.isSelected() || this.week3.isSelected() || this.week2.isSelected() || this.week1.isSelected())) {
            this.week0.setSelected(true);
        } else {
            this.week0.setSelected(false);
        }
        this.dataChange = true;
    }

    public void initSelect() {
        Vector<String> vector = new Vector<String>(7);
        GPCalendar.DayType[] rows = this.project.getActiveCalendar().getMyTypes();
        for (int i = 0; i < rows.length; ++i) {
            GPCalendar.DayType dayType = rows[i];
            if (!dayType.equals(GPCalendar.DayType.WEEKEND)) continue;
            if (i == 0) {
                vector.add("6");
                continue;
            }
            vector.add(i - 1 + "");
        }
        int[] select = new int[vector.size()];
        if (select.length > 0) {
            if (vector.contains("0")) {
                this.week1.setSelected(true);
            }
            if (vector.contains("1")) {
                this.week2.setSelected(true);
            }
            if (vector.contains("2")) {
                this.week3.setSelected(true);
            }
            if (vector.contains("3")) {
                this.week4.setSelected(true);
            }
            if (vector.contains("4")) {
                this.week5.setSelected(true);
            }
            if (vector.contains("5")) {
                this.week6.setSelected(true);
            }
            if (vector.contains("6")) {
                this.week7.setSelected(true);
            }
        } else {
            this.week0.setSelected(true);
        }
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        int index;
        ProcessProjectWeekendEnum weekEnd;
        int i;
        Object[] obj;
        if (this.dateError) {
            this.dateError = false;
            return;
        }
        if (!this.checkDate()) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.kDTable1.getRowCount(); ++i2) {
            IRow row = this.kDTable1.getRow(i2);
            if (row.getCell("date").getValue() == null || !(row.getCell("date").getValue() instanceof Date)) continue;
            list.add(row.getCell("date").getValue());
        }
        this.getUIContext().put("list", list);
        Vector<ProcessProjectWeekendEnum> vector = new Vector<ProcessProjectWeekendEnum>();
        if (this.week0.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.None);
        }
        if (this.week1.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.Monday);
        }
        if (this.week2.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.Tuesday);
        }
        if (this.week3.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.Wednesday);
        }
        if (this.week4.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.Thursday);
        }
        if (this.week5.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.Friday);
        }
        if (this.week6.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.Saturday);
        }
        if (this.week7.isSelected()) {
            vector.add(ProcessProjectWeekendEnum.Sunday);
        }
        if ((obj = vector.toArray()).length >= 7) {
            if (e == null) {
                throw new Exception(GanttResourceUtil.getResource("Gantt_WeekendLower7"));
            }
            MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_WeekendLower7"));
            return;
        }
        if (obj.length == 0) {
            if (e == null) {
                throw new Exception(GanttResourceUtil.getResource("Gantt_MustWeekend"));
            }
            MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_MustWeekend"));
            return;
        }
        for (int i3 = 1; i3 <= 7; ++i3) {
            this.project.getActiveCalendar().setWeekDayType(i3, GPCalendar.DayType.WORKING);
        }
        boolean b = true;
        for (i = 0; i < obj.length; ++i) {
            weekEnd = (ProcessProjectWeekendEnum)((Object)obj[i]);
            index = Integer.parseInt(weekEnd.getValue());
            if (index != 8) continue;
            b = false;
        }
        for (i = 0; b && i < obj.length; ++i) {
            weekEnd = (ProcessProjectWeekendEnum)((Object)obj[i]);
            index = Integer.parseInt(weekEnd.getValue());
            index = index == 7 ? 1 : ++index;
            this.project.getActiveCalendar().setWeekDayType(index, GPCalendar.DayType.WEEKEND);
        }
        this.project.getActiveCalendar().getPublicHolidays().clear();
        for (i = 0; i < list.size(); ++i) {
            this.project.getActiveCalendar().setPublicHoliDayType((Date)list.get(i));
        }
        this.project.setAskForSave(true);
        this.dataChange = false;
        this.dateError = false;
        MsgBox.showInfo((String)GanttResourceUtil.getResource("Gantt_OptSuccess"));
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.kDTable1.addRow();
        this.dataChange = true;
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.kDTable1);
        if (rows.length > 0) {
            int i;
            Date stand = ModifyStandDate.getStandDate();
            for (i = 0; i < rows.length; ++i) {
                ICell cell = this.kDTable1.getRow(rows[i]).getCell("date");
                if (!(cell.getValue() instanceof Date) || !((Date)cell.getValue()).before(stand)) continue;
                MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_CantDelHoliday"));
                return;
            }
            for (i = 0; i < rows.length; ++i) {
                this.kDTable1.removeRow(rows[i] - i);
            }
            this.dataChange = true;
        }
    }

    public static List getData(GanttProject ganttProject) {
        List list = new ArrayList();
        try {
            UIContext context = new UIContext();
            context.put((Object)"project", (Object)ganttProject);
            context.put((Object)"publicHolidays", (Object)ganttProject.getActiveCalendar().getPublicHolidays());
            context.put((Object)"Owner", (Object)ganttProject);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HolidayEditUI.class.getName(), (Map)context);
            window.show();
            list = (List)window.getUIObject().getUIContext().get("list");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void disposeUIWindow() {
        if (this.dataChange) {
            int rtn = MsgBox.showConfirm3((String)GanttResourceUtil.getResource("Gantt_DataChanged"));
            if (rtn == 0) {
                try {
                    if (this.dateError) {
                        this.dateError = false;
                        throw new Exception(GanttResourceUtil.getResource("Gantt_HolidayMustAfterToday"));
                    }
                    this.actionOk_actionPerformed(null);
                }
                catch (Exception e) {
                    MsgBox.showWarning((String)e.getMessage());
                    return;
                }
                super.disposeUIWindow();
                return;
            }
            if (rtn == 1) {
                super.disposeUIWindow();
                return;
            }
            if (rtn != 2) return;
            return;
        }
        super.disposeUIWindow();
    }
}

