/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.freechart.ui.ExtensionFileFilter;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.project.IProjectCalendarFacade;
import com.kingdee.eas.mm.project.ProjectCalendarFacadeFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.client.GraphicOptionsUI;
import com.kingdee.eas.mm.project.client.HolidayEditUI;
import com.kingdee.eas.mm.project.client.MppDocHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.mm.project.util.MMProjectCalendar;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class MMGanttProject
extends GanttProject {
    public TestGanttRolloverButton btnImportXML;
    public TestGanttRolloverButton btnExportXML;
    public TestGanttRolloverButton btnImportMpp;
    public TestGanttRolloverButton btnExportMpp;
    public JMenuItem miImportXML;
    public JMenuItem miExportXML;
    public JMenuItem miImportMpp;
    public JMenuItem miExportMpp;
    public JCheckBoxMenuItem miMileStone = null;
    protected KDBizPromptBox prmtStorageOrgUnit;
    protected KDLabelContainer contStorageOrgUnit;
    protected CoreBaseCollection taskDatas = null;
    protected CoreBaseInfo project = null;
    protected EntityViewInfo viewInfo = null;
    protected TaskNode root = null;
    protected IProjectCalendarFacade iProjectCalendar = null;
    protected String orgId = null;
    private Map context;
    private boolean isShowUI = true;
    protected Boolean isTemplate = Boolean.FALSE;

    public MMGanttProject(boolean isOnlyViewer, Map ctx) {
        super(isOnlyViewer);
        if (ctx != null) {
            this.context = ctx;
            this.orgId = (String)ctx.get("orgId");
            this.project = (CoreBaseInfo)ctx.get("project");
            this.isTemplate = (Boolean)ctx.get("isTemp");
        }
        this.addController();
        this.initCalendar();
        this.initWorkButton();
        this.setWorkButton();
        this.viewInfo = new EntityViewInfo();
    }

    private void initCalendar() {
        if (this.orgId == null) {
            return;
        }
        try {
            this.iProjectCalendar = ProjectCalendarFacadeFactory.getRemoteInstance();
            ArrayList calendars = this.iProjectCalendar.getAllFreeDate(this.orgId);
            Iterator it = calendars.iterator();
            for (int i = 1; i <= 7; ++i) {
                this.getActiveCalendar().setWeekDayType(i, GPCalendar.DayType.WORKING);
            }
            while (it.hasNext()) {
                MMProjectCalendar mmCalendar = (MMProjectCalendar)it.next();
                this.getActiveCalendar().setPublicHoliDayType(mmCalendar.getWorkDate().getTime());
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
    }

    @Override
    public void setProjectData(Graphics g) {
        if (this.root == null || this.root.getUserObject() == null) {
            return;
        }
        ProjectTaskInfo taskInfo = (ProjectTaskInfo)((Task)this.root.getUserObject()).getUserObject();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        g.drawString(GanttResourceUtil.getResource("GANTT_PROJECT2"), 20, 60);
        g.drawString(taskInfo.getName(), 120, 60);
        g.drawString(GanttResourceUtil.getResource("GANTT_PLAN_BEGIN_TIME"), 20, 80);
        g.drawString(sf.format(taskInfo.getPlanBeginTime()), 120, 80);
        g.drawString(GanttResourceUtil.getResource("GANTT_PLAN_END_TIME"), 20, 100);
        g.drawString(sf.format(taskInfo.getPlanEndTime()), 120, 100);
        g.drawString(GanttResourceUtil.getResource("GANTT_PRINT_TIME"), 20, 120);
        g.drawString(sf.format(new Date()), 120, 120);
    }

    @Override
    public void setIcon(Graphics g) {
        g.setColor(new Color(118, 160, 192));
        g.fillRect(380, 50, 100, 10);
        g.setColor(Color.BLACK);
        g.drawString(GanttResourceUtil.getResource("GANTT_TASK3"), 320, 60);
        g.setColor(Color.BLACK);
        g.fillRect(380, 70, 100, 3);
        g.drawString(GanttResourceUtil.getResource("GANTT_PROGRESS1"), 320, 80);
        g.setColor(new Color(118, 160, 192));
        g.fillPolygon(new int[]{380, 385, 390, 385}, new int[]{95, 90, 95, 100}, 4);
        g.setColor(Color.BLACK);
        g.drawString(GanttResourceUtil.getResource("GANTT_MILESTONE"), 320, 100);
        g.fillPolygon(new int[]{380, 380, 385, 475, 480, 480}, new int[]{110, 120, 115, 115, 120, 110}, 6);
        g.drawString(GanttResourceUtil.getResource("GANTT_BREAK"), 320, 120);
        g.drawLine(380, 135, 480, 135);
        g.fillPolygon(new int[]{480, 475, 475}, new int[]{135, 130, 140}, 3);
        g.drawString(GanttResourceUtil.getResource("GANTT_PRE_REL"), 320, 140);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            if (menuItem.getName() != null && menuItem.getName().equals("miExportMpp")) {
                this.exportMpp();
            } else if (menuItem.getName() != null && menuItem.getName().equals("miImportMpp")) {
                this.importMpp();
            }
            if (menuItem.getName() != null && menuItem.getName().equals("miExportXML")) {
                this.exportGantt();
            } else if (menuItem.getName() != null && menuItem.getName().equals("miImportXML")) {
                this.importGantt();
            } else if (menuItem.getName() != null && menuItem.equals(this.miFile)) {
                this.saveGif();
            }
        } else if (e.getSource() instanceof TestGanttRolloverButton) {
            if (e.getSource() == this.btnFile) {
                this.saveGif();
            } else if (e.getSource() == this.bImport) {
                this.importMpp();
            } else if (e.getSource() == this.bExport) {
                this.exportMpp();
            }
        } else if (e.getSource() instanceof KDCheckBoxMenuItem) {
            this.showMileStone();
        }
    }

    @Override
    public void changeLanguageOfMenu() {
        super.changeLanguageOfMenu();
        this.miExportMpp = this.changeMenuLabel(this.miExportMpp, GanttResourceUtil.getResource("Gantt_ExpXML"));
        this.miImportMpp = this.changeMenuLabel(this.miImportMpp, GanttResourceUtil.getResource("Gantt_ImpXML"));
        this.miImportXML = this.changeMenuLabel(this.miImportXML, GanttResourceUtil.getResource("Gantt_ImpGan"));
        this.miExportXML = this.changeMenuLabel(this.miExportXML, GanttResourceUtil.getResource("Gantt_ExpGan"));
    }

    @Override
    public void addButtons(JToolBar toolBar) {
        super.addButtons(toolBar);
    }

    @Override
    public void addItemProjectMenu() {
        super.addItemProjectMenu();
        this.addTaoMenu();
        this.mProject.addSeparator();
        this.miImportXML = this.createNewItem(EASResource.getIcon((String)"imgTbtn_input"));
        this.miImportXML.setName("miImportXML");
        this.mProject.add(this.miImportXML);
        this.miImportMpp = this.createNewItem(EASResource.getIcon((String)"imgTbtn_input"));
        this.miImportMpp.setName("miImportMpp");
        this.mProject.add(this.miImportMpp);
        this.miExportXML = this.createNewItem(EASResource.getIcon((String)"imgTbtn_output"));
        this.miExportXML.setName("miExportXML");
        this.mProject.add(this.miExportXML);
        this.miExportMpp = this.createNewItem(EASResource.getIcon((String)"imgTbtn_output"));
        this.miExportMpp.setName("miExportMpp");
        this.mProject.add(this.miExportMpp);
    }

    public void saveGif() {
        BufferedImage image = this.getImage();
        try {
            String strFullPath = this.getSelectFile(true, new String[]{"jpg"});
            if (strFullPath != null) {
                File file = new File(strFullPath);
                if (file.exists() && !this.showConFirm(GanttResourceUtil.getResource("Gantt_IsCoverPassed"))) {
                    return;
                }
                ImageIO.write((RenderedImage)image, "JPG", new File(strFullPath));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMpp() {
        FileOutputStream fos = null;
        try {
            String strFullPath = this.getSelectFile(true, new String[]{"xml"});
            if (strFullPath != null) {
                File file = new File(strFullPath);
                if (file.exists() && !MsgBox.isOk((int)MsgBox.showConfirm2((Component)this, (String)GanttResourceUtil.getResource("Gantt_IsCoverPassed")))) {
                    return;
                }
                fos = new FileOutputStream(file);
                MppDocHandler.writeProjectXML(this, new BufferedOutputStream(fos));
                MsgBox.showWarning((Component)this, (String)GanttResourceUtil.getResource("Gantt_ExpSuccess"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException e) {
                    ExceptionHandler.handle((Component)this, (Throwable)e);
                }
            }
        }
    }

    private void importMpp() {
        try {
            File file;
            String strFullPath = this.getSelectFile(false, new String[]{"xml", "mpp"});
            if (strFullPath != null && !(file = new File(strFullPath)).exists()) {
                MsgBox.showWarning((Component)this, (String)GanttResourceUtil.getResource("Gantt_FileNotExist"));
                return;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
    }

    private void importGantt() {
        try {
            String strFullPath = this.getSelectFile(true, new String[]{"gan"});
            if (strFullPath != null) {
                File file = new File(strFullPath);
                if (!file.exists()) {
                    MsgBox.showWarning((Component)this, (String)GanttResourceUtil.getResource("Gantt_FileNotExist"));
                    return;
                }
                this.importXMLOnUI(file);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
    }

    private void exportGantt() {
        try {
            String strFullPath = this.getSelectFile(true, new String[]{"gan"});
            if (strFullPath != null) {
                File file = new File(strFullPath);
                if (file.exists() && !MsgBox.isOk((int)MsgBox.showConfirm2((Component)this, (String)GanttResourceUtil.getResource("Gantt_IsCoverPassed")))) {
                    return;
                }
                this.exportXMLOnUI(file);
                MsgBox.showWarning((Component)this, (String)GanttResourceUtil.getResource("Gantt_ExpSuccess"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
    }

    protected void importXMLOnUI(File tempFile) throws Exception {
    }

    protected void exportXMLOnUI(File tempFile) throws Exception {
    }

    @Override
    public String getSelectFile(boolean isSave, String[] ext) throws Exception {
        KDFileChooser chooser = new KDFileChooser(new File("."));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(GanttResourceUtil.getResource("Gantt_File"));
        for (int i = 0; i < ext.length; ++i) {
            chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(ext[i], ext[i]));
        }
        int returnVal = 0;
        returnVal = isSave ? chooser.showSaveDialog((Component)this) : chooser.showOpenDialog((Component)this);
        String strFullPath = null;
        String fExt = null;
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            strFullPath = file.getPath();
            fExt = chooser.getFileFilter().getDescription();
            int index = fExt.indexOf(".");
            fExt = fExt.substring(index + 1);
        }
        if (isSave && strFullPath != null && !strFullPath.endsWith("." + fExt)) {
            return strFullPath + "." + fExt;
        }
        return strFullPath;
    }

    public TestGanttRolloverButton addButtons(TestGanttRolloverButton btn, String icon, String name) {
        btn = new TestGanttRolloverButton(EASResource.getIcon((String)icon), name);
        btn.addActionListener(this);
        return btn;
    }

    @Override
    public void actionPerformed(KeyEvent e, GanttProject p) {
        new HelpUtils.ActionHelp("", (Component)p).actionPerformed(null);
    }

    @Override
    protected ArrayList getPrintList() {
        ArrayList idList = new ArrayList();
        return idList;
    }

    @Override
    public IMetaDataPK getTDQueryPK() {
        return null;
    }

    @Override
    public String getTDPath() {
        return null;
    }

    @Override
    public String getGraphicOptionsUI() {
        return GraphicOptionsUI.class.getName();
    }

    @Override
    public List getHolidayData() {
        return HolidayEditUI.getData(this);
    }

    @Override
    public String getTaskPropertiesUI() {
        return null;
    }

    @Override
    public void initTaskPropeeties() {
        super.initTaskPropeeties();
    }

    @Override
    public JMenuItem createNewItem(JMenuItem item, String icon, String name) {
        item = this.createNewItem(EASResource.getIcon((String)icon));
        item.setName(name);
        return item;
    }

    @Override
    public boolean showConFirm(String msg) {
        return MsgBox.isOk((int)MsgBox.showConfirm2((Component)this, (String)msg));
    }

    protected abstract ICoreBase getBizInterface() throws Exception;

    protected void addController() {
    }

    @Override
    protected void initWorkButton() {
    }

    @Override
    public String getIconPositions(DefaultListModel list) {
        return super.getIconPositions(list);
    }

    @Override
    protected void addButton(int icon, DefaultListModel list) {
        super.addButton(icon, list);
    }

    public void init() {
        this.loadDatas();
        this.initRoot();
        if (this.taskDatas != null && this.taskDatas.size() > 0) {
            this.initGanttTask();
        }
        this.initActions();
    }

    protected void initActions() {
    }

    protected abstract void initGanttTask();

    protected abstract void initRoot();

    protected void loadDatas() {
        try {
            this.taskDatas = this.getBizInterface().getCollection(this.getEntityViewInfo());
        }
        catch (BOSException e) {
            this.isShowUI = false;
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
        catch (Exception e) {
            this.isShowUI = false;
            ExceptionHandler.handle((Component)this, (Throwable)e);
        }
    }

    protected EntityViewInfo getEntityViewInfo() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(0), CompareType.NOTEQUALS));
        SorterItemInfo sorterInfo = new SorterItemInfo("wbsNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        SorterItemCollection sorters = this.viewInfo.getSorter();
        boolean isHasWBSSorter = false;
        for (int i = 0; i < sorters.size(); ++i) {
            SorterItemInfo sorter = sorters.get(i);
            if (!sorter.getPropertyName().equalsIgnoreCase("wbsNumber")) continue;
            isHasWBSSorter = true;
        }
        if (!isHasWBSSorter) {
            this.viewInfo.getSorter().add(sorterInfo);
        }
        this.viewInfo.setFilter(filter);
        return this.viewInfo;
    }

    public void setWorkButton() {
        Component[] buttons = this.toolBar.getComponents();
        boolean isSaveBtn = false;
        for (int i = 0; i < buttons.length; ++i) {
            TestGanttRolloverButton button;
            if (isSaveBtn && !this.isSaveVisible()) {
                isSaveBtn = false;
                this.toolBar.remove(buttons[i]);
            }
            if (!(buttons[i] instanceof TestGanttRolloverButton) || (button = (TestGanttRolloverButton)((Object)buttons[i])) != this.bSave) continue;
            isSaveBtn = true;
        }
        if (!this.isSaveVisible()) {
            this.bSave.setVisible(false);
        }
        if (!this.isSubmitVisible()) {
            this.bSubmit.setVisible(false);
        }
        this.mCalendar.setVisible(false);
        this.mHelp.setVisible(false);
        this.miImportXML.setVisible(false);
        this.miImportMpp.setVisible(false);
        this.miExportXML.setVisible(false);
        this.miExportMpp.setVisible(false);
        this.removeMenuItem();
    }

    @Override
    public int[] getDefaultIconListIntArray() {
        return new int[]{0, 48, 8, 33, 46, 47, 0, 50, 49, 52, 51, 14, 0, 28, 0, 21, 22, 23, 24, 25, 0, 1};
    }

    private void removeMenuItem() {
        this.miNewTask.setVisible(false);
        this.miDeleteTask.setVisible(false);
        this.mEdit.setVisible(false);
        this.getStatusBar().setVisible(false);
    }

    public CustomColumn createNewColumn(String colName, Class valueClass, Object defaultValue, DefaultCellEditor cellEditor) {
        DefaultCellEditor editor = null;
        JTextField realEditor = new JTextField();
        realEditor.setHorizontalAlignment(2);
        editor = cellEditor == null ? new DefaultCellEditor(realEditor) : cellEditor;
        CustomColumn newColumn = new CustomColumn(colName, valueClass, defaultValue);
        this.getTree().getTreeTable().addNewCustomColumn(newColumn, editor, false);
        return newColumn;
    }

    public TaskNode getRoot() {
        return this.root;
    }

    @Override
    public boolean isIndentable() {
        return true;
    }

    @Override
    public boolean isLinkVisible() {
        return false;
    }

    @Override
    public boolean isPrePrintSlfVisible() {
        return false;
    }

    @Override
    public boolean isPrintSlfVisible() {
        return false;
    }

    @Override
    public boolean isSaveVisible() {
        return false;
    }

    @Override
    public boolean isSubmitVisible() {
        return false;
    }

    @Override
    public boolean isUnLinkVisible() {
        return false;
    }

    @Override
    public boolean dedentCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public boolean afterDeleteTask() {
        return false;
    }

    @Override
    public boolean downCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public boolean indentCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public boolean afterNewTask() {
        return false;
    }

    @Override
    public boolean upCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public boolean beforeDedentCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public boolean beforeDeleteTask() {
        return false;
    }

    @Override
    public boolean beforeDownCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public boolean beforeIndentCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public boolean beforeNewTask() {
        return false;
    }

    @Override
    public boolean beforeUpCurrentNodes(DefaultMutableTreeNode[] selectedNodes) {
        return false;
    }

    @Override
    public void showMileStone() {
    }

    protected void setProject(CoreBaseInfo project) {
        this.project = project;
    }

    public Map getContext() {
        if (this.context == null) {
            return new HashMap();
        }
        return this.context;
    }

    public boolean isShowUI() {
        return this.isShowUI;
    }
}

