/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.mm.project.MonthPlanConst;
import com.kingdee.eas.mm.project.ProjectDictDataCollection;
import com.kingdee.eas.mm.project.ProjectDictDataFactory;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.client.AbstractMonthPlanFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.QueryFilterManager;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MonthPlanFilterUI
extends AbstractMonthPlanFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(MonthPlanFilterUI.class);
    private QueryFilterManager manager = super.getFilterManager();
    private CustomerParams cp = null;
    private Set statuses = new HashSet();
    private String TASKSTATUS_AUDIT = "4";
    private String TASKSTATUS_SUBMIT = "2";
    private String TASKSTATUS_COSTSUBMIT = "60";
    private String TASKSTATUS_RELEASE = "5";

    public MonthPlanFilterUI() throws Exception {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "STORAGEORGUNIT_CANT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        elements.add((FilterElement)new SingleFilterElement("project.number", (Component)this.prmtProject));
        elements.add((FilterElement)new SingleFilterElement("task.number", (Component)this.prmtProjectTask));
        SingleFilterElement beginTimeEle = new SingleFilterElement("beginTime", (Component)this.dpFromTime);
        beginTimeEle.setDefaultValue((Object)SCMClientUtils.getServerDate());
        elements.add((FilterElement)beginTimeEle);
        SingleFilterElement expectaionNumEle = new SingleFilterElement("period", (Component)this.txtPeriodNumber);
        elements.add((FilterElement)expectaionNumEle);
        this.txtPeriodNumber.setMinimumValue((Comparable)MonthPlanConst.ONE);
        this.txtPeriodNumber.setMaximumValue((Comparable)MonthPlanConst.PEROID_MAX);
        ProjectDictDataInfo pddInfo = ProjectDictDataFactory.getRemoteInstance().getProjectDictDataInfo((IObjectPK)new ObjectUuidPK("hEgxONeeRsmMdORdsDvcqZpMH64="));
        SingleFilterElement planningTypeEle = new SingleFilterElement("periodType.number", (Component)this.prmtPeriodType);
        planningTypeEle.setDefaultValue((Object)pddInfo);
        elements.add((FilterElement)planningTypeEle);
        SingleFilterElement taskTemplate = new SingleFilterElement("taskTemplate.number", (Component)this.prmtTaskTemplate);
        elements.add((FilterElement)taskTemplate);
        this.getFilterManager().setElement((FilterElement)elements);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setIsSupportMultiOrgs(true);
        this.initNeedMainOrgF7s();
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    protected void initNeedMainOrgF7s() {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        this.setTasktemplateF7(this.prmtStorageOrgUnit, this.prmtTaskTemplate, status);
        this.setTaskF7(this.prmtProjectTask, false);
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProject, status, false, null);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtProject, this.prmtProjectTask});
    }

    protected String getViewPermission() {
        return "mm_project_monthplanview";
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.kdcAudit.setSelected(true);
        this.kdcRelease.setSelected(true);
        this.kdcCostSubmit.setSelected(false);
        this.kdcSubmit.setSelected(false);
        super.loadData(entityViewInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.prmtPeriodType.getText(), CompareType.EQUALS));
        view.setFilter(filter);
        try {
            ProjectDictDataCollection coll = ProjectDictDataFactory.getRemoteInstance().getProjectDictDataCollection(view);
            this.prmtPeriodType.setData((Object)coll.get(0));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (this.cp.getCustomerParam("baseStatusAudit") != null && this.cp.getCustomerParam("baseStatusAudit").length() > 0) {
            this.kdcAudit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSumbit") != null && this.cp.getCustomerParam("baseStatusSumbit").length() > 0) {
            this.kdcSubmit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusCostSubmit") != null && this.cp.getCustomerParam("baseStatusCostSubmit").length() > 0) {
            this.kdcCostSubmit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusResleased") != null && this.cp.getCustomerParam("baseStatusResleased").length() > 0) {
            this.kdcRelease.setSelected(true);
        }
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (!flag) {
            return flag;
        }
        ArrayList<String> keys = new ArrayList<String>();
        if (flag) {
            if (this.manager != null && this.manager.getCustomerParams() != null && this.manager.getCustomerParams().getCustomerParamsHashMap() != null) {
                if (this.prmtStorageOrgUnit.getText() == null || this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() == 0) {
                    keys.add("STORAGEORG_ISNULL");
                }
                if (this.prmtProject.getText() == null || "".equals(this.prmtProject.getText())) {
                    keys.add("PROJECTISNULL");
                }
                if (this.dpFromTime.getText() == null || this.dpFromTime.getText() != null && this.dpFromTime.getText().length() == 0) {
                    keys.add("EXPECTATION_BEGINTIME_ISNULL");
                }
                if (this.txtPeriodNumber.getText().trim() == null || "".equals(this.txtPeriodNumber.getText())) {
                    keys.add("EXPECTATIONNUM_ISNULL");
                }
            } else {
                if (this.prmtStorageOrgUnit.getText() == null || this.prmtStorageOrgUnit.getText() != null && this.prmtStorageOrgUnit.getText().length() == 0) {
                    keys.add("STORAGEORG_ISNULL");
                }
                if (this.prmtProject.getText() == null || "".equals(this.prmtProject.getText())) {
                    keys.add("PROJECTISNULL");
                }
                if (this.dpFromTime.getText() == null || this.dpFromTime.getText() != null && this.dpFromTime.getText().length() == 0) {
                    keys.add("EXPECTATION_BEGINTIME_ISNULL");
                }
                if (this.txtPeriodNumber.getText().trim() == null || "".equals(this.txtPeriodNumber.getText())) {
                    keys.add("EXPECTATIONNUM_ISNULL");
                }
            }
            if (keys.size() > 0) {
                StringBuffer note = new StringBuffer();
                for (int i = 0; i < keys.size(); ++i) {
                    note.append(MonthPlanFilterUI.getResource(keys.get(i).toString()));
                    note.append("\n");
                }
                MsgBox.showInfo((String)note.toString());
                return false;
            }
        }
        this.statuses.clear();
        if (this.kdcAudit.isSelected()) {
            this.statuses.add(new Integer(4));
        }
        if (this.kdcSubmit.isSelected()) {
            this.statuses.add(new Integer(2));
        }
        if (this.kdcCostSubmit.isSelected()) {
            this.statuses.add(new Integer(60));
        }
        if (this.kdcRelease.isSelected()) {
            this.statuses.add(new Integer(5));
        }
        if (this.statuses.size() <= 0) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "MUST_ONE_STATUS"));
            SysUtil.abort();
            return false;
        }
        return true;
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectProblemResource", (String)strKey);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            return filterInfo;
        }
        if (this.statuses.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)this.statuses, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.kdcAudit.isSelected()) {
                pp.addCustomerParam("baseStatusAudit", this.TASKSTATUS_AUDIT);
            }
            if (this.kdcSubmit.isSelected()) {
                pp.addCustomerParam("baseStatusSumbit", this.TASKSTATUS_SUBMIT);
            }
            if (this.kdcCostSubmit.isSelected()) {
                pp.addCustomerParam("baseStatusCostSubmit", this.TASKSTATUS_COSTSUBMIT);
            }
            if (this.kdcRelease.isSelected()) {
                pp.addCustomerParam("baseStatusResleased", this.TASKSTATUS_RELEASE);
            }
        }
        return pp;
    }

    public void clear() {
        super.clear();
        this.kdcSubmit.setSelected(false);
        this.kdcCostSubmit.setSelected(false);
        this.kdcAudit.setSelected(true);
        this.kdcRelease.setSelected(true);
    }

    private void setTasktemplateF7(final KDBizPromptBox storageOrgUnitBox, final KDBizPromptBox taskTemplate, final HashSet status) {
        taskTemplate.setQueryInfo("com.kingdee.eas.mm.project.app.F7TaskTemplateQuery");
        taskTemplate.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                taskTemplate.setEntityViewInfo(MonthPlanFilterUI.this.getTasktemplateF7EntityView(storageOrgUnitBox, status));
                taskTemplate.getQueryAgent().resetRuntimeEntityView();
            }
        });
        taskTemplate.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                taskTemplate.setEntityViewInfo(MonthPlanFilterUI.this.getTasktemplateF7EntityView(storageOrgUnitBox, status));
                taskTemplate.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    public EntityViewInfo getTasktemplateF7EntityView(KDBizPromptBox storageOrgUnitBox, HashSet status) {
        Object[] objects;
        Object mainOrg = storageOrgUnitBox.getData();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (mainOrg == null) {
            keys.add("null");
        } else if (mainOrg != null && mainOrg instanceof OrgUnitInfo) {
            keys.add(((OrgUnitInfo)mainOrg).getId().toString());
        } else if (mainOrg instanceof Object[] && (objects = (Object[])mainOrg).length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)objects[i];
                keys.add(orgInfo.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInBalance", (Object)new Boolean(true)));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void setTaskF7(final KDBizPromptBox prmtTask, final boolean isTemplate) {
        prmtTask.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectTaskQuery");
        prmtTask.setEnabledMultiSelection(true);
        prmtTask.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                prmtTask.setEntityViewInfo(MonthPlanFilterUI.this.getTaskEntityViewInfo(MonthPlanFilterUI.this.prmtStorageOrgUnit, isTemplate));
                prmtTask.getQueryAgent().resetRuntimeEntityView();
            }
        });
        prmtTask.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                prmtTask.setEntityViewInfo(MonthPlanFilterUI.this.getTaskEntityViewInfo(MonthPlanFilterUI.this.prmtStorageOrgUnit, isTemplate));
                prmtTask.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    private EntityViewInfo getTaskEntityViewInfo(KDBizPromptBox storageOrgUnitBox, boolean isTemplate) {
        Object[] objects;
        Object mainOrg = storageOrgUnitBox.getData();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (mainOrg == null) {
            keys.add("null");
        } else if (mainOrg != null && mainOrg instanceof OrgUnitInfo) {
            keys.add(((OrgUnitInfo)mainOrg).getId().toString());
        } else if (mainOrg instanceof Object[] && (objects = (Object[])mainOrg).length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)objects[i];
                keys.add(orgInfo.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)new Boolean(isTemplate)));
        filterInfo.getFilterItems().add(new FilterItemInfo("wbsNumber", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }
}

