/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.swing.KDDBntScrollBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.project.IMonthPlan;
import com.kingdee.eas.mm.project.MonthPlanCalendarData;
import com.kingdee.eas.mm.project.MonthPlanCollection;
import com.kingdee.eas.mm.project.MonthPlanConst;
import com.kingdee.eas.mm.project.MonthPlanEntryInfo;
import com.kingdee.eas.mm.project.MonthPlanFactory;
import com.kingdee.eas.mm.project.MonthPlanFilterPharser;
import com.kingdee.eas.mm.project.MonthPlanInfo;
import com.kingdee.eas.mm.project.Peroid;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectPeroidData;
import com.kingdee.eas.mm.project.ProjectPriorityEnum;
import com.kingdee.eas.mm.project.TaskTemplateInfo;
import com.kingdee.eas.mm.project.client.AbstractMonthPlanUI;
import com.kingdee.eas.mm.project.client.MonthPlanFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MonthPlanUI
extends AbstractMonthPlanUI
implements IPrintActionListener {
    private static final Logger logger = CoreUIObject.getLogger(MonthPlanUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.mm.project.MonthPlanResource";
    private CommonQueryDialog commonQueryDialog = null;
    private MonthPlanFilterUI filterUI = null;
    protected static final IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.mm.project.app", "ProjectTaskQuery");
    private FilterInfo filterInfo = null;
    private boolean mustshowDiaglog = false;
    private boolean isMutex = false;
    private SelectorItemCollection selector = null;
    public boolean shouldReloadPrintVar = true;
    private static int columnNum = 3;
    private Peroid[] periods = null;
    private static String TB_PERIOD_MAX = "Max";
    private static String TB_PERIOD_PLANQTY = "Plan";
    private static String TB_PERIOD_ADJUSTQTY = "Adjust";
    private static String TB_TOTALPLANQTY = "planQtyTotal";
    private static String TB_TOTALADJUSTQTY = "qtyTotal";
    private static String TB_TASKTEMPLATE = "taskTemplate";
    private static String TB_DAYQTY = "dayQty";
    private static String TB_DAYMAXQTY = "dayMaxQty";
    private static String TB_PROJECTNAME = "project.name";
    private static String TB_PROJECTPRIORITY = "project.priority";
    private static String TB_MATERIALNAME = "material.name";
    private IMonthPlan iMonthPlan = null;
    private String lastTemplateId = null;
    private Map rowsEdited = new HashMap();
    private List rowsTotal = new ArrayList();
    private Map calendar = null;
    private ProjectDictDataInfo peroidType = null;
    private Map tables = null;
    private int tempRowCount = 0;
    private int totalDataRow = 0;
    private Map projectPeroidDataPlan = null;
    private Map projectPeroidDataAdjust = null;
    private static int defaultPageRow = 0;
    private JScrollBar vBar = new KDDBntScrollBar(1);
    private AdjustmentListener adjustListener = null;
    private KDTEditAdapter tableChangeListener = null;

    public void onLoad() throws Exception {
        this.kdtMain.getGroupManager().setGroup(true);
        this.kdtMain.getMergeManager().setMergeMode(5);
        super.onLoad();
        if (this.iMonthPlan == null) {
            this.iMonthPlan = MonthPlanFactory.getRemoteInstance();
        }
        this.txtColor.setText(this.getResource("MONTHPLAN_COLOR"));
        this.actionQuery_actionPerformed(null);
        this.kdtMain.getStyleAttributes().setLocked(true);
        this.kdtMain.getActionMap().remove("Paste");
        this.kdtMain.getActionMap().remove("Delete");
        this.kdtMain.getActionMap().remove("Copy");
        this.kdtMain.getActionMap().remove("Cut");
        this.tHelper.getDisabledTables().remove(this.kdtMain);
        this.actionSave.setEnabled(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void beforePreview() {
    }

    public void beforePrint() {
    }

    public void beforePrintOrPreview() {
    }

    public void closePreview() {
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        MonthPlanCollection colls = this.prepareSaveData();
        if (colls != null) {
            this.iMonthPlan.saveBatch(colls);
            this.rowsEdited.clear();
            this.actionRefresh_actionPerformed(null);
            this.actionEdit_actionPerformed(null);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.requestMutex("EDIT");
        }
        catch (Throwable e1) {
            this.handUIException(e1);
        }
        this.unLockColumns();
        this.actionSave.setEnabled(true);
        this.actionEdit.setEnabled(false);
    }

    private void requestMutex(String opState) throws Throwable {
        this.setOprtState(opState);
        this.pubFireVOChangeListener("1");
        this.isMutex = !opState.equalsIgnoreCase("RELEASEALL");
    }

    protected boolean checkBeforeWindowClosing() {
        boolean flag = super.checkBeforeWindowClosing();
        if (!this.isNeedSave()) {
            return false;
        }
        try {
            ArrayList table = new ArrayList();
            Iterator it = this.tables.values().iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof String)) continue;
                table.add(it.next());
            }
            this.iMonthPlan.releaseTempTable(table);
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        try {
            this.requestMutex("RELEASEALL");
        }
        catch (Throwable e1) {
            this.handUIException(e1);
        }
        return flag;
    }

    private boolean isNeedSave() {
        if (this.rowsEdited.size() > 0) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)"cs_dataCHG"));
            if (result == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                    return true;
                }
                catch (Exception e) {
                    this.handUIException(e);
                    return false;
                }
            }
            return result != 2;
        }
        return true;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isNeedSave()) {
            return;
        }
        if (e != null) {
            this.mustshowDiaglog = true;
        }
        if (this.showQueryDialog()) {
            MonthPlanFilterPharser pharse = new MonthPlanFilterPharser(this.filterInfo);
            this.periods = Peroid.calPeroid(pharse.getDate(), pharse.getPeriodNumber(), pharse.getPeriodType());
            this.initTableColumn(this.periods);
            this.tables = this.iMonthPlan.createData(this.filterInfo, this.tables);
            this.calendar = (Map)this.tables.get("canlendar");
            this.peroidType = (ProjectDictDataInfo)this.tables.get("peroidType");
            this.txtPeriodFrom.setText(this.periods[0].toString());
            this.txtPeriodTo.setText(this.periods[this.periods.length - 1].toString());
            this.txtPeriodType.setText(this.peroidType.getName());
            this.actionSave.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.kdtMain.removeRows();
            this.kdtMain.getStyleAttributes().setLocked(true);
            this.clearTemp();
            this.fillTable(null);
        } else {
            this.tHelper.setDialog(this.commonQueryDialog);
            SysUtil.abort();
        }
        try {
            this.requestMutex("RELEASEALL");
        }
        catch (Throwable e1) {
            this.handUIException(e1);
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isNeedSave()) {
            return;
        }
        this.tables = this.iMonthPlan.createData(this.filterInfo, this.tables);
        this.calendar = (Map)this.tables.get("canlendar");
        this.removeAction();
        this.kdtMain.removeRows();
        this.clearTemp();
        this.actionSave.setEnabled(false);
        this.actionEdit.setEnabled(true);
        this.initAction();
        this.fillTable(null);
        try {
            this.requestMutex("RELEASEALL");
        }
        catch (Throwable e1) {
            this.handUIException(e1);
        }
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            this.kdtMain.getColumn(peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setLocked(true);
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)RESOURCE_PATH, (String)key);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IObjectPK pk = LogUtil.beginLog(null, (String)"1", (BOSObjectType)new MonthPlanInfo().getBOSType(), null, null, (String)"mm_project_monthplanprint");
        this.print(false);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    @Override
    public void actionPrintView_actionPerformed(ActionEvent e) throws Exception {
        this.print(true);
    }

    protected KDTable getTableForPrintSetting() {
        return this.kdtMain;
    }

    private void print(boolean view) {
        KDTable tbl = this.getTableForPrintSetting();
        if (tbl != null) {
            this.preparePrintPage(tbl);
            KDPrinter printer = tbl.getPrintManager().getNewPrintManager().getPrinter();
            printer.addPrintActionListener((IPrintActionListener)this);
            if (view) {
                tbl.getPrintManager().printPreview();
            } else {
                tbl.getPrintManager().print();
            }
            printer.removePrintActionListener((IPrintActionListener)this);
        }
    }

    protected boolean isAllowLoadPrintSetting() {
        return false;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.kdlcPeriodType.getBoundLabelText());
        sb.append(" : &[period]");
        sb.append("&|");
        sb.append(this.kdlcPeroidFrom.getBoundLabelText());
        sb.append(" : &[PeroidFrom] ");
        sb.append("&|");
        sb.append(this.kdlcPeriodTo.getBoundLabelText());
        sb.append(" : &[PeroidTo] ");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = MonthPlanUI.this.preparePrintVariantMap();
                MonthPlanUI.this.shouldReloadPrintVar = false;
            }

            public Variant requestVarData(String varName) {
                if (MonthPlanUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("period", this.txtPeriodType.getText());
        map.put("PeroidFrom", this.txtPeriodFrom.getText());
        map.put("PeroidTo", this.txtPeriodTo.getText());
        return map;
    }

    private void initCommonQueryDialog() throws EASBizException {
        if (this.commonQueryDialog == null) {
            try {
                this.commonQueryDialog = new CommonQueryDialog();
                if (this.getUIWindow() == null) {
                    this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
                } else {
                    this.commonQueryDialog.setOwner((Component)((Object)this));
                }
                this.commonQueryDialog.setUiObject((IUIObject)this);
                String classFullName = this.getMetaDataPK().getFullName();
                this.commonQueryDialog.setParentUIClassName(classFullName);
                this.commonQueryDialog.setQueryObjectPK(mainQueryPK);
                this.commonQueryDialog.setTitle(this.getResource("MONTHPLAN_FILTER_TITLE"));
                this.commonQueryDialog.setShowSorter(false);
                this.commonQueryDialog.setShowFilter(false);
                this.filterUI = new MonthPlanFilterUI();
                Dimension size = new Dimension();
                size.width = 580;
                size.height = 345;
                this.filterUI.setSize(size);
                this.commonQueryDialog.addUserPanel((KDPanel)this.filterUI);
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("ERRORONINITDIALOG", e.getMessage()), e.getCause(), null);
            }
        }
    }

    private boolean showQueryDialog() throws EASBizException {
        try {
            this.initCommonQueryDialog();
            this.filterUI.getUIContext().clear();
            this.filterUI.getUIContext().putAll(this.getUIContext());
            if (!this.mustshowDiaglog) {
                QuerySolutionInfo currSolution = this.commonQueryDialog.getCurrentSolutionInfo();
                IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
                String uiName = null;
                String name = MonthPlanUI.getQueryInfo(mainQueryPK).getFullName();
                uiName = StringUtils.replace((String)this.getMetaDataPK().toString(), (String)"\\", (String)".");
                if (iQuery == null || name == null) {
                    return false;
                }
                currSolution = iQuery.getDefaultSolution(uiName, name);
                if (null != currSolution && currSolution.isIsUserDefaultSolu() && null != currSolution.getEntityViewInfo()) {
                    EntityViewInfo entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    entityViewInfo = new EntityViewInfo(currSolution.getEntityViewInfo());
                    this.filterInfo = entityViewInfo.getFilter();
                    this.selector = entityViewInfo.getSelector();
                    return true;
                }
            }
            if (this.commonQueryDialog.show()) {
                this.filterInfo = this.filterUI.getFilterInfo();
                this.filterInfo.mergeFilter(this.commonQueryDialog.getCommonFilter(), "and");
                this.selector = this.filterUI.getSelectors();
                this.mustshowDiaglog = false;
                return true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.mustshowDiaglog = false;
        return false;
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    private void initTableColumn(Peroid[] columns) {
        this.kdtMain.checkParsed(true);
        int columnCount = this.kdtMain.getColumnCount();
        int number = columns.length;
        Style style = this.kdtMain.getHead().getRow(0).getCell(0).getStyle();
        ShareStyleAttributes ssa = this.kdtMain.getHead().getRow(0).getCell(0).getSSA();
        IColumn column = null;
        for (int i = 0; i < number * columnNum; i += columnNum) {
            Peroid period = columns[i / 3];
            column = this.kdtMain.addColumn();
            column.setKey(period.toString() + TB_PERIOD_MAX);
            column.setUserObject((Object)period);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column = this.kdtMain.addColumn();
            column.setKey(period.toString() + TB_PERIOD_PLANQTY);
            column.setUserObject((Object)period);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            column = this.kdtMain.addColumn();
            column.setKey(period.toString() + TB_PERIOD_ADJUSTQTY);
            column.setUserObject((Object)period);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            KDTCell cell = new KDTCell();
            cell.setStyle(style);
            cell.setSSA(ssa);
            cell.setValue((Object)period.toString());
            this.kdtMain.getHead().getRow(0).setCell(columnCount + i, cell);
            this.kdtMain.getHead().getRow(0).setCell(columnCount + i + 1, cell);
            this.kdtMain.getHead().getRow(0).setCell(columnCount + i + 2, cell);
            cell = new KDTCell();
            cell.setStyle(style);
            cell.setSSA(ssa);
            cell.setValue((Object)this.getResource("MONTHPLAN_PERIOD_MAXQTY"));
            this.kdtMain.getHead().getRow(1).setCell(columnCount + i, cell);
            cell = new KDTCell();
            cell.setStyle(style);
            cell.setSSA(ssa);
            cell.setValue((Object)this.getResource("MONTHPLAN_PERIOD_PLANQTY"));
            this.kdtMain.getHead().getRow(1).setCell(columnCount + i + 1, cell);
            cell = new KDTCell();
            cell.setStyle(style);
            cell.setSSA(ssa);
            cell.setValue((Object)this.getResource("MONTHPLAN_PERIOD_ADJUSTQTY"));
            this.kdtMain.getHead().getRow(1).setCell(columnCount + i + 2, cell);
            KDTMergeBlock mb = new KDTMergeBlock();
            mb.setLeft(columnCount + i);
            mb.setTop(0);
            mb.setRight(columnCount + i + 2);
            mb.setBottom(0);
            this.kdtMain.getHeadMergeManager().mergeBlock(mb);
        }
    }

    private void clearTemp() {
        this.projectPeroidDataPlan = null;
        this.projectPeroidDataAdjust = null;
        this.rowsEdited.clear();
        this.rowsTotal.clear();
        this.totalDataRow = 0;
        this.lastTemplateId = null;
    }

    private void setMergeColumn(int first, int last) {
        int i;
        this.kdtMain.getMergeManager().setMergeMode(3);
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.kdtMain.getGroupManager().setGroup(true);
            for (i = 0; i < mergeColumnKeys.length; ++i) {
                this.kdtMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.kdtMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
        for (i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            this.kdtMain.getColumn(peroid.toString() + TB_PERIOD_MAX).setGroup(true);
            this.kdtMain.getColumn(peroid.toString() + TB_PERIOD_MAX).setMergeable(true);
        }
        this.kdtMain.getGroupManager().group(first, last);
    }

    private String[] getMergeColumnKeys() {
        return new String[]{TB_TASKTEMPLATE, TB_DAYMAXQTY, TB_DAYQTY, TB_MATERIALNAME};
    }

    private void setPeroidColor(int rowIndex, int colIndex, boolean isTotalRow) {
        BigDecimal planQty = null;
        BigDecimal adjustQty = null;
        BigDecimal totalQty = null;
        int planQtyIndex = colIndex - 1;
        int totalQtyIndex = colIndex - 2;
        adjustQty = (BigDecimal)this.kdtMain.getCell(rowIndex, colIndex).getValue();
        planQty = (BigDecimal)this.kdtMain.getCell(rowIndex, planQtyIndex).getValue();
        if (isTotalRow) {
            totalQty = (BigDecimal)this.kdtMain.getCell(rowIndex, totalQtyIndex).getValue();
            if (adjustQty != null && planQty != null) {
                if (adjustQty.compareTo(planQty) != 0) {
                    this.kdtMain.getCell(rowIndex, colIndex).getStyleAttributes().setFontColor(Color.BLUE);
                } else {
                    this.kdtMain.getCell(rowIndex, colIndex).getStyleAttributes().setFontColor(Color.BLACK);
                }
            }
            if (totalQty == null) {
                return;
            }
            if (planQty != null && planQty.compareTo(totalQty) > 0) {
                this.kdtMain.getCell(rowIndex, planQtyIndex).getStyleAttributes().setFontColor(Color.RED);
            }
            if (adjustQty != null && adjustQty.compareTo(totalQty) > 0) {
                this.kdtMain.getCell(rowIndex, colIndex).getStyleAttributes().setFontColor(Color.RED);
            }
        } else {
            if (adjustQty == null) {
                return;
            }
            if (planQty == null) {
                this.kdtMain.getCell(rowIndex, colIndex).getStyleAttributes().setFontColor(Color.BLUE);
            } else if (adjustQty.compareTo(planQty) != 0) {
                this.kdtMain.getCell(rowIndex, colIndex).getStyleAttributes().setFontColor(Color.BLUE);
            } else {
                this.kdtMain.getCell(rowIndex, colIndex).getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
    }

    private void setRowColor(IRow row, boolean isTotalRow) {
        BigDecimal planQty = null;
        BigDecimal adjustQty = null;
        BigDecimal totalQty = null;
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            planQty = (BigDecimal)row.getCell(peroid.toString() + TB_PERIOD_PLANQTY).getValue();
            adjustQty = (BigDecimal)row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).getValue();
            if (isTotalRow) {
                totalQty = (BigDecimal)row.getCell(peroid.toString() + TB_PERIOD_MAX).getValue();
                if (adjustQty != null && planQty != null && adjustQty.compareTo(planQty) != 0) {
                    row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setFontColor(Color.BLUE);
                }
                if (totalQty == null) continue;
                if (planQty != null && planQty.compareTo(totalQty) > 0) {
                    row.getCell(peroid.toString() + TB_PERIOD_PLANQTY).getStyleAttributes().setFontColor(Color.RED);
                }
                if (adjustQty == null || adjustQty.compareTo(totalQty) <= 0) continue;
                row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setFontColor(Color.RED);
                continue;
            }
            if (adjustQty == null) continue;
            if (planQty == null) {
                row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setFontColor(Color.BLUE);
                continue;
            }
            if (adjustQty.compareTo(planQty) == 0) continue;
            row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setFontColor(Color.BLUE);
        }
    }

    private void initAction() {
        this.adjustListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                try {
                    MonthPlanUI.this.fillTable(e);
                }
                catch (BOSException e1) {
                    MonthPlanUI.this.handleException((Exception)((Object)e1));
                }
            }
        };
        this.vBar.addAdjustmentListener(this.adjustListener);
        this.kdtMain.getLayoutManager().setVerticalScrollBar(this.vBar);
        this.tableChangeListener = new KDTEditAdapter(){
            private Object oldValue = null;

            public void editStarting(KDTEditEvent e) {
                try {
                    this.oldValue = MonthPlanUI.this.kdtEntries_ChangedStarting(e);
                }
                catch (Exception ex) {
                    MonthPlanUI.this.handUIException(ex);
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    MonthPlanUI.this.kdtEntries_ChangedStopped(e, this.oldValue);
                }
                catch (Exception exc) {
                    MonthPlanUI.this.handUIException(exc);
                }
            }
        };
        this.kdtMain.addKDTEditListener((KDTEditListener)this.tableChangeListener);
    }

    private Object kdtEntries_ChangedStarting(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object oldValue = this.kdtMain.getCell(rowIndex, colIndex).getValue();
        return oldValue;
    }

    private void kdtEntries_ChangedStopped(KDTEditEvent e, Object oldValue) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        BigDecimal newValue = (BigDecimal)e.getValue();
        BigDecimal old = (BigDecimal)oldValue;
        BigDecimal temp = null;
        if (newValue == null && old == null) {
            return;
        }
        if (newValue == null && old != null) {
            this.rowsEdited.put(new Integer(rowIndex), new Integer(rowIndex));
            this.kdtMain.getCell(rowIndex, colIndex).setValue((Object)MonthPlanConst.ZERO);
            temp = MonthPlanConst.ZERO.subtract(old);
        } else if (newValue != null && old == null) {
            this.rowsEdited.put(new Integer(rowIndex), new Integer(rowIndex));
            this.kdtMain.getCell(rowIndex, colIndex).setValue((Object)newValue);
            temp = newValue;
        } else if (newValue.compareTo(old) > 0) {
            this.rowsEdited.put(new Integer(rowIndex), new Integer(rowIndex));
            temp = newValue.subtract(old);
        } else if (newValue.compareTo(old) < 0) {
            this.rowsEdited.put(new Integer(rowIndex), new Integer(rowIndex));
            temp = newValue.subtract(old);
        } else {
            return;
        }
        BigDecimal adjustTotal = (BigDecimal)this.kdtMain.getCell(rowIndex, TB_TOTALADJUSTQTY).getValue();
        if (adjustTotal != null) {
            this.kdtMain.getCell(rowIndex, TB_TOTALADJUSTQTY).setValue((Object)adjustTotal.add(temp));
        } else {
            this.kdtMain.getCell(rowIndex, TB_TOTALADJUSTQTY).setValue((Object)MonthPlanConst.ZERO.add(temp));
        }
        int totalRowIndex = this.findTemplateTotalRow(this.kdtMain.getRow(rowIndex));
        IRow totalRow = this.kdtMain.getRow(totalRowIndex);
        BigDecimal rowAdjustTotal = (BigDecimal)totalRow.getCell(colIndex).getValue();
        adjustTotal = (BigDecimal)totalRow.getCell(TB_TOTALADJUSTQTY).getValue();
        if (adjustTotal != null) {
            totalRow.getCell(colIndex).setValue((Object)rowAdjustTotal.add(temp));
            totalRow.getCell(TB_TOTALADJUSTQTY).setValue((Object)adjustTotal.add(temp));
        } else {
            totalRow.getCell(colIndex).setValue((Object)MonthPlanConst.ZERO.add(temp));
            totalRow.getCell(TB_TOTALADJUSTQTY).setValue((Object)MonthPlanConst.ZERO.add(temp));
        }
        this.setPeroidColor(rowIndex, colIndex, false);
        this.setPeroidColor(totalRow.getRowIndex(), colIndex, true);
    }

    private void removeAction() {
        int i;
        AdjustmentListener[] listeners;
        if (this.adjustListener != null) {
            this.vBar.removeAdjustmentListener(this.adjustListener);
            listeners = this.vBar.getAdjustmentListeners();
            for (i = 0; i < listeners.length; ++i) {
                this.vBar.removeAdjustmentListener(listeners[i]);
            }
        }
        if (this.tableChangeListener != null) {
            this.kdtMain.removeKDTEditListener((KDTEditListener)this.tableChangeListener);
            listeners = (KDTEditListener[])this.kdtMain.getListeners(KDTEditListener.class);
            for (i = 0; i < listeners.length; ++i) {
                this.kdtMain.removeKDTEditListener((KDTEditListener)listeners[i]);
            }
        }
    }

    public void fillTable(AdjustmentEvent e) throws BOSException {
        int tablesize = 0;
        int last = this.kdtMain.getLayoutManager().getVertical(1).getLast();
        tablesize = this.kdtMain.getRowCount();
        int from = tablesize + 1;
        if (e == null || last + 1 > tablesize) {
            Map pageData = this.iMonthPlan.getOnePageData(this.tables, this.totalDataRow + 1, defaultPageRow, this.periods);
            IRowSet project = (IRowSet)pageData.get("Task");
            IRowSet task = (IRowSet)pageData.get("Project");
            IRowSet monthPlan = (IRowSet)pageData.get("MonthPlan");
            IRowSet rowCount = (IRowSet)pageData.get("rowCount");
            try {
                if (rowCount != null && rowCount.next()) {
                    this.tempRowCount = rowCount.getInt("FRowCount");
                }
                this.removeAction();
                this.insertData(project, task, monthPlan);
                this.initAction();
            }
            catch (SQLException e1) {
                throw new BOSException((Throwable)e1);
            }
        }
    }

    private void insertData(IRowSet project, IRowSet task, IRowSet monthPlan) throws SQLException {
        if (project == null) {
            return;
        }
        this.buildPlanPeriodData(task);
        this.buildAdjustPeriodData(monthPlan);
        int firstrow = -1;
        while (project.next()) {
            IRow row;
            String templateId = project.getString("FTaskTemplateID");
            String projectId = project.getString("FProjectID");
            if (this.lastTemplateId == null) {
                this.lastTemplateId = templateId;
            }
            if (this.lastTemplateId.equalsIgnoreCase(templateId)) {
                row = this.insertOneRowData(project);
                if (firstrow == -1) {
                    firstrow = row.getRowIndex();
                }
                ++this.totalDataRow;
                this.fillPlanQty(projectId, templateId, row);
                this.fillAdjustQty(projectId, templateId, row);
                this.setRowColor(row, false);
                row.setMergeable(true);
            } else {
                this.insertTotalRow();
                row = this.insertOneRowData(project);
                if (firstrow == -1) {
                    firstrow = row.getRowIndex();
                }
                ++this.totalDataRow;
                this.fillPlanQty(projectId, templateId, row);
                this.fillAdjustQty(projectId, templateId, row);
                this.setRowColor(row, false);
                this.lastTemplateId = templateId;
                row.setMergeable(true);
            }
            if (this.totalDataRow != this.tempRowCount) continue;
            int rowIndex = this.insertTotalRow();
            if (firstrow != -1) continue;
            firstrow = rowIndex;
        }
        if (firstrow != -1) {
            int last = this.kdtMain.getRowCount();
            this.setMergeColumn(firstrow - 1, last);
        }
    }

    private int insertTotalRow() {
        IRow rowTotal = this.kdtMain.addRow();
        int index = rowTotal.getRowIndex();
        this.rowsTotal.add(new Integer(index));
        IRow preRow = this.kdtMain.getRow(index - 1);
        ProjectPeroidData data = (ProjectPeroidData)preRow.getUserObject();
        int precision = data.getPrecision();
        rowTotal.getCell(TB_TASKTEMPLATE).setValue(preRow.getCell(TB_TASKTEMPLATE).getValue());
        rowTotal.getCell(TB_DAYQTY).setValue(preRow.getCell(TB_DAYQTY).getValue());
        rowTotal.getCell(TB_DAYMAXQTY).setValue(preRow.getCell(TB_DAYMAXQTY).getValue());
        rowTotal.getCell(TB_PROJECTNAME).setValue((Object)this.getResource("MONTH_PLAN_TOTAL"));
        rowTotal.getCell(TB_MATERIALNAME).setValue(preRow.getCell(TB_MATERIALNAME).getValue());
        int firstIndex = this.findTemplateFirstRow(preRow);
        int lastIndex = preRow.getRowIndex();
        BigDecimal totalPlan = null;
        BigDecimal totalAdjust = null;
        BigDecimal tempPlan = null;
        BigDecimal tempAdjust = null;
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            totalPlan = MonthPlanConst.ZERO;
            totalAdjust = MonthPlanConst.ZERO;
            for (int j = firstIndex; j <= lastIndex; ++j) {
                tempPlan = (BigDecimal)this.kdtMain.getCell(j, peroid.toString() + TB_PERIOD_PLANQTY).getValue();
                if (tempPlan != null) {
                    totalPlan = totalPlan.add(tempPlan);
                }
                if ((tempAdjust = (BigDecimal)this.kdtMain.getCell(j, peroid.toString() + TB_PERIOD_ADJUSTQTY).getValue()) == null) continue;
                totalAdjust = totalAdjust.add(tempAdjust);
            }
            rowTotal.getCell(peroid.toString() + TB_PERIOD_MAX).setValue(preRow.getCell(peroid.toString() + TB_PERIOD_MAX).getValue());
            rowTotal.getCell(peroid.toString() + TB_PERIOD_PLANQTY).setValue((Object)totalPlan);
            rowTotal.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).setValue((Object)totalAdjust);
        }
        totalPlan = MonthPlanConst.ZERO;
        totalAdjust = MonthPlanConst.ZERO;
        for (int j = firstIndex; j <= lastIndex; ++j) {
            tempPlan = (BigDecimal)this.kdtMain.getCell(j, TB_TOTALPLANQTY).getValue();
            if (tempPlan != null) {
                totalPlan = totalPlan.add(tempPlan);
            }
            if ((tempAdjust = (BigDecimal)this.kdtMain.getCell(j, TB_TOTALADJUSTQTY).getValue()) == null) continue;
            totalAdjust = totalAdjust.add(tempAdjust);
        }
        rowTotal.getCell(TB_TOTALPLANQTY).setValue((Object)totalPlan);
        rowTotal.getCell(TB_TOTALADJUSTQTY).setValue((Object)totalAdjust);
        this.setRowColor(rowTotal, true);
        this.initQtyField(precision, rowTotal);
        return rowTotal.getRowIndex();
    }

    private int findTemplateFirstRow(IRow preRow) {
        ProjectPeroidData temp;
        int rowIndex;
        int targetIndex = rowIndex = preRow.getRowIndex();
        ProjectPeroidData data = (ProjectPeroidData)preRow.getUserObject();
        int i = rowIndex - 1;
        while (i >= 0 && (temp = (ProjectPeroidData)this.kdtMain.getRow(i).getUserObject()) != null && temp.getTaskTemplateId().equalsIgnoreCase(data.getTaskTemplateId())) {
            targetIndex = i--;
        }
        return targetIndex;
    }

    private int findTemplateTotalRow(IRow preRow) {
        int rowIndex;
        int targetIndex = rowIndex = preRow.getRowIndex();
        int tableSize = this.kdtMain.getRowCount();
        for (int i = rowIndex + 1; i <= tableSize; ++i) {
            ProjectPeroidData temp = (ProjectPeroidData)this.kdtMain.getRow(i).getUserObject();
            if (temp != null) continue;
            targetIndex = i;
            break;
        }
        return targetIndex;
    }

    private IRow insertOneRowData(IRowSet project) throws SQLException {
        IRow row = this.kdtMain.addRow();
        String projectId = project.getString("FTasktemplateID");
        String templateId = project.getString("FProjectID");
        String storageOrgUnitId = project.getString("FStorageOrgUnitID");
        BigDecimal maxDayQty = project.getBigDecimal("FDayMaxQty");
        int precision = project.getInt("FPrecision");
        int priority = project.getInt("FProjectPriority");
        ProjectPeroidData peroidData = new ProjectPeroidData(projectId, templateId, storageOrgUnitId, precision);
        row.setUserObject((Object)peroidData);
        this.initQtyField(precision, row);
        row.getCell(TB_TASKTEMPLATE).setValue((Object)project.getString("FTasktemplateName"));
        row.getCell(TB_DAYQTY).setValue((Object)project.getBigDecimal("FDayQty"));
        row.getCell(TB_DAYMAXQTY).setValue((Object)maxDayQty);
        row.getCell(TB_PROJECTNAME).setValue((Object)project.getString("FProjectName"));
        row.getCell(TB_PROJECTPRIORITY).setValue((Object)ProjectPriorityEnum.getEnum((int)priority).getAlias());
        row.getCell(TB_MATERIALNAME).setValue((Object)project.getString("FMaterialName"));
        List calendarData = (List)this.calendar.get(storageOrgUnitId);
        int currentIndex = 0;
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            currentIndex = this.calMaxPeroidQty(row, calendarData, maxDayQty, peroid, currentIndex);
        }
        return row;
    }

    private void unLockColumns() {
        Peroid currPeroid = Peroid.getPeroid(new java.util.Date(), this.peroidType.getNumber());
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            if (peroid.getYear() <= currPeroid.getYear() && (peroid.getYear() != currPeroid.getYear() || peroid.getPeriod() < currPeroid.getPeriod())) continue;
            this.kdtMain.getColumn(peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setLocked(false);
            for (Integer row : this.rowsTotal) {
                this.kdtMain.getCell(row.intValue(), peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setLocked(true);
            }
        }
    }

    private void initQtyField(int precision, IRow row) {
        KDTDefaultCellEditor editorQty = FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)false);
        String str = ProjectUtil.getFormatString(precision);
        row.getCell(TB_DAYQTY).setEditor((ICellEditor)editorQty);
        row.getCell(TB_DAYMAXQTY).setEditor((ICellEditor)editorQty);
        row.getCell(TB_DAYQTY).getStyleAttributes().setNumberFormat(str);
        row.getCell(TB_DAYMAXQTY).getStyleAttributes().setNumberFormat(str);
        row.getCell(TB_TOTALPLANQTY).setEditor((ICellEditor)editorQty);
        row.getCell(TB_TOTALADJUSTQTY).setEditor((ICellEditor)editorQty);
        row.getCell(TB_TOTALPLANQTY).getStyleAttributes().setNumberFormat(str);
        row.getCell(TB_TOTALADJUSTQTY).getStyleAttributes().setNumberFormat(str);
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).setEditor((ICellEditor)editorQty);
            row.getCell(peroid.toString() + TB_PERIOD_MAX).setEditor((ICellEditor)editorQty);
            row.getCell(peroid.toString() + TB_PERIOD_PLANQTY).setEditor((ICellEditor)editorQty);
            row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).getStyleAttributes().setNumberFormat(str);
            row.getCell(peroid.toString() + TB_PERIOD_MAX).getStyleAttributes().setNumberFormat(str);
            row.getCell(peroid.toString() + TB_PERIOD_PLANQTY).getStyleAttributes().setNumberFormat(str);
        }
    }

    private int calMaxPeroidQty(IRow row, List calendar, BigDecimal maxDayQty, Peroid peroid, int index) {
        int resultIndex = index;
        MonthPlanCalendarData firstDay = null;
        MonthPlanCalendarData lastDay = null;
        MonthPlanCalendarData currentDay = null;
        for (resultIndex = index; resultIndex < calendar.size(); ++resultIndex) {
            currentDay = (MonthPlanCalendarData)calendar.get(resultIndex);
            if (!peroid.toString().equalsIgnoreCase(Peroid.getPeroid(currentDay.getDate(), this.peroidType.getNumber()).toString())) break;
            if (firstDay == null) {
                firstDay = currentDay;
            }
            lastDay = currentDay;
        }
        BigDecimal workDays = null;
        workDays = lastDay == null || firstDay == null ? MonthPlanConst.ZERO : new BigDecimal(lastDay.getWorkDateSeq() - firstDay.getWorkDateSeq() + 1);
        BigDecimal maxPeroidQty = maxDayQty.multiply(workDays);
        row.getCell(peroid.toString() + TB_PERIOD_MAX).setValue((Object)maxPeroidQty);
        return resultIndex;
    }

    private void fillPlanQty(String projectId, String templateId, IRow row) throws SQLException {
        ProjectPeroidData peroidData = (ProjectPeroidData)this.projectPeroidDataPlan.get(projectId + templateId);
        row.setUserObject((Object)peroidData);
        BigDecimal planQty = null;
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            planQty = peroidData.getQty(peroid);
            row.getCell(peroid.toString() + TB_PERIOD_PLANQTY).setValue((Object)planQty);
            row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).setValue((Object)planQty);
        }
        row.getCell(TB_TOTALPLANQTY).setValue((Object)peroidData.calTotalQty());
        row.getCell(TB_TOTALADJUSTQTY).setValue((Object)peroidData.calTotalQty());
    }

    private void fillAdjustQty(String projectId, String templateId, IRow row) throws SQLException {
        ProjectPeroidData peroidData = (ProjectPeroidData)this.projectPeroidDataAdjust.get(projectId + templateId);
        if (peroidData == null) {
            return;
        }
        row.setUserObject((Object)peroidData);
        BigDecimal adjustQty = null;
        for (int i = 0; i < this.periods.length; ++i) {
            Peroid peroid = this.periods[i];
            adjustQty = peroidData.getQty(peroid);
            if (adjustQty == null) continue;
            row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).setValue((Object)adjustQty);
        }
        row.getCell(TB_TOTALADJUSTQTY).setValue((Object)peroidData.calTotalQty());
    }

    private void buildPlanPeriodData(IRowSet task) throws SQLException {
        if (task == null) {
            return;
        }
        if (this.projectPeroidDataPlan == null) {
            this.projectPeroidDataPlan = new HashMap();
        }
        String storageOrgUnitId = null;
        String projectId = null;
        String taskTemplateId = null;
        Date planEndTime = null;
        BigDecimal qty = null;
        int precision = 0;
        String lastProjectId = null;
        String lastTemplateId = null;
        ProjectPeroidData peroidData = null;
        while (task.next()) {
            storageOrgUnitId = task.getString("FStorageOrgUnitID");
            projectId = task.getString("FProjectID");
            taskTemplateId = task.getString("FTaskTemplateID");
            planEndTime = task.getDate("FPlanEndTime");
            qty = task.getBigDecimal("FQty");
            precision = task.getInt("FPrecision");
            qty.setScale(precision, 4);
            Peroid peroid = Peroid.getPeroid(planEndTime, this.peroidType.getNumber());
            if (peroidData != null && projectId.equalsIgnoreCase(lastProjectId) && taskTemplateId.equalsIgnoreCase(lastTemplateId)) {
                peroidData.addQty(peroid, qty);
                continue;
            }
            lastProjectId = projectId;
            lastTemplateId = taskTemplateId;
            peroidData = new ProjectPeroidData(projectId, taskTemplateId, storageOrgUnitId, precision);
            peroidData.addQty(peroid, qty);
            this.projectPeroidDataPlan.put(projectId + taskTemplateId, peroidData);
        }
    }

    private void buildAdjustPeriodData(IRowSet monthPlan) throws SQLException {
        if (monthPlan == null) {
            return;
        }
        if (this.projectPeroidDataAdjust == null) {
            this.projectPeroidDataAdjust = new HashMap();
        }
        String storageOrgUnitId = null;
        String projectId = null;
        String taskTemplateId = null;
        int precision = 0;
        String monthPlanId = null;
        String entryId = null;
        int year = 0;
        int peroidNumber = 0;
        BigDecimal qty = null;
        String lastProjectId = null;
        String lastTemplateId = null;
        ProjectPeroidData peroidData = null;
        while (monthPlan.next()) {
            storageOrgUnitId = monthPlan.getString("FStorageOrgUnitID");
            projectId = monthPlan.getString("FProjectID");
            taskTemplateId = monthPlan.getString("FTaskTemplateID");
            monthPlanId = monthPlan.getString("FID");
            entryId = monthPlan.getString("FEntryID");
            year = monthPlan.getInt("FYear");
            peroidNumber = monthPlan.getInt("FPeroid");
            qty = monthPlan.getBigDecimal("FAdjustQty");
            precision = monthPlan.getInt("FPrecision");
            qty.setScale(precision, 4);
            Peroid peroid = new Peroid(year, peroidNumber, null);
            peroid.setMonthPlanEntryId(entryId);
            if (peroidData != null && projectId.equalsIgnoreCase(lastProjectId) && taskTemplateId.equalsIgnoreCase(lastTemplateId)) {
                peroidData.addQty(peroid, qty);
                continue;
            }
            lastProjectId = projectId;
            lastTemplateId = taskTemplateId;
            peroidData = new ProjectPeroidData(projectId, taskTemplateId, storageOrgUnitId, precision);
            peroidData.setMonthPlanId(monthPlanId);
            peroidData.addQty(peroid, qty);
            this.projectPeroidDataAdjust.put(projectId + taskTemplateId, peroidData);
        }
    }

    private MonthPlanCollection prepareSaveData() {
        Iterator it = this.rowsEdited.values().iterator();
        MonthPlanCollection monthPlans = new MonthPlanCollection();
        MonthPlanInfo monthPlan = null;
        MonthPlanEntryInfo monthPlanEntry = null;
        while (it.hasNext()) {
            Integer rowNum = (Integer)it.next();
            IRow row = this.kdtMain.getRow(rowNum.intValue());
            ProjectPeroidData peroidData = (ProjectPeroidData)row.getUserObject();
            if (peroidData != null) {
                monthPlan = new MonthPlanInfo();
                ProjectInfo project = new ProjectInfo();
                project.setId(BOSUuid.read((String)peroidData.getProjectId()));
                monthPlan.setProject(project);
                TaskTemplateInfo template = new TaskTemplateInfo();
                template.setId(BOSUuid.read((String)peroidData.getTaskTemplateId()));
                monthPlan.setTaskTemplate(template);
                if (peroidData.getMonthPlanId() != null) {
                    monthPlan.setId(BOSUuid.read((String)peroidData.getMonthPlanId()));
                }
            }
            for (int i = 0; this.periods != null && i < this.periods.length; ++i) {
                Peroid peroid = this.periods[i];
                BigDecimal adjustQty = (BigDecimal)row.getCell(peroid.toString() + TB_PERIOD_ADJUSTQTY).getValue();
                if (adjustQty == null || adjustQty.compareTo(MonthPlanConst.ZERO) < 0) continue;
                monthPlanEntry = new MonthPlanEntryInfo();
                if (peroidData.getEntryId(peroid) != null) {
                    monthPlanEntry.setId(BOSUuid.read((String)peroidData.getEntryId(peroid)));
                }
                monthPlanEntry.setYear(peroid.getYear());
                monthPlanEntry.setPeroid(peroid.getPeriod());
                monthPlanEntry.setAdjustQty(adjustQty);
                if (monthPlan == null) continue;
                monthPlan.getEntries().add(monthPlanEntry);
            }
            monthPlans.add(monthPlan);
        }
        return monthPlans;
    }

    static {
        Dimension d = KDToolkit.getScreenSize();
        int h = 768;
        if (d != null) {
            h = d.height;
        }
        defaultPageRow = h <= 768 ? 30 : 50;
    }
}

