/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.client.MMGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTree2;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.msopen.MSPDIOpen;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyCollection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyConstraint;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ConstraintType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.DateRange;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Day;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Duration;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendar;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarException;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectCalendarHours;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectHeader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.RelationType;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ResourceAssignment;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpp.MPPReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mpx.MPXWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.MSPDIReader;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.mspdi.MSPDIWriter;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.utility.NumberUtility;
import com.kingdee.eas.mm.project.util.MMProjectCalendar;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class MppDocHandler {
    public static MMGanttProject project;
    public static ProjectFile m_file;
    private static HashMap m_ganttMpxTaskMap;

    public static ProjectFile readProject(MMGanttProject ganttProject, InputStream is) throws Exception {
        ProjectFile projectFile = MppDocHandler.readProject(is);
        if (projectFile == null) {
            MsgBox.showWarning((Component)ganttProject, (String)GanttResourceUtil.getResource("Gantt_EXTWrong"));
            SysUtil.abort();
        }
        MppDocHandler.openProject(ganttProject, projectFile);
        is.close();
        return projectFile;
    }

    public static void openProject(GanttProject projectUI, ProjectFile projectFile) throws Exception {
        MSPDIOpen open = new MSPDIOpen(projectUI.getTree(), projectUI, projectFile);
        open.load();
    }

    public static void writeProjectMPX(MMGanttProject ganttProject, OutputStream ous) throws Exception {
        ProjectFile projectFile = MppDocHandler.createProjectFile(ganttProject);
        MPXWriter writer = new MPXWriter();
        writer.write(projectFile, ous);
        ous.close();
    }

    public static void writeProjectXML(MMGanttProject ganttProject, OutputStream ous) throws Exception {
        ProjectFile projectFile = MppDocHandler.createProjectFile(ganttProject);
        MSPDIWriter writer = new MSPDIWriter();
        writer.write(projectFile, ous);
        ous.close();
    }

    public static ProjectFile createProjectFile(MMGanttProject projectUI) throws Exception {
        project = projectUI;
        Task[] tasks = projectUI.getTaskManager().getTasks();
        return MppDocHandler.createProjectFileOnUI(projectUI.getTree(), null, null, null, tasks);
    }

    public static ProjectFile readProject(InputStream is) {
        is = new BufferedInputStream(is);
        is.mark(0);
        ProjectFile mpx = null;
        try {
            mpx = new MPXReader().read(is);
        }
        catch (Exception ex) {
            try {
                is.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (mpx == null) {
            try {
                mpx = new MPPReader().read(is);
            }
            catch (Exception ex) {
                try {
                    is.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (mpx == null) {
            try {
                mpx = new MSPDIReader().read(is);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return mpx;
    }

    public static ProjectFile createProjectFileOnUI(GanttTree2 tree, TaskDependencyCollection dependencyCol, Date startDate, String id, Task[] tasks) throws Exception {
        ProjectFile file;
        m_file = file = new ProjectFile();
        file.setAutoTaskID(true);
        file.setAutoTaskUniqueID(true);
        file.setAutoResourceID(true);
        file.setAutoResourceUniqueID(true);
        file.setAutoOutlineLevel(true);
        file.setAutoOutlineNumber(true);
        file.setAutoWBS(true);
        file.setAutoCalendarUniqueID(true);
        ProjectCalendar calendar = file.addDefaultBaseCalendar();
        ProjectCalendarException exception = calendar.addCalendarException();
        exception.setFromDate(startDate);
        exception.setToDate(startDate);
        exception.setWorking(false);
        ProjectHeader header = file.getProjectHeader();
        header.setStartDate(startDate);
        MppDocHandler.processTasks();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)id));
        view.setFilter(filter);
        view.getSelector().add("*");
        view.getSelector().add("parent.*");
        view.getSorter().add(new SorterItemInfo("seq"));
        return file;
    }

    private static void processTasks() {
        Task[] children = project.getTaskManager().getTaskHierarchy().getNestedTasks(project.getTaskManager().getTaskHierarchy().getRootTask());
        for (int i = 0; i < children.length; ++i) {
            MppDocHandler.processTask(children[i], null);
        }
    }

    private static void processTask(Task ganttTask, com.kingdee.eas.mm.project.client.net.sf.mpxj.Task parent) {
        try {
            float percentageComplete = ganttTask.getCompletionPercentage();
            boolean milestone = ganttTask.isMilestone();
            long taskLength = !milestone ? ganttTask.getDuration().getLength() : 0L;
            com.kingdee.eas.mm.project.client.net.sf.mpxj.Task mpxTask = parent == null ? m_file.addTask() : parent.addTask();
            mpxTask.setName(ganttTask.getName());
            mpxTask.setMilestone(false);
            mpxTask.setStart(ganttTask.getStart().getTime());
            mpxTask.setConstraintDate(ganttTask.getStart().getTime());
            mpxTask.setConstraintType(ConstraintType.MUST_START_ON);
            mpxTask.setDuration(Duration.getInstance(6, TimeUnit.DAYS));
            mpxTask.setPercentageComplete(NumberUtility.getDouble(90.0));
            mpxTask.setNotes(ganttTask.getNotes());
            m_ganttMpxTaskMap.put(new Integer(ganttTask.getTaskID()), mpxTask.getUniqueID());
            Task[] children = project.getTaskManager().getTaskHierarchy().getNestedTasks(ganttTask);
            for (int i = 0; i < children.length; ++i) {
                MppDocHandler.processTask(children[i], mpxTask);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void processRelationships() {
        Task[] children = project.getTaskManager().getTaskHierarchy().getNestedTasks(project.getTaskManager().getTaskHierarchy().getRootTask());
        for (int i = 0; i < children.length; ++i) {
            this.processRelationships(children[i]);
        }
    }

    private void processRelationships(Task ganttTask) {
        TaskDependency[] dependencies = ganttTask.getDependencies().toArray();
        block6: for (int loop = 0; loop < dependencies.length; ++loop) {
            TaskDependency relationship = dependencies[loop];
            Integer mpxSuccessorTaskID = (Integer)m_ganttMpxTaskMap.get(new Integer(relationship.getDependant().getTaskID()));
            Integer mpxPredecessorTaskID = (Integer)m_ganttMpxTaskMap.get(new Integer(relationship.getDependee().getTaskID()));
            if (mpxSuccessorTaskID == null || mpxPredecessorTaskID == null) continue;
            com.kingdee.eas.mm.project.client.net.sf.mpxj.Task mpxSuccessorTask = m_file.getTaskByUniqueID(mpxSuccessorTaskID);
            com.kingdee.eas.mm.project.client.net.sf.mpxj.Task mpxPredecessorTask = m_file.getTaskByUniqueID(mpxPredecessorTaskID);
            Relation mpxRelation = mpxSuccessorTask.addPredecessor(mpxPredecessorTask);
            TaskDependencyConstraint constraint = relationship.getConstraint();
            switch (constraint.getID()) {
                case 1: {
                    mpxRelation.setType(RelationType.START_START);
                    continue block6;
                }
                case 4: {
                    mpxRelation.setType(RelationType.START_FINISH);
                    continue block6;
                }
                case 2: {
                    mpxRelation.setType(RelationType.FINISH_START);
                    continue block6;
                }
                case 3: {
                    mpxRelation.setType(RelationType.FINISH_FINISH);
                }
            }
        }
        Task[] children = project.getTaskManager().getTaskHierarchy().getNestedTasks(ganttTask);
        for (int i = 0; i < children.length; ++i) {
            this.processRelationships(children[i]);
        }
    }

    public static void exportProjectTask(CoreBaseCollection collection, ProjectTaskInfo projectRoot, File file, List list) throws Exception {
        ProjectFile projectFile = new ProjectFile();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ProjectTaskInfo projectTask = null;
        FileOutputStream output = null;
        com.kingdee.eas.mm.project.client.net.sf.mpxj.Task root = null;
        com.kingdee.eas.mm.project.client.net.sf.mpxj.Task parent = null;
        com.kingdee.eas.mm.project.client.net.sf.mpxj.Task task = null;
        try {
            int i;
            output = new FileOutputStream(file);
            Date from1 = df.parse("08:00");
            Date to1 = df.parse("12:00");
            Date from2 = df.parse("13:00");
            Date to2 = df.parse("17:00");
            ProjectCalendar calendar = projectFile.addBaseCalendar();
            calendar.setName(EASResource.getString((String)"com.kingdee.eas.mm.project.PROJECTAutoGenerateResource", (String)"6_MppDocHandler"));
            calendar.setWorkingDay(Day.FRIDAY, true);
            calendar.setWorkingDay(Day.MONDAY, true);
            calendar.setWorkingDay(Day.THURSDAY, true);
            calendar.setWorkingDay(Day.TUESDAY, true);
            calendar.setWorkingDay(Day.WEDNESDAY, true);
            calendar.setWorkingDay(Day.SUNDAY, true);
            calendar.setWorkingDay(Day.SATURDAY, true);
            ProjectCalendarHours hours = calendar.addCalendarHours(Day.SUNDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.SATURDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.FRIDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.MONDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.THURSDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.WEDNESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.TUESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            ProjectCalendarException exception = null;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                exception = calendar.addCalendarException();
                MMProjectCalendar cal = (MMProjectCalendar)list.get(i2);
                exception.setFromDate(cal.getWorkDate().getTime());
                exception.setToDate(cal.getWorkDate().getTime());
                exception.setWorking(false);
            }
            ProjectHeader header = projectFile.getProjectHeader();
            header.setStartDate(null);
            root = projectFile.addTask();
            root.setUniqueID(new Integer(0));
            root.setID(new Integer(0));
            root.setWBS("0");
            root.setOutlineNumber("0");
            root.setOutlineLevel(new Integer(0));
            Calendar beginDate = Calendar.getInstance();
            projectFile.resetID();
            projectFile.setAutoTaskID(true);
            projectFile.setAutoTaskUniqueID(true);
            projectFile.setAutoResourceID(true);
            projectFile.setAutoResourceUniqueID(true);
            projectFile.setAutoOutlineLevel(true);
            projectFile.setAutoOutlineNumber(true);
            projectFile.setAutoWBS(true);
            projectFile.setAutoCalendarUniqueID(true);
            for (i = 0; i < collection.size(); ++i) {
                projectTask = (ProjectTaskInfo)collection.get(i);
                projectTask.getPlanEndTime();
                if (i == 0) {
                    task = root.addTask();
                } else if (projectTask.getParent() == null) {
                    parent = projectFile.getTaskByUniqueID((Integer)map.get(((ProjectTaskInfo)collection.get(0)).getId().toString()));
                    task = root.addTask();
                } else {
                    parent = projectFile.getTaskByUniqueID((Integer)map.get(projectTask.getParent().getId().toString()));
                    if (parent != null) {
                        task = parent.addTask();
                    } else {
                        parent = projectFile.getTaskByUniqueID((Integer)map.get(((ProjectTaskInfo)collection.get(0)).getId().toString()));
                        task = parent.addTask();
                    }
                }
                task.setName(projectTask.getName());
                task.setMilestone(projectTask.isIsMileStone());
                beginDate.setTimeInMillis(projectTask.getPlanBeginTime().getTime());
                beginDate.set(11, 0);
                beginDate.set(12, 0);
                beginDate.set(13, 0);
                task.setStart(beginDate.getTime());
                task.setFinish(projectTask.getPlanEndTime());
                task.setConstraintDate(beginDate.getTime());
                task.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
                task.setEstimated(true);
                task.setDuration(Duration.getInstance(projectTask.getTotalTime().intValue(), TimeUnit.DAYS));
                task.setPercentageComplete(NumberUtility.getDouble(projectTask.getCompletePercent().doubleValue()));
                int actual = (int)projectTask.getCompletePercent().doubleValue() * projectTask.getTotalTime().intValue() / 100;
                ResourceAssignment assignment = task.addResourceAssignment();
                assignment.setResourceID(new Integer(-65535));
                assignment.setWork(Duration.getInstance(projectTask.getTotalTime().intValue(), TimeUnit.DAYS));
                assignment.setRemainingWork(Duration.getInstance(projectTask.getTotalTime().intValue() - actual, TimeUnit.DAYS));
                assignment.setActualWork(Duration.getInstance(actual, TimeUnit.DAYS));
                assignment.setOvertimeWork(Duration.getInstance(0, TimeUnit.DAYS));
                map.put(projectTask.getId().toString(), task.getUniqueID());
            }
            for (i = 0; i < collection.size(); ++i) {
                projectTask = (ProjectTaskInfo)collection.get(i);
                com.kingdee.eas.mm.project.client.net.sf.mpxj.Task curTask = null;
                com.kingdee.eas.mm.project.client.net.sf.mpxj.Task preTask = null;
                if (projectTask.getPreTask() == null) continue;
                curTask = projectFile.getTaskByUniqueID((Integer)map.get(projectTask.getId().toString()));
                preTask = projectFile.getTaskByUniqueID((Integer)map.get(projectTask.getPreTask().getId().toString()));
                if (preTask == null) continue;
                Relation relation = curTask.addPredecessor(preTask);
                if (projectTask.getIteratorType().getId().toString().equals("v1VYDRfdTvK2ahwoFyvCLppMH64=")) {
                    relation.setType(RelationType.START_START);
                } else if (projectTask.getIteratorType().getId().toString().equals("lS5zDgcXS7Ovp7Xx1hjzJZpMH64=")) {
                    relation.setType(RelationType.FINISH_FINISH);
                } else if (projectTask.getIteratorType().getId().toString().equals("V7CLkDIwR9Cbr4Bs/mppV5pMH64=")) {
                    relation.setType(RelationType.START_FINISH);
                } else if (projectTask.getIteratorType().getId().toString().equals("Fq4GNbRIRsycITnKFLeBd5pMH64=")) {
                    relation.setType(RelationType.FINISH_START);
                }
                relation.setDuration(Duration.getInstance(projectTask.getInterval().intValue(), TimeUnit.DAYS));
            }
            beginDate.setTimeInMillis(projectRoot.getPlanBeginTime().getTime());
            beginDate.set(11, 0);
            beginDate.set(12, 0);
            beginDate.set(13, 0);
            root.setName(projectRoot.getName());
            root.setStart(beginDate.getTime());
            root.setFinish(projectRoot.getPlanEndTime());
            root.setConstraintDate(beginDate.getTime());
            root.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
            root.setEstimated(true);
            root.setDuration(projectFile.getDuration(EASResource.getString((String)"com.kingdee.eas.mm.project.PROJECTAutoGenerateResource", (String)"6_MppDocHandler"), projectRoot.getPlanBeginTime(), projectRoot.getPlanEndTime()));
            root.setPercentageComplete(NumberUtility.getDouble(projectFile.getProjectHeader().getPercentageComplete().doubleValue()));
            MSPDIWriter writer = new MSPDIWriter();
            writer.write(projectFile, output);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (output != null) {
                ((OutputStream)output).close();
            }
        }
    }

    public static void exportProjectTask1(CoreBaseCollection collection, File file, List list) throws Exception {
        ProjectFile projectFile = new ProjectFile();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ProjectTaskInfo projectTask = null;
        FileOutputStream output = null;
        com.kingdee.eas.mm.project.client.net.sf.mpxj.Task parent = null;
        com.kingdee.eas.mm.project.client.net.sf.mpxj.Task task = null;
        try {
            int i;
            output = new FileOutputStream(file);
            Date from1 = df.parse("08:00");
            Date to1 = df.parse("12:00");
            Date from2 = df.parse("13:00");
            Date to2 = df.parse("17:00");
            projectFile.setAutoTaskID(true);
            projectFile.setAutoTaskUniqueID(true);
            projectFile.setAutoResourceID(true);
            projectFile.setAutoResourceUniqueID(true);
            projectFile.setAutoOutlineLevel(true);
            projectFile.setAutoOutlineNumber(true);
            projectFile.setAutoWBS(true);
            projectFile.setAutoCalendarUniqueID(true);
            ProjectCalendar calendar = projectFile.addBaseCalendar();
            calendar.setName(EASResource.getString((String)"com.kingdee.eas.mm.project.PROJECTAutoGenerateResource", (String)"6_MppDocHandler"));
            calendar.setWorkingDay(Day.FRIDAY, true);
            calendar.setWorkingDay(Day.MONDAY, true);
            calendar.setWorkingDay(Day.THURSDAY, true);
            calendar.setWorkingDay(Day.TUESDAY, true);
            calendar.setWorkingDay(Day.WEDNESDAY, true);
            calendar.setWorkingDay(Day.SUNDAY, true);
            calendar.setWorkingDay(Day.SATURDAY, true);
            ProjectCalendarHours hours = calendar.addCalendarHours(Day.SUNDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.SATURDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.FRIDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.MONDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.THURSDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.WEDNESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            hours = calendar.addCalendarHours(Day.TUESDAY);
            hours.addDateRange(new DateRange(from1, to1));
            hours.addDateRange(new DateRange(from2, to2));
            ProjectCalendarException exception = null;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                exception = calendar.addCalendarException();
                MMProjectCalendar cal = (MMProjectCalendar)list.get(i2);
                exception.setFromDate(cal.getWorkDate().getTime());
                exception.setToDate(cal.getWorkDate().getTime());
                exception.setWorking(false);
            }
            ProjectHeader header = projectFile.getProjectHeader();
            header.setStartDate(null);
            for (i = 0; i < collection.size(); ++i) {
                projectTask = (ProjectTaskInfo)collection.get(i);
                if (i == 0) {
                    task = projectFile.addTask();
                } else if (projectTask.getParent() == null) {
                    parent = projectFile.getTaskByUniqueID((Integer)map.get(((ProjectTaskInfo)collection.get(0)).getId().toString()));
                    task = projectFile.addTask();
                } else {
                    parent = projectFile.getTaskByUniqueID((Integer)map.get(projectTask.getParent().getId().toString()));
                    if (parent != null) {
                        task = parent.addTask();
                    } else {
                        parent = projectFile.getTaskByUniqueID((Integer)map.get(((ProjectTaskInfo)collection.get(0)).getId().toString()));
                        task = parent.addTask();
                    }
                }
                task.setName(projectTask.getName());
                task.setMilestone(projectTask.isIsMileStone());
                Calendar beginDate = Calendar.getInstance();
                beginDate.setTimeInMillis(projectTask.getPlanBeginTime().getTime());
                beginDate.set(11, 0);
                beginDate.set(12, 0);
                beginDate.set(13, 0);
                task.setStart(beginDate.getTime());
                task.setFinish(projectTask.getPlanEndTime());
                task.setConstraintDate(beginDate.getTime());
                task.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
                task.setEstimated(true);
                task.setDuration(Duration.getInstance(projectTask.getTotalTime().intValue(), TimeUnit.DAYS));
                task.setPercentageComplete(NumberUtility.getDouble(projectTask.getCompletePercent().doubleValue()));
                int actual = (int)projectTask.getCompletePercent().doubleValue() * projectTask.getTotalTime().intValue() / 100;
                ResourceAssignment assignment = task.addResourceAssignment();
                assignment.setResourceID(new Integer(-65535));
                assignment.setWork(Duration.getInstance(projectTask.getTotalTime().intValue(), TimeUnit.DAYS));
                assignment.setRemainingWork(Duration.getInstance(projectTask.getTotalTime().intValue() - actual, TimeUnit.DAYS));
                assignment.setActualWork(Duration.getInstance(actual, TimeUnit.DAYS));
                assignment.setOvertimeWork(Duration.getInstance(0, TimeUnit.DAYS));
                map.put(projectTask.getId().toString(), task.getUniqueID());
            }
            for (i = 0; i < collection.size(); ++i) {
                projectTask = (ProjectTaskInfo)collection.get(i);
                com.kingdee.eas.mm.project.client.net.sf.mpxj.Task curTask = null;
                com.kingdee.eas.mm.project.client.net.sf.mpxj.Task preTask = null;
                if (projectTask.getPreTask() == null) continue;
                curTask = projectFile.getTaskByUniqueID((Integer)map.get(projectTask.getId().toString()));
                preTask = projectFile.getTaskByUniqueID((Integer)map.get(projectTask.getPreTask().getId().toString()));
                if (preTask == null) continue;
                Relation relation = curTask.addPredecessor(preTask);
                if (projectTask.getIteratorType().getId().toString().equals("v1VYDRfdTvK2ahwoFyvCLppMH64=")) {
                    relation.setType(RelationType.START_START);
                } else if (projectTask.getIteratorType().getId().toString().equals("lS5zDgcXS7Ovp7Xx1hjzJZpMH64=")) {
                    relation.setType(RelationType.FINISH_FINISH);
                } else if (projectTask.getIteratorType().getId().toString().equals("V7CLkDIwR9Cbr4Bs/mppV5pMH64=")) {
                    relation.setType(RelationType.START_FINISH);
                } else if (projectTask.getIteratorType().getId().toString().equals("Fq4GNbRIRsycITnKFLeBd5pMH64=")) {
                    relation.setType(RelationType.FINISH_START);
                }
                relation.setDuration(Duration.getInstance(projectTask.getInterval().intValue(), TimeUnit.DAYS));
            }
            MSPDIWriter writer = new MSPDIWriter();
            writer.write(projectFile, output);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (output != null) {
                ((OutputStream)output).close();
            }
        }
    }

    static {
        m_ganttMpxTaskMap = new HashMap();
    }
}

