/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.project.ChangeTypeEnum;
import com.kingdee.eas.mm.project.client.AbstractPMChangeFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PMChangeFilterUI
extends AbstractPMChangeFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PMChangeFilterUI.class);
    private CustomerParams cp = null;
    private Set statuses = new HashSet();
    private ItemListener changeTypeSelected = null;

    public PMChangeFilterUI() throws Exception {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        MMRangeFilterElement projectName = new MMRangeFilterElement("project.number", (Component)this.prmtProjectF, (Component)this.prmtProjectT);
        elements.add((FilterElement)projectName);
        MMRangeFilterElement number = new MMRangeFilterElement("number", (Component)this.prmtNumberF, (Component)this.prmtNumberT);
        this.prmtNumberF.setCommitFormat("$number$");
        this.prmtNumberT.setCommitFormat("$number$");
        elements.add((FilterElement)number);
        this.getFilterManager().setElement((FilterElement)elements);
        this.kdcbSaved.setSelected(true);
        this.kdcbSubmit.setSelected(true);
        this.kdcbAudit.setSelected(true);
        this.initControls();
        this.initActions();
    }

    private void initControls() {
        this.kdCompChangeType.addItem((Object)"");
        this.kdCompChangeType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.mm.project.ChangeTypeEnum").toArray());
        this.setProjectF7(this.prmtProjectF, null, false, null);
        this.setProjectF7(this.prmtProjectT, null, false, null);
    }

    public void setProjectF7(final KDBizPromptBox projectBox, final HashSet status, final boolean isTemplate, SelectorItemCollection userSelectors) {
        projectBox.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectQuery");
        projectBox.setCommitFormat("$number$");
        if (userSelectors != null) {
            projectBox.setSelectorCollection(userSelectors);
        }
        projectBox.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                projectBox.setEntityViewInfo(PMChangeFilterUI.this.getProjectF7EntityView(status, isTemplate));
                projectBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
        projectBox.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                projectBox.setEntityViewInfo(PMChangeFilterUI.this.getProjectF7EntityView(status, isTemplate));
                projectBox.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    private EntityViewInfo getProjectF7EntityView(HashSet status, boolean isTemplate) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (status != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)new Boolean(isTemplate), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void initActions() {
        this.changeTypeSelected = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (PMChangeFilterUI.this.kdCompChangeType.getSelectedItem() instanceof String) {
                    PMChangeFilterUI.this.removeActions();
                    PMChangeFilterUI.this.kdCompChangeType.setSelectedIndex(-1);
                    PMChangeFilterUI.this.initActions();
                    return;
                }
            }
        };
        this.kdCompChangeType.addItemListener(this.changeTypeSelected);
    }

    private void removeActions() {
        if (this.changeTypeSelected != null) {
            this.kdCompChangeType.removeItemListener(this.changeTypeSelected);
        }
    }

    public boolean verify() {
        super.verify();
        this.statuses.clear();
        if (this.kdcbSaved.isSelected()) {
            this.statuses.add(new Integer(1));
        }
        if (this.kdcbAudit.isSelected()) {
            this.statuses.add(new Integer(4));
        }
        if (this.kdcbSubmit.isSelected()) {
            this.statuses.add(new Integer(2));
        }
        if (this.statuses.size() <= 0) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "MUST_ONE_STATUS"));
            SysUtil.abort();
            return false;
        }
        return true;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        FilterInfo filter = new FilterInfo();
        if (this.statuses.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)this.statuses, CompareType.INCLUDE));
            if (this.txtProjectName.getText() != null && this.txtProjectName.getText().length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("project.name", (Object)("%" + this.txtProjectName.getText() + "%"), CompareType.LIKE));
            }
        }
        if (this.kdCompChangeType.getSelectedIndex() != -1) {
            if (this.kdCompChangeType.getSelectedItem().equals((Object)ChangeTypeEnum.PROJECTCHANGE)) {
                filter.getFilterItems().add(new FilterItemInfo("changeType", (Object)new Integer(10)));
            } else if (this.kdCompChangeType.getSelectedItem().equals((Object)ChangeTypeEnum.WBSCHANGE)) {
                filter.getFilterItems().add(new FilterItemInfo("changeType", (Object)new Integer(20)));
            }
        }
        try {
            filterInfo.mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        logger.error((Object)("Mandy: " + filterInfo));
        return filterInfo;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public CustomerParams getCustomerParams() {
        String projectName;
        CustomerParams pp = super.getCustomerParams();
        if (this.kdcbAudit.isSelected()) {
            pp.addCustomerParam("baseStatusAudit", "4");
        }
        if (this.kdcbSaved.isSelected()) {
            pp.addCustomerParam("baseStatusSave", "1");
        }
        if (this.kdcbSubmit.isSelected()) {
            pp.addCustomerParam("baseStatusSumbit", "2");
        }
        if (!(this.kdCompChangeType.getSelectedItem() instanceof String) && this.kdCompChangeType.getSelectedIndex() != -1) {
            pp.addCustomerParam("changeType", "" + ((ChangeTypeEnum)((Object)this.kdCompChangeType.getSelectedItem())).getValue());
        }
        if ((projectName = this.txtProjectName.getText()) != null && projectName.length() > 0) {
            pp.addCustomerParam("projectName", projectName);
        }
        return pp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeActions();
        this.kdcbSaved.setSelected(false);
        this.kdcbSubmit.setSelected(false);
        this.kdcbAudit.setSelected(false);
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("baseStatusAudit") != null && this.cp.getCustomerParam("baseStatusAudit").length() > 0) {
            this.kdcbAudit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSave") != null && this.cp.getCustomerParam("baseStatusSave").length() > 0) {
            this.kdcbSaved.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSumbit") != null && this.cp.getCustomerParam("baseStatusSumbit").length() > 0) {
            this.kdcbSubmit.setSelected(true);
        }
        if (this.cp.getCustomerParam("changeType") != null && this.cp.getCustomerParam("changeType").length() > 0) {
            String value = this.cp.getCustomerParam("changeType");
            if (value.equalsIgnoreCase("10")) {
                this.kdCompChangeType.setSelectedItem((Object)ChangeTypeEnum.PROJECTCHANGE);
            } else {
                this.kdCompChangeType.setSelectedItem((Object)ChangeTypeEnum.WBSCHANGE);
            }
        }
        if (this.cp.getCustomerParam("projectName") != null && this.cp.getCustomerParam("projectName").length() > 0) {
            this.txtProjectName.setText(this.cp.getCustomerParam("projectName"));
        }
        this.initActions();
    }

    public void clear() {
        super.clear();
        this.kdcbAudit.setSelected(true);
        this.kdcbSaved.setSelected(true);
        this.kdcbSubmit.setSelected(true);
        this.txtProjectName.setText(null);
        this.kdCompChangeType.setSelectedIndex(-1);
    }
}

