/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.mm.project.ProjectGroupInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.client.AbstractProjectBaseTreeListUI;
import com.kingdee.eas.mm.project.client.IObserver;
import com.kingdee.eas.mm.project.client.ProjectGoupTreeFactory;
import com.kingdee.eas.mm.project.client.ProjectGroupTreeUI;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public abstract class ProjectBaseTreeListUI
extends AbstractProjectBaseTreeListUI
implements IObserver {
    private static final long serialVersionUID = -6042418147133753023L;
    private static final Logger logger = CoreUIObject.getLogger(ProjectBaseTreeListUI.class);
    protected ProjectGroupTreeUI treeui = null;

    public void onLoad() throws Exception {
        if (this.isFirstOnload()) {
            this.treeui = ProjectGoupTreeFactory.createTreeUI(this.treePanel, this, this.isProjectMode(), this.isTemplate(), true);
        }
        super.onLoad();
    }

    public String[] getMainFilterInfo(FilterInfo f) {
        String[] args = null;
        for (int i = 0; i < f.getFilterItems().size(); ++i) {
            FilterItemInfo info = f.getFilterItems().get(i);
            String pname = info.getPropertyName();
            if (!pname.equalsIgnoreCase("storageOrgUnit.number")) continue;
            if (f.getFilterItems().get(i).getCompareValue() instanceof String) {
                String o = (String)f.getFilterItems().get(i).getCompareValue();
                args = new String[]{o};
            }
            if (!(f.getFilterItems().get(i).getCompareValue() instanceof HashSet)) break;
            LinkedHashSet set = (LinkedHashSet)f.getFilterItems().get(i).getCompareValue();
            args = new String[set.size()];
            set.toArray(args);
            break;
        }
        return args;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        super.beforeExcutQuery(ev);
        if (ev != null && ev.getFilter() != null) {
            String[] ars = this.getMainFilterInfo(ev.getFilter());
            this.treeui.setOrgs(ars);
        }
    }

    @Override
    public void selectedGroup(ProjectGroupInfo projectGroup) {
        if (this.isProjectMode()) {
            return;
        }
        try {
            FilterInfo filter = this.mainQuery.getFilter();
            FilterItemInfo filerGroup = null;
            int len = filter.getFilterItems().size();
            for (int i = 0; i < len; ++i) {
                FilterItemInfo info = filter.getFilterItems().get(i);
                String pname = info.getPropertyName();
                if (!pname.equalsIgnoreCase("group.id")) continue;
                filerGroup = info;
                break;
            }
            if (filerGroup == null) {
                FilterInfo filterOther = new FilterInfo();
                filterOther.getFilterItems().add(new FilterItemInfo("group.id", (Object)projectGroup.getId().toString(), CompareType.EQUALS));
                filter.mergeFilter(filterOther, "and");
                this.mainQuery.setFilter(filter);
            } else {
                filerGroup.setCompareValue((Object)projectGroup.getId().toString());
            }
            this.refreshList();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void selectedProject(ProjectInfo project) {
        if (!this.isProjectMode()) {
            return;
        }
        try {
            FilterInfo filter = this.mainQuery.getFilter();
            FilterItemInfo filerGroup = null;
            int len = filter.getFilterItems().size();
            for (int i = 0; i < len; ++i) {
                FilterItemInfo info = filter.getFilterItems().get(i);
                String pname = info.getPropertyName();
                if (!pname.equalsIgnoreCase("project.id")) continue;
                filerGroup = info;
                break;
            }
            if (filerGroup == null) {
                FilterInfo filterOther = new FilterInfo();
                filterOther.getFilterItems().add(new FilterItemInfo("project.id", (Object)project.getId().toString(), CompareType.EQUALS));
                filter.mergeFilter(filterOther, "and");
                this.mainQuery.setFilter(filter);
            } else {
                filerGroup.setCompareValue((Object)project.getId().toString());
            }
            this.refreshList();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected boolean isProjectMode() {
        return true;
    }

    protected abstract boolean isTemplate();

    @Override
    public String getCurrentCUID() {
        CtrlUnitInfo curCtrlUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
        if (curCtrlUnitInfo != null) {
            return curCtrlUnitInfo.getId().toString();
        }
        return null;
    }

    protected boolean isSupportDynQuery() {
        return true;
    }
}

