/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.calendar.extendcontrols.KDWorkCalendar;
import com.kingdee.eas.base.calendar.extendcontrols.KDWorkCalendarEventListener;
import com.kingdee.eas.base.calendar.plaf.KingdeeWorkCalendarUI;
import com.kingdee.eas.basedata.assistant.WorkDateTypeEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.FactoryCalendarUtils;
import com.kingdee.eas.mm.project.IProjectCalendar;
import com.kingdee.eas.mm.project.ProjectCalendarEntryCollection;
import com.kingdee.eas.mm.project.ProjectCalendarEntryInfo;
import com.kingdee.eas.mm.project.ProjectCalendarFactory;
import com.kingdee.eas.mm.project.ProjectCalendarInfo;
import com.kingdee.eas.mm.project.ProjectCalendarRuleEntryCollection;
import com.kingdee.eas.mm.project.ProjectCalendarRuleEntryInfo;
import com.kingdee.eas.mm.project.ProjectCalendarRuleInfo;
import com.kingdee.eas.mm.project.ProjectCalendarUtils;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.client.AbstractProjectCalendarEditUI;
import com.kingdee.eas.mm.project.client.ProjectCalendarRuleEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class ProjectCalendarEditUI
extends AbstractProjectCalendarEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectCalendarEditUI.class);
    private java.util.Date projectEndDate = null;
    private java.util.Date selectStartDate = null;
    private java.util.Date selectEndDate = null;
    private java.util.Date startDate = null;
    private java.util.Date endDate = null;
    private java.util.Date factStartDate = null;
    private java.util.Date factEndDate = null;
    private boolean isRule = false;
    private int ruleYear = 1900;
    private ProjectCalendarRuleInfo ruleInfo = null;
    private ProjectCalendarInfo projectCalendarInfo = null;
    private String projectCalendarId = null;
    private KDWorkCalendar kdWorkCalendar = new KDWorkCalendar();
    private Border border = new LineBorder(new Color(180, 180, 180));
    private KDCheckBox[] weeksBox = new KDCheckBox[]{this.chkSun, this.chkMon, this.chkTue, this.chkWed, this.chkThu, this.chkFri, this.chkSat};
    private Color[] dateTypeColor = new Color[]{new Color(155, 206, 161), new Color(255, 255, 255), new Color(255, 188, 74), new Color(215, 233, 217)};
    private JLabel[] dateTypeLabel = new JLabel[]{this.lblHalfWorkday, this.lblWorkday, this.lblHoliday, this.lblWeekend};
    private int[] weeksCommand = new int[]{1, 2, 3, 4, 5, 6, 7};
    private Map selectWeek = new HashMap();
    CheckWeekListener listener = null;
    DataChangeListener dataChangeListener = null;
    KDWorkCalendarEventListener workCalendarListener = null;
    DataChangeListener workDataChangeListener = null;
    private String workCalendarRes = "com.kingdee.eas.mm.project.ProjectCalendarResource";
    private int monthsPerPage = 12;
    private int monthsPerRow = 4;
    private ProjectInfo project = new ProjectInfo();
    private Map map = new HashMap();
    private boolean isInitEnd = false;
    private boolean isAudit = false;

    public void onLoad() throws Exception {
        this.setDate();
        super.onLoad();
        this.initUI();
        this.setKDTableEnable(OprtState.VIEW);
        this.isInitEnd = true;
    }

    public void setDate() {
        Calendar cl = Calendar.getInstance();
        if (this.ruleYear == 1900) {
            this.project = (ProjectInfo)this.getUIContext().get("Project");
            this.projectCalendarId = this.project.getProjectCalendar().getId().toString();
            if (4 == this.project.getBaseStatus().getValue()) {
                this.isAudit = true;
            }
            this.selectStartDate = this.project.getEaristBeginTime();
            this.selectEndDate = this.project.getLastEndTime();
            if (this.selectStartDate == null || this.selectEndDate == null) {
                this.selectStartDate = this.project.getPlanBeginTime();
                this.selectEndDate = this.project.getPlanEndTime();
            }
            this.projectEndDate = this.selectEndDate;
            Calendar c = Calendar.getInstance();
            c.setTime(this.selectStartDate);
            c.set(c.get(1), 0, 1);
            this.startDate = c.getTime();
            c.setTime(this.selectEndDate);
            c.set(c.get(1), 11, 31);
            this.endDate = c.getTime();
            this.prmtProjectCalendar.setValue((Object)this.project.getName());
        } else {
            cl.set(this.ruleYear, 0, 1);
            this.startDate = this.selectStartDate = cl.getTime();
            cl.set(this.ruleYear, 11, 31);
            this.endDate = this.selectEndDate = cl.getTime();
        }
        this.selectStartDate = FactoryCalendarUtils.clearTime((java.util.Date)this.selectStartDate);
        this.selectEndDate = FactoryCalendarUtils.clearTime((java.util.Date)this.selectEndDate);
        this.pkStartWorkDate.setValue((Object)this.selectStartDate);
        this.pkEndWorkDate.setValue((Object)this.selectEndDate);
        cl.setTime(this.selectStartDate);
        cl.set(cl.get(1), cl.get(2), 1);
        this.selectStartDate = cl.getTime();
        cl.setTime(this.selectEndDate);
        cl.set(cl.get(1), cl.get(2), cl.getActualMaximum(5));
        this.selectEndDate = cl.getTime();
    }

    private void initUI() {
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionSetRule.setEnabled(true);
        this.actionAddNew.setVisible(false);
        this.actionRemove.setVisible(false);
        this.kdWorkCalendar.setOpaque(false);
        this.kDNumberTextFieldValidDay.setEnabled(false);
        this.kDButtonDelYear.setPreferredSize(new Dimension(73, 54));
        this.kDButtonDelYear.setMaximumSize(new Dimension(73, 54));
        this.kDButtonDelYear.setMinimumSize(new Dimension(73, 54));
        this.kDButtonDelYear.setSize(new Dimension(73, 54));
        for (int i = 0; i < this.dateTypeLabel.length; ++i) {
            this.dateTypeLabel[i].setBackground(this.dateTypeColor[i]);
            this.dateTypeLabel[i].setBorder(this.border);
        }
        this.btnPreMonths.setEnabled(false);
        this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top"));
        this.btnPreMonths.setPressedIcon(EASResource.getIcon((String)"imgDate_button_top_1"));
        this.btnPreMonths.setText("");
        this.btnPreMonths.setBorder(this.border);
        this.btnNextMonths.setEnabled(false);
        this.btnNextMonths.setText("");
        this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down"));
        this.btnNextMonths.setPressedIcon(EASResource.getIcon((String)"imgDate_button_down_1"));
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuFile.removeAll();
        this.menuFile.addSeparator("kDSeparator3");
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
        this.menuEdit.removeAll();
        this.menuEdit.add((JMenuItem)this.menuItemEdit);
        this.menuEdit.add((JMenuItem)this.menuItemSubmit);
        this.menuEdit.add((JMenuItem)this.kDMenuItemSetRule);
        this.menuItemEdit.setEnabled(true);
        this.menuItemSubmit.setEnabled(false);
        this.menuItemRemove.setEnabled(true);
        this.kDMenuItemSetRule.setIcon(EASResource.getIcon((String)"imgTbtn_rulesetting"));
        this.kDMenuItemSetRule.setEnabled(true);
        this.menuView.setVisible(false);
        this.menuBiz.setVisible(false);
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnEdit);
        this.toolBar.add((Component)this.btnSubmit);
        this.btnEdit.setEnabled(true);
        this.btnSubmit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnSetRule.setEnabled(true);
        this.btnSetRule.setIcon(EASResource.getIcon((String)"imgTbtn_rulesetting"));
        this.toolBar.add((Component)this.separatorFW1);
        this.toolBar.add((Component)this.btnSetRule);
        this.btnEdit.setToolTipText(this.btnEdit.getText());
        this.setButtonDefaultStyl(this.btnEdit);
        this.btnAddNew.setVisible(false);
    }

    private void initData() {
        this.getProjectCalendarById();
        this.project.setProjectCalendar(this.projectCalendarInfo);
        this.setDefaultData();
        this.initCalendarByCurStartAndEndDate();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.add((Component)this.kdWorkCalendar, null);
        this.kdWorkCalendar.setBounds(new Rectangle(10, 98, 900, 460));
    }

    private void getProjectCalendarById() {
        try {
            IProjectCalendar iProjectCalendar = (IProjectCalendar)this.getBizInterface();
            if (this.isRule) {
                this.projectCalendarInfo = iProjectCalendar.getProjectCalendarById(this.projectCalendarId, this.selectStartDate, this.selectEndDate);
                if (this.projectCalendarInfo != null) {
                    int sel = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"CalExistIsClover"));
                    if (sel == 2) {
                        return;
                    }
                    this.setOprtState(OprtState.EDIT);
                    this.setDefaultDateType();
                    ProjectCalendarEntryCollection collection = new ProjectCalendarEntryCollection();
                    collection = iProjectCalendar.createProjectCalendar(this.startDate, this.endDate, this.projectCalendarId, false);
                    this.setWorkCalendarTypeByRuleInfo(this.ruleInfo, collection);
                    this.projectCalendarInfo.put("entrys", (Object)collection);
                } else {
                    this.projectCalendarInfo = new ProjectCalendarInfo();
                    this.projectCalendarInfo.setId(BOSUuid.read((String)this.projectCalendarId));
                    this.setDefaultDateType();
                    ProjectCalendarEntryCollection collection = new ProjectCalendarEntryCollection();
                    collection = iProjectCalendar.createProjectCalendar(this.startDate, this.endDate, this.projectCalendarId, false);
                    this.setWorkCalendarTypeByRuleInfo(this.ruleInfo, collection);
                    this.projectCalendarInfo.put("entrys", (Object)collection);
                }
            } else if ("nz4fwnlKQs2UUNYLZfS4U5nUdmw=".equals(this.projectCalendarId)) {
                this.projectCalendarInfo = new ProjectCalendarInfo();
                this.projectCalendarInfo.setNumber(this.project.getNumber() + "Time");
                ProjectCalendarEntryCollection collection = iProjectCalendar.createProjectCalendar(this.startDate, this.endDate, null, true);
                this.projectCalendarInfo.getEntrys().addCollection(collection);
                this.setDefaultDateType();
            } else {
                this.projectCalendarInfo = iProjectCalendar.getProjectCalendarById(this.projectCalendarId, this.selectStartDate, this.selectEndDate);
                this.map = iProjectCalendar.getStartAndEndDateByID(this.projectCalendarId);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void addListener() {
        CheckWeekListener listener = new CheckWeekListener();
        for (int i = 0; i < this.weeksBox.length; ++i) {
            this.weeksBox[i].setActionCommand(String.valueOf(this.weeksCommand[i]));
            this.weeksBox[i].addActionListener((ActionListener)listener);
        }
        this.dataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                ProjectCalendarEditUI.this.date_dataChange(e);
            }
        };
        this.pkStartWorkDate.addDataChangeListener(this.dataChangeListener);
        this.pkEndWorkDate.addDataChangeListener(this.dataChangeListener);
        this.workDataChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ProjectCalendarEditUI.this.totalValidWorkDate();
            }
        };
        this.kdWorkCalendar.addDataChangeListener(this.workDataChangeListener);
    }

    private void removeListener() {
        for (int i = 0; i < this.weeksBox.length; ++i) {
            if (this.weeksBox[i].getActionListeners() == null) continue;
            this.weeksBox[i].removeActionListener((ActionListener)this.listener);
        }
        if (this.dataChangeListener != null) {
            this.pkStartWorkDate.removeDataChangeListener(this.dataChangeListener);
            this.pkEndWorkDate.removeDataChangeListener(this.dataChangeListener);
        }
        if (this.workDataChangeListener != null) {
            this.kdWorkCalendar.removeDataChangeListener(this.workDataChangeListener);
        }
    }

    private void setKDTableEnable(String status) {
        block6: {
            block5: {
                if (!status.equalsIgnoreCase(OprtState.VIEW)) break block5;
                this.menuItemEdit.setEnabled(true);
                this.menuItemSubmit.setEnabled(false);
                this.btnEdit.setEnabled(true);
                this.btnSubmit.setEnabled(false);
                if (this.isAudit) {
                    this.pkStartWorkDate.setEnabled(false);
                    this.pkStartWorkDate.setAccessAuthority(1);
                    this.pkEndWorkDate.setAccessAuthority(1);
                    this.pkEndWorkDate.setEnabled(false);
                } else {
                    this.pkStartWorkDate.setEnabled(true);
                    this.kdWorkCalendar.setEditable(true);
                    this.pkStartWorkDate.setAccessAuthority(0);
                    this.pkEndWorkDate.setAccessAuthority(0);
                    this.pkEndWorkDate.setEnabled(true);
                }
                this.kDButtonDelYear.setEnabled(false);
                for (int j = 0; j < this.weeksBox.length; ++j) {
                    this.weeksBox[j].setEnabled(false);
                }
                break block6;
            }
            if (!status.equalsIgnoreCase(OprtState.EDIT)) break block6;
            this.menuItemEdit.setEnabled(false);
            this.menuItemSubmit.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnSubmit.setEnabled(true);
            this.pkStartWorkDate.setEnabled(false);
            this.pkEndWorkDate.setEnabled(false);
            if (!this.isAudit) {
                this.kDButtonDelYear.setEnabled(true);
                for (int j = 0; j < this.weeksBox.length; ++j) {
                    this.weeksBox[j].setEnabled(true);
                }
            }
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initData();
        this.addListener();
    }

    @Override
    public void storeFields() {
        this.setDataObject((IObjectValue)this.projectCalendarInfo);
        super.storeFields();
        this.putCalendarToEditData();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setKDTableEnable(OprtState.VIEW);
        this.setOprtState(OprtState.VIEW);
        this.getUIContext().put("projectCalendar", this.editData);
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        if ("nz4fwnlKQs2UUNYLZfS4U5nUdmw=".equals(this.projectCalendarId)) {
            this.projectCalendarId = pk.toString();
        }
        super.doAfterSubmit(pk);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setKDTableEnable(OprtState.EDIT);
    }

    @Override
    public void actionNextMonths_actionPerformed(ActionEvent e) throws Exception {
        this.dealPreOrNextMonths(1);
    }

    @Override
    public void actionPreMonths_actionPerformed(ActionEvent e) throws Exception {
        this.dealPreOrNextMonths(-1);
    }

    @Override
    public void actionSetRule_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"targetID", SysContext.getSysContext().getCurrentUser());
        if (this.projectCalendarInfo.getId() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"NeedSaveOne"));
            return;
        }
        this.project.setProjectCalendar(this.projectCalendarInfo);
        uiContext.put((Object)"project", (Object)this.project);
        uiContext.put((Object)"openModel", (Object)"frame");
        Date startDate = this.pkStartWorkDate.getSqlDate();
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        uiContext.put((Object)"year", (Object)new Integer(c.get(1)));
        c.setTime(this.projectEndDate);
        uiContext.put((Object)"endYear", (Object)new Integer(c.get(1)));
        uiContext.put((Object)"isAudit", (Object)new Boolean(this.isAudit));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProjectCalendarRuleEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        ProjectCalendarRuleEditUI ruleUi = (ProjectCalendarRuleEditUI)uiWindow.getUIObject();
        Integer yy = (Integer)ruleUi.getUIContext().get("YEAR");
        if (yy == null) {
            return;
        }
        this.ruleYear = yy;
        this.ruleInfo = (ProjectCalendarRuleInfo)ruleUi.getUIContext().get("RULE");
        this.isRule = true;
        this.editData = null;
        this.isInitEnd = false;
        this.onLoad();
        this.isRule = false;
        this.ruleInfo = null;
        this.setKDTableEnable(OprtState.EDIT);
    }

    private void dealPreOrNextMonths(int seq) {
        java.util.Date endMonth = this.getBeforOrAfterDate(this.factEndDate, seq);
        java.util.Date startMonth = this.getBeforOrAfterDate(endMonth, -this.monthsPerPage + 1);
        if (seq > 0) {
            if (endMonth.after(this.selectEndDate)) {
                return;
            }
            this.setNextMonthBtnStatus(endMonth, true);
            this.setPreMonthBtnStatus(startMonth, false);
        }
        if (seq < 0) {
            if (startMonth.before(this.selectStartDate)) {
                return;
            }
            this.setPreMonthBtnStatus(startMonth, true);
            this.setNextMonthBtnStatus(endMonth, false);
        }
        this.kdWorkCalendar.clearYearMonth();
        this.kdWorkCalendar.addYearMonth(startMonth, endMonth);
        this.factStartDate = startMonth;
        this.factEndDate = endMonth;
    }

    @Override
    public void actonDelYear_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.kDComboBoxDelYear.getSelectedItem();
        Date startDate = this.pkStartWorkDate.getSqlDate();
        Date endDate = this.pkEndWorkDate.getSqlDate();
        Calendar cl = Calendar.getInstance();
        cl.setTime(startDate);
        int yStart = cl.get(1);
        cl.setTime(endDate);
        int yEnd = cl.get(1);
        int year = 0;
        if (obj != null) {
            year = (Integer)obj;
            int startYear = (Integer)this.map.get("startYear");
            int endYear = (Integer)this.map.get("endYear");
            if (year >= yStart || year <= yEnd) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"DateAlreadyOptr"));
                return;
            }
            if (year == startYear || year == endYear) {
                this.delEntrys(year);
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"KeepDateContinuum"));
                return;
            }
        }
    }

    private void delEntrys(int year) {
        try {
            ((IProjectCalendar)this.getBizInterface()).delEntrysByYear(this.projectCalendarId, year);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        ProjectCalendarEntryCollection entrys = this.projectCalendarInfo.getEntrys();
        int size = entrys.size();
        Calendar cal = Calendar.getInstance();
        for (int i = size - 1; i >= 0; --i) {
            ProjectCalendarEntryInfo entryInfo = entrys.get(i);
            cal.setTime(entryInfo.getWorkDate());
            int yy = cal.get(1);
            if (yy != year) continue;
            entrys.removeObject(i);
        }
        this.initCalendarByCurStartAndEndDate();
    }

    protected IObjectValue createNewData() {
        ProjectCalendarInfo objectValue = new ProjectCalendarInfo();
        return objectValue;
    }

    private void totalValidWorkDate() {
        Map daysMap = this.kdWorkCalendar.getSettedDays();
        KingdeeWorkCalendarUI.CustomDate customDate = null;
        int count = 0;
        Iterator it1 = daysMap.keySet().iterator();
        Calendar cal = Calendar.getInstance();
        java.util.Date curDate = null;
        java.util.Date startDate = this.pkStartWorkDate.getSqlDate();
        java.util.Date endDate = this.pkEndWorkDate.getSqlDate();
        cal.setTime(startDate);
        startDate = cal.getTime();
        cal.setTime(endDate);
        endDate = cal.getTime();
        KingdeeWorkCalendarUI.DayType dayType = null;
        while (it1.hasNext()) {
            customDate = (KingdeeWorkCalendarUI.CustomDate)it1.next();
            dayType = (KingdeeWorkCalendarUI.DayType)daysMap.get(customDate);
            cal.set(customDate.getYear(), customDate.getMonth(), customDate.getDate());
            curDate = cal.getTime();
            if (curDate.compareTo(startDate) < 0 || curDate.compareTo(endDate) > 0 || dayType.getType() != 1) continue;
            ++count;
        }
        this.kDNumberTextFieldValidDay.setValue((Object)new Integer(count));
    }

    private boolean isValidDate(java.util.Date startDate, java.util.Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(startDate);
        int startYear = cl.get(1);
        int startMonth = cl.get(2);
        int startDay = cl.get(5);
        cl.setTime(endDate);
        int endYear = cl.get(1);
        int endMonth = cl.get(2);
        int endDay = cl.get(5);
        return startYear <= endYear && (startYear != endYear || startMonth < endMonth || startDay <= endDay);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProjectCalendarFactory.getRemoteInstance();
    }

    private void date_dataChange(DataChangeEvent e) {
        String name;
        Object newObj = e.getNewValue();
        java.util.Date oldDate = (java.util.Date)e.getOldValue();
        boolean isStartDate = false;
        java.util.Date newDate = null;
        if (!this.isInitEnd) {
            return;
        }
        if (oldDate == null) {
            return;
        }
        if (newObj instanceof java.util.Date) {
            newDate = (java.util.Date)newObj;
            Calendar cal = Calendar.getInstance();
            cal.setTime(newDate);
            int yyNew = cal.get(1);
            int mmNew = cal.get(2);
            int ddNew = cal.get(5);
            cal.setTime(oldDate);
            int yyOld = cal.get(1);
            int mmOld = cal.get(2);
            int ddOld = cal.get(5);
            if (yyNew == yyOld && mmNew == mmOld && ddNew == ddOld) {
                return;
            }
        }
        if ("pkEndWorkDate".equals(name = ((KDDatePicker)e.getSource()).getName())) {
            java.util.Date startTime = (java.util.Date)this.pkStartWorkDate.getValue();
            if (newDate == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"endDateIsNull"));
                this.pkEndWorkDate.setValue((Object)oldDate);
                return;
            }
            if (!this.isValidDate(startTime, newDate)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"startDateTooLarge"));
                this.pkEndWorkDate.setValue((Object)oldDate);
                return;
            }
        } else {
            java.util.Date endTime = (java.util.Date)this.pkEndWorkDate.getValue();
            if (newDate == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"startDateIsNull"));
                this.pkStartWorkDate.setValue((Object)oldDate);
                return;
            }
            if (!this.isValidDate(newDate, endTime)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.workCalendarRes, (String)"startDateTooLarge"));
                this.pkStartWorkDate.setValue((Object)oldDate);
                return;
            }
            isStartDate = true;
        }
        this.changeCalendarInfo(newDate, isStartDate);
        this.initData();
    }

    private void setDefaultData() {
        this.chkSun.setSelected(this.projectCalendarInfo.isIsSunRest());
        this.chkMon.setSelected(this.projectCalendarInfo.isIsMonRest());
        this.chkTue.setSelected(this.projectCalendarInfo.isIsTueRest());
        this.chkWed.setSelected(this.projectCalendarInfo.isIsWedRest());
        this.chkThu.setSelected(this.projectCalendarInfo.isIsThuRest());
        this.chkFri.setSelected(this.projectCalendarInfo.isIsFriRest());
        this.chkSat.setSelected(this.projectCalendarInfo.isIsSatRest());
    }

    private void setDefaultDateType() {
        this.projectCalendarInfo.setIsSunRest(true);
        this.projectCalendarInfo.setIsMonRest(false);
        this.projectCalendarInfo.setIsTueRest(false);
        this.projectCalendarInfo.setIsWedRest(false);
        this.projectCalendarInfo.setIsThuRest(false);
        this.projectCalendarInfo.setIsFriRest(false);
        this.projectCalendarInfo.setIsSatRest(true);
    }

    private void setDateTypeByEdit() {
        ProjectCalendarEntryCollection collect = this.projectCalendarInfo.getEntrys();
        ProjectCalendarEntryInfo entryInfo = null;
        for (int i = 0; i < collect.size(); ++i) {
            entryInfo = collect.get(i);
            this.kdWorkCalendar.setDayType(entryInfo.getWorkDate(), entryInfo.getDateType().getValue());
        }
    }

    private void putCalendarToEditData() {
        Map workDays = this.kdWorkCalendar.getSettedDays();
        ProjectCalendarEntryCollection days = this.editData.getEntrys();
        Calendar cl = Calendar.getInstance();
        if (workDays != null && workDays.size() > 0) {
            Set keys = workDays.keySet();
            for (KingdeeWorkCalendarUI.CustomDate d : keys) {
                KingdeeWorkCalendarUI.DayType dt = (KingdeeWorkCalendarUI.DayType)workDays.get(d);
                cl.set(d.getYear(), d.getMonth(), d.getDate());
                java.util.Date date = cl.getTime();
                this.setDateTypeByFCalendarEntry(date, dt.getType(), days);
            }
        }
        this.editData.put("entrys", (Object)days);
    }

    private void setDateTypeByFCalendarEntry(java.util.Date date, int dateType, ProjectCalendarEntryCollection entryColl) {
        Iterator it = entryColl.iterator();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        while (it.hasNext()) {
            ProjectCalendarEntryInfo entryInfo = (ProjectCalendarEntryInfo)it.next();
            cal.setTime(entryInfo.getWorkDate());
            int yy = cal.get(1);
            int mm = cal.get(2);
            int dd = cal.get(5);
            if (yy != year || mm != month || dd != day) continue;
            entryInfo.setDateType(WorkDateTypeEnum.getEnum((int)dateType));
            break;
        }
    }

    private void setPreMonthBtnStatus(java.util.Date preMonth, boolean preOperate) {
        if (preMonth == null) {
            return;
        }
        if (this.editData.getEntrys().size() == 0) {
            this.btnPreMonths.setEnabled(false);
            return;
        }
        java.util.Date dStartDate = this.pkStartWorkDate.getSqlDate();
        if (dStartDate == null) {
            dStartDate = this.startDate;
        }
        if (preOperate) {
            if (preMonth.getYear() < dStartDate.getYear() || preMonth.getYear() == dStartDate.getYear() && preMonth.getMonth() <= dStartDate.getMonth()) {
                this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top_2"));
                this.btnPreMonths.setEnabled(false);
            } else {
                this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top"));
                this.btnPreMonths.setEnabled(true);
            }
        } else if (preMonth.getYear() < dStartDate.getYear() || preMonth.getYear() == dStartDate.getYear() && preMonth.getMonth() < dStartDate.getMonth()) {
            this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top_2"));
            this.btnPreMonths.setEnabled(false);
        } else {
            this.btnPreMonths.setIcon(EASResource.getIcon((String)"imgDate_button_top"));
            this.btnPreMonths.setEnabled(true);
        }
    }

    private void setNextMonthBtnStatus(java.util.Date nextMonth, boolean nextOpreate) {
        if (this.editData.getEntrys().size() == 0) {
            this.btnNextMonths.setEnabled(false);
            return;
        }
        java.util.Date dEndDate = this.pkEndWorkDate.getSqlDate();
        if (dEndDate == null) {
            dEndDate = this.endDate;
        }
        if (nextOpreate) {
            if (nextMonth.getYear() > dEndDate.getYear() || nextMonth.getYear() == dEndDate.getYear() && nextMonth.getMonth() >= dEndDate.getMonth()) {
                this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down_2"));
                this.btnNextMonths.setEnabled(false);
            } else {
                this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down"));
                this.btnNextMonths.setEnabled(true);
            }
        } else if (nextMonth.getYear() > dEndDate.getYear() || nextMonth.getYear() == dEndDate.getYear() && nextMonth.getMonth() > dEndDate.getMonth()) {
            this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down_2"));
            this.btnNextMonths.setEnabled(false);
        } else {
            this.btnNextMonths.setIcon(EASResource.getIcon((String)"imgDate_button_down"));
            this.btnNextMonths.setEnabled(true);
        }
    }

    private java.util.Date getBeforOrAfterDate(java.util.Date d, int pad) {
        if (d == null) {
            d = new java.util.Date();
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(d);
        int year = cl.get(1);
        int month = cl.get(2) + pad;
        if (month > 11) {
            month -= 12;
            year = cl.get(1) + 1;
        } else if (month < 0) {
            month = 12 + month;
            year = cl.get(1) - 1;
        }
        cl.set(year, month, 1);
        return cl.getTime();
    }

    private void changeCalendarInfo(java.util.Date newDate, boolean isStart) {
        if (isStart) {
            this.selectStartDate = newDate;
        } else {
            this.selectEndDate = newDate;
        }
    }

    private void initCalendarByCurStartAndEndDate() {
        ProjectCalendarEntryCollection col = this.projectCalendarInfo.getEntrys();
        this.startDate = col.get(0).getWorkDate();
        this.endDate = col.get(col.size() - 1).getWorkDate();
        this.setDataObject((IObjectValue)this.projectCalendarInfo);
        if (this.projectCalendarInfo != null) {
            this.oldData = (ProjectCalendarInfo)this.projectCalendarInfo.clone();
        }
        this.factStartDate = this.selectStartDate;
        this.factEndDate = this.getBeforOrAfterDate(this.selectStartDate, this.monthsPerPage - 1);
        if (!this.factEndDate.before(this.selectEndDate)) {
            this.factEndDate = this.selectEndDate;
        } else {
            this.btnNextMonths.setEnabled(true);
        }
        this.kdWorkCalendar.clearYearMonth();
        this.kdWorkCalendar.addYearMonth(this.factStartDate, this.factEndDate);
        this.kdWorkCalendar.setNumberPerRow(this.monthsPerRow);
        this.setDateTypeByEdit();
        this.totalValidWorkDate();
        this.putDelYear();
    }

    private void setProjectCalendarWorkBox(int i, boolean isSelected) {
        switch (i) {
            case 1: {
                this.projectCalendarInfo.setIsSunRest(isSelected);
                break;
            }
            case 2: {
                this.projectCalendarInfo.setIsMonRest(isSelected);
                break;
            }
            case 3: {
                this.projectCalendarInfo.setIsTueRest(isSelected);
                break;
            }
            case 4: {
                this.projectCalendarInfo.setIsWedRest(isSelected);
                break;
            }
            case 5: {
                this.projectCalendarInfo.setIsThuRest(isSelected);
                break;
            }
            case 6: {
                this.projectCalendarInfo.setIsFriRest(isSelected);
                break;
            }
            case 7: {
                this.projectCalendarInfo.setIsSatRest(isSelected);
            }
        }
    }

    private void setWorkCalendarTypeByRuleInfo(ProjectCalendarRuleInfo ruleInfo, ProjectCalendarEntryCollection collection) {
        ProjectCalendarRuleEntryCollection ruleCollection = ruleInfo.getEntrys();
        ProjectCalendarRuleEntryInfo ruleEntryInfo = null;
        for (int i = 0; i < ruleCollection.size(); ++i) {
            ruleEntryInfo = ruleCollection.get(i);
            this.setWorkCalendarType(ruleEntryInfo, collection);
        }
    }

    private void setWorkCalendarType(ProjectCalendarRuleEntryInfo ruleEntryInfo, ProjectCalendarEntryCollection collection) {
        int monthRule = ruleEntryInfo.getMonth();
        int dayRule = ruleEntryInfo.getDay();
        int seriesDay = ruleEntryInfo.getSeriesDays() - 1;
        int cycleTypre = ruleEntryInfo.getCycSign().getValue();
        if (cycleTypre != 30 && cycleTypre != 10) {
            for (int i = 0; i < collection.size(); ++i) {
                ProjectCalendarEntryInfo entryInfo = collection.get(i);
                ProjectCalendarUtils.setFCEInfoWorkDateType(monthRule, dayRule, seriesDay, entryInfo, collection);
            }
        } else {
            ProjectCalendarEntryCollection startRestDayCollection = new ProjectCalendarEntryCollection();
            startRestDayCollection = cycleTypre == 30 ? ProjectCalendarUtils.getFCEntrysBySean(monthRule, dayRule, collection) : ProjectCalendarUtils.getFCEntrysByWeek(monthRule, dayRule, collection);
            for (int j = 0; j < startRestDayCollection.size(); ++j) {
                ProjectCalendarEntryInfo entryInfo = startRestDayCollection.get(j);
                entryInfo.setDateType(WorkDateTypeEnum.RESTDAY);
                int seq = entryInfo.getSeq();
                ProjectCalendarUtils.setSeriesDayWorkDateType(seq, seriesDay, collection);
            }
        }
    }

    private void putDelYear() {
        if ((Integer)this.map.get("startYear") == null) {
            return;
        }
        int startYear = (Integer)this.map.get("startYear");
        int endYear = (Integer)this.map.get("endYear");
        Calendar cal = Calendar.getInstance();
        int currYear = cal.get(1);
        if (startYear < currYear && currYear - startYear > 4) {
            startYear = currYear - 3;
        }
        cal.setTime(this.projectEndDate);
        int end = cal.get(1);
        if (this.isAudit) {
            startYear = end + 1;
        }
        Vector<Integer> vecList = new Vector<Integer>(endYear - startYear + 1);
        for (int i = startYear; i <= endYear; ++i) {
            vecList.add(new Integer(i));
        }
        this.kDComboBoxDelYear.setModel(new DefaultComboBoxModel(vecList));
    }

    private class CheckWeekListener
    implements ActionListener {
        private CheckWeekListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof KDCheckBox) {
                String comm = e.getActionCommand();
                for (int i = 0; i < ProjectCalendarEditUI.this.weeksCommand.length; ++i) {
                    if (ProjectCalendarEditUI.this.weeksCommand[i] != Integer.parseInt(comm)) continue;
                    ArrayList<java.util.Date> d = new ArrayList<java.util.Date>();
                    Calendar cl = Calendar.getInstance();
                    java.util.Date endDate = ProjectCalendarEditUI.this.pkEndWorkDate.getSqlDate();
                    cl.setTime(endDate);
                    cl.set(cl.get(1), cl.get(2), cl.getActualMaximum(5));
                    endDate = cl.getTime();
                    java.util.Date startDate = ProjectCalendarEditUI.this.pkStartWorkDate.getSqlDate();
                    cl.setTime(startDate);
                    cl.set(cl.get(1), cl.get(2), 1);
                    startDate = cl.getTime();
                    while (ProjectCalendarEditUI.this.isValidDate(startDate, endDate)) {
                        int dw = cl.get(7);
                        if (dw == ProjectCalendarEditUI.this.weeksCommand[i]) {
                            d.add(cl.getTime());
                            cl.add(5, 7);
                        } else {
                            cl.add(5, 1);
                        }
                        startDate = cl.getTime();
                    }
                    KDCheckBox tmp = (KDCheckBox)e.getSource();
                    if (tmp.isSelected()) {
                        ProjectCalendarEditUI.this.selectWeek.put(tmp.getName(), comm);
                        ProjectCalendarEditUI.this.kdWorkCalendar.setDayType(d.toArray(new java.util.Date[0]), 3);
                    } else {
                        ProjectCalendarEditUI.this.selectWeek.remove(tmp.getName());
                        ProjectCalendarEditUI.this.kdWorkCalendar.setDayType(d.toArray(new java.util.Date[0]), 1);
                    }
                    ProjectCalendarEditUI.this.totalValidWorkDate();
                    ProjectCalendarEditUI.this.kdWorkCalendar.repaint();
                    ProjectCalendarEditUI.this.setProjectCalendarWorkBox(ProjectCalendarEditUI.this.weeksCommand[i], tmp.isSelected());
                    break;
                }
            }
        }
    }
}

