/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.IProjectFeedBack;
import com.kingdee.eas.mm.project.ProjectFeedBackFactory;
import com.kingdee.eas.mm.project.ProjectFeedBackInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.client.AbstractProjectFeedBackEditUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.mm.project.util.MMProjectFinalVariable;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ProjectFeedBackEditUI
extends AbstractProjectFeedBackEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectFeedBackEditUI.class);
    private DataChangeListener projectTaskDataChanged = null;
    private DataChangeListener projectDataChanged = null;
    private DataChangeListener precisionChanged = null;
    private DataChangeListener qtyChanged = null;
    private DataChangeListener pkActEndTimeChanged = null;
    private DataChangeListener pkActBeginTimeChanged = null;
    private ProjectInfo newProjectInfo = null;
    private StorageOrgUnitInfo storage = null;
    private MMProjectCalendarFactory mmCalendarFactory = null;
    static final int DEFAULTPRECESION = 8;
    private KDFormattedTextField[] CURRENCYPRECISIONCOMPENT = new KDFormattedTextField[]{this.txtPlanTotalCast, this.txtActTotalCost, this.txtPlanUnitCost, this.txtActUnitCost};

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        if (this.editData != null) {
            this.storage = this.editData.getStorageOrgUnit();
            if (this.editData.getProjectTask() != null) {
                try {
                    this.commPrjTaskValue(this.editData.getProjectTask());
                    this.precisionControl(this.editData.getProjectTask());
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else if (this.editData.getProject() != null) {
                try {
                    this.commProjectValue(this.editData.getProject());
                    this.precisionControl(this.editData.getProject());
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        } else {
            this.storage = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        }
        this.addListener();
        try {
            PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId()), (String)"mm_project_feedBackCostView");
            this.txtActTotalCost.setValue((Object)this.editData.getActTotalCost());
            this.txtActUnitCost.setValue((Object)this.editData.getActUnitCost());
        }
        catch (Exception e) {
            this.txtActTotalCost.setValue(null);
            this.txtActUnitCost.setValue(null);
        }
        if (this.prmtMaterial.getData() != null) {
            try {
                int precision = ProjectUtil.getPrecisionByMaterialInfo((MaterialInfo)this.prmtMaterial.getData(), (MeasureUnitInfo)this.prmtUnit.getData());
                this.txtPlanQty.setPrecision(precision);
                this.txtActQty.setPrecision(precision);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.removeButton();
        this.btnSubmit.setVisible(true);
        this.actionCancel.setEnabled(false);
        this.actionCancelCancel.setEnabled(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.initNeedMainOrgF7s();
        int precision = 8;
        if (this.prmtMaterial.getData() != null && this.prmtUnit.getData() != null) {
            precision = ProjectUtil.getPrecisionByMaterialInfo((MaterialInfo)this.prmtMaterial.getData(), (MeasureUnitInfo)this.prmtUnit.getData());
        }
        this.txtActUsedTime.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtActUsedTime.setRemoveingZeroInDispaly(false);
        this.txtActUsedTime.setSupportedEmpty(true);
        this.txtWorktime.setPrecision(0);
        this.txtWorktime.setRemoveingZeroInDispaly(false);
        this.txtWorktime.setSupportedEmpty(true);
        this.txtActUsedTime.setPrecision(0);
        this.txtActUsedTime.setRemoveingZeroInDispaly(false);
        this.txtActUsedTime.setSupportedEmpty(true);
        this.kDCompletePercent.setPrecision(2);
        this.kDCompletePercent.setRemoveingZeroInDispaly(false);
        this.kDCompletePercent.setSupportedEmpty(true);
        this.kDCompletePercent.setMaximumValue((Comparable)new BigDecimal(100.0));
        this.kDCompletePercent.setMinimumValue((Comparable)new BigDecimal(0.0));
        this.txtActQty.setPrecision(precision);
        this.txtActQty.setRemoveingZeroInDispaly(false);
        this.txtActQty.setSupportedEmpty(true);
        this.actionAudit.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl F9"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl F9"));
        this.actionUnAudit.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl F10"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl F10"));
        this.menuSubmitOption.remove((JMenuItem)this.chkMenuItemSubmitAndPrint);
        if (this.getOprtState() == "EDIT" || this.getOprtState() == "VIEW") {
            this.menuSubmitOption.setVisible(false);
        }
    }

    public void setStatus() {
        super.setStatus();
        ProjectFeedBackInfo info = (ProjectFeedBackInfo)this.dataBinder.getValueObject();
        if ("VIEW".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState())) {
            if (info != null) {
                if (info.getBaseStatus() != null && info.getBaseStatus() == MMBaseStatusEnum.SAVED) {
                    this.actionSubmit.setEnabled(true);
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(false);
                    this.actionRemove.setEnabled(true);
                    this.actionEdit.setEnabled(true);
                }
                if (info.getBaseStatus() != null && info.getBaseStatus() == MMBaseStatusEnum.SUBMIT) {
                    this.actionSubmit.setEnabled(false);
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(false);
                    this.actionRemove.setEnabled(true);
                    this.actionEdit.setEnabled(true);
                    this.actionSave.setEnabled(false);
                } else if (info.getBaseStatus() != null && info.getBaseStatus() == MMBaseStatusEnum.SUBMITCOST) {
                    this.actionSubmit.setEnabled(false);
                    this.actionAudit.setEnabled(true);
                    this.actionUnAudit.setEnabled(false);
                    this.actionRemove.setEnabled(true);
                    this.actionEdit.setEnabled(true);
                    this.actionSave.setEnabled(false);
                } else if (info.getBaseStatus() != null && info.getBaseStatus() == MMBaseStatusEnum.AUDIT) {
                    this.actionAudit.setEnabled(false);
                    this.actionUnAudit.setEnabled(true);
                    this.actionSubmit.setEnabled(false);
                    this.actionRemove.setEnabled(false);
                    this.actionEdit.setEnabled(false);
                }
            }
            this.actionCopy.setEnabled(true);
            if (this.getDetailTable() != null) {
                this.actionAddLine.setEnabled(false);
                this.actionRemoveLine.setEnabled(false);
                this.actionInsertLine.setEnabled(false);
            }
        } else if ("EDIT".equals(this.getOprtState())) {
            this.actionUnAudit.setEnabled(false);
            this.actionRemove.setEnabled(true);
            this.actionCopy.setEnabled(true);
            if (info != null && info.getBaseStatus() != null && info.getBaseStatus() == MMBaseStatusEnum.SUBMIT) {
                this.actionAudit.setEnabled(false);
                this.actionSubmit.setEnabled(true);
                this.actionEdit.setEnabled(false);
                this.actionSave.setEnabled(true);
            } else if (info != null && info.getBaseStatus() != null && info.getBaseStatus() == MMBaseStatusEnum.SUBMITCOST) {
                this.actionSubmit.setEnabled(true);
                this.actionAudit.setEnabled(true);
                this.actionSave.setEnabled(false);
            } else if (info != null && info.getBaseStatus() != null && info.getBaseStatus() == MMBaseStatusEnum.SAVED) {
                this.actionSubmit.setEnabled(true);
                this.actionAudit.setEnabled(false);
                this.actionSave.setEnabled(true);
                this.actionEdit.setEnabled(false);
            } else {
                this.actionAudit.setEnabled(false);
            }
            if (this.getDetailTable() != null) {
                this.actionAddLine.setEnabled(true);
                this.actionRemoveLine.setEnabled(true);
                this.actionInsertLine.setEnabled(true);
            }
        }
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_project_projectFeedBackAddnew";
        }
        if ("EDIT".equals(status)) {
            return "mm_project_projectFeedBackModify";
        }
        if ("VIEW".equals(status)) {
            return "mm_project_projectFeedBackView";
        }
        return null;
    }

    protected void initBatchInterface() {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ProjectFeedBackFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, null, "id", this.txtNumber, null);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProjectFeedBackFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initNeedMainOrgF7s() {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        SelectorItemCollection projectSelectors = new SelectorItemCollection();
        projectSelectors.add(new SelectorItemInfo("*"));
        projectSelectors.add(new SelectorItemInfo("material.id"));
        projectSelectors.add(new SelectorItemInfo("material.baseUnit.id"));
        projectSelectors.add(new SelectorItemInfo("material.baseUnit.name"));
        projectSelectors.add(new SelectorItemInfo("material.baseUnit.number"));
        projectSelectors.add(new SelectorItemInfo("material.number"));
        projectSelectors.add(new SelectorItemInfo("material.name"));
        projectSelectors.add(new SelectorItemInfo("baseUnit.id"));
        projectSelectors.add(new SelectorItemInfo("baseUnit.number"));
        projectSelectors.add(new SelectorItemInfo("baseUnit.name"));
        projectSelectors.add(new SelectorItemInfo("currency.id"));
        projectSelectors.add(new SelectorItemInfo("currency.number"));
        projectSelectors.add(new SelectorItemInfo("currency.name"));
        projectSelectors.add(new SelectorItemInfo("currency.precision"));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProject, status, false, projectSelectors);
        HashSet<Integer> status1 = new HashSet<Integer>();
        status1.add(new Integer(5));
        SelectorItemCollection taskSelectors = new SelectorItemCollection();
        taskSelectors.add(new SelectorItemInfo("material.id"));
        taskSelectors.add(new SelectorItemInfo("material.number"));
        taskSelectors.add(new SelectorItemInfo("material.name"));
        taskSelectors.add(new SelectorItemInfo("iteratorType.id"));
        taskSelectors.add(new SelectorItemInfo("iteratorType.number"));
        taskSelectors.add(new SelectorItemInfo("iteratorType.name"));
        taskSelectors.add(new SelectorItemInfo("currency.id"));
        taskSelectors.add(new SelectorItemInfo("currency.name"));
        taskSelectors.add(new SelectorItemInfo("currency.number"));
        taskSelectors.add(new SelectorItemInfo("currency.precision"));
        taskSelectors.add(new SelectorItemInfo("unit.id"));
        taskSelectors.add(new SelectorItemInfo("unit.name"));
        taskSelectors.add(new SelectorItemInfo("unit.number"));
        taskSelectors.add(new SelectorItemInfo("material.baseUnit.id"));
        taskSelectors.add(new SelectorItemInfo("material.baseUnit.name"));
        taskSelectors.add(new SelectorItemInfo("material.baseUnit.number"));
        ProjectUtil.setProjectTaskF71(this.prmtStorageOrgUnit, this.prmtProject, null, this.prmtProjectTask, status1, taskSelectors);
        UIHelper.registerMeasureUnitF7((KDBizPromptBox)this.prmtMaterial, (KDBizPromptBox)this.prmtUnit);
        this.setProcessStatusF7();
    }

    private void setProcessStatusF7() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(8)));
        viewInfo.setFilter(filterInfo);
        this.prmtProcessStatus.setEntityViewInfo(viewInfo);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.getNewOrg() != null) {
            if (chgVo.isDiffrent()) {
                try {
                    CurrencyInfo currency = this.getCurrenyOrgUnitInfo(((StorageOrgUnitInfo)chgVo.getNewOrg()).getId().toString());
                    SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)currency, (KDFormattedTextField[])this.CURRENCYPRECISIONCOMPENT);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
                this.clearValue();
            }
        } else {
            String msg = ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "ORG_CANT_NULL");
            MsgBox.showInfo((String)msg);
            this.prmtStorageOrgUnit.setValue(chgVo.getOldOrg());
        }
    }

    protected IObjectValue createNewData() {
        ProjectFeedBackInfo objectValue = null;
        StorageOrgUnitInfo storage = (StorageOrgUnitInfo)this.getDefaultMainBizOrg();
        if (storage == null) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectFeedBackResource.NO_ADDNEW_PERMISSION"));
            SysUtil.abort();
        }
        try {
            objectValue = (ProjectFeedBackInfo)((IProjectFeedBack)this.getBizInterface()).createNewData(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (objectValue == null) {
            objectValue = new ProjectFeedBackInfo();
        }
        objectValue.setBaseStatus(MMBaseStatusEnum.ADDNEW);
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        this.clearValue();
        try {
            objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            objectValue.setCreateTime(SCMClientUtils.getServerDate());
            objectValue.setActBeginTime(SCMClientUtils.getServerDate());
            objectValue.setActEndTime(SCMClientUtils.getServerDate());
            objectValue.setBizDate(SCMClientUtils.getServerDate());
            int time = ProjectUtil.getWorkData(new Date(objectValue.getActBeginTime().getTime()), new Date(objectValue.getActEndTime().getTime()));
            this.txtActUsedTime.setValue((Object)new Integer(time));
            objectValue.setActUsedTime(new BigDecimal(time));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return objectValue;
    }

    private void prmtPorjectTask_dataChanged(DataChangeEvent e) throws Exception {
        ProjectTaskInfo oldValue = (ProjectTaskInfo)e.getOldValue();
        ProjectTaskInfo newValue = (ProjectTaskInfo)e.getNewValue();
        this.txtActTotalCost.setValue(null);
        this.txtActUnitCost.setValue(null);
        this.editData.setActTotalCost(new BigDecimal(0));
        this.editData.setActUnitCost(new BigDecimal(0));
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        if (isDiffrent && this.mmCalendarFactory != null) {
            this.commPrjTaskValue(newValue);
            if (this.pkActEndTime.getValue() == null || this.pkActEndTime.getValue() == null) {
                return;
            }
            if (this.pkActBeginTime.getValue() != null && this.pkActEndTime.getValue() != null) {
                int time = this.mmCalendarFactory.getWorklength(new Timestamp(((Date)this.pkActBeginTime.getValue()).getTime()), new Timestamp(((Date)this.pkActEndTime.getValue()).getTime()));
                this.txtActUsedTime.setValue((Object)new Integer(time));
            }
            this.pkActBeginTime.setValue((Object)newValue.getPlanBeginTime());
            this.pkActEndTime.setValue((Object)newValue.getPlanEndTime());
        }
    }

    protected void initListener() {
        super.initListener();
        this.projectTaskDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProjectFeedBackEditUI.this.prmtPorjectTask_dataChanged(e);
                }
                catch (Exception exc) {
                    ProjectFeedBackEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtProjectTask.addDataChangeListener(this.projectTaskDataChanged);
        this.projectDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProjectFeedBackEditUI.this.prmtPorject_dataChanged(e);
                }
                catch (Exception exc) {
                    ProjectFeedBackEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtProject.addDataChangeListener(this.projectDataChanged);
        this.precisionChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProjectFeedBackEditUI.this.prmtUnit_dataChanged(e);
                }
                catch (Exception exc) {
                    ProjectFeedBackEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtUnit.addDataChangeListener(this.precisionChanged);
        this.pkActBeginTimeChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProjectFeedBackEditUI.this.removeListener();
                    ProjectFeedBackEditUI.this.pkActBeginTime_dataChanged(e);
                    ProjectFeedBackEditUI.this.addListener();
                }
                catch (Exception exc) {
                    ProjectFeedBackEditUI.this.handUIException(exc);
                }
            }
        };
        this.pkActBeginTime.addDataChangeListener(this.pkActBeginTimeChanged);
        this.pkActEndTimeChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProjectFeedBackEditUI.this.removeListener();
                    ProjectFeedBackEditUI.this.pkActEndTime_dataChanged(e);
                    ProjectFeedBackEditUI.this.addListener();
                }
                catch (Exception exc) {
                    ProjectFeedBackEditUI.this.handUIException(exc);
                }
            }
        };
        this.pkActEndTime.addDataChangeListener(this.pkActEndTimeChanged);
    }

    private void prmtPorject_dataChanged(DataChangeEvent e) throws Exception {
        ProjectInfo newValue;
        ProjectInfo oldValue = (ProjectInfo)e.getOldValue();
        this.newProjectInfo = newValue = (ProjectInfo)e.getNewValue();
        this.prmtProjectTask.setValue(null);
        this.txtActTotalCost.setValue(null);
        this.txtActUnitCost.setValue(null);
        this.editData.setActTotalCost(new BigDecimal(0));
        this.editData.setActUnitCost(new BigDecimal(0));
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        if (isDiffrent) {
            this.commProjectValue(newValue);
            this.pkActBeginTime.setValue((Object)newValue.getPlanBeginTime());
            this.pkActEndTime.setValue((Object)newValue.getPlanEndTime());
        }
    }

    private void prmtUnit_dataChanged(DataChangeEvent e) throws Exception {
        MeasureUnitInfo oldValue = (MeasureUnitInfo)e.getOldValue();
        MeasureUnitInfo newValue = (MeasureUnitInfo)e.getNewValue();
        int precision = 8;
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        if (isDiffrent) {
            if (newValue != null && !"".equals(newValue) && this.prmtMaterial.getData() != null) {
                precision = ProjectUtil.getPrecisionByMaterialInfo((MaterialInfo)this.prmtMaterial.getData(), newValue);
            }
            this.txtPlanQty.setPrecision(precision);
            this.txtPlanQty.setRemoveingZeroInDispaly(false);
            this.txtPlanQty.setSupportedEmpty(true);
            this.txtActQty.setPrecision(precision);
            this.txtActQty.setRemoveingZeroInDispaly(false);
            this.txtActQty.setSupportedEmpty(true);
        }
    }

    private void pkActEndTime_dataChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        Object oldValue = e.getOldValue();
        if (newValue == null || this.mmCalendarFactory == null) {
            return;
        }
        try {
            Date old = (Date)newValue;
            Date beginDate = (Date)this.pkActBeginTime.getValue();
            if (beginDate != null) {
                Date newdate = this.mmCalendarFactory.getWorkdate(old);
                this.pkActEndTime.setValue((Object)newdate);
                int time = this.mmCalendarFactory.getWorklength(beginDate, newdate);
                this.txtActUsedTime.setValue((Object)new Integer(time));
            }
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    private void pkActBeginTime_dataChanged(DataChangeEvent e) throws Exception {
        Object newValue = e.getNewValue();
        Date newDate = null;
        if (newValue == null || this.mmCalendarFactory == null) {
            return;
        }
        try {
            newDate = (Date)newValue;
            if (newDate != null) {
                Date newdate = this.mmCalendarFactory.getWorkdate(newDate);
                Date endDate = (Date)this.pkActEndTime.getValue();
                if (endDate != null) {
                    this.pkActBeginTime.setValue((Object)newdate);
                    int time = this.mmCalendarFactory.getWorklength(newdate, endDate);
                    this.txtActUsedTime.setValue((Object)new Integer(time));
                }
            }
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("project.material.*"));
        sic.add(new SelectorItemInfo("project.baseUnit.*"));
        sic.add(new SelectorItemInfo("projectTask.unit.*"));
        sic.add(new SelectorItemInfo("projectTask.material.*"));
        sic.add(new SelectorItemInfo("projectTask.material.baseUnit.*"));
        sic.add(new SelectorItemInfo("projectTask.iteratorType.*"));
        sic.add(new SelectorItemInfo("projectTask.currency.*"));
        sic.add(new SelectorItemInfo("project.currency.*"));
        sic.add(new SelectorItemInfo("project.material.baseUnit.*"));
        sic.add(new SelectorItemInfo("actUnitCost"));
        sic.add(new SelectorItemInfo("actTotalCost"));
        return sic;
    }

    private void removeListener() {
        if (this.projectTaskDataChanged != null) {
            this.prmtProjectTask.removeDataChangeListener(this.projectTaskDataChanged);
        }
        if (this.projectDataChanged != null) {
            this.prmtProject.removeDataChangeListener(this.projectDataChanged);
        }
        if (this.precisionChanged != null) {
            this.prmtUnit.removeDataChangeListener(this.precisionChanged);
        }
        if (this.precisionChanged != null) {
            this.prmtUnit.removeDataChangeListener(this.precisionChanged);
        }
        if (this.pkActBeginTimeChanged != null) {
            this.pkActBeginTime.removeDataChangeListener(this.pkActBeginTimeChanged);
        }
        if (this.pkActEndTimeChanged != null) {
            this.pkActEndTime.removeDataChangeListener(this.pkActEndTimeChanged);
        }
        if (this.qtyChanged != null) {
            this.txtActQty.removeDataChangeListener(this.qtyChanged);
        }
    }

    private void addListener() {
        if (this.projectTaskDataChanged != null) {
            this.prmtProjectTask.addDataChangeListener(this.projectTaskDataChanged);
        }
        if (this.projectDataChanged != null) {
            this.prmtProject.addDataChangeListener(this.projectDataChanged);
        }
        if (this.precisionChanged != null) {
            this.prmtUnit.addDataChangeListener(this.precisionChanged);
        }
        if (this.pkActBeginTimeChanged != null) {
            this.pkActBeginTime.addDataChangeListener(this.pkActBeginTimeChanged);
        }
        if (this.pkActEndTimeChanged != null) {
            this.pkActEndTime.addDataChangeListener(this.pkActEndTimeChanged);
        }
        if (this.qtyChanged == null) {
            this.qtyChanged = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ProjectFeedBackEditUI.this.txtActTotalCost.setValue(null);
                    ProjectFeedBackEditUI.this.txtActUnitCost.setValue(null);
                    ProjectFeedBackEditUI.this.editData.setActTotalCost(new BigDecimal(0));
                    ProjectFeedBackEditUI.this.editData.setActUnitCost(new BigDecimal(0));
                }
            };
            this.txtActQty.addDataChangeListener(this.qtyChanged);
        }
    }

    private void commProjectValue(ProjectInfo projectInfo) throws Exception {
        if (projectInfo == null) {
            this.clearValue();
        } else {
            this.mmCalendarFactory = new MMProjectCalendarFactory(null, projectInfo.getId().toString());
            this.txtWBS.setText(null);
            this.prmtMaterial.setValue((Object)projectInfo.getMaterial());
            this.prmtUnit.setValue((Object)projectInfo.getBaseUnit());
            if (projectInfo.getBaseUnit() == null) {
                this.txtPlanQty.setPrecision(8);
                this.txtPlanQty.setRemoveingZeroInDispaly(false);
                this.txtPlanQty.setSupportedEmpty(true);
                this.txtActQty.setPrecision(8);
                this.txtActQty.setRemoveingZeroInDispaly(false);
                this.txtActQty.setSupportedEmpty(true);
            }
            this.prmtProcessStatus.setEnabled(false);
            this.txtPlanQty.setValue((Object)projectInfo.getQty());
            this.prmtIteratorType.setValue(null);
            this.txtWorktime.setValue((Object)projectInfo.getTotalTime());
            this.kDPlanBeginTime.setValue((Object)projectInfo.getPlanBeginTime());
            this.kDPlanEndTime.setValue((Object)projectInfo.getPlanEndTime());
            this.kDFirstBegin.setValue((Object)projectInfo.getEaristBeginTime());
            this.kDLastBegin.setValue((Object)projectInfo.getLastBeginTime());
            this.kDFirstEnd.setValue((Object)projectInfo.getEaristEndTime());
            this.kDLastEnd.setValue((Object)projectInfo.getLastEndTime());
            this.prmtCurrency.setValue((Object)projectInfo.getCurrency());
            try {
                PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId()), (String)"mm_project_feedBackCostView");
                this.txtPlanTotalCast.setValue((Object)projectInfo.getTotalCost());
                this.txtPlanUnitCost.setValue((Object)projectInfo.getUnitCost());
            }
            catch (Exception e) {
                this.txtPlanTotalCast.setValue(null);
                this.txtPlanUnitCost.setValue(null);
            }
            this.precisionControl(projectInfo);
        }
    }

    private void commPrjTaskValue(ProjectTaskInfo taskInfo) throws Exception {
        if (taskInfo == null) {
            this.clearValue();
            this.commProjectValue(this.newProjectInfo);
            this.precisionControl(this.newProjectInfo);
        } else {
            this.txtWBS.setText(taskInfo.getWbsNumber());
            this.prmtMaterial.setValue((Object)taskInfo.getMaterial());
            this.prmtUnit.setValue((Object)taskInfo.getUnit());
            if (taskInfo.getBaseUnit() == null) {
                this.txtPlanQty.setPrecision(8);
                this.txtPlanQty.setRemoveingZeroInDispaly(false);
                this.txtPlanQty.setSupportedEmpty(true);
                this.txtActQty.setPrecision(8);
                this.txtActQty.setRemoveingZeroInDispaly(false);
                this.txtActQty.setSupportedEmpty(true);
            }
            this.prmtProcessStatus.setEnabled(true);
            this.txtPlanQty.setValue((Object)taskInfo.getQty());
            this.prmtIteratorType.setValue((Object)taskInfo.getIteratorType());
            this.txtWorktime.setValue((Object)taskInfo.getTotalTime());
            this.kDPlanBeginTime.setValue((Object)taskInfo.getPlanBeginTime());
            this.kDPlanEndTime.setValue((Object)taskInfo.getPlanEndTime());
            this.kDFirstBegin.setValue((Object)taskInfo.getEaristBeginTime());
            this.kDLastBegin.setValue((Object)taskInfo.getLastBeginTime());
            this.kDFirstEnd.setValue((Object)taskInfo.getEaristEndTime());
            this.kDLastEnd.setValue((Object)taskInfo.getLastEndTime());
            this.prmtCurrency.setValue((Object)taskInfo.getCurrency());
            try {
                PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId()), (String)"mm_project_feedBackCostView");
                this.txtPlanTotalCast.setValue((Object)taskInfo.getTotalCost());
                this.txtPlanUnitCost.setValue((Object)taskInfo.getUnitCost());
            }
            catch (Exception e) {
                this.txtPlanTotalCast.setValue(null);
                this.txtPlanUnitCost.setValue(null);
            }
            this.precisionControl(taskInfo);
        }
    }

    private void clearValue() {
        this.txtWBS.setText(null);
        this.prmtMaterial.setValue(null);
        this.prmtUnit.setValue(null);
        this.txtPlanQty.setValue(null);
        this.prmtIteratorType.setValue(null);
        this.txtWorktime.setValue(null);
        this.kDPlanBeginTime.setValue(null);
        this.kDPlanEndTime.setValue(null);
        this.kDFirstBegin.setValue(null);
        this.kDLastBegin.setValue(null);
        this.kDFirstEnd.setValue(null);
        this.kDLastEnd.setValue(null);
        this.prmtCurrency.setValue(null);
        this.txtPlanTotalCast.setValue(null);
        this.txtPlanUnitCost.setValue(null);
        this.prmtProcessStatus.setValue(null);
    }

    private void precisionControl(Object obj) throws EASBizException, BOSException {
        if (obj instanceof ProjectTaskInfo) {
            if (((ProjectTaskInfo)obj).getCurrency() != null && ((ProjectTaskInfo)obj).getCurrency() != null) {
                SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)((ProjectTaskInfo)obj).getCurrency(), (KDFormattedTextField[])this.CURRENCYPRECISIONCOMPENT);
            }
        } else if (obj instanceof ProjectInfo && ((ProjectInfo)obj).getCurrency() != null && ((ProjectInfo)obj).getCurrency() != null) {
            SCMClientUtils.changeTableColPrecisionByCurrency((CurrencyInfo)((ProjectInfo)obj).getCurrency(), (KDFormattedTextField[])this.CURRENCYPRECISIONCOMPENT);
        }
    }

    private CurrencyInfo getCurrenyOrgUnitInfo(String orgUnitID) throws Exception {
        CurrencyInfo currencyInfo = null;
        currencyInfo = orgUnitID == null ? ProjectUtil.getCurrenyOrgUnitInfo(this.getDefaultMainBizOrg().getId().toString()) : ProjectUtil.getCurrenyOrgUnitInfo(orgUnitID);
        return currencyInfo;
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        ProjectFeedBackInfo task = (ProjectFeedBackInfo)newData;
        task.setAuditor(null);
        task.setLastUpdateUser(null);
        task.setAuditTime(null);
        task.setLastUpdateTime(null);
        task.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        task.setBaseStatus(MMBaseStatusEnum.ADDNEW);
        task.setActUnitCost(MMProjectFinalVariable.ZERO);
        task.setActTotalCost(MMProjectFinalVariable.ZERO);
        task.setCompletePercent(MMProjectFinalVariable.ZERO);
        try {
            task.setCreateTime(SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        if (this.getOprtState() == "ADDNEW") {
            this.menuSubmitOption.setVisible(true);
            this.chkMenuItemSubmitAndAddNew.setVisible(true);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.getOprtState() == "EDIT") {
            this.menuSubmitOption.setVisible(true);
            this.chkMenuItemSubmitAndAddNew.setVisible(true);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.unLockUI();
        }
    }
}

