/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.project.client.AbstractProjectFeedBackFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ProjectFeedBackFilterUI
extends AbstractProjectFeedBackFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectFeedBackFilterUI.class);
    private CustomerParams cp = null;
    private DataChangeListener stotageDataChanged = null;

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectFeedBackResource", (String)strKey);
    }

    protected String getViewPermission() {
        if (((BOSUIContext)this.getContextObject()).get((Object)"paraCost1") != null) {
            return "mm_project_feedBackCostView";
        }
        return "mm_project_projectFeedBackView";
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (!flag) {
            return flag;
        }
        if (!(this.save.isSelected() || this.audit.isSelected() || this.submit.isSelected() || this.submitcost.isSelected())) {
            MsgBox.showInfo((String)ProjectFeedBackFilterUI.getResource("NEED_STATUS"));
            flag = false;
        }
        return flag;
    }

    private void addListener() {
        this.stotageDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    ProjectFeedBackFilterUI.this.prmtProjectF.setValue(null);
                    ProjectFeedBackFilterUI.this.prmtNumberF.setValue(null);
                    ProjectFeedBackFilterUI.this.prmtProjectTaskF.setValue(null);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.stotageDataChanged);
    }

    private void removeListener() {
        if (this.stotageDataChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.stotageDataChanged);
        }
    }

    public void onLoad() throws Exception {
        this.setIsSupportMultiOrgs(true);
        super.onLoad();
        this.initLocalF7();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "STORAGEORGUNIT_CANT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        SingleFilterElement projectName = new SingleFilterElement("project.number", (Component)this.prmtProjectF);
        elements.add((FilterElement)projectName);
        SingleFilterElement taskName = new SingleFilterElement("projectTask.number", (Component)this.prmtProjectTaskF);
        elements.add((FilterElement)taskName);
        SingleFilterElement number = new SingleFilterElement("number", (Component)this.prmtNumberF);
        elements.add((FilterElement)number);
        MMRangeFilterElement bizDate = new MMRangeFilterElement("bizDate", (Component)this.kDBizDateF, (Component)this.kDBizDateT);
        elements.add((FilterElement)bizDate);
        MMRangeFilterElement planStart = new MMRangeFilterElement("actBeginTime", (Component)this.kDActBeginTimeF, (Component)this.kDActBeginTimeT);
        planStart.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        Timestamp[] dates = SCMUtils.getDefaultDateRange((Date)SCMClientUtils.getServerDate2());
        planStart.setDefaultValue((Object)dates);
        elements.add((FilterElement)planStart);
        MMRangeFilterElement planEnd = new MMRangeFilterElement("actEndTime", (Component)this.kDActEndTimeF, (Component)this.kDActEndTimeT);
        planEnd.addVerifyItem(new VerifyItem(VerifyType.LESS_EQUAL_TYPE, SCMClientUtils.getResource((String)"CompareDate")));
        planEnd.setDefaultValue((Object)dates);
        elements.add((FilterElement)planEnd);
        bizDate.setDefaultValue((Object)dates);
        this.getFilterManager().setElement((FilterElement)elements);
        if (((BOSUIContext)this.getContextObject()).get((Object)"paraCost1") != null) {
            this.save.setSelected(false);
        } else {
            this.save.setSelected(true);
        }
        this.audit.setSelected(true);
        this.submit.setSelected(true);
        this.txtActUsedTimeF.setPrecision(0);
        this.txtActUsedTimeF.setRemoveingZeroInDispaly(false);
        this.txtActUsedTimeF.setSupportedEmpty(true);
        this.txtActUsedTimeT.setPrecision(0);
        this.txtActUsedTimeT.setRemoveingZeroInDispaly(false);
        this.txtActUsedTimeT.setSupportedEmpty(true);
        this.addListener();
    }

    public FilterInfo getFilterInfo() {
        HashSet<Integer> set = new HashSet<Integer>();
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (this.save.isSelected()) {
            set.add(new Integer(1));
        }
        if (this.audit.isSelected()) {
            set.add(new Integer(4));
        }
        if (this.submit.isSelected()) {
            set.add(new Integer(2));
        }
        if (this.submitcost.isSelected()) {
            set.add(new Integer(60));
        }
        Integer userTimeF = this.txtActUsedTimeF.getIntegerValue();
        Integer userTimeT = this.txtActUsedTimeT.getIntegerValue();
        FilterInfo filter = new FilterInfo();
        if (userTimeF != null) {
            filter.getFilterItems().add(new FilterItemInfo("actUsedTime", (Object)userTimeF, CompareType.GREATER_EQUALS));
        }
        if (userTimeT != null) {
            filter.getFilterItems().add(new FilterItemInfo("actUsedTime", (Object)userTimeT, CompareType.LESS_EQUALS));
        }
        if (set.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    protected void initLocalF7() {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProjectF, status, false, null);
        HashSet<Integer> ProjectStatus = new HashSet<Integer>();
        ProjectStatus.add(new Integer(5));
        this.f7Manager.registerContextChangeF7(this.prmtProjectTaskF, "storageOrgUnit.id");
        this.f7Manager.registerContextChangeF7(this.prmtNumberF, "storageOrgUnit.id");
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.audit.isSelected()) {
                pp.addCustomerParam("baseStatusAudit", "4");
            }
            if (this.save.isSelected()) {
                pp.addCustomerParam("baseStatusSave", "1");
            }
            if (this.submit.isSelected()) {
                pp.addCustomerParam("baseStatusSumbit", "2");
            }
            if (this.submitcost.isSelected()) {
                pp.addCustomerParam("baseStatusSumbitCost", "60");
            }
        }
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        this.audit.setSelected(false);
        this.save.setSelected(false);
        this.submit.setSelected(false);
        this.submitcost.setSelected(false);
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("baseStatusAudit") != null && this.cp.getCustomerParam("baseStatusAudit").length() > 0) {
            this.audit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSave") != null && this.cp.getCustomerParam("baseStatusSave").length() > 0) {
            if (((BOSUIContext)this.getContextObject()).get((Object)"paraCost1") != null) {
                this.save.setSelected(false);
            }
            this.save.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSumbit") != null && this.cp.getCustomerParam("baseStatusSumbit").length() > 0) {
            this.submit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSumbitCost") != null && this.cp.getCustomerParam("baseStatusSumbitCost").length() > 0) {
            this.submitcost.setSelected(true);
        }
        this.addListener();
    }

    public void clear() {
        super.clear();
        this.audit.setSelected(true);
        this.save.setSelected(true);
        this.submit.setSelected(true);
        this.submitcost.setSelected(true);
    }
}

