/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.mm.project.ProjectFeedBackFactory;
import com.kingdee.eas.mm.project.ProjectGroupInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.client.AbstractProjectFeedBackListUI;
import com.kingdee.eas.mm.project.client.ProjectFeedBackEditUI;
import com.kingdee.eas.mm.project.client.ProjectFeedBackFilterUI;
import com.kingdee.eas.scm.common.client.ISCMFilter;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ProjectFeedBackListUI
extends AbstractProjectFeedBackListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectFeedBackListUI.class);
    private FilterInfo newFilter = null;
    private FilterInfo mainFilter;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.removeButton();
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.menuItemRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.actionAudit.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl F9"));
        this.menuItemAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl F9"));
        this.actionUnAudit.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("ctrl F10"));
        this.menuItemUnAudit.setAccelerator(KeyStroke.getKeyStroke("ctrl F10"));
    }

    @Override
    protected boolean isTemplate() {
        return false;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProjectFeedBackFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected String getEditUIName() {
        return ProjectFeedBackEditUI.class.getName();
    }

    protected ISCMFilter getFilterUI() throws Exception {
        return new ProjectFeedBackFilterUI();
    }

    protected String getViewPermissionItem() {
        return "mm_project_projectFeedBackView";
    }

    protected void initBatchInterface() {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ProjectFeedBackFactory.class);
        this.getTableSelectionHelper().setTableProperty((CoreBillListUI)this, this.mainQueryPK, this.tblMain, "id", null, "number", null, "storageOrgUnit.id");
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            int precision = (Integer)row.getCell("currency.precision").getValue();
            SCMClientUtils.changeTableColPrecision((int)precision, (KDTable)this.tblMain, (String[])new String[]{"actUnitCost", "actTotalCost"}, (int)i);
            try {
                PermissionHelper.checkFunctionPermission((IObjectPK)this.getUserPk(), (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)row.getCell("storageOrgUnit.id").getValue().toString())), (String)"mm_project_feedBackCostView");
                continue;
            }
            catch (Exception ee) {
                row.getCell("actUnitCost").setValue(null);
                row.getCell("actTotalCost").setValue(null);
            }
        }
    }

    protected void execQuery() {
        if (this.newFilter == null || !this.mainQuery.getFilter().equals((Object)this.newFilter)) {
            this.newFilter = new FilterInfo();
            FilterInfo mainFilter = this.mainQuery.getFilter();
            FilterItemInfo projectInfo = null;
            FilterItemInfo taskInfo = null;
            StringBuffer mask = new StringBuffer();
            int size = 0;
            for (int i = 0; i < mainFilter.getFilterItems().size(); ++i) {
                if (mainFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("project.number")) {
                    projectInfo = mainFilter.getFilterItems().get(i);
                    continue;
                }
                if (mainFilter.getFilterItems().get(i).getPropertyName().equalsIgnoreCase("projectTask.number")) {
                    taskInfo = mainFilter.getFilterItems().get(i);
                    continue;
                }
                size = this.newFilter.getFilterItems().size();
                if (this.newFilter.getFilterItems().size() == 0) {
                    mask.append("(#" + size);
                } else {
                    mask.append(" and #" + size);
                }
                this.newFilter.getFilterItems().add(mainFilter.getFilterItems().get(i));
            }
            mask.append(")");
            if (projectInfo != null) {
                this.newFilter.getFilterItems().add(projectInfo);
            }
            if (taskInfo != null) {
                this.newFilter.getFilterItems().add(taskInfo);
            }
            if (this.newFilter.getFilterItems().size() - size == 4) {
                mask.append(" and (#" + (size + 1) + " and #" + (size + 2) + " or #" + (size + 3) + ")");
            } else if (this.newFilter.getFilterItems().size() - size == 3) {
                mask.append(" and (#" + (size + 1) + " and #" + (size + 2) + ")");
            } else if (this.newFilter.getFilterItems().size() - size == 2) {
                mask.append(" and (#" + (size + 1) + ")");
            }
            this.newFilter.setMaskString(mask.toString());
            this.mainQuery.setFilter(this.newFilter);
        }
        super.execQuery();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("isFromTask") != null && this.getUIContext().get("isFromTask").equals("true")) {
            String task = (String)this.getUIContext().get("task");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectTask.id", (Object)task, CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            this.mainQuery = this.getEntityViewInfo(viewInfo);
            this.handleDynamicQuery(Util.getDynSelector((EntityViewInfo)this.mainQuery));
            String[] showFields = this.getQueryShowField();
            if (showFields != null) {
                IColumn col;
                int j;
                for (j = 0; j < this.tblMain.getColumnCount(); ++j) {
                    col = this.tblMain.getColumn(j);
                    col.getStyleAttributes().setHided(true);
                }
                for (j = 0; j < this.getQueryShowField().length; ++j) {
                    col = this.tblMain.getColumn(this.getQueryShowField()[j]);
                    if (col == null) continue;
                    col.getStyleAttributes().setHided(false);
                }
            }
            this.tblMain.removeRows(false);
            this.refreshList();
            this.getUIContext().remove("isFromTask");
        } else {
            super.actionQuery_actionPerformed(e);
        }
        this.mainFilter = this.mainQuery.getFilter();
    }

    @Override
    public void selectedProject(ProjectInfo project) {
        FilterInfo filter = (FilterInfo)this.mainQuery.getFilter().clone();
        boolean isHasProject = false;
        int len = filter.getFilterItems().size();
        for (int i = 0; i < len; ++i) {
            FilterItemInfo info = filter.getFilterItems().get(i);
            String pname = info.getPropertyName();
            if (!pname.equalsIgnoreCase("project.id")) continue;
            filter.getFilterItems().get(i).setCompareValue((Object)project.getId().toString());
            filter.getFilterItems().get(i).setCompareType(CompareType.EQUALS);
            isHasProject = true;
            break;
        }
        if (!isHasProject) {
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)project.getId().toString(), CompareType.EQUALS));
        }
        try {
            this.mainQuery.setFilter(filter);
            this.refreshList();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public void selectedGroup(ProjectGroupInfo projectGroup) {
        FilterInfo filter = (FilterInfo)this.mainQuery.getFilter().clone();
        boolean isHasProject = false;
        if (projectGroup.getParent() == null) {
            filter = this.mainFilter;
        } else {
            StringBuffer projectSql = new StringBuffer();
            projectSql.append("select FID from T_MM_Project where FGROUPID in ");
            projectSql.append("(select FID from T_MM_ProjectGroup where FPARENTID = '");
            projectSql.append(projectGroup.getId().toString());
            projectSql.append("') ");
            projectSql.append("or  FGROUPID = '");
            projectSql.append(projectGroup.getId().toString());
            projectSql.append("' ");
            int len = filter.getFilterItems().size();
            for (int i = 0; i < len; ++i) {
                FilterItemInfo info = filter.getFilterItems().get(i);
                String pname = info.getPropertyName();
                if (!pname.equalsIgnoreCase("project.id")) continue;
                filter.getFilterItems().get(i).setCompareValue((Object)projectSql.toString());
                filter.getFilterItems().get(i).setCompareType(CompareType.INNER);
                isHasProject = true;
                break;
            }
            if (!isHasProject) {
                filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectSql.toString(), CompareType.INNER));
            }
        }
        try {
            this.mainQuery.setFilter(filter);
            this.refreshList();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }
}

