/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.project.client.AbstractProjectFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ProjectFilterUI
extends AbstractProjectFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectFilterUI.class);
    private CustomerParams cp = null;
    private boolean isMode = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getViewPermission() {
        return "mm_project_view";
    }

    public void onLoad() throws Exception {
        String type = (String)((BOSUIContext)this.getContextObject()).get((Object)"IsProjectType");
        super.onLoad();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ProjectFilterUI.getResource("MUST_IS_BILU")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        SingleFilterElement proNumber = new SingleFilterElement("number", (Component)this.projectNumber);
        elements.add((FilterElement)proNumber);
        SingleFilterElement materialnumber = new SingleFilterElement("material.number", (Component)this.prmtMaterial);
        elements.add((FilterElement)materialnumber);
        SingleFilterElement adminOrgUnitname = new SingleFilterElement("adminOrgUnit.number", (Component)this.prmtAdminOrgUnit);
        elements.add((FilterElement)adminOrgUnitname);
        SingleFilterElement personname = new SingleFilterElement("person.number", (Component)this.prmtPerson);
        elements.add((FilterElement)personname);
        Timestamp[] dates = SCMUtils.getDefaultDateRange((Date)SCMClientUtils.getServerDate2());
        MMRangeFilterElement planBeganTimeData = new MMRangeFilterElement("planBeginTime", (Component)this.planbeganDate, (Component)this.planbeganDateTo);
        planBeganTimeData.setDefaultValue((Object)dates);
        elements.add((FilterElement)planBeganTimeData);
        MMRangeFilterElement planEndTimeData = new MMRangeFilterElement("planEndTime", (Component)this.endDate, (Component)this.endDateTo);
        planEndTimeData.setDefaultValue((Object)dates);
        elements.add((FilterElement)planEndTimeData);
        this.getFilterManager().setElement((FilterElement)elements);
        this.setIsModeValue(type);
        this.initNeedMainOrgF7s();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        HashSet<Integer> set = new HashSet<Integer>();
        String projectTextName = this.projectName.getText();
        if (this.CheckBoxSave.isSelected()) {
            set.add(new Integer(1));
        }
        if (this.CheckBoxAudit.isSelected()) {
            set.add(new Integer(4));
        }
        if (this.CheckBoxForbit.isSelected()) {
            set.add(new Integer(50));
        }
        if (this.CheckSumbit.isSelected()) {
            set.add(new Integer(2));
        }
        if (this.closeCheckBox.isSelected()) {
            set.add(new Integer(7));
        }
        if (set.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + projectTextName + "%"), CompareType.LIKE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return filterInfo;
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (!flag) {
            return flag;
        }
        if (!(this.CheckBoxSave.isSelected() || this.CheckBoxAudit.isSelected() || this.CheckBoxForbit.isSelected() || this.CheckSumbit.isSelected() || this.closeCheckBox.isSelected())) {
            MsgBox.showInfo((String)ProjectFilterUI.getResource("NEED_STATUS"));
            flag = false;
        }
        return flag;
    }

    protected void initNeedMainOrgF7s() {
        this.projectNumber.setEnabledMultiSelection(true);
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.projectNumber, null, this.isMode, null);
        ProjectUtil.setMaterialF74CU(this.prmtStorageOrgUnit, this.prmtMaterial, this.f7Manager.getF7DisplayMode(), (Object)this, true);
        this.f7Manager.registerContextChangeF7(this.projectNumber, "storageOrgUnit.id");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtAdminOrgUnit, this.prmtPerson});
        this.setBizOrgF7ByType(this.prmtAdminOrgUnit, OrgType.Admin, this.getMainBizOrgType(), true);
        ProjectUtil.setPersonF7(this.prmtAdminOrgUnit, this.prmtPerson);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        String projectTextName = this.projectName.getText();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.CheckBoxAudit.isSelected()) {
                pp.addCustomerParam("baseStatusAudit", "4");
            }
            if (this.CheckBoxSave.isSelected()) {
                pp.addCustomerParam("baseStatusSave", "1");
            }
            if (this.CheckSumbit.isSelected()) {
                pp.addCustomerParam("baseStatusSumbit", "2");
            }
            if (this.CheckBoxForbit.isSelected()) {
                pp.addCustomerParam("baseStatusForbit", "50");
            }
            if (this.closeCheckBox.isSelected()) {
                pp.addCustomerParam("baseStatusClose", "7");
            }
            if (projectTextName != null && projectTextName.length() > 0) {
                pp.addCustomerParam("name", projectTextName);
            }
        }
        return pp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.CheckBoxAudit.setSelected(false);
        this.CheckBoxSave.setSelected(false);
        this.CheckSumbit.setSelected(false);
        this.CheckBoxForbit.setSelected(false);
        this.closeCheckBox.setSelected(false);
        this.projectName.setText("");
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("baseStatusAudit") != null && this.cp.getCustomerParam("baseStatusAudit").length() > 0) {
            this.CheckBoxAudit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSave") != null && this.cp.getCustomerParam("baseStatusSave").length() > 0) {
            this.CheckBoxSave.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSumbit") != null && this.cp.getCustomerParam("baseStatusSumbit").length() > 0) {
            this.CheckSumbit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusForbit") != null && this.cp.getCustomerParam("baseStatusForbit").length() > 0) {
            this.CheckBoxForbit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusClose") != null && this.cp.getCustomerParam("baseStatusClose").length() > 0) {
            this.closeCheckBox.setSelected(true);
        }
        if (this.cp.getCustomerParam("name") != null && this.cp.getCustomerParam("name").length() > 0) {
            this.projectName.setText(this.cp.getCustomerParam("name"));
        }
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectResource", (String)strKey);
    }

    public void clear() {
        super.clear();
        this.CheckBoxAudit.setSelected(true);
        this.CheckBoxSave.setSelected(true);
        this.CheckSumbit.setSelected(true);
        this.CheckBoxForbit.setSelected(true);
        this.closeCheckBox.setSelected(true);
        this.projectName.setText("");
    }

    private void setIsModeValue(String type) {
        if (type.equals("true")) {
            this.isMode = true;
        }
        if (type.equals("false")) {
            this.isMode = false;
        }
    }
}

