/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.project.DictDataTypeEnum;
import com.kingdee.eas.mm.project.ProjectDictDataFactory;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectProblemFactory;
import com.kingdee.eas.mm.project.ProjectProblemInfo;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.RiskLevelEnum;
import com.kingdee.eas.mm.project.client.AbstractProjectProblemEditUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.util.DictDataControlUtil;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ProjectProblemEditUI
extends AbstractProjectProblemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectProblemEditUI.class);
    private DataChangeListener projectTaskDataChanged = null;
    private DataChangeListener projectDataChanged = null;

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        try {
            if (chgVo.isDiffrent() && !this.isFirstOnload()) {
                if (chgVo.getNewOrg() != null) {
                    OrgUnitInfo orgUnitInfo = (OrgUnitInfo)chgVo.getNewOrg();
                    ProjectProblemInfo problemInfo = new ProjectProblemInfo();
                    problemInfo.setStorageOrgUnit((StorageOrgUnitInfo)chgVo.getNewOrg());
                    this.initNeedMainOrgF7s();
                    problemInfo.setNumber(this.txtNumber.getText());
                    this.setDataObject((IObjectValue)problemInfo);
                    ProjectDictDataInfo pddInfo = ProjectDictDataFactory.getRemoteInstance().getProjectDictDataInfo((IObjectPK)new ObjectUuidPK("nHKc52ABSw2L60vTIRmuAZpMH64="));
                    if (pddInfo != null) {
                        problemInfo.setRiskType(pddInfo);
                    }
                    problemInfo.setUrgent(RiskLevelEnum.CRITICAL);
                    this.prmtProject.setValue(null);
                    this.prmtProjectTask.setValue(null);
                    this.txtWBS.setText(null);
                    this.prmtMaterial.setValue(null);
                    this.kdcTaskType.setSelectedIndex(-1);
                    this.prmtAdminOrgUnit.setValue(null);
                    this.prmtPerson.setValue(null);
                    this.chkIsMileStone.setSelected(false);
                } else {
                    String msg = ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "STORAGEORGUNIT_CANT_NULL");
                    MsgBox.showInfo((String)msg);
                    this.prmtStorageOrgUnit.setValue(chgVo.getOldOrg());
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected IObjectValue createNewData() {
        ProjectProblemInfo objectValue = null;
        try {
            objectValue = new ProjectProblemInfo();
            objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
            ProjectDictDataInfo pddInfo = ProjectDictDataFactory.getRemoteInstance().getProjectDictDataInfo((IObjectPK)new ObjectUuidPK("nHKc52ABSw2L60vTIRmuAZpMH64="));
            objectValue.setRiskType(pddInfo);
            objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            objectValue.setCreateTime(SCMClientUtils.getServerDate());
            objectValue.setUrgent(RiskLevelEnum.CRITICAL);
            objectValue.setBizDate(SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtMaterial.setValue(null);
        return objectValue;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ProjectProblemFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected KDTextField getNumTextField() {
        return this.txtNumber;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_project_projectProblemAddnew";
        }
        if ("EDIT".equals(status)) {
            return "mm_project_projectProblemModify";
        }
        if ("VIEW".equals(status)) {
            return "mm_project_projectProblemView";
        }
        return null;
    }

    public String getProblemResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectProblemResource", (String)strKey);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("project.person.name"));
        sic.add(new SelectorItemInfo("project.person.id"));
        sic.add(new SelectorItemInfo("project.material.name"));
        sic.add(new SelectorItemInfo("project.material.id"));
        sic.add(new SelectorItemInfo("project.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("project.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("projectTask.*"));
        sic.add(new SelectorItemInfo("projectTask.taskType.*"));
        sic.add(new SelectorItemInfo("projectTask.person.name"));
        sic.add(new SelectorItemInfo("projectTask.person.id"));
        sic.add(new SelectorItemInfo("projectTask.material.name"));
        sic.add(new SelectorItemInfo("projectTask.material.id"));
        sic.add(new SelectorItemInfo("projectTask.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("projectTask.adminOrgUnit.id"));
        return sic;
    }

    protected int getShowMessagePolicy() {
        return 2;
    }

    protected void initBatchInterface() {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, ProjectProblemFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, null, "id", this.txtNumber, null);
    }

    protected void initNeedMainOrgF7s() {
        SelectorItemCollection projectSelector = new SelectorItemCollection();
        SelectorItemCollection taskSelector = new SelectorItemCollection();
        projectSelector.add(new SelectorItemInfo("*"));
        projectSelector.add(new SelectorItemInfo("material.name"));
        projectSelector.add(new SelectorItemInfo("person.name"));
        projectSelector.add(new SelectorItemInfo("adminOrgUnit.name"));
        taskSelector.add(new SelectorItemInfo("*"));
        taskSelector.add(new SelectorItemInfo("material.name"));
        taskSelector.add(new SelectorItemInfo("person.name"));
        taskSelector.add(new SelectorItemInfo("adminOrgUnit.name"));
        taskSelector.add(new SelectorItemInfo("taskType.*"));
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProject, status, false, projectSelector);
        HashSet<Integer> taskStatus = new HashSet<Integer>();
        taskStatus.add(new Integer(5));
        ProjectUtil.setProjectTaskF7(this.prmtStorageOrgUnit, this.prmtProject, null, this.prmtProjectTask, taskStatus, taskSelector);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtProject, this.prmtProjectTask});
    }

    private void initOwnWorkButton() {
        this.removeButton();
        this.btnPrint.setVisible(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setVisible(true);
        this.menuItemPrint.setVisible(true);
        this.menuItemPrintPreview.setVisible(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.menuItemCancel.setVisible(true);
        this.menuItemCancelCancel.setVisible(true);
    }

    protected void initListener() {
        super.initListener();
        this.projectDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProjectProblemEditUI.this.prmtProject_dataChanged(e);
                }
                catch (Exception exc) {
                    ProjectProblemEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtProject.addDataChangeListener(this.projectDataChanged);
        this.projectTaskDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ProjectProblemEditUI.this.prmtProjectTask_dataChanged(e);
                }
                catch (Exception exc) {
                    ProjectProblemEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtProjectTask.addDataChangeListener(this.projectTaskDataChanged);
    }

    @Override
    public void loadFields() {
        try {
            DictDataControlUtil.registControl(new KDComboBox[]{this.kdcTaskType}, new DictDataTypeEnum[]{DictDataTypeEnum.TASKTYPE});
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        this.kdcTaskType.setSelectedIndex(-1);
        this.removeListener();
        if (this.editData != null) {
            if (this.editData.getProjectTask() != null) {
                this.setValue((IObjectValue)this.editData.getProjectTask());
            } else if (this.editData.getProject() != null) {
                this.setValue((IObjectValue)this.editData.getProject());
            }
        }
        super.loadFields();
        this.addListener();
    }

    private void addListener() {
        this.prmtProject.addDataChangeListener(this.projectDataChanged);
        this.prmtProjectTask.addDataChangeListener(this.projectTaskDataChanged);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setMainStatusBar(MainStatusBar.getMainStatusBar());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("DictDataTypeEnum", (Object)new Integer(40), CompareType.EQUALS));
        ev.setFilter(filter);
        this.prmtRiskType.setEntityViewInfo(ev);
        this.actionSubmit.setVisible(false);
        this.actionSubmitOption.setVisible(false);
        this.initOwnWorkButton();
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setEnabled(false);
        this.actionPrintPreview.setEnabled(false);
        this.txtContent.setMaxLength(250);
        this.actionCancel.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("shift F8"));
        this.menuItemCancel.setAccelerator(KeyStroke.getKeyStroke("shift F8"));
        this.actionCancelCancel.putValue("AcceleratorKey", (Object)KeyStroke.getKeyStroke("shift F9"));
        this.menuItemCancelCancel.setAccelerator(KeyStroke.getKeyStroke("shift F9"));
    }

    private void prmtProjectTask_dataChanged(DataChangeEvent e) {
        ProjectTaskInfo newValue;
        ProjectTaskInfo oldValue = (ProjectTaskInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (ProjectTaskInfo)e.getNewValue()));
        if (isDiffrent && newValue != null) {
            ProjectTaskInfo ptInfo = (ProjectTaskInfo)this.prmtProjectTask.getData();
            this.setValue((IObjectValue)newValue);
        }
    }

    public void removeListener() {
        if (this.projectTaskDataChanged != null) {
            this.prmtProjectTask.removeDataChangeListener(this.projectTaskDataChanged);
        }
        if (this.projectDataChanged != null) {
            this.prmtProject.removeDataChangeListener(this.projectDataChanged);
        }
    }

    private void prmtProject_dataChanged(DataChangeEvent e) {
        ProjectInfo newValue;
        ProjectInfo oldValue = (ProjectInfo)e.getOldValue();
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (ProjectInfo)e.getNewValue()));
        if (isDifferent && newValue != null) {
            this.setValue((IObjectValue)newValue);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        ProjectProblemInfo task = (ProjectProblemInfo)newData;
        task.setAuditor(null);
        task.setLastUpdateUser(null);
        task.setAuditTime(null);
        task.setLastUpdateTime(null);
        task.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        task.setBaseStatus(MMBaseStatusEnum.ADDNEW);
        task.setBizDate(new Date());
        try {
            task.setCreateTime(SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setValue(IObjectValue info) {
        if (info instanceof ProjectInfo) {
            this.txtWBS.setText(null);
            this.prmtProjectTask.setValue(null);
            this.prmtPerson.setValue((Object)((ProjectInfo)info).getPerson());
            this.prmtAdminOrgUnit.setValue((Object)((ProjectInfo)info).getAdminOrgUnit());
            this.prmtMaterial.setValue((Object)((ProjectInfo)info).getMaterial());
        } else if (info instanceof ProjectTaskInfo) {
            this.kdcTaskType.setSelectedItem((Object)((ProjectTaskInfo)info).getTaskType());
            this.kdcTaskType.setSelectedIndex(this.getSelectItemIndex(((ProjectTaskInfo)info).getTaskType()));
            this.txtWBS.setText(((ProjectTaskInfo)info).getWbsNumber());
            this.prmtPerson.setValue((Object)((ProjectTaskInfo)info).getPerson());
            this.prmtAdminOrgUnit.setValue((Object)((ProjectTaskInfo)info).getAdminOrgUnit());
            this.prmtMaterial.setValue((Object)((ProjectTaskInfo)info).getMaterial());
            this.chkIsMileStone.setSelected(((ProjectTaskInfo)info).isIsMileStone());
        }
    }

    private int getSelectItemIndex(ProjectDictDataInfo dataInfo) {
        if (this.kdcTaskType != null && dataInfo != null) {
            for (int i = 0; i < this.kdcTaskType.getItemCount(); ++i) {
                if (SCMGroupClientUtils.isDiffrent((Object)this.kdcTaskType.getItemAt(i), (Object)dataInfo)) continue;
                return i;
            }
        }
        return -1;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.actionAudit.setEnabled(false);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.unLockUI();
        }
    }
}

