/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.mm.common.MMSingleFilterElement;
import com.kingdee.eas.mm.project.client.AbstractProjectProblemReportFilterUI;
import com.kingdee.eas.mm.project.client.ProjectProblemFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ProjectProblemReportFilterUI
extends AbstractProjectProblemReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectProblemReportFilterUI.class);
    private Timestamp[] dates = ProjectProblemReportFilterUI.getDefaultDateRange(SCMClientUtils.getServerDate2());
    private DataChangeListener stotageDataChanged = null;
    private DataChangeListener projectDataChanged = null;

    public ProjectProblemReportFilterUI() throws Exception {
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        elements.add((FilterElement)mainOrgElement);
        elements.add((FilterElement)new SingleFilterElement("bizBillNumF", (Component)this.txtNumberF));
        elements.add((FilterElement)new MMSingleFilterElement("project.numberF", (Component)this.prmtProjectF));
        elements.add((FilterElement)new MMSingleFilterElement("task.numberF", (Component)this.prmtProjectTaskF));
        SingleFilterElement dateF = new SingleFilterElement("dateF", (Component)this.queryDateF);
        dateF.setDefaultValue((Object)this.dates[0]);
        SingleFilterElement dateT = new SingleFilterElement("dateT", (Component)this.queryDateT);
        dateT.setDefaultValue((Object)this.dates[1]);
        elements.add((FilterElement)dateF);
        elements.add((FilterElement)dateT);
        SingleFilterElement normalCheckBox = new SingleFilterElement("normal", (Component)this.normal);
        this.normal.setSelected(true);
        elements.add((FilterElement)normalCheckBox);
        SingleFilterElement criticalCheckBox = new SingleFilterElement("critical", (Component)this.critical);
        this.critical.setSelected(true);
        elements.add((FilterElement)criticalCheckBox);
        SingleFilterElement dangerCheckBox = new SingleFilterElement("danger", (Component)this.danger);
        this.danger.setSelected(true);
        elements.add((FilterElement)dangerCheckBox);
        SingleFilterElement saveCheckBox = new SingleFilterElement("save", (Component)this.save);
        this.save.setSelected(true);
        elements.add((FilterElement)saveCheckBox);
        SingleFilterElement auditCheckBox = new SingleFilterElement("audit", (Component)this.audit);
        this.audit.setSelected(true);
        elements.add((FilterElement)auditCheckBox);
        SingleFilterElement forbidCheckBox = new SingleFilterElement("forbid", (Component)this.forbid);
        this.forbid.setSelected(true);
        elements.add((FilterElement)forbidCheckBox);
        this.getFilterManager().setElement((FilterElement)elements);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        super.loadData(entityViewInfo);
        this.addListener();
    }

    private void addListener() {
        this.stotageDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    ProjectProblemReportFilterUI.this.txtNumberF.setValue(null);
                    ProjectProblemReportFilterUI.this.prmtProjectF.setValue(null);
                    ProjectProblemReportFilterUI.this.prmtProjectTaskF.setValue(null);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.stotageDataChanged);
        this.projectDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    ProjectProblemReportFilterUI.this.prmtProjectTaskF.setValue(null);
                }
            }
        };
        this.prmtProjectF.addDataChangeListener(this.projectDataChanged);
    }

    private void removeListener() {
        if (this.stotageDataChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.stotageDataChanged);
        }
        if (this.projectDataChanged != null) {
            this.prmtProjectF.removeDataChangeListener(this.projectDataChanged);
        }
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    public static String getResource(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectProblemResource", (String)strKey);
    }

    protected String getViewPermission() {
        return "mm_project_reportView";
    }

    protected void initNeedMainOrgF7s() {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        status.add(new Integer(5));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProjectF, status, false, null);
        ProjectUtil.setProjectTaskF7(this.prmtStorageOrgUnit, this.prmtProjectF, null, this.prmtProjectTaskF, null, null);
        ProjectProblemFilterUI.setProjectProblemF7(this.prmtStorageOrgUnit, this.txtNumberF, null, false);
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtProjectF, this.txtNumberF});
    }

    public void onLoad() throws Exception {
        this.setIsSupportMultiOrgs(true);
        super.onLoad();
        this.initNeedMainOrgF7s();
        this.addListener();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public boolean verify() {
        boolean result = super.verify();
        ArrayList<String> keys = new ArrayList<String>();
        if (result) {
            if (this.queryDateF.getValue() == null || this.queryDateT.getValue() == null) {
                keys.add("DATEISNULL");
            }
            if (this.queryDateF.getValue() != null && this.queryDateT.getValue() != null && ((Date)this.queryDateT.getValue()).getTime() < ((Date)this.queryDateF.getValue()).getTime()) {
                keys.add("periodDate");
            }
            if (this.prmtStorageOrgUnit.getValue() == null) {
                keys.add("STORAGEORG_ISNULL");
            }
            if (this.prmtProjectF.getText() == null || "".equals(this.prmtProjectF.getText())) {
                keys.add("PROJECT_NUMBER_NOT_NULL");
            }
            if (!(this.normal.isSelected() || this.critical.isSelected() || this.danger.isSelected())) {
                keys.add("URGENTISNULL");
            }
            if (!(this.save.isSelected() || this.audit.isSelected() || this.forbid.isSelected())) {
                keys.add("BILLISNULL");
            }
            if (keys.size() > 0) {
                StringBuffer note = new StringBuffer();
                for (int i = 0; i < keys.size(); ++i) {
                    note.append(ProjectProblemReportFilterUI.getResource(keys.get(i).toString()));
                    note.append("\n");
                }
                MsgBox.showInfo((String)note.toString());
                return false;
            }
        }
        return result;
    }
}

