/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.BOSUIContext;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.mm.common.client.MMRangeFilterElement;
import com.kingdee.eas.mm.project.client.AbstractProjectTaskFilterUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.filter.CompositeFilterElement;
import com.kingdee.eas.scm.common.filter.FilterElement;
import com.kingdee.eas.scm.common.filter.SingleFilterElement;
import com.kingdee.eas.scm.common.verify.VerifyItem;
import com.kingdee.eas.scm.common.verify.VerifyType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProjectTaskFilterUI
extends AbstractProjectTaskFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectTaskFilterUI.class);
    private boolean isTemplate = false;
    private CustomerParams cp = null;
    private Set statuses = new HashSet();
    private DataChangeListener stotageDataChanged = null;
    private DataChangeListener projectDataChanged = null;

    public void onLoad() throws Exception {
        Boolean isTemplate = (Boolean)((BOSUIContext)this.getContextObject()).get((Object)"isTemplate");
        this.isTemplate = isTemplate;
        this.setIsSupportMultiOrgs(true);
        super.onLoad();
        this.initOwnF7();
        CompositeFilterElement elements = new CompositeFilterElement(0);
        SingleFilterElement mainOrgElement = new SingleFilterElement("storageOrgUnit.number", (Component)this.prmtStorageOrgUnit);
        mainOrgElement.addVerifyItem(new VerifyItem(VerifyType.REQUIRED_TYPE, ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "STORAGEORGUNIT_CANT_NULL")));
        elements.add((FilterElement)mainOrgElement);
        this.getFilterManager().setMainOrgElement((FilterElement)mainOrgElement, this.getPropertyOfMainBizOrg());
        SingleFilterElement createOrgElement = new SingleFilterElement("createOrgUnit.number", (Component)this.prmtCreateOrgUnit);
        elements.add((FilterElement)createOrgElement);
        SingleFilterElement taskType = new SingleFilterElement("taskType.number", (Component)this.prmtTaskType);
        elements.add((FilterElement)taskType);
        SingleFilterElement projectName = new SingleFilterElement("project.number", (Component)this.prmtProjectFrom);
        elements.add((FilterElement)projectName);
        SingleFilterElement taskTemplate = new SingleFilterElement("taskTemplate.number", (Component)this.prmtTaskTemplateFrom);
        elements.add((FilterElement)taskTemplate);
        SingleFilterElement taskName = new SingleFilterElement("number", (Component)this.prmtTaskFrom);
        elements.add((FilterElement)taskName);
        SingleFilterElement materialnumber = new SingleFilterElement("material.number", (Component)this.prmtMaterialFrom);
        elements.add((FilterElement)materialnumber);
        SingleFilterElement adminOrgUnitname = new SingleFilterElement("adminOrgUnit.number", (Component)this.prmtAdminOrgUnitFrom);
        elements.add((FilterElement)adminOrgUnitname);
        MMRangeFilterElement planStart = new MMRangeFilterElement("planBeginTime", (Component)this.dpPlanStartFrom, (Component)this.dpPlanStartTo);
        elements.add((FilterElement)planStart);
        MMRangeFilterElement planEnd = new MMRangeFilterElement("planEndTime", (Component)this.dpPlanEndFrom, (Component)this.dpPlanEndTo);
        elements.add((FilterElement)planEnd);
        this.getFilterManager().setElement((FilterElement)elements);
        this.cbSave.setSelected(true);
        this.cbAudit.setSelected(true);
        this.cbSubmit.setSelected(true);
        this.cbCostSubmit.setSelected(true);
        this.cbResleased.setSelected(true);
        this.cbClose.setSelected(true);
        this.initNeedMainOrgF7s();
        this.addListener();
    }

    protected void initNeedMainOrgF7s() {
        this.setBizOrgF7ByType(this.prmtAdminOrgUnitFrom, OrgType.Admin, this.getMainBizOrgType(), true);
        ProjectUtil.setMaterialF74ETO10ByStorageOrgUnit(this.prmtStorageOrgUnit, this.prmtMaterialFrom, this.f7Manager.getF7DisplayMode(), (Object)this, true);
        this.f7Manager.registerContextChangeF7(this.prmtTaskTemplateFrom, "storageOrgUnit.id");
    }

    private void initOwnF7() {
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(1));
        status.add(new Integer(2));
        status.add(new Integer(5));
        status.add(new Integer(60));
        status.add(new Integer(4));
        status.add(new Integer(7));
        this.prmtProjectFrom.setEnabledMultiSelection(true);
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProjectFrom, status, this.isTemplate, null);
        ProjectTaskFilterUI.setTasktemplateF7(this.prmtStorageOrgUnit, this.prmtTaskTemplateFrom, status);
        this.prmtCreateOrgUnit.setEnabledMultiSelection(true);
        this.prmtTaskType.setEnabledMultiSelection(true);
        this.setTaskF7(this.prmtTaskFrom, this.isTemplate);
    }

    public static void setTasktemplateF7(final KDBizPromptBox storageOrgUnitBox, final KDBizPromptBox taskTemplate, final HashSet status) {
        taskTemplate.setQueryInfo("com.kingdee.eas.mm.project.app.F7TaskTemplateQuery");
        taskTemplate.setEnabledMultiSelection(true);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        taskTemplate.setSelectorCollection(selectors);
        taskTemplate.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                taskTemplate.setEntityViewInfo(ProjectTaskFilterUI.getTasktemplateF7EntityView(storageOrgUnitBox, status));
                taskTemplate.getQueryAgent().resetRuntimeEntityView();
            }
        });
        taskTemplate.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                taskTemplate.setEntityViewInfo(ProjectTaskFilterUI.getTasktemplateF7EntityView(storageOrgUnitBox, status));
                taskTemplate.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    public static EntityViewInfo getTasktemplateF7EntityView(KDBizPromptBox storageOrgUnitBox, HashSet status) {
        Object[] objects;
        Object mainOrg = storageOrgUnitBox.getData();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (mainOrg == null) {
            keys.add("null");
        } else if (mainOrg != null && mainOrg instanceof OrgUnitInfo) {
            keys.add(((OrgUnitInfo)mainOrg).getId().toString());
        } else if (mainOrg instanceof Object[] && (objects = (Object[])mainOrg).length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)objects[i];
                keys.add(orgInfo.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)status, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private void setTaskF7(final KDBizPromptBox prmtTask, boolean isTemplate) {
        prmtTask.setQueryInfo("com.kingdee.eas.mm.project.app.F7ProjectTaskQuery");
        prmtTask.setEnabledMultiSelection(true);
        prmtTask.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent paramCommitEvent) {
                prmtTask.setEntityViewInfo(ProjectTaskFilterUI.this.getTaskEntityViewInfo(ProjectTaskFilterUI.this.prmtStorageOrgUnit));
                prmtTask.getQueryAgent().resetRuntimeEntityView();
            }
        });
        prmtTask.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                prmtTask.setEntityViewInfo(ProjectTaskFilterUI.this.getTaskEntityViewInfo(ProjectTaskFilterUI.this.prmtStorageOrgUnit));
                prmtTask.getQueryAgent().resetRuntimeEntityView();
            }
        });
    }

    private EntityViewInfo getTaskEntityViewInfo(KDBizPromptBox storageOrgUnitBox) {
        Object[] objects;
        Object mainOrg = storageOrgUnitBox.getData();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (mainOrg == null) {
            keys.add("null");
        } else if (mainOrg != null && mainOrg instanceof OrgUnitInfo) {
            keys.add(((OrgUnitInfo)mainOrg).getId().toString());
        } else if (mainOrg instanceof Object[] && (objects = (Object[])mainOrg).length > 0) {
            for (int i = 0; i < objects.length; ++i) {
                OrgUnitInfo orgInfo = (OrgUnitInfo)objects[i];
                keys.add(orgInfo.getId().toString());
            }
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)new Boolean(this.isTemplate)));
        filterInfo.getFilterItems().add(new FilterItemInfo("wbsNumber", null, CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    protected void setCreateOrgUnitF7(KDBizPromptBox bizOrgUnitBox, OrgType orgType) {
        bizOrgUnitBox.setEnabledMultiSelection(true);
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(orgType);
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = super.getFilterInfo();
        if (filterInfo == null) {
            return filterInfo;
        }
        if (this.statuses.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)this.statuses, CompareType.INCLUDE));
            try {
                filterInfo.mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        FilterInfo filterTemp = new FilterInfo();
        try {
            filterInfo.mergeFilter(filterTemp, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        logger.debug((Object)("Mandy: " + filterInfo));
        logger.error((Object)("Mandy: " + filterInfo));
        return filterInfo;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.prmtStorageOrgUnit;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        this.cp = cp;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams pp = super.getCustomerParams();
        if (this.prmtStorageOrgUnit.getValue() != null) {
            if (this.cbAudit.isSelected()) {
                pp.addCustomerParam("baseStatusAudit", "4");
            }
            if (this.cbSave.isSelected()) {
                pp.addCustomerParam("baseStatusSave", "1");
            }
            if (this.cbSubmit.isSelected()) {
                pp.addCustomerParam("baseStatusSumbit", "2");
            }
            if (this.cbCostSubmit.isSelected()) {
                pp.addCustomerParam("baseStatusCostSubmit", "60");
            }
            if (this.cbClose.isSelected()) {
                pp.addCustomerParam("baseStatusClose", "7");
            }
            if (this.cbResleased.isSelected()) {
                pp.addCustomerParam("baseStatusResleased", "5");
            }
        }
        return pp;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.removeListener();
        this.cbResleased.setSelected(false);
        this.cbClose.setSelected(false);
        this.cbCostSubmit.setSelected(false);
        this.cbSubmit.setSelected(false);
        this.cbSave.setSelected(false);
        this.cbAudit.setSelected(false);
        super.loadData(entityViewInfo);
        if (this.cp.getCustomerParam("baseStatusAudit") != null && this.cp.getCustomerParam("baseStatusAudit").length() > 0) {
            this.cbAudit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSave") != null && this.cp.getCustomerParam("baseStatusSave").length() > 0) {
            this.cbSave.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusSumbit") != null && this.cp.getCustomerParam("baseStatusSumbit").length() > 0) {
            this.cbSubmit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusCostSubmit") != null && this.cp.getCustomerParam("baseStatusCostSubmit").length() > 0) {
            this.cbCostSubmit.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusClose") != null && this.cp.getCustomerParam("baseStatusClose").length() > 0) {
            this.cbClose.setSelected(true);
        }
        if (this.cp.getCustomerParam("baseStatusResleased") != null && this.cp.getCustomerParam("baseStatusResleased").length() > 0) {
            this.cbResleased.setSelected(true);
        }
        this.addListener();
    }

    public boolean verify() {
        boolean flag = super.verify();
        if (!flag) {
            return flag;
        }
        this.statuses.clear();
        if (this.cbSave.isSelected()) {
            this.statuses.add(new Integer(1));
        }
        if (this.cbAudit.isSelected()) {
            this.statuses.add(new Integer(4));
        }
        if (this.cbSubmit.isSelected()) {
            this.statuses.add(new Integer(2));
        }
        if (this.cbCostSubmit.isSelected()) {
            this.statuses.add(new Integer(60));
        }
        if (this.cbResleased.isSelected()) {
            this.statuses.add(new Integer(5));
        }
        if (this.cbClose.isSelected()) {
            this.statuses.add(new Integer(7));
        }
        if (this.statuses.size() <= 0) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "MUST_ONE_STATUS"));
            SysUtil.abort();
            return false;
        }
        return true;
    }

    protected String getViewPermission() {
        return "mm_projecttask_view";
    }

    public void clear() {
        super.clear();
        this.cbAudit.setSelected(true);
        this.cbClose.setSelected(true);
        this.cbCostSubmit.setSelected(true);
        this.cbResleased.setSelected(true);
        this.cbSave.setSelected(true);
        this.cbSubmit.setSelected(true);
    }

    protected String getPropertyOfMainBizOrg() {
        return "storageOrgUnit.id";
    }

    private void addListener() {
        this.stotageDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    ProjectTaskFilterUI.this.prmtTaskFrom.setValue(null);
                    ProjectTaskFilterUI.this.prmtTaskTemplateFrom.setValue(null);
                    ProjectTaskFilterUI.this.prmtProjectFrom.setValue(null);
                    ProjectTaskFilterUI.this.prmtMaterialFrom.setValue(null);
                    ProjectTaskFilterUI.this.prmtAdminOrgUnitFrom.setValue(null);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.stotageDataChanged);
        this.projectDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    ProjectTaskFilterUI.this.prmtTaskFrom.setValue(null);
                }
            }
        };
        this.prmtProjectFrom.addDataChangeListener(this.projectDataChanged);
    }

    private void removeListener() {
        if (this.stotageDataChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.stotageDataChanged);
        }
        if (this.projectDataChanged != null) {
            this.prmtProjectFrom.removeDataChangeListener(this.projectDataChanged);
        }
    }
}

