/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.mm.common.ICommSchedulingFacade;
import com.kingdee.eas.mm.project.MonthPlanConst;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.ProjectTaskPlanningFacadeFactory;
import com.kingdee.eas.mm.project.ProjectTaskPlanningReportUtil;
import com.kingdee.eas.mm.project.client.AbstractProjectTaskPlanningUI;
import com.kingdee.eas.mm.project.client.ProjectTaskPlanningReportFilterUI;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProjectTaskPlanningUI
extends AbstractProjectTaskPlanningUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ProjectTaskPlanningUI.class);
    private RptParams rps = new RptParams();
    private String tempTable = null;
    private ProjectTaskPlanningReportFilterUI queryPanel = null;

    public void onLoad() throws Exception {
        this.tblMain.setEditable(false);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.menuItemView.setVisible(false);
    }

    protected RptParams getParamsForInit() {
        return this.rps;
    }

    protected ICommSchedulingFacade getRemoteInstance() throws BOSException {
        return ProjectTaskPlanningFacadeFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "FTaskName";
    }

    protected String getViewPermissionItem() {
        return "mm_project_taskPlanningReportView";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected boolean checkBeforeWindowClosing() {
        boolean isClose = super.checkBeforeWindowClosing();
        if (isClose && this.tempTable != null) {
            try {
                this.getRemoteInstance().dropTempTable(this.tempTable);
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return isClose;
    }

    public void beforePrint() {
        String operName = SCMClientUtils.getResource((String)"LOG_PRINT");
        IObjectPK pk = LogUtil.beginLog(null, (String)operName, (BOSObjectType)new ProjectTaskInfo().getBOSType(), null, (String)operName);
        LogUtil.afterLog(null, (IObjectPK)pk);
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.kdlcPeroidType.getBoundLabelText());
        sb.append(" : &[period]");
        sb.append("&|");
        sb.append(this.kdlcPeroidFrom.getBoundLabelText());
        sb.append(" : &[PeroidFrom] ");
        sb.append("&|");
        sb.append(this.kdlcPeroidTo.getBoundLabelText());
        sb.append(" : &[PeroidTo] ");
        sb.append("&|");
        header.addRow(sb.toString(), sa);
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = ProjectTaskPlanningUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("period", this.txtPeroidType.getText());
        map.put("PeroidFrom", this.txtPeroidFrom.getText());
        map.put("PeroidTo", this.txtPeroidTo.getText());
        return map;
    }

    protected void query() {
        this.execQuery();
    }

    protected void execQuery() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        if (this.params == null) {
            return;
        }
        try {
            RptParams rpt;
            RptRowSet rs = null;
            if (from == 0) {
                this.rps.clear();
                this.rps.putAll(this.params.toMap());
                this.rps.setString("tempTable", this.tempTable);
                rpt = this.getRemoteInstance().createTempTable(this.rps);
                this.tempTable = rpt.getString("tempTable");
                this.setTempTable(this.tempTable);
                this.rps.setString("tempTable", this.tempTable);
                ProjectTaskPlanningReportUtil util = new ProjectTaskPlanningReportUtil(null, this.rps);
                RptTableHeader header = util.getReportHeader();
                ProjectDictDataInfo peroidType = (ProjectDictDataInfo)rpt.getObject("peroidType");
                String[] peroidRang = (String[])rpt.getObject("peroidRang");
                this.txtPeroidType.setText(peroidType.getName());
                this.txtPeroidFrom.setText(peroidRang[0]);
                this.txtPeroidTo.setText(peroidRang[1]);
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
                rpt = this.getRemoteInstance().query(rpt, 0, KDTDataRequestManager.defaultPageRow);
                rs = (RptRowSet)rpt.getObject("rowset");
            } else {
                rpt = this.getRemoteInstance().query(this.rps, from, len);
                rs = (RptRowSet)rpt.getObject("rowset");
            }
            BigDecimal qty = null;
            Date planEndDate = null;
            int precision = 0;
            ProjectTaskPlanningReportUtil util = new ProjectTaskPlanningReportUtil(null, this.params);
            Calendar beginDate = util.buildBeginTime();
            Calendar endDate = Calendar.getInstance();
            while (rs.next()) {
                IRow row = this.tblMain.addRow();
                row.getCell("FStorageName").setValue((Object)rs.getString("FStorageName"));
                row.getCell("FProjectName").setValue((Object)rs.getString("FProjectName"));
                row.getCell("FTaskType").setValue((Object)rs.getString("FTaskType"));
                row.getCell("FTaskName").setValue((Object)rs.getString("FTaskName"));
                row.getCell("FMaterialName").setValue((Object)rs.getString("FMaterialName"));
                row.getCell("FMeasureUnit").setValue((Object)rs.getString("FMeasureUnit"));
                BigDecimal milestone = rs.getBigDecimal("FMileStone");
                if (milestone.intValue() > 0) {
                    row.getCell("FMileStone").setValue((Object)new Boolean(true));
                } else {
                    row.getCell("FMileStone").setValue((Object)new Boolean(false));
                }
                qty = rs.getBigDecimal("FQty");
                planEndDate = (Date)rs.getObject("FPlanEndTime");
                precision = rs.getInt("FQtyPrecision");
                endDate.setTime(planEndDate);
                qty.setScale(precision, 4);
                int peroid = util.getCurExpectationIssue(beginDate, endDate);
                if (MonthPlanConst.ZERO.compareTo(qty) == 0) continue;
                row.getCell("FPeroid" + peroid).setValue((Object)qty);
            }
            this.tblMain.repaint();
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception e1) {
            this.handleException(e1);
        }
        this.setMergeColumn();
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys1();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                this.tblMain.getColumn(mergeColumnKeys[i]).setGroup(true);
                this.tblMain.getColumn(mergeColumnKeys[i]).setMergeable(true);
            }
        }
    }

    public String[] getMergeColumnKeys1() {
        return new String[]{"FStorageName", "FProjectName", "FTaskType", "FMaterialName", "FMeasureUnit"};
    }

    protected CustomerQueryPanel getCustomerQueryPanel() throws Exception {
        if (this.queryPanel == null) {
            this.queryPanel = new ProjectTaskPlanningReportFilterUI();
        }
        return this.queryPanel;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

