/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.ProjectTaskSyncFacadeFactory;
import com.kingdee.eas.mm.project.client.AbstractProjectTaskSyncUI;
import com.kingdee.eas.mm.project.util.MMProjectCalendarFactory;
import com.kingdee.eas.mm.project.util.MMProjectFinalVariable;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ProjectTaskSyncUI
extends AbstractProjectTaskSyncUI {
    private static final Logger logger = CoreUIObject.getLogger(ProjectTaskSyncUI.class);
    private final String TASK_NUMBER = "taskNumber";
    private final String MATERIAL = "product";
    private final String PERIOD_BEFORE_CHANGE = "periodBefore";
    private final String PERIOD_AFTER_CHANGE = "periodAfter";
    private final String BEGIN_DATE_BEFORE_CHANGE = "startBefore";
    private final String BEGIN_DATE_AFTER_CHANGE = "startAfter";
    private final String END_DATE_BEFORE_CHANGE = "endBefore";
    private final String END_DATE_AFTER_CHANGE = "endAfter";
    private ProjectTaskInfo projectTaskInfo = null;
    private String projectId = null;
    private KDTEditAdapter tblMainChange = null;
    private MMProjectCalendarFactory mmCalendarFactory = null;
    private String storageOrgUnitId = null;
    private String[][] colPaires = new String[][]{{"periodBefore", "periodAfter"}, {"startBefore", "startAfter"}, {"endBefore", "endAfter"}};
    private boolean isTableChange = false;
    private boolean isSync = false;

    public boolean isSync() {
        return this.isSync;
    }

    public void setSync(boolean isSync) {
        this.isSync = isSync;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSyncTask();
        this.initActions();
    }

    private void initSyncTask() throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        KDDatePicker dpDate = new KDDatePicker();
        String projectTaskId = (String)this.getUIContext().get("projectTaskId");
        this.projectTaskInfo = ProjectTaskFactory.getRemoteInstance().getProjectTaskInfo("select *,material.name,storageOrgUnit.id,iteratorType.id,iteratorType.number,project.totalTime,project.planBeginTime,project.planEndTime where id = '" + projectTaskId + "'");
        this.storageOrgUnitId = this.projectTaskInfo.getStorageOrgUnit().getId().toString();
        this.projectId = this.projectTaskInfo.getProject().getId().toString();
        IRow currentRow = this.tblMain.addRow();
        KDTDefaultCellEditor editorTotalTime = FormattedEditorFactory.getBigDecimalCellEditor((int)0, (boolean)false);
        this.tblMain.getColumn("periodAfter").setEditor((ICellEditor)editorTotalTime);
        this.tblMain.getColumn("startBefore").setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
        this.tblMain.getColumn("startAfter").setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
        this.tblMain.getColumn("endBefore").setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
        this.tblMain.getColumn("endAfter").setEditor((ICellEditor)new KDTDefaultCellEditor(dpDate));
        currentRow.getRowIndex();
        currentRow.getCell("taskNumber").setValue((Object)this.projectTaskInfo.getNumber());
        if (this.projectTaskInfo.getMaterial() != null) {
            currentRow.getCell("product").setValue((Object)this.projectTaskInfo.getMaterial().getName());
        }
        currentRow.getCell("periodBefore").setValue((Object)this.projectTaskInfo.getTotalTime());
        currentRow.getCell("periodAfter").setValue((Object)this.projectTaskInfo.getTotalTime());
        currentRow.getCell("startBefore").setValue((Object)this.projectTaskInfo.getPlanBeginTime());
        currentRow.getCell("startAfter").setValue((Object)this.projectTaskInfo.getPlanBeginTime());
        currentRow.getCell("endBefore").setValue((Object)this.projectTaskInfo.getPlanEndTime());
        currentRow.getCell("endAfter").setValue((Object)this.projectTaskInfo.getPlanEndTime());
        this.tblMain.getActionMap().get("Delete").setEnabled(false);
        this.tblMain.getActionMap().get("Cut").setEnabled(false);
        this.tblMain.getActionMap().get("Paste").setEnabled(false);
    }

    private void removeActions() {
        if (this.tblMainChange != null) {
            this.tblMain.removeKDTEditListener((KDTEditListener)this.tblMainChange);
        }
    }

    private void initActions() {
        if (this.tblMainChange == null) {
            this.tblMainChange = new KDTEditAdapter(){
                private Object oldValue = null;

                public void editStarting(KDTEditEvent e) {
                    try {
                        this.oldValue = ProjectTaskSyncUI.this.kdtEntries_ChangedStarting(e, ProjectTaskSyncUI.this.tblMain);
                    }
                    catch (Exception ex) {
                        ProjectTaskSyncUI.this.handUIException(ex);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        ProjectTaskSyncUI.this.removeActions();
                        ProjectTaskSyncUI.this.wbsTableChanged(e, this.oldValue);
                    }
                    catch (Exception exc) {
                        ProjectTaskSyncUI.this.handUIException(exc);
                    }
                    finally {
                        ProjectTaskSyncUI.this.initActions();
                    }
                }
            };
        }
        this.tblMain.addKDTEditListener((KDTEditListener)this.tblMainChange);
    }

    private Object kdtEntries_ChangedStarting(KDTEditEvent e, KDTable table) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object oldValue = table.getCell(rowIndex, colIndex).getValue();
        return oldValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void wbsTableChanged(KDTEditEvent e, Object oldValue) throws EASBizException, BOSException {
        int rowIndex = -1;
        int colIndex = -1;
        try {
            rowIndex = e.getRowIndex();
            colIndex = e.getColIndex();
            Object newValue = null;
            String colName = this.tblMain.getColumn(colIndex).getKey();
            if (this.mmCalendarFactory == null) {
                this.mmCalendarFactory = new MMProjectCalendarFactory(null, this.projectId);
            } else if (!this.mmCalendarFactory.getProjectId().equalsIgnoreCase(this.projectId)) {
                this.mmCalendarFactory.changeOrg(this.projectId);
            }
            newValue = e.getValue();
            if (newValue != null && newValue.toString().equals(oldValue.toString())) {
                return;
            }
            if (colName.equalsIgnoreCase("periodAfter")) {
                if (newValue == null) {
                    this.tblMain.getCell(rowIndex, "periodAfter").setValue(oldValue);
                    return;
                }
                BigDecimal newTotalTime = (BigDecimal)newValue;
                if (newTotalTime.compareTo(new BigDecimal("0.0")) == 0) {
                    this.tblMain.getCell(rowIndex, "periodAfter").setValue(oldValue);
                    return;
                }
                int changeObject = this.canChange(rowIndex, colIndex, 0);
                Timestamp timestamp = this.projectTaskInfo.getPlanBeginTime();
                Timestamp timestamp2 = this.projectTaskInfo.getPlanEndTime();
                if (timestamp == null) return;
                if (timestamp2 == null) {
                    return;
                }
                switch (changeObject) {
                    case 0: {
                        int totalTime = this.mmCalendarFactory.getWorklength(timestamp, timestamp2);
                        this.tblMain.getCell(rowIndex, "periodAfter").setValue((Object)new BigDecimal(totalTime));
                        return;
                    }
                    case 1: {
                        if (!this.mmCalendarFactory.isWorkDay(timestamp2)) {
                            MsgBox.showInfo((String)this.getResource("NOTIN_FACTORYCALENDAR"));
                            this.tblMain.getCell(rowIndex, "periodAfter").setValue(oldValue);
                            return;
                        }
                        Date date = this.mmCalendarFactory.addWroklength(timestamp2, -newTotalTime.intValue());
                        this.tblMain.getCell(rowIndex, "startAfter").setValue((Object)date);
                        return;
                    }
                    case 2: {
                        if (!this.mmCalendarFactory.isWorkDay(timestamp)) {
                            MsgBox.showInfo((String)this.getResource("NOTIN_FACTORYCALENDAR"));
                            this.tblMain.getCell(rowIndex, "periodAfter").setValue(oldValue);
                            return;
                        }
                        Date date = this.mmCalendarFactory.addWroklength(timestamp, newTotalTime.intValue());
                        this.tblMain.getCell(rowIndex, "endAfter").setValue((Object)date);
                        return;
                    }
                }
                return;
            }
            if (colName.equalsIgnoreCase("startAfter")) {
                if (newValue == null) {
                    this.tblMain.getCell(rowIndex, "startAfter").setValue(oldValue);
                    return;
                }
                Date planBeginTime = (Date)newValue;
                planBeginTime = this.mmCalendarFactory.getWorkdate(planBeginTime);
                this.tblMain.getCell(rowIndex, "startAfter").setValue((Object)planBeginTime);
                int changeObject = this.canChange(rowIndex, colIndex, 1);
                BigDecimal bigDecimal = (BigDecimal)this.tblMain.getCell(rowIndex, "periodAfter").getValue();
                Date date = (Date)this.tblMain.getCell(rowIndex, "endAfter").getValue();
                if (!this.mmCalendarFactory.isWorkDay(date)) {
                    MsgBox.showInfo((String)this.getResource("NOTIN_FACTORYCALENDAR"));
                    this.tblMain.getCell(rowIndex, "startAfter").setValue(oldValue);
                    return;
                }
                switch (changeObject) {
                    case 0: {
                        if (planBeginTime.compareTo(date) > 0) {
                            MsgBox.showInfo((String)this.getResource("PLANBEGIN_GREATER_PLANEND"));
                            this.tblMain.getCell(rowIndex, "startAfter").setValue(oldValue);
                            SysUtil.abort();
                        }
                        int total = this.mmCalendarFactory.getWorklength(planBeginTime, date);
                        this.tblMain.getCell(rowIndex, "periodAfter").setValue((Object)new BigDecimal(total));
                        return;
                    }
                    case 1: {
                        planBeginTime = this.mmCalendarFactory.addWroklength(date, -bigDecimal.intValue());
                        this.tblMain.getCell(rowIndex, "startAfter").setValue((Object)planBeginTime);
                        return;
                    }
                    case 2: {
                        Date date2 = this.mmCalendarFactory.addWroklength(planBeginTime, bigDecimal.intValue());
                        this.tblMain.getCell(rowIndex, "endAfter").setValue((Object)date2);
                        return;
                    }
                }
                return;
            }
            if (!colName.equalsIgnoreCase("endAfter")) return;
            if (newValue == null) {
                this.tblMain.getCell(rowIndex, "endAfter").setValue(oldValue);
                return;
            }
            Date planEndTime = (Date)newValue;
            planEndTime = this.mmCalendarFactory.getWorkdate(planEndTime);
            this.tblMain.getCell(rowIndex, "endAfter").setValue((Object)planEndTime);
            BigDecimal totalTime = (BigDecimal)this.tblMain.getCell(rowIndex, "periodAfter").getValue();
            Date date = (Date)this.tblMain.getCell(rowIndex, "startAfter").getValue();
            if (!this.mmCalendarFactory.isWorkDay(date)) {
                MsgBox.showInfo((String)this.getResource("NOTIN_FACTORYCALENDAR"));
                this.tblMain.getCell(rowIndex, "endAfter").setValue(oldValue);
                return;
            }
            int n = this.canChange(rowIndex, colIndex, 2);
            switch (n) {
                case 0: {
                    if (date.compareTo(planEndTime) > 0) {
                        MsgBox.showInfo((String)this.getResource("PLANBEGIN_GREATER_PLANEND"));
                        this.tblMain.getCell(rowIndex, "endAfter").setValue(oldValue);
                        SysUtil.abort();
                    }
                    int total = this.mmCalendarFactory.getWorklength(date, planEndTime);
                    this.tblMain.getCell(rowIndex, "periodAfter").setValue((Object)new BigDecimal(total));
                    return;
                }
                case 1: {
                    Date date3 = this.mmCalendarFactory.addWroklength(planEndTime, -totalTime.intValue());
                    this.tblMain.getCell(rowIndex, "startAfter").setValue((Object)date3);
                    return;
                }
                case 2: {
                    planEndTime = this.mmCalendarFactory.addWroklength(date, totalTime.intValue());
                    this.tblMain.getCell(rowIndex, "endAfter").setValue((Object)planEndTime);
                    return;
                }
            }
            return;
        }
        catch (EASBizException bizE) {
            this.tblMain.getCell(rowIndex, colIndex).setValue(oldValue);
            throw bizE;
        }
        catch (BOSException bosE) {
            throw bosE;
        }
        finally {
            this.setWBSChangedColor(rowIndex);
        }
    }

    private void setWBSChangedColor(int rowIndex) {
        if (rowIndex != -1) {
            for (int i = 0; i < this.colPaires.length; ++i) {
                Object oldValue = this.tblMain.getCell(rowIndex, this.colPaires[i][0]).getValue();
                Object newValue = this.tblMain.getCell(rowIndex, this.colPaires[i][1]).getValue();
                if (this.colPaires[i][0].equalsIgnoreCase("startBefore")) {
                    Date planBegin;
                    if (oldValue != null) {
                        planBegin = (Date)oldValue;
                        oldValue = this.toCalendar(planBegin).getTime();
                    }
                    if (newValue != null) {
                        planBegin = (Date)newValue;
                        newValue = this.toCalendar(planBegin).getTime();
                    }
                }
                if (this.colPaires[i][0].equalsIgnoreCase("endBefore")) {
                    Date planEnd;
                    if (oldValue != null) {
                        planEnd = (Date)oldValue;
                        oldValue = this.toCalendar(planEnd).getTime();
                    }
                    if (newValue != null) {
                        planEnd = (Date)newValue;
                        newValue = this.toCalendar(planEnd).getTime();
                    }
                }
                this.setWBSColor(oldValue, newValue, this.colPaires[i][0], this.colPaires[i][1], rowIndex);
            }
        }
    }

    private String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.PMChangeResource", (String)key);
    }

    private void setWBSColor(Object oldValue, Object newValue, String colOld, String colNew, int rowIndex) {
        Color defaultColor = this.tblMain.getCell(rowIndex, colOld).getStyleAttributes().getBackground();
        if (oldValue != null) {
            if (newValue == null) {
                this.tblMain.getCell(rowIndex, colNew).getStyleAttributes().setBackground(MMProjectFinalVariable.CHANGED_COLOR);
                if (!this.isTableChange) {
                    this.isTableChange = true;
                }
            } else if (!oldValue.toString().equals(newValue.toString())) {
                if (newValue instanceof BigDecimal && oldValue instanceof BigDecimal) {
                    if (((BigDecimal)oldValue).compareTo((BigDecimal)newValue) != 0) {
                        this.tblMain.getCell(rowIndex, colNew).getStyleAttributes().setBackground(MMProjectFinalVariable.CHANGED_COLOR);
                        if (!this.isTableChange) {
                            this.isTableChange = true;
                        }
                    } else {
                        this.tblMain.getCell(rowIndex, colNew).getStyleAttributes().setBackground(defaultColor);
                    }
                    return;
                }
                this.tblMain.getCell(rowIndex, colNew).getStyleAttributes().setBackground(MMProjectFinalVariable.CHANGED_COLOR);
                if (!this.isTableChange) {
                    this.isTableChange = true;
                }
            } else {
                this.tblMain.getCell(rowIndex, colNew).getStyleAttributes().setBackground(defaultColor);
            }
        } else if (newValue != null) {
            this.tblMain.getCell(rowIndex, colNew).getStyleAttributes().setBackground(MMProjectFinalVariable.CHANGED_COLOR);
            if (!this.isTableChange) {
                this.isTableChange = true;
            }
        } else if (newValue == null) {
            this.tblMain.getCell(rowIndex, colNew).getStyleAttributes().setBackground(defaultColor);
        }
    }

    private int canChange(int rowIndex, int colIndex, int changeObject) {
        ProjectDictDataInfo iteraterType = this.projectTaskInfo.getIteratorType();
        int returnType = 0;
        if (this.projectTaskInfo != null && iteraterType != null) {
            if (iteraterType.getNumber().equalsIgnoreCase("FS") || iteraterType.getNumber().equalsIgnoreCase("SS")) {
                if (changeObject == 0) {
                    returnType = 2;
                } else if (changeObject == 2) {
                    returnType = 0;
                }
            } else if (iteraterType.getNumber().equalsIgnoreCase("FF") || iteraterType.getNumber().equalsIgnoreCase("SF")) {
                if (changeObject == 0) {
                    returnType = 1;
                } else if (changeObject == 1) {
                    returnType = 0;
                }
            }
        } else {
            returnType = changeObject == 0 ? 2 : (changeObject == 1 ? 2 : 1);
        }
        return returnType;
    }

    private Calendar toCalendar(Date theDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(theDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @Override
    public void actionSyncUpdate_actionPerformed(ActionEvent e) throws Exception {
        this.projectTaskInfo.setTotalTime((BigDecimal)this.tblMain.getRow(0).getCell("periodAfter").getValue());
        Date originPlanBeginDate = (Date)this.tblMain.getRow(0).getCell("startBefore").getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(originPlanBeginDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date currPlanBeginDate = (Date)this.tblMain.getRow(0).getCell("startAfter").getValue();
        if (currPlanBeginDate.compareTo(calendar.getTime()) == 0) {
            currPlanBeginDate = originPlanBeginDate;
        }
        Date currPlanEndDate = (Date)this.tblMain.getRow(0).getCell("endAfter").getValue();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.projectTaskInfo.setPlanBeginTime(Timestamp.valueOf(df.format(currPlanBeginDate)));
        this.projectTaskInfo.setPlanEndTime(Timestamp.valueOf(df.format(currPlanEndDate)));
        ProjectTaskSyncFacadeFactory.getRemoteInstance().syncTask(this.projectTaskInfo, this.projectTaskInfo.getProject());
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectTaskResource.SYNC_SUCCESS"));
        this.setSync(true);
    }
}

