/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntries;
import com.kingdee.eas.framework.batchaction.BatchSelectionEntry;
import com.kingdee.eas.mm.common.client.KDTableUtils;
import com.kingdee.eas.mm.project.IProjectTask;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.client.ProjectTaskListUI;
import com.kingdee.eas.mm.project.client.ProjectTaskReleserUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.action.ActionProxy;
import com.kingdee.eas.scm.common.action.TableSelectionHelper;
import com.kingdee.eas.scm.common.service.SCMServiceFactory;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ReleserActionProxy
extends ActionProxy {
    private static final long serialVersionUID = -1000617819542188449L;
    private BatchActionEnum bizAction;
    private ActionLevelEnum level;

    public ReleserActionProxy(ItemAction action, String actionMethod, ActionLevelEnum level, BatchActionEnum bizAction) {
        super(action, actionMethod, level, bizAction);
        this.level = level;
    }

    public ReleserActionProxy(ItemAction action, String actionMethod, BatchActionEnum bizAction) {
        super(action, actionMethod, bizAction);
        this.bizAction = bizAction;
    }

    protected boolean beforeAction() {
        if ("ADDNEW".equals(this.getUIObject().getOprtState()) && !this.bizAction.equals((Object)BatchActionEnum.SAVE) && !this.bizAction.equals((Object)BatchActionEnum.SUBMIT)) {
            MsgBox.showWarning((String)ResourceUtils.getMessage((String)"com.kingdee.eas.scm.common.ActionResource", (String)"SAVE_FIRST"));
            return false;
        }
        if (super.getActionManager().getTableSelectionHelper().hasSelectedRows(this.level)) {
            return true;
        }
        MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
        return false;
    }

    protected boolean doActionPerformed(BatchSelectionEntries selectionEntry) throws Exception {
        boolean ret = super.doActionPerformed(selectionEntry);
        if (!ret) {
            return ret;
        }
        selectionEntry.getEntries().clear();
        KDTable tblMain = ((TableSelectionHelper)this.getActionManager().getTableSelectionHelper()).getTblMain();
        String flag = ((ProjectTaskListUI)this.getUIObject()).isTransfer;
        HashMap map = this.getIDs(tblMain);
        String projectId = (String)map.get("projectId");
        ArrayList list = (ArrayList)map.get("list");
        if (projectId != null) {
            ProjectTaskListUI projectTaskList = (ProjectTaskListUI)this.getUIObject();
            String orgUnitInfos = "";
            OrgUnitInfo[] mainOrgs = SCMServiceFactory.getPermissionService().getAuthorizedBizOrgUnits((IObjectPK)new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), projectTaskList.getBizOrgType(), null);
            for (int i = 0; i < mainOrgs.length; ++i) {
                OrgUnitInfo orgUnitInfo = mainOrgs[i];
                orgUnitInfos = orgUnitInfos + "'" + orgUnitInfo.getId().toString() + "'";
                if (i == mainOrgs.length - 1) continue;
                orgUnitInfos = orgUnitInfos + ",";
            }
            IProjectTask projectTask = ProjectTaskFactory.getRemoteInstance();
            ArrayList releserList = projectTask.getReleserProjectTask(projectId, orgUnitInfos, flag);
            UIContext ctx = new UIContext();
            ctx.put((Object)"releserList", (Object)releserList);
            String uiClass = "com.kingdee.eas.mm.project.client.ProjectTaskReleserUI";
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
            if (flag.equals("0")) {
                uiWindow.getUIObject().setUITitle(ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "TASKREQUEST"));
            } else if (flag.equals("1")) {
                uiWindow.getUIObject().setUITitle(ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "UNTASKREQUEST"));
            }
            uiWindow.show();
            ProjectTaskReleserUI ui = (ProjectTaskReleserUI)uiWindow.getUIObject();
            if (!ui.isConfirm) {
                return false;
            }
            HashSet set = (HashSet)ui.getOrderIDS();
            if (set.size() > 0) {
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    BatchSelectionEntry entry = new BatchSelectionEntry();
                    String[] string = (String[])iter.next();
                    entry.setId(string[0]);
                    entry.setNumber(string[1]);
                    selectionEntry.getEntries().add(entry);
                }
            }
        }
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                selectionEntry.getEntries().add((BatchSelectionEntry)list.get(i));
            }
        }
        if (selectionEntry.getEntries().size() < 1) {
            ret = false;
        }
        return ret;
    }

    private HashMap getIDs(KDTable table) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int start = 0;
        int end = 0;
        String projectId = "";
        ArrayList<BatchSelectionEntry> list = new ArrayList<BatchSelectionEntry>();
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            if (sb == null) continue;
            start = sb.getTop();
            end = sb.getBottom();
            boolean isTableSelected = KDTableUtils.isTableSelected((KDTable)table);
            if (isTableSelected) {
                start = 0;
                end = table.getRowCount() - 1;
            }
            for (int j = start; j <= end; ++j) {
                IRow row = table.getRow(j);
                if (row.getCell("projectType.id").getValue().toString().equals("U+F6TI7tSwWsxrdj4TYytZpMH64=")) {
                    if (projectId.indexOf(row.getCell("project.id").getValue().toString()) != -1) continue;
                    if (!projectId.equals("")) {
                        projectId = projectId + ",";
                    }
                    projectId = projectId + "'" + row.getCell("project.id").getValue().toString() + "'";
                    continue;
                }
                BatchSelectionEntry entry = new BatchSelectionEntry();
                entry.setId(row.getCell("id").getValue().toString());
                entry.setNumber(row.getCell("number").getValue().toString());
                entry.setRowNum(row.getRowIndex());
                list.add(entry);
            }
        }
        if (!projectId.equals("")) {
            map.put("projectId", projectId);
        }
        map.put("list", list);
        return map;
    }
}

