/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitDelegationFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminF7NoPerm;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.client.UIHelper;
import com.kingdee.eas.mm.project.DictDataTypeEnum;
import com.kingdee.eas.mm.project.ITaskTemplate;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.TaskTemplateFactory;
import com.kingdee.eas.mm.project.TaskTemplateInfo;
import com.kingdee.eas.mm.project.client.AbstractTaskTemplateEditUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.util.DictDataControlUtil;
import com.kingdee.eas.scm.common.action.ISupportBatchAction;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.F7ContextManager;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.ComboBoxModel;
import org.apache.log4j.Logger;

public class TaskTemplateEditUI
extends AbstractTaskTemplateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaskTemplateEditUI.class);
    private DataChangeListener materialDataChanged = null;
    private DataChangeListener adminOrgUnitDataChanged = null;
    private DataChangeListener storageOrgUnitDataChanged = null;
    private static int TXT_NAME_MAXLENGTH = 255;

    public KDTextField getNumTextField() {
        return this.txtNumber;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtStorageOrgUnit;
    }

    protected String getPermissionItem(String status) {
        if ("ADDNEW".equals(status)) {
            return "mm_project_taskTemplateAddnew";
        }
        if ("EDIT".equals(status)) {
            return "mm_project_taskTemplateModify";
        }
        if ("VIEW".equals(status)) {
            return "mm_project_taskTemplateView";
        }
        return null;
    }

    protected void initNeedMainOrgF7s() {
        this.setDepartmentF7(this.prmtAdminOrgUnit);
        this.setPersonF7(this.prmtAdminOrgUnit, this.prmtPerson);
        this.registBizMaterialF74ETO();
        this.prmtMaterial.setDisplayFormat("$name$");
        this.setNeedMainOrgF7s(new KDBizPromptBox[]{this.prmtAdminOrgUnit});
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setMainStatusBar(MainStatusBar.getMainStatusBar());
    }

    protected int getShowMessagePolicy() {
        return 2;
    }

    @Override
    public void storeFields() {
        if (this.txtName.getText() != null && this.txtName.getText().trim().equals("")) {
            this.txtName.setText(null);
        }
        super.storeFields();
    }

    public void onLoad() throws Exception {
        try {
            DictDataControlUtil.registControl(new KDComboBox[]{this.kdcTaskType}, new DictDataTypeEnum[]{DictDataTypeEnum.TASKTYPE});
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
        super.onLoad();
        this.txtStandardCost.setMinimumValue((Comparable)new BigDecimal("0"));
        this.txtStandardCost.setMaximumValue((Comparable)new BigDecimal("10000000000000"));
        this.txtStandardCost.setRemoveingZeroInDispaly(false);
        this.txtStandardCost.setNegatived(false);
        this.txtStandardCost.setHorizontalAlignment(4);
        this.txtEndLeadTime.setMinimumValue((Comparable)new BigDecimal("-9999"));
        this.txtEndLeadTime.setMaximumValue((Comparable)new BigDecimal("9999"));
        this.txtEndLeadTime.setRemoveingZeroInDispaly(false);
        this.txtEndLeadTime.setNegatived(true);
        this.txtEndLeadTime.setHorizontalAlignment(4);
        this.txtEndLeadTime.setSupportedEmpty(true);
        this.txtBeginLeadTime.setMinimumValue((Comparable)new BigDecimal("-9999"));
        this.txtBeginLeadTime.setMaximumValue((Comparable)new BigDecimal("9999"));
        this.txtBeginLeadTime.setRemoveingZeroInDispaly(false);
        this.txtBeginLeadTime.setNegatived(true);
        this.txtBeginLeadTime.setHorizontalAlignment(4);
        this.txtBeginLeadTime.setSupportedEmpty(true);
        this.txtWorktime.setMaximumValue((Comparable)new BigDecimal("9999"));
        this.txtWorktime.setRemoveingZeroInDispaly(false);
        this.txtWorktime.setNegatived(false);
        this.txtWorktime.setHorizontalAlignment(4);
        this.txtWorktime.setSupportedEmpty(true);
        this.txtDayQty.setMaximumValue((Comparable)new BigDecimal("9999"));
        this.txtDayQty.setRemoveingZeroInEdit(false);
        this.txtDayQty.setNegatived(false);
        this.txtDayQty.setSupportedEmpty(true);
        this.txtDayQty.setHorizontalAlignment(4);
        this.txtDayQty.setPrecision(4);
        this.txtDayMaxQty.setMaximumValue((Comparable)new BigDecimal("9999"));
        this.txtDayMaxQty.setRemoveingZeroInEdit(false);
        this.txtDayMaxQty.setNegatived(false);
        this.txtDayMaxQty.setSupportedEmpty(true);
        this.txtDayMaxQty.setHorizontalAlignment(4);
        this.txtDayMaxQty.setPrecision(4);
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType());
        if (this.isFirstOnload() && orgUnitInfo != null) {
            OrgChangeVO orgChangeVO = new OrgChangeVO();
            orgChangeVO.setNewOrg((Object)orgUnitInfo);
            this.afterMainOrgChanged(orgChangeVO);
        }
        this.removeButton();
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        this.prmtMaterial.setDisplayFormat("$name$");
        this.prmtAdminOrgUnit.setDisplayFormat("$name$");
        this.txtName.setMaxLength(TXT_NAME_MAXLENGTH);
    }

    protected IObjectValue createNewData() {
        TaskTemplateInfo objectValue = null;
        try {
            objectValue = (TaskTemplateInfo)((ITaskTemplate)this.getBizInterface()).createNewData(true);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (objectValue == null) {
            objectValue = new TaskTemplateInfo();
        }
        objectValue.setBaseStatus(MMBaseStatusEnum.ADDNEW);
        objectValue.setStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg());
        this.currStorageInfo = objectValue.getStorageOrgUnit();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        try {
            if (objectValue.getStorageOrgUnit() != null) {
                objectValue.setCurrency(ProjectUtil.getCurrenyOrgUnitInfo(objectValue.getStorageOrgUnit().getId().toString()));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        ProjectDictDataInfo info = null;
        if (this.getOprtState().equalsIgnoreCase("ADDNEW")) {
            for (int i = 0; i < this.kdcTaskType.getItemCount(); ++i) {
                info = (ProjectDictDataInfo)this.kdcTaskType.getItemAt(i);
                if (!"0".equals(info.getNumber())) continue;
                objectValue.setTaskType(info);
                break;
            }
        }
        return objectValue;
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        if (chgVo.isDiffrent()) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)chgVo.getNewOrg();
            this.afterMainOrgChanged(orgUnitInfo);
        }
    }

    private void registBizMaterialF74ETO() {
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.prmtStorageOrgUnit.getData();
        if (orgInfo == null) {
            orgInfo = this.getDefaultMainBizOrg();
        }
        String orgId = "";
        orgId = orgInfo == null ? "'null'" : orgInfo.getId().toString();
        UIHelper.registerBizMaterialF7((F7ContextManager)this.f7Manager, (KDBizPromptBox)this.prmtMaterial, (OrgUnitInfo)orgInfo);
        EntityViewInfo view = this.prmtMaterial.getEntityViewInfo();
        StringBuffer sqlBuf = new StringBuffer("");
        sqlBuf.append("select FMaterialID from T_BD_MaterialPlan t0 inner join T_BD_ManufactureStrategy t1 ");
        sqlBuf.append("on t0.FManufactureStrategyID = t1.FID where t1.FID in( '");
        sqlBuf.append("GE2FIa4GQ6uhdx0RDGuibtg0uEU=','qAXoUB/uBg/gQKjAYj0WQ9g0uEU=");
        sqlBuf.append("') AND t0.FOrgUnit = '");
        sqlBuf.append(orgId);
        sqlBuf.append("'");
        FilterItemInfo filterItem = new FilterItemInfo("id", (Object)sqlBuf.toString(), CompareType.INNER);
        String mask = "(" + view.getFilter().getMaskString() + ") AND #" + (view.getFilter().getFilterItems().size() - 1);
        view.getFilter().getFilterItems().add(filterItem);
        if (view.getFilter().getMaskString() != null) {
            view.getFilter().setMaskString(mask);
        }
        this.prmtMaterial.setEntityViewInfo(view);
    }

    protected void afterMainOrgChanged(OrgUnitInfo orgInfo) {
        CurrencyInfo currencyInfo = null;
        if (!"VIEW".equals(this.getOprtState()) && !"FINDVIEW".equals(this.getOprtState())) {
            if ("ADDNEW".equals(this.getOprtState())) {
                this.prmtMaterial.setValue(null);
                this.prmtAdminOrgUnit.setValue(null);
            }
            if (orgInfo != null) {
                try {
                    currencyInfo = ProjectUtil.getCurrenyOrgUnitInfo(orgInfo.getId().toString());
                    this.prmtCurrency.setValue((Object)currencyInfo);
                    if (currencyInfo != null) {
                        this.txtStandardCost.setPrecision(currencyInfo.getPrecision());
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        if (this.editData != null && this.editData.getTaskType() != null) {
            ComboBoxModel model = this.kdcTaskType.getModel();
            model.setSelectedItem(this.editData.getTaskType());
        }
        CurrencyInfo currencyInfo = null;
        if (this.editData != null && this.editData.getCurrency() != null && (currencyInfo = this.editData.getCurrency()) != null) {
            this.txtStandardCost.setPrecision(currencyInfo.getPrecision());
        }
        this.addListener();
    }

    private void addListener() {
        this.materialDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    TaskTemplateEditUI.this.prmtMaterial_dataChanged(e);
                }
                catch (Exception exc) {
                    TaskTemplateEditUI.this.handUIException(exc);
                }
            }
        };
        this.prmtMaterial.addDataChangeListener(this.materialDataChanged);
        this.adminOrgUnitDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    TaskTemplateEditUI.this.prmtPerson.setValue(null);
                }
            }
        };
        this.prmtAdminOrgUnit.addDataChangeListener(this.adminOrgUnitDataChanged);
        this.storageOrgUnitDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null) {
                    TaskTemplateEditUI.this.prmtStorageOrgUnit.setValue(e.getOldValue());
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.storageOrgUnitDataChanged);
    }

    private void removeListener() {
        if (this.materialDataChanged != null) {
            this.prmtMaterial.removeDataChangeListener(this.materialDataChanged);
        }
        if (this.adminOrgUnitDataChanged != null) {
            this.prmtAdminOrgUnit.removeDataChangeListener(this.adminOrgUnitDataChanged);
        }
        if (this.storageOrgUnitDataChanged != null) {
            this.prmtStorageOrgUnit.removeDataChangeListener(this.storageOrgUnitDataChanged);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        super.setFieldsNull(newData);
        TaskTemplateInfo task = (TaskTemplateInfo)newData;
        task.setAuditor(null);
        task.setLastUpdateUser(null);
        task.setAuditTime(null);
        task.setLastUpdateTime(null);
        task.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        task.setBaseStatus(MMBaseStatusEnum.ADDNEW);
        try {
            task.setCreateTime(SCMClientUtils.getServerDate());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void prmtMaterial_dataChanged(DataChangeEvent e) {
        MaterialInfo newValue;
        MaterialInfo oldValue = (MaterialInfo)e.getOldValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (MaterialInfo)e.getNewValue()));
        if (isDiffrent) {
            if (newValue == null) {
                this.txtStandardCost.setValue(null);
            } else {
                String[] params = new String[]{((MaterialInfo)this.prmtMaterial.getData()).getId().toString(), ((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getData()).getId().toString()};
                BigDecimal value = null;
                try {
                    value = ((ITaskTemplate)this.getBizInterface()).getStandardCost(params);
                }
                catch (Exception e1) {
                    this.handUIException(e1);
                }
                this.txtStandardCost.setValue((Object)value);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("material.baseUnit.*"));
        sic.add(new SelectorItemInfo("taskType.*"));
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaskTemplateFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected void initBatchInterface() {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, TaskTemplateFactory.class);
        this.getTableSelectionHelper().setTableProperty((ISupportBatchAction)this, null, "id", this.txtNumber, null);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.actionAudit.setEnabled(false);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.unLockUI();
        }
    }

    protected void setDepartmentF7(KDBizPromptBox bizOrgUnitBox) {
        OrgUnitInfo orgInfo = null;
        bizOrgUnitBox.setSelector((KDPromptSelector)new AdminF7NoPerm());
        bizOrgUnitBox.setDisplayFormat("$name$");
        bizOrgUnitBox.setEditFormat("$name$");
        bizOrgUnitBox.setCommitFormat("$number$;$code$");
        bizOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        IFilterInfoProducer iProducer = FilterInfoProducerFactory.getOrgUnitDelegationFilterInfoProducer((DelegationPartsEnum)DelegationPartsEnum.THE_TO_UNIT, (OrgType)OrgType.Admin);
        OrgUnitDelegationFilterInfoProducer producer = (OrgUnitDelegationFilterInfoProducer)iProducer;
        producer.getModel().setDoNotUseUserOrgRangeAsFilter();
        bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)producer);
        if (this.getMainOrgContext() != null && (orgInfo = (OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())) != null) {
            bizOrgUnitBox.setCurrentMainBizOrgUnit(orgInfo, this.getMainBizOrgType());
        }
    }
}

