/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.project.ProjectCalendarFacadeFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTaskFactory;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.client.AbstractWBSExportUI;
import com.kingdee.eas.mm.project.client.MppDocHandler;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class WBSExportUI
extends AbstractWBSExportUI {
    private static final Logger logger = CoreUIObject.getLogger(WBSExportUI.class);
    private DataChangeListener projectDataChanged = null;
    String filePath = null;

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        if (newOrgId == null || !newOrgId.equals(oldOrgId)) {
            this.prmtProject.setValue(null);
            this.prmtProjectTask.setValue(null);
        }
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public void onLoad() throws Exception {
        String strTemplate = (String)this.getUIContext().get("UIClassParam");
        boolean isTemplate = this.toBoolean(strTemplate);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isTemplate", (Object)new Boolean(isTemplate));
        super.onLoad();
        this.selectFile.setEnabled(true);
        this.export.setEnabled(true);
        this.selectFile.setIcon(UIManager.getIcon("Tree.openIcon"));
        this.prmtStorageOrgUnit.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)this.getMainBizOrgType(), (String)this.getViewPermission()));
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        status.add(new Integer(7));
        status.add(new Integer(5));
        status.add(new Integer(50));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProject, status, isTemplate, null);
        ProjectUtil.setProjectTaskF7(null, this.prmtProject, null, this.prmtProjectTask, status, null);
        ProjectUtil.setMainBizOrgF7(this.prmtStorageOrgUnit, this.getViewPermission());
        this.prmtStorageOrgUnit.setEnabledMultiSelection(false);
        this.addListener();
    }

    public CoreBaseCollection getProjectTaskCollection() throws BOSException {
        CoreBaseCollection collection = null;
        CoreBaseCollection collection2 = new CoreBaseCollection();
        EntityViewInfo viewInfo = new EntityViewInfo();
        Object projectTask = null;
        FilterInfo filter = new FilterInfo();
        FilterInfo filter2 = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("project", (Object)((ProjectInfo)this.prmtProject.getValue()).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(0), CompareType.NOTEQUALS));
        if (this.prmtProjectTask.getValue() != null) {
            filter.getFilterItems().add(new FilterItemInfo("wbsNumber", (Object)(((ProjectTaskInfo)this.prmtProjectTask.getValue()).getWbsNumber() + ".%"), CompareType.LIKE));
            filter2.getFilterItems().add(new FilterItemInfo("id", (Object)((ProjectTaskInfo)this.prmtProjectTask.getValue()).getId().toString(), CompareType.EQUALS));
            filter.mergeFilter(filter2, "or");
        }
        SorterItemInfo sorterInfo = null;
        sorterInfo = new SorterItemInfo("wbsNumber");
        sorterInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterInfo);
        viewInfo.setFilter(filter);
        try {
            collection = ProjectTaskFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getCollection(viewInfo);
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        if (collection.size() > 0 && ((ProjectTaskInfo)collection.get(collection.size() - 1)).getLevel() == 0) {
            collection2.add(collection.get(collection.size() - 1));
            for (int i = 0; i < collection.size() - 1; ++i) {
                collection2.add(collection.get(i));
            }
            collection = collection2;
        }
        return collection;
    }

    @Override
    public void actionSelectFile_actionPerformed(ActionEvent e) throws Exception {
        WBSExportUI component = this;
        this.filePath = ProjectUtil.getSelectFile(false, new String[]{"xml"}, this.filePath, (Component)((Object)component));
        if (this.filePath == null) {
            return;
        }
        this.file.setText(this.filePath);
    }

    protected String getViewPermission() {
        return "mm_projecttask_export";
    }

    @Override
    public void actionExportProjectTask_actionPerformed(ActionEvent e) throws Exception {
        File exportFile = null;
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)this.getResourceString("STORAGEORGUNIT_CANT_NULL"));
            return;
        }
        if (this.prmtProject.getValue() == null) {
            MsgBox.showInfo((String)this.getResourceString("PROJECT_NOT_NULL"));
            return;
        }
        if (this.file.getText() == null || this.file.getText().equals("")) {
            MsgBox.showInfo((String)this.getResourceString("FILEPATH_NOT_NULL"));
            return;
        }
        try {
            exportFile = new File(this.file.getText().endsWith(".xml") ? this.file.getText() : this.file.getText() + ".xml");
            if (!exportFile.isAbsolute()) {
                MsgBox.showInfo((String)this.getResourceString("ABSOLUTE"));
                return;
            }
            if (!exportFile.exists()) {
                exportFile.createNewFile();
            }
        }
        catch (Exception e1) {
            MsgBox.showInfo((String)this.getResourceString("INVALID_FILEPATH"));
            return;
        }
        CoreBaseCollection collection = this.getProjectTaskCollection();
        ArrayList list = ProjectCalendarFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).getAllFreeDate(((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()).getId().toString());
        ProjectTaskInfo root = ProjectTaskFactory.getRemoteInstance().getRootProject(((ProjectInfo)this.prmtProject.getValue()).getId().toString());
        MppDocHandler.exportProjectTask(collection, root, exportFile, list);
        MsgBox.showInfo((String)this.getResourceString("EXPORT_PROJECT_SUCCESS"));
        this.actionExitCurrent_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public String getResourceString(String strKey) {
        return EASResource.getString((String)"com.kingdee.eas.mm.project.WBSResource", (String)strKey);
    }

    private boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    private void addListener() {
        this.projectDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (e.getNewValue() == null || !e.getNewValue().equals(e.getOldValue())) {
                    WBSExportUI.this.prmtProjectTask.setValue(null);
                }
            }
        };
        this.prmtProject.addDataChangeListener(this.projectDataChanged);
    }
}

