/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.freechart.ui.ExtensionFileFilter;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotpMetaDataFactory;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.common.MMBaseStatusEnum;
import com.kingdee.eas.mm.common.client.MMUtils;
import com.kingdee.eas.mm.planning.AllEnum;
import com.kingdee.eas.mm.project.ProjectDictDataCollection;
import com.kingdee.eas.mm.project.ProjectDictDataFactory;
import com.kingdee.eas.mm.project.ProjectDictDataInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.mm.project.ProjectTask;
import com.kingdee.eas.mm.project.ProjectTaskInfo;
import com.kingdee.eas.mm.project.WBSImportorFacadeFactory;
import com.kingdee.eas.mm.project.client.AbstractWBSImportUI;
import com.kingdee.eas.mm.project.client.MppDocHandler;
import com.kingdee.eas.mm.project.client.ProjectTaskListUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Column;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.ProjectFile;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Relation;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Table;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.Task;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TaskField;
import com.kingdee.eas.mm.project.client.net.sf.mpxj.TimeUnit;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class WBSImportUI
extends AbstractWBSImportUI {
    private static final Logger logger = CoreUIObject.getLogger(WBSImportUI.class);
    private final String COL_ID = "id";
    private final String COL_IS_SELECT = "isSelected";
    private final String COL_NAME = "name";
    private final String COL_TOTALTIME = "totalTime";
    private final String COL_BEGINTIME = "beginTime";
    private final String COL_ENDTIME = "endTime";
    private ProjectFile mpx = null;
    private List firstLevelTask = new ArrayList();
    private List impFirstLevelTask = new ArrayList();
    private List impTasks = new ArrayList();
    private Map impTaskstemp = new HashMap();
    private StorageOrgUnitInfo storageOrg = null;
    private ProjectInfo project = null;
    private ProjectInfo srcProject = null;
    private ProjectTaskInfo parentTask = null;
    private boolean isTemplate = false;
    private IUIWindow dialog = null;
    private String path = ".";
    private ProjectDictDataInfo taskType = null;
    private ProjectDictDataInfo FS = null;
    private ProjectDictDataInfo FF = null;
    private ProjectDictDataInfo SF = null;
    private ProjectDictDataInfo SS = null;
    private ProjectDictDataInfo feedBackMode = null;
    private DataChangeListener projectDataChanged = null;
    private DataChangeListener prmtStorageOrgUnitDataChanged = null;
    private Map taskTitles = new HashMap();
    private List allTitleType = new ArrayList();
    private List titlesList = new ArrayList();
    private KDTEditAdapter importFileNameListener = null;
    private Map templetConnection = new HashMap();
    private String[] templeDateField = new String[]{"storageOrgUnit", "taskType", "material", "qty", "carNumber", "adminOrgUnit", "person", "createOrgUnit", "centralPurStgOrg", "feedbackMode", "totalCost", "unitCost", "comment"};
    private static final String RES_PRD_ORDER = "com.kingdee.eas.mm.project.WBSImportResource";
    private CurrencyInfo currencyInfo = null;

    protected OrgType getMainBizOrgType() {
        return OrgType.Storage;
    }

    public OrgType getMainType() {
        return this.getMainBizOrgType();
    }

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmtStorageOrgUnit;
    }

    public void onLoad() throws Exception {
        String strTemplate = (String)this.getUIContext().get("UIClassParam");
        this.isTemplate = this.toBoolean(strTemplate);
        super.onLoad();
        this.prmtStorageOrgUnit.setValue((Object)MMUtils.getDefaultMainBizOrg((OrgType)OrgType.Storage, (String)"mm_project_wbs_import"));
        this.setTitle();
        this.initOwnF7();
        this.kdtMain.checkParsed();
        this.kdtConfigure.checkParsed();
        this.tHelper.getDisabledTables().add(this.kdtMain);
        this.tHelper.getDisabledTables().add(this.kdtConfigure);
        KDCheckBox isSelect = new KDCheckBox();
        KDDatePicker startDate = new KDDatePicker();
        KDDatePicker endDate = new KDDatePicker();
        this.kdtMain.getColumn("beginTime").setEditor((ICellEditor)new KDTDefaultCellEditor(startDate));
        this.kdtMain.getColumn("endTime").setEditor((ICellEditor)new KDTDefaultCellEditor(endDate));
        this.kdtMain.getColumn("beginTime").getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        this.kdtMain.getColumn("endTime").getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        this.kdtMain.getActionMap().remove("Delete");
        this.kdtConfigure.getActionMap().remove("Delete");
        isSelect.setSelected(false);
        this.kdtMain.getColumn("isSelected").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)isSelect));
        this.kdtMain.getStyleAttributes().setLocked(true);
        this.kdtMain.getColumn("isSelected").getStyleAttributes().setLocked(false);
    }

    private void initOwnF7() {
        ProjectUtil.setMainBizOrgF7(this.prmtStorageOrgUnit, this.getPermissionItem());
        HashSet<Integer> status = new HashSet<Integer>();
        status.add(new Integer(4));
        HashSet<Integer> taskStatus = new HashSet<Integer>();
        taskStatus.add(new Integer(4));
        taskStatus.add(new Integer(2));
        taskStatus.add(new Integer(60));
        taskStatus.add(new Integer(5));
        ProjectUtil.setProjectF7(this.prmtStorageOrgUnit, this.prmtProject, status, this.isTemplate, null);
        ProjectUtil.setProjectTaskF7(this.prmtStorageOrgUnit, this.prmtProject, null, this.prmtParent, taskStatus, null);
    }

    private String getPermissionItem() {
        return "mm_projecttask_import";
    }

    protected KDTable getTableForCommon() {
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtStorageOrgUnit.setRequired(true);
        this.prmtProject.setRequired(true);
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnCancelAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelect.setIcon(UIManager.getIcon("Tree.openIcon"));
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.impFirstLevelTask.clear();
        this.impTasks.clear();
        this.impTaskstemp.clear();
        if (this.prmtStorageOrgUnit.getValue() == null) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "PLEASE_CHOOSE_ORG"));
            SysUtil.abort();
            return;
        }
        this.storageOrg = (StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue();
        this.currencyInfo = ProjectUtil.getCurrenyOrgUnitInfo(this.storageOrg.getId().toString());
        if (this.prmtProject.getValue() == null) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "PLEASE_CHOOSE_PROJECT"));
            SysUtil.abort();
            return;
        }
        this.project = (ProjectInfo)this.prmtProject.getValue();
        if (this.prmtParent.getValue() != null) {
            this.parentTask = (ProjectTaskInfo)this.prmtParent.getValue();
        }
        int rowCount = this.kdtMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object isSelected = this.kdtMain.getCell(i, "isSelected").getValue();
            if (!((Boolean)isSelected).booleanValue()) continue;
            Integer id = (Integer)this.kdtMain.getCell(i, "id").getValue();
            for (Task task : this.firstLevelTask) {
                if (!task.getID().equals(id)) continue;
                this.impFirstLevelTask.add(task);
            }
        }
        if (this.mpx == null) {
            return;
        }
        List list = this.processIMP();
        this.isShowTaskListUI(list);
        this.destroyWindow();
    }

    private void isShowTaskListUI(List list) {
        int result;
        String s = "";
        String xinxi = "";
        if (list != null && list.size() > 0) {
            String ne = EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectResource", (String)"WBSNUMBER_SIFJIEIF");
            xinxi = EASResource.getString((String)"com.kingdee.eas.mm.project.ProjectResource", (String)"WBSINPORT_IS_NOTNULL");
            for (int i = 0; i < list.size(); ++i) {
                s = s + list.get(i) + ne + "\n";
            }
        }
        if ((result = s.equals("") && "".equals(s) ? MsgBox.showConfirm2((Component)((Object)this), (String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "IMP_SUCCESS")) : MsgBox.showConfirm3a((String)xinxi, (String)s)) == 0) {
            try {
                Window p = SwingUtilities.getWindowAncestor((Component)((Object)this));
                this.getUIWindow().close();
                UIContext context = new UIContext();
                context.put((Object)"UIClassParam", (Object)new Boolean(this.isTemplate).toString());
                context.put((Object)"wbscopy", (Object)"false");
                context.put((Object)"storgnumber", (Object)((StorageOrgUnitInfo)this.prmtStorageOrgUnit.getValue()));
                context.put((Object)"toProject", (Object)this.project);
                context.put((Object)"Owner", (Object)p);
                this.dialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.project.client.ProjectTaskListUI", (Map)context, null, OprtState.VIEW);
                this.dialog.show();
                ((ProjectTaskListUI)this.dialog.getUIObject()).requestFocusInWindow();
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        } else {
            this.getUIWindow().close();
        }
    }

    private List processIMP() throws Exception {
        this.processWBS(this.mpx);
        this.processRelationships(this.mpx);
        ProjectTaskInfo parent = null;
        if (this.parentTask != null) {
            parent = this.parentTask;
        }
        if (this.impTasks.size() == 0) {
            MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "CHOOSE_IMP_TASK"));
            SysUtil.abort();
        }
        List list = WBSImportorFacadeFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext()).importWBS(this.storageOrg.getId().toString(), this.srcProject, this.project, parent, this.impTasks);
        return list;
    }

    private void processWBS(ProjectFile mpx) throws Exception {
        Iterator iter = this.impFirstLevelTask.iterator();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> pks = new HashSet<String>();
        pks.add("lS5zDgcXS7Ovp7Xx1hjzJZpMH64=");
        pks.add("Fq4GNbRIRsycITnKFLeBd5pMH64=");
        pks.add("V7CLkDIwR9Cbr4Bs/mppV5pMH64=");
        pks.add("v1VYDRfdTvK2ahwoFyvCLppMH64=");
        pks.add("LCjtHmEGRSCChKDBR/R9jJpMH64=");
        pks.add("8/nx9bmpQC6M7x3BBwNUappMH64=");
        filter.getFilterItems().add(new FilterItemInfo("id", pks, CompareType.INCLUDE));
        view.setFilter(filter);
        ProjectDictDataCollection coll = null;
        try {
            coll = ProjectDictDataFactory.getRemoteInstance().getProjectDictDataCollection(view);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        for (int i = 0; i < coll.size(); ++i) {
            ProjectDictDataInfo temp = coll.get(i);
            if (temp.getId().toString().equalsIgnoreCase("LCjtHmEGRSCChKDBR/R9jJpMH64=")) {
                this.taskType = temp;
                continue;
            }
            if (temp.getId().toString().equalsIgnoreCase("lS5zDgcXS7Ovp7Xx1hjzJZpMH64=")) {
                this.FF = temp;
                continue;
            }
            if (temp.getId().toString().equalsIgnoreCase("v1VYDRfdTvK2ahwoFyvCLppMH64=")) {
                this.SS = temp;
                continue;
            }
            if (temp.getId().toString().equalsIgnoreCase("Fq4GNbRIRsycITnKFLeBd5pMH64=")) {
                this.FS = temp;
                continue;
            }
            if (temp.getId().toString().equalsIgnoreCase("V7CLkDIwR9Cbr4Bs/mppV5pMH64=")) {
                this.SF = temp;
                continue;
            }
            if (!temp.getId().toString().equalsIgnoreCase("8/nx9bmpQC6M7x3BBwNUappMH64=")) continue;
            this.feedBackMode = temp;
        }
        while (iter.hasNext()) {
            this.processTask((Task)iter.next(), null);
        }
    }

    private void processTask(Task task, ProjectTaskInfo parent) throws BOSException, EASBizException {
        List children = task.getChildTasks();
        ProjectTaskInfo pTask = new ProjectTaskInfo();
        if (this.templetConnection != null) {
            for (String fieldName : this.templetConnection.keySet()) {
                String fileTaskFieldName = (String)this.templetConnection.get(fieldName);
                TaskField field = (TaskField)this.taskTitles.get(fileTaskFieldName);
                Object valueObject = task.getCachedValue(field);
                pTask.put(fieldName, valueObject);
            }
        }
        pTask.setId(BOSUuid.create((BOSObjectType)pTask.getBOSType()));
        pTask.setName(task.getName());
        pTask.setIsMileStone(task.getMilestone());
        TimeUnit timeunit = task.getDuration().getUnits();
        BigDecimal totalTime = null;
        if (timeunit.getValue() == 1) {
            totalTime = new BigDecimal(task.getDuration().getDuration() / 8.0);
        } else if (timeunit.getValue() == 2) {
            totalTime = new BigDecimal(task.getDuration().getDuration());
        }
        pTask.setTotalTime(totalTime);
        pTask.setPlanBeginTime(this.toTimestamp(task.getStart()));
        pTask.setPlanEndTime(this.toTimestamp(task.getFinish()));
        pTask.setProject(this.project);
        try {
            pTask.setCurrency(this.currencyInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        pTask.setBaseStatus(MMBaseStatusEnum.SAVED);
        pTask.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        pTask.setCreateTime(new Timestamp(System.currentTimeMillis()));
        pTask.setIsTemplate(this.isTemplate);
        if (parent != null) {
            pTask.setParent(parent);
        }
        this.impTaskstemp.put(task.getID(), pTask);
        this.impTasks.add(pTask);
        if (children.size() != 0) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                this.processTask((Task)iter.next(), pTask);
            }
        }
    }

    private Timestamp toTimestamp(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new Timestamp(calendar.getTimeInMillis());
    }

    private void processRelationships(ProjectFile mpx) {
        Iterator taskIter = mpx.getAllTasks().iterator();
        ProjectTaskInfo ptask1 = null;
        ProjectTaskInfo ptask2 = null;
        String iteratorType = "";
        while (taskIter.hasNext()) {
            Task task = (Task)taskIter.next();
            if (this.impTaskstemp.get(task.getID()) == null) continue;
            ptask1 = (ProjectTaskInfo)this.impTaskstemp.get(task.getID());
            List rels = task.getPredecessors();
            if (rels == null) continue;
            for (Relation rel : rels) {
                if (this.impTaskstemp.get(rel.getTask().getID()) == null) continue;
                ptask2 = (ProjectTaskInfo)this.impTaskstemp.get(rel.getTask().getID());
                switch (rel.getType().getType()) {
                    case 0: {
                        iteratorType = "FF";
                        break;
                    }
                    case 1: {
                        iteratorType = "FS";
                        break;
                    }
                    case 2: {
                        iteratorType = "SF";
                        break;
                    }
                    case 3: {
                        iteratorType = "SS";
                    }
                }
                ptask1.setPreTask(ptask2);
                TimeUnit timeunit = rel.getDuration().getUnits();
                BigDecimal iterator = null;
                if (timeunit.getValue() == 1) {
                    iterator = new BigDecimal(rel.getDuration().getDuration() / 8.0);
                } else if (timeunit.getValue() == 2) {
                    iterator = new BigDecimal(rel.getDuration().getDuration());
                }
                ptask1.setInterval(iterator);
                if (iteratorType.equalsIgnoreCase("FF")) {
                    ptask1.setIteratorType(this.FF);
                    continue;
                }
                if (iteratorType.equalsIgnoreCase("SS")) {
                    ptask1.setIteratorType(this.SS);
                    continue;
                }
                if (iteratorType.equalsIgnoreCase("SF")) {
                    ptask1.setIteratorType(this.SF);
                    continue;
                }
                if (!iteratorType.equalsIgnoreCase("FS")) continue;
                ptask1.setIteratorType(this.FS);
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.destroyWindow();
    }

    @Override
    public void actionSelectFile_actionPerformed(ActionEvent e) throws Exception {
        this.mpx = null;
        this.firstLevelTask.clear();
        this.impFirstLevelTask.clear();
        this.impTasks.clear();
        this.impTaskstemp.clear();
        this.taskTitles.clear();
        this.allTitleType.clear();
        this.titlesList.clear();
        super.actionSelectFile_actionPerformed(e);
        String strFullPath = this.getSelectFile(false, new String[]{"xml", "mpp"});
        if (strFullPath != null) {
            this.txtFile.setText(strFullPath);
            File file = null;
            BufferedInputStream in = null;
            FileInputStream fileInputStream = null;
            try {
                file = new File(strFullPath);
                fileInputStream = new FileInputStream(file);
                in = new BufferedInputStream(fileInputStream);
                if (!file.exists()) {
                    MsgBox.showWarning((Component)((Object)this), (String)GanttResourceUtil.getResource("Gantt_FileNotExist"));
                    return;
                }
                if (this.kdtMain.getRowCount() > 0) {
                    this.kdtMain.removeRows();
                    this.kdtConfigure.removeRows();
                }
                this.mpx = MppDocHandler.readProject(in);
                if (this.mpx == null) {
                    return;
                }
                this.getTaskTitles();
                this.setSelectTaskValue();
                IColumn column = null;
                KDComboBox comboBox = new KDComboBox();
                for (int i = 0; i < this.titlesList.size(); ++i) {
                    comboBox.addItem(this.titlesList.get(i));
                }
                comboBox.setEditable(false);
                KDTDefaultCellEditor boxEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
                column = this.kdtConfigure.getColumn("importFileField");
                column.setEditor((ICellEditor)boxEditor);
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                EntityObjectInfo destEntity = loader.getEntity(new ProjectTask().getType());
                IBotpMetaData destBotpEntity = BotpMetaDataFactory.createEntity((EntityObjectInfo)destEntity);
                this.buildHeadRuleRow(destBotpEntity);
            }
            catch (Exception e1) {
                throw new Exception(e1);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    public List getTaskLevel1(ProjectFile mpx) {
        if (mpx == null) {
            return null;
        }
        List tasks = mpx.getChildTasks();
        List taskLevel1 = null;
        if (tasks != null && tasks.size() > 1) {
            return tasks;
        }
        if (tasks != null && tasks.size() == 1) {
            Task rootTask = (Task)tasks.get(0);
            this.srcProject = new ProjectInfo();
            this.srcProject.setName(rootTask.getName());
            this.srcProject.setPlanBeginTime(this.toTimestamp(rootTask.getStart()));
            this.srcProject.setPlanEndTime(this.toTimestamp(rootTask.getFinish()));
            taskLevel1 = ((Task)tasks.get(0)).getChildTasks();
        }
        return taskLevel1;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        int rowCount = this.kdtMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.kdtMain.getCell(i, "isSelected").setValue((Object)new Boolean(true));
        }
    }

    @Override
    public void actionCancelAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelAll_actionPerformed(e);
        int rowCount = this.kdtMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.kdtMain.getCell(i, "isSelected").setValue((Object)new Boolean(false));
        }
    }

    public String getSelectFile(boolean isSave, String[] ext) throws Exception {
        KDFileChooser chooser = new KDFileChooser(new File(this.path));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(GanttResourceUtil.getResource("Gantt_File"));
        for (int i = 0; i < ext.length; ++i) {
            chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(ext[i], ext[i]));
        }
        int returnVal = 0;
        returnVal = isSave ? chooser.showSaveDialog((Component)((Object)this)) : chooser.showOpenDialog((Component)((Object)this));
        String strFullPath = null;
        String fExt = null;
        if (returnVal == 0) {
            File file = chooser.getSelectedFile();
            strFullPath = file.getPath();
            fExt = chooser.getFileFilter().getDescription();
            int index = fExt.indexOf(".");
            fExt = fExt.substring(index + 1);
        }
        if (isSave && strFullPath != null && !strFullPath.endsWith("." + fExt)) {
            this.path = strFullPath;
            return strFullPath + "." + fExt;
        }
        if (strFullPath != null) {
            int index = 0;
            index = strFullPath.lastIndexOf("\\");
            this.path = strFullPath.substring(0, index);
        }
        return strFullPath;
    }

    private boolean toBoolean(String name) {
        return name != null && name.equalsIgnoreCase("true");
    }

    private void setTitle() {
        if (this.isTemplate) {
            this.setUITitle(ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "WBS_TEMPLATE_IMP"));
        } else {
            this.setUITitle(ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "WBS_IMP"));
        }
    }

    protected void initListener() {
        super.initListener();
        this.projectDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    WBSImportUI.this.prmtProject_dataChanged(e);
                }
                catch (Exception exc) {
                    WBSImportUI.this.handUIException(exc);
                }
            }
        };
        this.prmtProject.addDataChangeListener(this.projectDataChanged);
        this.prmtStorageOrgUnitDataChanged = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                OrgUnitInfo newValue = (OrgUnitInfo)e.getNewValue();
                OrgUnitInfo oldValue = (OrgUnitInfo)e.getOldValue();
                boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
                if (isDiffrent) {
                    WBSImportUI.this.prmtProject.setValue(null);
                    WBSImportUI.this.prmtParent.setValue(null);
                }
            }
        };
        this.prmtStorageOrgUnit.addDataChangeListener(this.prmtStorageOrgUnitDataChanged);
        this.importFileNameListener = new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    WBSImportUI.this.importFileName_dataChanged(e);
                }
                catch (Exception exc) {
                    WBSImportUI.this.handUIException(exc);
                }
            }
        };
        this.kdtConfigure.addKDTEditListener((KDTEditListener)this.importFileNameListener);
    }

    private void prmtProject_dataChanged(DataChangeEvent e) {
        ProjectInfo newValue;
        ProjectInfo oldValue = (ProjectInfo)e.getOldValue();
        boolean isDifferent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)(newValue = (ProjectInfo)e.getNewValue()));
        if (isDifferent && newValue != null) {
            this.prmtParent.setValue(null);
        }
    }

    private void getTaskTitles() {
        List titles = this.mpx.getTables();
        Table table = null;
        Column col = null;
        List colList = null;
        TaskField taskField = null;
        for (int i = 0; i < titles.size(); ++i) {
            table = (Table)titles.get(i);
            colList = table.getColumns();
            if (table.getResourceFlag()) continue;
            for (int j = 0; j < colList.size(); ++j) {
                col = (Column)colList.get(j);
                taskField = (TaskField)col.getFieldType();
                if (!taskField.getName().equals(col.getTitle()) && !taskField.getName().equalsIgnoreCase("Task Name")) {
                    this.allTitleType.add(col.getTitle());
                }
                this.taskTitles.put(col.getTitle(), taskField);
            }
        }
    }

    private void setSelectTaskValue() {
        this.firstLevelTask = this.getTaskLevel1(this.mpx);
        Object valueObject = null;
        String fieldName = null;
        TaskField field = null;
        if (this.firstLevelTask != null) {
            this.titlesList.add(AllEnum.NULL);
            for (int i = 0; i < this.firstLevelTask.size(); ++i) {
                Task task = (Task)this.firstLevelTask.get(i);
                TimeUnit timeunit = task.getDuration().getUnits();
                BigDecimal total = null;
                if (timeunit.getValue() == 1) {
                    total = new BigDecimal(task.getDuration().getDuration() / 8.0);
                } else if (timeunit.getValue() == 2) {
                    total = new BigDecimal(task.getDuration().getDuration());
                }
                task.getText1();
                IRow row = this.kdtMain.addRow();
                row.getCell("id").setValue((Object)task.getID());
                row.getCell("isSelected").setValue((Object)new Boolean(false));
                row.getCell("name").setValue((Object)task.getName());
                if (total != null) {
                    row.getCell("totalTime").setValue((Object)new Double(total.doubleValue()));
                }
                row.getCell("beginTime").setValue((Object)task.getStart());
                row.getCell("endTime").setValue((Object)task.getFinish());
                for (int j = this.allTitleType.size() - 1; j >= 0; --j) {
                    fieldName = (String)this.allTitleType.get(j);
                    field = (TaskField)this.taskTitles.get(fieldName);
                    valueObject = task.getCachedValue(field);
                    if (valueObject == null) continue;
                    this.titlesList.add(fieldName);
                    this.allTitleType.remove(j);
                }
            }
        }
    }

    private void importFileName_dataChanged(KDTEditEvent e) {
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)e.getOldValue(), (Object)e.getValue());
        if (isDiffrent) {
            int colIndex = e.getColIndex();
            String fieldName = this.kdtConfigure.getColumnKey(colIndex);
            IRow row = this.kdtConfigure.getRow(e.getRowIndex());
            Object fieldValue = row.getCell("fieldName").getValue();
            if ("importFileField".equalsIgnoreCase(fieldName)) {
                if (e.getValue() == null || e.getValue() instanceof AllEnum) {
                    if (this.templetConnection.get(fieldValue) != null) {
                        this.templetConnection.remove(fieldValue);
                    }
                } else {
                    this.templetConnection.put(fieldValue, row.getCell("importFileField").getValue());
                }
            }
        }
    }

    private void buildHeadRuleRow(IBotpMetaData destBotpEntity) {
        ArrayList destBotpChildrenPropertyList = destBotpEntity.getChildren();
        Iterator iter = destBotpChildrenPropertyList.iterator();
        String name = null;
        IRow row = null;
        ICell cellKey = null;
        ICell cellName = null;
        String fieldName = null;
        String remarkName = null;
        while (iter.hasNext()) {
            IBotpMetaData childProperty = (IBotpMetaData)iter.next();
            if (childProperty.getCompositeRelateEntity() != null) {
                this.buildHeadRuleRow(childProperty);
                continue;
            }
            name = childProperty.getName();
            if (!this.isExistsInList(name)) continue;
            row = this.kdtConfigure.addRow();
            cellName = row.getCell("fieldName");
            cellName.getStyleAttributes().setLocked(true);
            cellName.setValue((Object)name);
            cellKey = row.getCell("taskField");
            cellKey.getStyleAttributes().setLocked(true);
            cellKey.setUserObject((Object)childProperty);
            if ("storageOrgUnit".equalsIgnoreCase(name)) {
                fieldName = this.getResourceMsg("fstorageOrgUnit");
                cellKey.setValue((Object)fieldName);
            } else if ("carNumber".equalsIgnoreCase(name)) {
                fieldName = this.getResourceMsg("fcarNumber");
                cellKey.setValue((Object)fieldName);
            } else {
                cellKey.setValue((Object)childProperty.getDisplayName());
            }
            cellName = row.getCell("configDescribe");
            cellName.getStyleAttributes().setLocked(true);
            remarkName = this.getResourceMsg(name);
            cellName.setValue((Object)remarkName);
        }
    }

    private boolean isExistsInList(String name) {
        boolean isExist = false;
        for (int i = 0; i < this.templeDateField.length; ++i) {
            if (!this.templeDateField[i].equalsIgnoreCase(name)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    private String getResourceMsg(String key) {
        return ResourceUtils.getMessage((String)RES_PRD_ORDER, (String)key);
    }
}

