/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.mm.common.util.ResourceManage;
import com.kingdee.eas.mm.project.IWBSRuler;
import com.kingdee.eas.mm.project.WBSRulerFactory;
import com.kingdee.eas.mm.project.WBSRulerInfo;
import com.kingdee.eas.mm.project.client.AbstractWBSRulerEditUI;
import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class WBSRulerEditUI
extends AbstractWBSRulerEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WBSRulerEditUI.class);
    private String COL_LEVEL = "level";
    private String COL_DIGITIS = "digists";
    private String projectid = null;
    private Boolean isModify = Boolean.TRUE;
    private Boolean isEditEnd = Boolean.FALSE;
    private WBSRulerInfo[] defaultWBSRulerInfos = null;
    private boolean isChanged = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.projectid = (String)this.getUIContext().get("PROJECTID");
        this.isModify = (Boolean)this.getUIContext().get("ISMODIFY");
        if (this.isModify == null) {
            this.isModify = Boolean.TRUE;
        }
        this.kdtMain.checkParsed();
        this.initWorkButon();
        this.initTable();
        this.initTableRows(this.projectid);
        this.txtPreNumber.setText(this.getWBSNumber());
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.isChanged = false;
        this.getBizInterface().save(this.defaultWBSRulerInfos);
        MsgBox.showInfo((String)ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "WBSRULER_SAVE_SUCC"));
        this.actionSave.setEnabled(false);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.kdtMain.getColumn(this.COL_DIGITIS).getStyleAttributes().setLocked(false);
        this.actionEdit.setEnabled(false);
    }

    public IWBSRuler getBizInterface() throws BOSException {
        return WBSRulerFactory.getRemoteInstance();
    }

    public void initWorkButon() {
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.txtPreNumber.setEditable(false);
        this.actionEdit.setEnabled(true);
        this.actionSave.setEnabled(false);
    }

    private void kdtMain_Changed(KDTEditEvent e) throws Exception {
        Object oldValue = e.getOldValue();
        Object newValue = e.getValue();
        boolean isDiffrent = SCMGroupClientUtils.isDiffrent((Object)oldValue, (Object)newValue);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (newValue == null) {
            this.kdtMain.getRow(rowIndex).getCell(this.COL_DIGITIS).setValue(oldValue);
            return;
        }
        if (isDiffrent && newValue instanceof Byte) {
            String oldIntValue;
            String newIntValue;
            isDiffrent = oldValue != null ? !(newIntValue = newValue.toString()).equalsIgnoreCase(oldIntValue = oldValue.toString()) : true;
        }
        if (isDiffrent) {
            this.isChanged = true;
            this.actionSave.setEnabled(true);
            if (this.kdtMain.getColumnKey(colIndex).equalsIgnoreCase(this.COL_DIGITIS)) {
                this.kdtMain.getRow(rowIndex).getCell(this.COL_DIGITIS).setValue(newValue);
            }
            this.defaultWBSRulerInfos[rowIndex].setDigists(Integer.parseInt(newValue.toString()));
            this.txtPreNumber.setText(this.getWBSNumber());
        }
    }

    private void initTable() {
        this.kdtMain.getColumn(this.COL_LEVEL).getStyleAttributes().setLocked(true);
        this.kdtMain.getStyleAttributes().setLocked(true);
        if (!this.isModify.booleanValue()) {
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(false);
        }
        KDFormattedTextField digitisField = new KDFormattedTextField();
        digitisField.setDataType(6);
        digitisField.setMinimumValue((Comparable)new Integer("1"));
        digitisField.setMaximumValue((Comparable)new Integer("5"));
        digitisField.setRemoveingZeroInDispaly(false);
        digitisField.setNegatived(false);
        this.kdtMain.getColumn(this.COL_DIGITIS).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtMain.getColumn(this.COL_DIGITIS).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)digitisField));
        this.kdtMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                WBSRulerEditUI.this.isEditEnd = Boolean.FALSE;
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    WBSRulerEditUI.this.kdtMain_Changed(e);
                    WBSRulerEditUI.this.isEditEnd = Boolean.TRUE;
                }
                catch (Exception exc) {
                    WBSRulerEditUI.this.handUIException(exc);
                }
            }
        });
    }

    public String getWBSNumber() {
        String wbs = "";
        if (this.defaultWBSRulerInfos == null) {
            return null;
        }
        for (int i = 0; i < this.defaultWBSRulerInfos.length; ++i) {
            WBSRulerInfo info = this.defaultWBSRulerInfos[i];
            for (int j = 0; j < info.getDigists() - 1; ++j) {
                wbs = wbs + "0";
            }
            wbs = wbs + "1";
            if (i == this.defaultWBSRulerInfos.length - 1) continue;
            wbs = wbs + ".";
        }
        return wbs;
    }

    private void initTableRows(String projectid) throws BOSException {
        IWBSRuler iWBSRuler = null;
        iWBSRuler = WBSRulerFactory.getRemoteInstance();
        this.defaultWBSRulerInfos = iWBSRuler.getWBSRuler(projectid);
        if (this.defaultWBSRulerInfos == null) {
            return;
        }
        for (int i = 0; i < this.defaultWBSRulerInfos.length; ++i) {
            WBSRulerInfo info = this.defaultWBSRulerInfos[i];
            this.kdtMain.checkParsed();
            IRow row = this.kdtMain.addRow();
            row.getCell(this.COL_LEVEL).setValue((Object)new Integer(info.getLevel()));
            row.getCell(this.COL_DIGITIS).setValue((Object)new Integer(info.getDigists()));
        }
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (!this.isEditEnd.booleanValue()) {
            this.kdtMain.getEditManager().editingStopped();
        }
        if (this.isChanged) {
            b = true;
            b = this.checkSaveChange();
        }
        return b;
    }

    private boolean checkSaveChange() {
        int result = MsgBox.showConfirm3((Component)((Object)this), (String)ResourceManage.getResource((String)"Confirm_Save_Exit"));
        if (result == 0) {
            try {
                this.actionSave_actionPerformed(null);
                return true;
            }
            catch (Exception e) {
                this.handUIException(e);
                return false;
            }
        }
        return result != 2;
    }

    public static void viewWBSRuler(String projectid, boolean isModify) throws UIException {
        UIContext ctx = new UIContext();
        ctx.put((Object)"PROJECTID", (Object)projectid);
        ctx.put((Object)"ISMODIFY", (Object)isModify);
        String uiClass = "com.kingdee.eas.mm.project.client.WBSRulerEditUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }
}

