/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttExportSettings;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Chart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartSelection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartSelectionListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartViewState;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.OptionsDialogAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IStatus;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.Status;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIConfiguration;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public abstract class ChartComponentBase
extends JPanel {
    public static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(12);
    protected final ChartViewState myChartViewState;
    private final IGanttProject myProject;
    private final ZoomManager myZoomManager;
    private MouseWheelListenerBase myMouseWheelListener;
    private final UIFacade myUIFacade;
    private OptionsDialogAction myOptionsDialogAction;

    public ChartComponentBase(IGanttProject project, UIFacade uiFacade, ZoomManager zoomManager) {
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.myZoomManager = zoomManager;
        this.myChartViewState = new ChartViewState(project, uiFacade);
        this.myChartViewState.addStateListener(new ChartViewState.Listener(){

            @Override
            public void startDateChanged(ChartViewState.ViewStateEvent e) {
                ChartComponentBase.this.repaint();
            }

            @Override
            public void zoomChanged(ZoomEvent e) {
                ChartComponentBase.this.getImplementation().zoomChanged(e);
            }
        });
        this.myMouseWheelListener = new MouseWheelListenerBase();
        this.addMouseListener(this.getMouseListener());
        this.addMouseMotionListener(this.getMouseMotionListener());
        this.addMouseWheelListener(this.myMouseWheelListener);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public ChartViewState getViewState() {
        return this.myChartViewState;
    }

    public ZoomListener getZoomListener() {
        return this.getImplementation();
    }

    public GPOptionGroup[] getOptionGroups() {
        return this.getChartModel().getChartOptionGroups();
    }

    public Chart createCopy() {
        return new AbstractChartImplementation(this.getChartModel().createCopy());
    }

    public ChartSelection getSelection() {
        return this.getImplementation().getSelection();
    }

    public IStatus canPaste(ChartSelection selection) {
        return this.getImplementation().canPaste(selection);
    }

    public void paste(ChartSelection selection) {
        this.getImplementation().paste(selection);
    }

    public void addSelectionListener(ChartSelectionListener listener) {
        this.getImplementation().addSelectionListener(listener);
    }

    public void removeSelectionListener(ChartSelectionListener listener) {
        this.getImplementation().removeSelectionListener(listener);
    }

    protected UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    protected TaskManager getTaskManager() {
        return this.myProject.getTaskManager();
    }

    protected TimeUnitStack getTimeUnitStack() {
        return this.myProject.getTimeUnitStack();
    }

    protected UIConfiguration getUIConfiguration() {
        return this.myProject.getUIConfiguration();
    }

    protected void setDefaultCursor() {
        this.setCursor(DEFAULT_CURSOR);
    }

    public Action getOptionsDialogAction() {
        if (this.myOptionsDialogAction == null) {
            this.myOptionsDialogAction = new OptionsDialogAction(this.getOptionGroups(), this.getUIFacade()){

                @Override
                protected Component createPreviewComponent() {
                    return ChartComponentBase.this.createPreviewComponent();
                }
            };
        }
        return this.myOptionsDialogAction;
    }

    protected Component createPreviewComponent() {
        return null;
    }

    protected abstract ChartModelBase getChartModel();

    protected abstract MouseListener getMouseListener();

    protected abstract MouseMotionListener getMouseMotionListener();

    protected abstract AbstractChartImplementation getImplementation();

    protected static class ChartSelectionImpl
    implements ChartSelection {
        private List myTasks = new ArrayList();
        private List myTasksRO = Collections.unmodifiableList(this.myTasks);
        private List myHumanResources = new ArrayList();
        private List myHumanResourceRO = Collections.unmodifiableList(this.myHumanResources);
        private boolean isTransactionRunning;

        protected ChartSelectionImpl() {
        }

        @Override
        public boolean isEmpty() {
            return this.myTasks.isEmpty() && this.myHumanResources.isEmpty();
        }

        @Override
        public List getTasks() {
            return this.myTasksRO;
        }

        @Override
        public List getHumanResources() {
            return this.myHumanResourceRO;
        }

        @Override
        public IStatus isDeletable() {
            return Status.OK_STATUS;
        }

        @Override
        public void startCopyClipboardTransaction() {
            if (this.isTransactionRunning) {
                throw new IllegalStateException("Transaction is already running");
            }
            this.isTransactionRunning = true;
        }

        @Override
        public void startMoveClipboardTransaction() {
            if (this.isTransactionRunning) {
                throw new IllegalStateException("Transaction is already running");
            }
            this.isTransactionRunning = true;
        }

        @Override
        public void cancelClipboardTransaction() {
            this.isTransactionRunning = false;
        }

        @Override
        public void commitClipboardTransaction() {
            this.isTransactionRunning = false;
        }
    }

    public class AbstractChartImplementation
    implements Chart,
    ZoomListener {
        private ChartModelBase myChartModel;
        private Set mySelectionListeners = new LinkedHashSet();
        private MouseInteraction myActiveInteraction;

        public AbstractChartImplementation() {
        }

        private AbstractChartImplementation(ChartModelBase chartModel) {
            this.myChartModel = chartModel;
        }

        public void beginScrollViewInteraction(MouseEvent e) {
            this.setActiveInteraction(new ScrollViewInteraction(e));
        }

        public MouseInteraction finishInteraction() {
            try {
                if (this.getActiveInteraction() != null) {
                    this.getActiveInteraction().finish();
                }
                MouseInteraction mouseInteraction = this.getActiveInteraction();
                return mouseInteraction;
            }
            finally {
                this.setActiveInteraction(null);
            }
        }

        protected void setActiveInteraction(MouseInteraction myActiveInteraction) {
            this.myActiveInteraction = myActiveInteraction;
        }

        public MouseInteraction getActiveInteraction() {
            return this.myActiveInteraction;
        }

        @Override
        public void zoomChanged(ZoomEvent e) {
            ChartComponentBase.this.invalidate();
            ChartComponentBase.this.repaint();
        }

        public void paintComponent(Graphics g) {
        }

        private ChartModelBase getChartModel() {
            return this.myChartModel == null ? ChartComponentBase.this.getChartModel() : this.myChartModel;
        }

        @Override
        public RenderedImage getRenderedImage(GanttExportSettings settings) {
            return null;
        }

        @Override
        public BufferedImage getChart(GanttExportSettings settings) {
            return null;
        }

        @Override
        public Date getStartDate() {
            return this.getChartModel().getStartDate();
        }

        @Override
        public Date getEndDate() {
            return this.getChartModel().getEndDate();
        }

        @Override
        public String getName() {
            return ChartComponentBase.this.getName();
        }

        @Override
        public void setTaskManager(TaskManager taskManager) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public GPOptionGroup[] getOptionGroups() {
            return this.getChartModel().getChartOptionGroups();
        }

        @Override
        public Chart createCopy() {
            return new AbstractChartImplementation(this.getChartModel().createCopy());
        }

        @Override
        public Object getAdapter(Class arg0) {
            return null;
        }

        @Override
        public ChartSelection getSelection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IStatus canPaste(ChartSelection selection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void paste(ChartSelection selection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSelectionListener(ChartSelectionListener listener) {
            this.mySelectionListeners.add(listener);
        }

        @Override
        public void removeSelectionListener(ChartSelectionListener listener) {
            this.mySelectionListeners.remove(listener);
        }

        protected void fireSelectionChanged() {
            for (ChartSelectionListener nextListener : this.mySelectionListeners) {
                nextListener.selectionChanged();
            }
        }
    }

    protected class MouseWheelListenerBase
    implements MouseWheelListener {
        protected MouseWheelListenerBase() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (this.isRotationUp(e)) {
                this.fireZoomOut();
            } else {
                this.fireZoomIn();
            }
        }

        private void fireZoomIn() {
            if (ChartComponentBase.this.myZoomManager.canZoomIn()) {
                ChartComponentBase.this.myZoomManager.zoomIn();
            }
        }

        private void fireZoomOut() {
            if (ChartComponentBase.this.myZoomManager.canZoomOut()) {
                ChartComponentBase.this.myZoomManager.zoomOut();
            }
        }

        private boolean isRotationUp(MouseWheelEvent e) {
            return e.getWheelRotation() < 0;
        }
    }

    protected class MouseMotionListenerBase
    extends MouseMotionAdapter {
        protected MouseMotionListenerBase() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            MouseInteraction activeInteraction = ChartComponentBase.this.getImplementation().getActiveInteraction();
            if (activeInteraction != null) {
                activeInteraction.apply(e);
            }
        }
    }

    protected class MouseListenerBase
    extends MouseAdapter {
        public JPopupMenu menu;

        protected MouseListenerBase() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger() || e.getButton() == 3) {
                Action[] actions = this.getPopupMenuActions();
                if (actions.length > 0) {
                    this.menu = ChartComponentBase.this.getUIFacade().showPopupMenu(ChartComponentBase.this, actions, e.getX(), e.getY());
                }
                return;
            }
            switch (e.getButton()) {
                case 1: {
                    this.processLeftButton(e);
                    break;
                }
            }
        }

        private void processLeftButton(MouseEvent e) {
            ChartComponentBase.this.getImplementation().beginScrollViewInteraction(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            ChartComponentBase.this.getImplementation().finishInteraction();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ChartComponentBase.this.setDefaultCursor();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ChartComponentBase.this.setCursor(new Cursor(0));
        }

        protected Action[] getPopupMenuActions() {
            return new Action[0];
        }
    }

    protected class ScrollViewInteraction
    extends MouseInteractionBase
    implements MouseInteraction {
        private float myPreviousAbsoluteDiff;

        protected ScrollViewInteraction(MouseEvent e) {
            super(e);
        }

        @Override
        public void apply(MouseEvent event) {
            float absoluteDiff = this.getLengthDiff(event);
            float relativeDiff = this.myPreviousAbsoluteDiff - absoluteDiff;
            TaskLength diff = ChartComponentBase.this.getTaskManager().createLength(ChartComponentBase.this.getViewState().getBottomTimeUnit(), relativeDiff);
            float daysF = diff.getLength(ChartComponentBase.this.getTimeUnitStack().getDefaultTimeUnit());
            int days = (int)daysF;
            if (days == 0) {
                return;
            }
            if (days > 0) {
                ChartComponentBase.this.getUIFacade().getScrollingManager().scrollRight();
            }
            if (days < 0) {
                ChartComponentBase.this.getUIFacade().getScrollingManager().scrollLeft();
            }
            this.myPreviousAbsoluteDiff = absoluteDiff;
        }

        @Override
        public void finish() {
        }
    }

    protected abstract class MouseInteractionBase {
        private int myStartX;

        protected MouseInteractionBase(MouseEvent e) {
            this.myStartX = e.getX();
        }

        protected float getLengthDiff(MouseEvent event) {
            float diff = ChartComponentBase.this.getChartModel().calculateLength(this.myStartX, event.getX(), event.getY());
            return diff;
        }

        public void paint(Graphics g) {
        }

        protected int getStartX() {
            return this.myStartX;
        }
    }

    protected static interface MouseInteraction {
        public void apply(MouseEvent var1);

        public void finish();

        public void paint(Graphics var1);
    }
}

