/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.CustomPropertyDefinition;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.org.w3c.util.DateParser;
import com.kingdee.eas.mm.project.client.gantt.org.w3c.util.InvalidDateException;
import java.util.GregorianCalendar;
import java.util.List;

public interface CustomPropertyManager {
    public List getDefinitions();

    public CustomPropertyDefinition createDefinition(String var1, String var2, String var3, String var4);

    public static class PropertyTypeEncoder {
        public static String encodeFieldType(Class fieldType) {
            String result = null;
            if (fieldType.equals(String.class)) {
                result = "text";
            } else if (fieldType.equals(Boolean.class)) {
                result = "boolean";
            } else if (fieldType.equals(Integer.class)) {
                result = "int";
            } else if (fieldType.equals(Double.class)) {
                result = "double";
            } else if (fieldType.isAssignableFrom(GregorianCalendar.class)) {
                result = "date";
            }
            return result;
        }

        public static CustomPropertyDefinition decodeTypeAndDefaultValue(final String typeAsString, final String valueAsString) {
            Object defaultValue;
            Class type;
            if (typeAsString.equals("text")) {
                type = String.class;
                defaultValue = valueAsString.toString();
            } else if (typeAsString.equals("boolean")) {
                type = Boolean.class;
                defaultValue = Boolean.valueOf(valueAsString);
            } else if (typeAsString.equals("int")) {
                type = Integer.class;
                defaultValue = Integer.valueOf(valueAsString);
            } else if (typeAsString.equals("double")) {
                type = Double.class;
                defaultValue = Double.valueOf(valueAsString);
            } else if (typeAsString.equals("date")) {
                type = GregorianCalendar.class;
                GanttCalendar c = null;
                try {
                    c = new GanttCalendar(DateParser.parse(valueAsString));
                }
                catch (InvalidDateException e) {
                    e.printStackTrace();
                }
                defaultValue = c;
            } else {
                type = String.class;
                defaultValue = "";
            }
            return new CustomPropertyDefinition(){

                @Override
                public Object getDefaultValue() {
                    return defaultValue;
                }

                @Override
                public String getDefaultValueAsString() {
                    return valueAsString;
                }

                @Override
                public String getID() {
                    return null;
                }

                @Override
                public String getName() {
                    return null;
                }

                @Override
                public Class getType() {
                    return type;
                }

                @Override
                public String getTypeAsString() {
                    return typeAsString;
                }
            };
        }
    }
}

