/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTreeTableModel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ModifyStandDate;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.TreeTableCellEditorImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.UIInstanceOf;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencySlice;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.DateUtils;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.jdesktop.jdnc.JNTreeTable;
import org.jdesktop.swing.JXTreeTable;
import org.jdesktop.swing.table.TableColumnExt;
import org.jdesktop.swing.treetable.TreeTableModel;

class GPTreeTableBase
extends JNTreeTable {
    public GanttProject project;
    private static final long serialVersionUID = -2558392926149658826L;

    protected GPTreeTableBase(TreeTableModel model, GanttProject myProject) {
        super(new JXTreeTable(model){
            private static final long serialVersionUID = -8573069410199311688L;

            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.isAltDown() || e.isControlDown()) {
                    this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
                }
                boolean result = super.processKeyBinding(ks, e, condition, pressed);
                this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
                return result;
            }

            public String getToolTipText(MouseEvent arg0) {
                String s = null;
                try {
                    TableColumnExt columnExt = this.getColumnExt(this.columnAtPoint(arg0.getPoint()));
                    int row = this.rowAtPoint(arg0.getPoint());
                    int col = this.columnAtPoint(arg0.getPoint());
                    Object obj = this.getValueAt(row, col);
                    s = columnExt.getTitle() + ":" + (obj == null ? "" : obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return s;
            }
        });
    }

    protected TableColumnExt newTableColumnExt(int modelIndex) {
        TableColumnExt result = new TableColumnExt(modelIndex);
        TableCellEditor defaultEditor = this.getTreeTable().getDefaultEditor(this.getTreeTableModel().getColumnClass(modelIndex));
        if (defaultEditor != null) {
            result.setCellEditor((TableCellEditor)new TreeTableCellEditorImpl(defaultEditor));
        }
        return result;
    }

    protected TableCellEditor newDateCellEditor() {
        return new DateCellEditor();
    }

    public GanttProject getGanttProject() {
        return null;
    }

    class EndDateCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -5802769152605502670L;
        private final Color colorNormal;
        private final Color colorError;
        private Date date;

        public EndDateCellEditor() {
            super(new JTextField());
            this.colorNormal = null;
            this.colorError = new Color(255, 125, 125);
            this.date = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            int taskIdColumnIndex = -1;
            for (int i = 0; i < arg0.getColumnCount(); ++i) {
                if (!arg0.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                taskIdColumnIndex = i;
                break;
            }
            int taskId = Integer.parseInt(arg0.getValueAt(arg3, taskIdColumnIndex).toString());
            GanttTask task = GPTreeTableBase.this.project.getTaskManager().getTask(taskId);
            TaskNode taskNode = (TaskNode)GPTreeTableBase.this.project.getTree().getNode(task.getTaskID());
            if (!taskNode.isLeaf()) {
                return null;
            }
            if (UIInstanceOf.isUI(GPTreeTableBase.this.getGanttProject(), 4) && task.getCompletionPercentage() == 100.0f) {
                return null;
            }
            JTextField result = (JTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            this.getComponent().setBackground(this.colorNormal);
            GPTreeTableBase.this.project.currentEditCell = this;
            String dateString = ((JTextComponent)this.getComponent()).getText();
            try {
                this.date = DateUtils.parseDate(dateString, GanttLanguage.getInstance().getLocale());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return result;
        }

        @Override
        public Object getCellEditorValue() {
            String dateString = ((JTextComponent)this.getComponent()).getText();
            try {
                if (!ModifyStandDate.validateDate(dateString)) {
                    throw new ParseException("", 1);
                }
                this.date = DateUtils.parseDate(dateString, GanttLanguage.getInstance().getLocale());
                this.getComponent().setBackground(this.colorNormal);
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
            }
            return new GanttCalendar(this.date == null ? new Date() : this.date);
        }

        @Override
        public boolean stopCellEditing() {
            boolean res = true;
            try {
                String dateString = ((JTextComponent)this.getComponent()).getText();
                if (!ModifyStandDate.validateDate(dateString)) {
                    throw new ParseException("", 1);
                }
                this.getComponent().setBackground(this.colorNormal);
                super.fireEditingStopped();
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
                this.getComponent().setBackground(this.colorError);
                res = false;
            }
            return res;
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }
    }

    class StartDateCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -5802769152605502670L;
        private final Color colorNormal;
        private final Color colorError;
        private Date date;
        JTable table;
        int row;

        public StartDateCellEditor() {
            super(new JTextField());
            this.colorNormal = null;
            this.colorError = new Color(255, 125, 125);
            this.date = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            this.table = arg0;
            this.row = arg3;
            int taskIdColumnIndex = -1;
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                if (!this.table.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                taskIdColumnIndex = i;
                break;
            }
            int taskId = Integer.parseInt(this.table.getValueAt(this.row, taskIdColumnIndex).toString());
            GanttTask task = GPTreeTableBase.this.project.getTaskManager().getTask(taskId);
            TaskNode taskNode = (TaskNode)GPTreeTableBase.this.project.getTree().getNode(task.getTaskID());
            if (!taskNode.isLeaf()) {
                return null;
            }
            try {
                this.date = DateUtils.parseDate(arg0.getValueAt(arg3, arg4).toString(), GanttLanguage.getInstance().getLocale());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
            if (UIInstanceOf.isUI(GPTreeTableBase.this.getGanttProject(), 4)) {
                if (this.date.before(ModifyStandDate.getStandDate()) && task.getCompletionPercentage() != 0.0f) {
                    return null;
                }
                if (task.getCompletionPercentage() == 100.0f) {
                    return null;
                }
            }
            JTextField result = (JTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            this.getComponent().setBackground(this.colorNormal);
            GPTreeTableBase.this.project.currentEditCell = this;
            return result;
        }

        @Override
        public Object getCellEditorValue() {
            String dateString = ((JTextComponent)this.getComponent()).getText();
            try {
                if (!ModifyStandDate.validateDate(dateString)) {
                    throw new ParseException("", 1);
                }
                Date temp = DateUtils.parseDate(dateString, GanttLanguage.getInstance().getLocale());
                if (UIInstanceOf.isUI(GPTreeTableBase.this.getGanttProject(), 4) && temp.before(ModifyStandDate.getStandDate())) {
                    throw new ParseException("", 1);
                }
                if (!this.validateStartDate(temp)) {
                    throw new ParseException("", 1);
                }
                this.date = temp;
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
            return new GanttCalendar(this.date == null ? new Date() : this.date);
        }

        @Override
        public boolean stopCellEditing() {
            boolean res = true;
            try {
                String dateString = ((JTextComponent)this.getComponent()).getText();
                if (!ModifyStandDate.validateDate(dateString)) {
                    throw new ParseException("", 1);
                }
                Date temp = DateUtils.parseDate(dateString, GanttLanguage.getInstance().getLocale());
                this.getComponent().setBackground(this.colorNormal);
                if (UIInstanceOf.isUI(GPTreeTableBase.this.getGanttProject(), 4) && temp.before(ModifyStandDate.getStandDate())) {
                    throw new ParseException("", 1);
                }
                if (!this.validateStartDate(temp)) {
                    throw new ParseException("", 1);
                }
                super.fireEditingStopped();
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
                this.getComponent().setBackground(this.colorError);
                res = false;
            }
            return res;
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }

        public boolean validateStartDate(Date validateDate) {
            boolean b = true;
            int taskIdColumnIndex = -1;
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                if (!this.table.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                taskIdColumnIndex = i;
                break;
            }
            int taskId = Integer.parseInt(this.table.getValueAt(this.row, taskIdColumnIndex).toString());
            GanttTask task = GPTreeTableBase.this.project.getTaskManager().getTask(taskId);
            TaskDependencySlice dependencySlice = task.getDependenciesAsDependant();
            TaskDependency[] dependencies = dependencySlice.toArray();
            for (int i = 0; i < dependencies.length; ++i) {
                TaskDependency dependency = dependencies[i];
                Task temp = dependency.getDependee();
                if (!temp.getEnd().getTime().after(validateDate)) continue;
                int rtn = MsgBox.showConfirm2((String)GanttResourceUtil.getResource("Gantt_DeleteLinkAndChange"));
                if (0 == rtn) {
                    task.getDependencies().clear();
                    continue;
                }
                this.date = task.getStart().getTime();
                b = false;
            }
            return b;
        }
    }

    class DateCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -5802769152605502670L;
        private final Color colorNormal;
        private final Color colorError;
        private Date date;

        public DateCellEditor() {
            super(new JTextField());
            this.colorNormal = null;
            this.colorError = new Color(255, 125, 125);
            this.date = null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            JTextField result = (JTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            this.getComponent().setBackground(this.colorNormal);
            return result;
        }

        @Override
        public Object getCellEditorValue() {
            return new GanttCalendar(this.date == null ? new Date() : this.date);
        }

        @Override
        public boolean stopCellEditing() {
            boolean res = true;
            try {
                String dateString = ((JTextComponent)this.getComponent()).getText();
                this.date = DateUtils.parseDate(dateString, GanttLanguage.getInstance().getLocale());
                this.getComponent().setBackground(this.colorNormal);
                if (UIInstanceOf.isUI(GPTreeTableBase.this.getGanttProject(), 4) && this.date.before(ModifyStandDate.getStandDate())) {
                    return false;
                }
                super.fireEditingStopped();
            }
            catch (ParseException e) {
                Toolkit.getDefaultToolkit().beep();
                this.getComponent().setBackground(this.colorError);
                res = false;
            }
            return res;
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }
    }
}

