/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;
import com.kingdee.eas.mm.project.client.gantt.org.w3c.util.DateParser;
import com.kingdee.eas.mm.project.client.gantt.org.w3c.util.InvalidDateException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class GanttCalendar
extends GregorianCalendar
implements Serializable {
    private static final long serialVersionUID = -2013372683597317874L;
    private GanttLanguage language = GanttLanguage.getInstance();
    private boolean isFixed;

    public boolean isFixed() {
        return this.isFixed;
    }

    public void setFixed(boolean fixed) {
        this.isFixed = fixed;
    }

    public GanttCalendar() {
        this.set(11, 0);
        this.set(12, 0);
        this.set(13, 0);
        this.set(14, 0);
    }

    public GanttCalendar(int year, int month, int date) {
        super(year, month, date);
    }

    public GanttCalendar(GanttCalendar g) {
        super(g.getYear(), g.getMonth(), g.getDate());
    }

    public GanttCalendar(Date date) {
        this.setTime(date);
    }

    public static GanttCalendar parseXMLDate(String s) {
        return GanttCalendar.parseXMLDate(s, "/");
    }

    public static GanttCalendar parseXMLDate(String s, String parseString) {
        GanttCalendar result = new GanttCalendar();
        result.clear();
        try {
            Date date = DateParser.parse(s);
            result.setTime(date);
        }
        catch (InvalidDateException e) {
            int fb = s.indexOf(parseString);
            int sb = s.indexOf(parseString, fb + 1);
            String d = s.substring(0, fb);
            String m = s.substring(fb + 1, sb);
            String y = s.substring(sb + 1);
            result.set(1, new Integer(y).hashCode());
            result.set(2, new Integer(m).hashCode() - 1);
            result.set(5, new Integer(d).hashCode());
        }
        return result;
    }

    public GanttCalendar Clone() {
        GanttCalendar clone = new GanttCalendar(this.getYear(), this.getMonth(), this.getDay());
        clone.setFixed(this.isFixed());
        return clone;
    }

    @Override
    public String toString() {
        return DateParser.getIsoDateNoHours(this.getTime());
    }

    public String toXMLString() {
        return DateParser.getIsoDateNoHours(this.getTime());
    }

    public int getYear() {
        return this.get(1);
    }

    public int getMonth() {
        return this.get(2);
    }

    public int getDate() {
        return this.get(5);
    }

    public int getDay() {
        return this.get(5);
    }

    public int getDayWeek() {
        return this.get(7);
    }

    public int getWeek() {
        return this.get(3);
    }

    public String[] getDayMonthLanguage() {
        String[] res = new String[12];
        for (int i = 0; i < 12; ++i) {
            res[i] = this.language.getMonth(i);
        }
        return res;
    }

    public String[] getDayWeekLanguage() {
        String[] res = new String[7];
        for (int i = 0; i < 7; ++i) {
            res[i] = this.language.getDay(i);
        }
        return res;
    }

    public void setYear(int y) {
        this.set(1, y);
    }

    public void setMonth(int m) {
        this.set(2, m);
    }

    public void setDay(int d) {
        this.set(5, d);
    }

    public void add(int dayNumber) {
        this.add(5, dayNumber);
    }

    public GanttCalendar newAdd(int dayNumber) {
        GanttCalendar gc = new GanttCalendar(this.getYear(), this.getMonth(), this.getDate());
        gc.add(5, dayNumber);
        return gc;
    }

    public int diff(GanttCalendar d) {
        GanttCalendar d2;
        GanttCalendar d1;
        int res = 0;
        if (this.compareTo(d) == 0) {
            return res;
        }
        if (this.compareTo(d) < 0) {
            d1 = this.Clone();
            d2 = new GanttCalendar(d);
        } else {
            d1 = new GanttCalendar(d);
            d2 = this.Clone();
        }
        while (d1.compareTo(d2) != 0) {
            d1.add(1);
            ++res;
        }
        return res;
    }

    public String getdayMonth() {
        return this.language.getMonth(this.getMonth());
    }

    public String getdayWeek() {
        return this.language.getDay(this.get(7) - 1);
    }

    public int getNumberOfDay() {
        return this.getActualMaximum(5);
    }

    private int module(int number) {
        if (number > 0) {
            return 1;
        }
        if (number < 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(GanttCalendar when) {
        int[] comparissons = new int[]{1, 2, 5};
        for (int i = 0; i < comparissons.length; ++i) {
            switch (this.module(this.get(comparissons[i]) - when.get(comparissons[i]))) {
                case -1: {
                    return -1;
                }
                case 1: {
                    return 1;
                }
            }
        }
        return 0;
    }

    public boolean equals(GanttCalendar when) {
        return this.getYear() == when.getYear() && this.getMonth() == when.getMonth() && this.getDay() == when.getDay();
    }

    public void goNextMonth() {
        this.add(2, 1);
    }

    public void goPrevMonth() {
        this.add(2, -1);
    }

    public void go(int field, int value) {
        this.add(field, value);
    }

    public static String getDateAndTime() {
        GanttCalendar c = new GanttCalendar();
        return c.toString() + " - " + GanttLanguage.getInstance().formatTime(c);
    }

    @Override
    public int compareTo(Calendar o) {
        return this.compareTo((GanttCalendar)o);
    }
}

