/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.task.LinkTasksAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.task.UnlinkTasksAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Chart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IAdaptable;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TaskTreeUIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class GanttChartTabContentPanel
implements IAdaptable {
    private KDSplitPane mySplitPane;
    private Component myTaskTree;
    private final Component myGanttChart;
    private final TaskTreeUIFacade myTreeFacade;
    private JPanel myTabContentPanel;
    private final IGanttProject myProject;
    private final UIFacade myWorkbenchFacade;

    GanttChartTabContentPanel(IGanttProject project, UIFacade workbenchFacade, TaskTreeUIFacade treeFacade, Component ganttChart) {
        this.myProject = project;
        this.myWorkbenchFacade = workbenchFacade;
        this.myTreeFacade = treeFacade;
        this.myTaskTree = treeFacade.getTreeComponent();
        this.myGanttChart = ganttChart;
    }

    Component getComponent() {
        if (this.myTabContentPanel == null) {
            JPanel left = new JPanel(new BorderLayout());
            left.add(this.myTaskTree, "Center");
            left.setPreferredSize(new Dimension(315, 600));
            left.setBackground(new Color(102, 153, 153));
            JPanel right = new JPanel(new BorderLayout());
            right.add(this.myGanttChart, "Center");
            this.mySplitPane = new KDSplitPane(1);
            if (GanttLanguage.getInstance().getComponentOrientation() == ComponentOrientation.LEFT_TO_RIGHT) {
                this.mySplitPane.setLeftComponent((Component)left);
                this.mySplitPane.setRightComponent((Component)right);
                this.mySplitPane.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            } else {
                this.mySplitPane.setRightComponent((Component)left);
                this.mySplitPane.setLeftComponent((Component)right);
                this.mySplitPane.setDividerLocation((int)(Toolkit.getDefaultToolkit().getScreenSize().getWidth() - left.getPreferredSize().getWidth()));
                this.mySplitPane.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            }
            this.mySplitPane.setOneTouchExpandable(true);
            this.mySplitPane.setPreferredSize(new Dimension(800, 500));
            this.myTabContentPanel = new JPanel(new BorderLayout());
            this.myTabContentPanel.setBorder(new EmptyBorder(new Insets(4, 2, 5, 5)));
            this.myTabContentPanel.add((Component)this.mySplitPane, "Center");
        }
        return this.myTabContentPanel;
    }

    private Component createButtonPanel() {
        Box buttonBar = Box.createHorizontalBox();
        buttonBar.add(Box.createHorizontalStrut(4));
        TestGanttRolloverButton unindentButton = new TestGanttRolloverButton(this.myTreeFacade.getUnindentAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add((Component)((Object)unindentButton));
        TestGanttRolloverButton indentButton = new TestGanttRolloverButton(this.myTreeFacade.getIndentAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add((Component)((Object)indentButton));
        buttonBar.add(Box.createHorizontalStrut(3));
        TestGanttRolloverButton upButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveUpAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add((Component)((Object)upButton));
        TestGanttRolloverButton downButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveDownAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add((Component)((Object)downButton));
        buttonBar.add(Box.createHorizontalStrut(3));
        LinkTasksAction linkAction = new LinkTasksAction(this.myProject.getTaskManager(), this.myProject.getTaskSelectionManager(), this.myWorkbenchFacade);
        this.myTreeFacade.setLinkTasksAction(linkAction);
        TestGanttRolloverButton linkButton = new TestGanttRolloverButton(linkAction){

            public String getText() {
                return null;
            }
        };
        linkButton.setText("link");
        UnlinkTasksAction unlinkAction = new UnlinkTasksAction(this.myProject.getTaskManager(), this.myProject.getTaskSelectionManager(), this.myWorkbenchFacade, this.myProject);
        if (((GanttProject)this.myProject).isOnlyViewer) {
            unlinkAction.setEnabled(false);
        }
        this.myTreeFacade.setUnlinkTasksAction(unlinkAction);
        TestGanttRolloverButton unlinkButton = new TestGanttRolloverButton(unlinkAction){

            public String getText() {
                return null;
            }
        };
        if (((GanttProject)this.myProject).isLinkVisible()) {
            buttonBar.add((Component)((Object)unlinkButton));
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)buttonBar, "West");
        return buttonPanel;
    }

    private Component createExeButtonPanel() {
        Box buttonBar = Box.createHorizontalBox();
        buttonBar.add(Box.createHorizontalStrut(4));
        TestGanttRolloverButton upButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveUpAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add((Component)((Object)upButton));
        TestGanttRolloverButton downButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveDownAction()){

            public String getText() {
                return null;
            }
        };
        buttonBar.add((Component)((Object)downButton));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)buttonBar, "West");
        return buttonPanel;
    }

    int getDividerLocation() {
        return this.mySplitPane.getDividerLocation();
    }

    void setDividerLocation(int location) {
        this.mySplitPane.setDividerLocation(location);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (Container.class.equals((Object)adapter)) {
            return this.getComponent();
        }
        if (Chart.class.equals((Object)adapter)) {
            return this.myGanttChart;
        }
        return null;
    }
}

