/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ChartComponentBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttExportSettings;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTree2;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ModifyStandDate;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ProjectEventListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.TaskTreeImageGenerator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.UIInstanceOf;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.GPAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.GraphicOptionsAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartSelection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.DependencyInteractionRenderer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.GanttChart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.PublicHolidayDialogAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.RenderedChartImage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.RenderedGanttChartImage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.TaskInteractionHintRenderer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.VisibleNodesFilter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.item.ChartItem;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.item.TaskBoundaryChartItem;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.item.TaskProgressChartItem;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.item.TaskRegularAreaChartItem;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IStatus;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.Status;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.font.Fonts;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIConfiguration;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueDispatcher;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.ChangeValueListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionChangeListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.scrolling.ScrollingManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.taskproperties.TaskDependenciesPanel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumsListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLengthImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskMutator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskSelectionManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.RecalculateTaskScheduleAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.constraint.FinishStartConstraintImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskDependencyEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskListenerAdapter;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.event.TaskScheduleEvent;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnit;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.GPUndoManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;

public class GanttGraphicArea
extends ChartComponentBase
implements GanttChart,
CustomColumsListener,
ProjectEventListener {
    private static final Cursor W_RESIZE_CURSOR;
    private static final Cursor E_RESIZE_CURSOR;
    private static final Cursor CHANGE_PROGRESS_CURSOR;
    private static final int HEADER_OFFSET = 3;
    public GanttTree2 tree;
    public static Color taskDefaultColor;
    private int margY;
    private GanttProject appli;
    private UIConfiguration myUIConfiguration;
    private Color myProjectLevelTaskColor;
    private final ChartModelImpl myChartModel;
    private final TaskManager myTaskManager;
    private GPUndoManager myUndoManager;
    private JTableHeader myTableHeader = null;
    private MouseEvent myLastMouseEvent = null;
    private JPanel myPreviewPanel;
    private TaskTreeImageGenerator myTaskImageGenerator;
    private ChartImplementation myChartComponentImpl;
    private ScrollGanttChartCenterAction myScrollCenterAction;
    JPopupMenu menu = null;

    public GanttGraphicArea(GanttProject app, GanttTree2 ttree, TaskManager taskManager, ZoomManager zoomManager, GPUndoManager undoManager) {
        super(app, app, zoomManager);
        this.setBackground(Color.WHITE);
        this.myPreviewPanel = new ChartOptionsPreviewPanel(app);
        this.myTaskManager = taskManager;
        this.myUndoManager = undoManager;
        this.myChartModel = new ChartModelImpl(this.getTaskManager(), app.getTimeUnitStack(), app.getUIConfiguration(), app);
        this.myChartModel.addOptionChangeListener(new GPOptionChangeListener(){

            @Override
            public void optionsChanged() {
                GanttGraphicArea.this.repaint();
            }
        });
        this.getViewState().addStateListener(this.myChartModel);
        this.getViewState().setStartDate(GregorianCalendar.getInstance().getTime());
        this.myTaskManager.addTaskListener(new TaskListenerAdapter(){

            @Override
            public void taskScheduleChanged(TaskScheduleEvent e) {
                this.adjustDependencies((Task)e.getSource());
            }

            @Override
            public void dependencyAdded(TaskDependencyEvent e) {
                this.adjustDependencies(e.getDependency().getDependee());
                GanttGraphicArea.this.repaint();
            }

            @Override
            public void dependencyRemoved(TaskDependencyEvent e) {
                GanttGraphicArea.this.repaint();
            }

            private void adjustDependencies(Task task) {
                RecalculateTaskScheduleAlgorithm alg = GanttGraphicArea.this.myTaskManager.getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm();
                try {
                    alg.run(task);
                }
                catch (TaskDependencyException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.tree = ttree;
        this.margY = 0;
        this.appli = app;
        this.myTableHeader = this.tree.getTreeTable().getTable().getTableHeader();
        this.tree.getTreeTable().getCustomColumnsManager().addCustomColumnsListener(this);
        this.myTaskImageGenerator = new TaskTreeImageGenerator(ttree, app.getUIConfiguration());
    }

    public Color getTaskColor() {
        return this.myUIConfiguration.getTaskColor();
    }

    public void setProjectLevelTaskColor(Color c) {
        this.myProjectLevelTaskColor = c;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(465, 600);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.myChartModel.setBounds(this.getSize());
        this.myChartComponentImpl.paintComponent(g);
    }

    public ChartModelImpl getMyChartModel() {
        return this.myChartModel;
    }

    public void drawGPVersion(Graphics g) {
        g.setColor(Color.black);
        g.setFont(Fonts.GP_VERSION_FONT);
        g.drawString("GanttProject (2.0.2)", 3, this.getHeight() + 18);
    }

    public void setScrollBar(int v) {
        this.margY = v;
    }

    public int getScrollBar() {
        return this.margY;
    }

    @Override
    public String getName() {
        return GanttLanguage.getInstance().getText("gantt");
    }

    @Override
    public Date getStartDate() {
        GanttCalendar pstart = new GanttCalendar(this.getTaskManager().getProjectStart());
        GanttCalendar st = pstart.Clone();
        return st.getTime();
    }

    @Override
    public Date getEndDate() {
        TaskLength projectLength = this.getTaskManager().getProjectLength();
        GanttCalendar pstart = new GanttCalendar(this.getTaskManager().getProjectStart());
        pstart.add((int)projectLength.getLength());
        GanttCalendar end = pstart.Clone();
        return end.getTime();
    }

    @Override
    public BufferedImage getChart(GanttExportSettings settings) {
        RenderedChartImage renderedImage = (RenderedChartImage)this.getRenderedImage(settings);
        BufferedImage result = renderedImage.getWholeImage();
        this.repaint();
        return result;
    }

    @Override
    public RenderedImage getRenderedImage(GanttExportSettings settings) {
        Date dateStart = null;
        Date dateEnd = null;
        List myItemsToConsider = this.myTaskImageGenerator.getPrintableNodes(settings);
        TimeUnit unit = this.getViewState().getBottomTimeUnit();
        dateStart = settings.getStartDate() == null ? this.getStartDate() : settings.getStartDate();
        Date date = dateEnd = settings.getEndDate() == null ? this.getEndDate() : settings.getEndDate();
        if (dateStart.after(dateEnd)) {
            Date tmp = (Date)dateStart.clone();
            dateStart = (Date)dateEnd.clone();
            dateEnd = tmp;
        }
        TaskLength printedLength = this.getTaskManager().createLength(unit, dateStart, dateEnd);
        BufferedImage taskImage = (BufferedImage)this.myTaskImageGenerator.createImage(myItemsToConsider);
        int chartWidth = (int)((printedLength.getLength(this.getViewState().getBottomTimeUnit()) + 1.0f) * (float)this.getViewState().getBottomUnitWidth());
        chartWidth = this.getWidth();
        int chartHeight = taskImage.getHeight(null);
        return new RenderedGanttChartImage(this.myChartModel, this.myChartComponentImpl, GanttTree2.convertNodesListToItemList(myItemsToConsider), taskImage, chartWidth, chartHeight);
    }

    private GanttTree2 getTree() {
        return this.tree;
    }

    IGanttProject getProject() {
        return this.appli;
    }

    GPUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    @Override
    public ChartModelBase getChartModel() {
        return this.myChartModel;
    }

    @Override
    protected MouseListener getMouseListener() {
        return this.getChartImplementation().getMouseListener();
    }

    @Override
    protected MouseMotionListener getMouseMotionListener() {
        return this.getChartImplementation().getMouseMotionListener();
    }

    private Action[] getPopupMenuActions() {
        if (UIInstanceOf.isUI(this.appli, 2)) {
            return new Action[]{new GraphicOptionsAction(this.getOptionGroups(), this.appli)};
        }
        return new Action[]{new GraphicOptionsAction(this.getOptionGroups(), this.appli), new PublicHolidayDialogAction(this.getProject(), this.getUIFacade())};
    }

    @Override
    protected Component createPreviewComponent() {
        return this.myPreviewPanel;
    }

    @Override
    public void repaint() {
        try {
            this.myChartModel.setHeaderHeight(this.myTableHeader.getHeight() + 3);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        super.repaint();
    }

    @Override
    protected ChartComponentBase.AbstractChartImplementation getImplementation() {
        return (ChartComponentBase.AbstractChartImplementation)((Object)this.getChartImplementation());
    }

    private ChartImplementation getChartImplementation() {
        if (this.myChartComponentImpl == null) {
            this.myChartComponentImpl = new NewChartComponentImpl();
        }
        return this.myChartComponentImpl;
    }

    public Action getScrollCenterAction(ScrollingManager scrollMgr, TaskSelectionManager taskSelMgr, String iconSize) {
        if (this.myScrollCenterAction == null) {
            this.myScrollCenterAction = new ScrollGanttChartCenterAction(scrollMgr, taskSelMgr, iconSize);
        }
        return this.myScrollCenterAction;
    }

    public void setPreviousStateTasks(ArrayList tasks) {
        int rowHeight = this.myChartModel.setPreviousStateTasks(tasks);
        this.appli.getTree().getTable().setRowHeight(rowHeight);
    }

    public void setLayerPosition(Graphics g, int x, int y, String[] title) {
        int posX = 0;
        int posY = 0;
        posX = x + 15;
        posY = y;
        if (y + 100 > this.getHeight()) {
            posY = this.getHeight() - 105;
        }
        if (x + 200 > this.getWidth()) {
            posX = this.getWidth() - 205;
            posY += 20;
        }
        if (y + 100 > this.getHeight() && x + 200 > this.getWidth()) {
            posY = y - 100 - 5;
            posX = x - 200 - 5;
        }
        Color myColor = new Color(255, 255, 204);
        g.setColor(myColor);
        g.fillRect(posX, posY, 200, 100);
        g.setColor(Color.black);
        g.drawRect(posX, posY, 200, 100);
        g.drawString(title[0], posX + 5, posY + 15);
        g.drawString(title[1], posX + 5, posY + 35);
        g.drawString(title[2], posX + 5, posY + 55);
        g.drawString(title[3], posX + 5, posY + 75);
        g.drawString(title[4], posX + 5, posY + 95);
    }

    @Override
    public void setTaskManager(TaskManager taskManager) {
    }

    @Override
    public void reset() {
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void customColumsChange(CustomColumEvent event) {
        this.repaint();
    }

    public void setUIConfiguration(UIConfiguration configuration) {
        this.myUIConfiguration = configuration;
    }

    @Override
    public void appendBlankRow() {
        this.tree.addBlankLine(null, -1);
    }

    @Override
    public void projectModified() {
    }

    @Override
    public void projectSaved() {
    }

    @Override
    public void projectClosed() {
        this.repaint();
        this.setProjectLevelTaskColor(null);
        this.setPreviousStateTasks(null);
    }

    public static Color setTaskDefaultColor(Color color) {
        taskDefaultColor = color;
        return taskDefaultColor;
    }

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL cursorResource = GanttGraphicArea.class.getClassLoader().getResource("icons/cursorpercent.gif");
        Image image = toolkit.getImage(cursorResource);
        CHANGE_PROGRESS_CURSOR = toolkit.createCustomCursor(image, new Point(10, 5), "CursorPercent");
        W_RESIZE_CURSOR = new Cursor(10);
        E_RESIZE_CURSOR = new Cursor(11);
        taskDefaultColor = new Color(0.549f, 0.713f, 0.807f);
    }

    public static class ChartOptionsPreviewPanel
    extends JPanel
    implements ChangeValueListener {
        Text upText;
        Text downText;
        Text leftText;
        Text rightText;
        TaskBar taskBar;
        GanttProject project;

        public ChartOptionsPreviewPanel(GanttProject myProject) {
            this.project = myProject;
            this.addToDispatchers();
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(450, 70));
            this.taskBar = new TaskBar();
            this.upText = new Text(2, this.taskBar);
            this.downText = new Text(3, this.taskBar);
            this.leftText = new Text(0, this.taskBar);
            this.rightText = new Text(1, this.taskBar);
        }

        void refresh() {
        }

        private void addToDispatchers() {
            List dispatchers = this.project.getChangeValueDispatchers();
            for (int i = 0; i < dispatchers.size(); ++i) {
                ((ChangeValueDispatcher)dispatchers.get(i)).addChangeValueListener(this);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.taskBar.paintMe(g);
            this.upText.paintMe(g);
            this.downText.paintMe(g);
            this.leftText.paintMe(g);
            this.rightText.paintMe(g);
        }

        @Override
        public void changeValue(ChangeValueEvent event) {
            Object id = event.getID();
            if (id.equals("up")) {
                this.upText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            } else if (id.equals("down")) {
                this.downText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            } else if (id.equals("left")) {
                this.leftText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            } else if (id.equals("right")) {
                this.rightText.text = ChartOptionsPreviewPanel.getI18n(event.getNewValue().toString());
            }
            this.repaint();
        }

        static String getI18n(String id) {
            String res = GanttLanguage.getInstance().getText("optionValue." + id + ".label");
            if (res.startsWith("Missing Resource")) {
                res = id;
            }
            return res;
        }

        private static class Text {
            static final Font FONT = Fonts.PREVIEW_BAR_FONT;
            static final int LEFT = 0;
            static final int RIGHT = 1;
            static final int UP = 2;
            static final int DOWN = 3;
            static final int MARGIN = 3;
            String text = "";
            int position;
            private int x;
            private int y;
            TaskBar taskBar;

            Text(int position, TaskBar refBar) {
                this.position = position;
                this.taskBar = refBar;
            }

            void paintMe(Graphics g) {
                this.calculateCoordinates(g);
                g.setFont(FONT);
                g.drawString(this.text, this.x, this.y);
            }

            private void calculateCoordinates(Graphics g) {
                int textHeight = g.getFontMetrics(FONT).getHeight();
                int textWidth = g.getFontMetrics(FONT).stringWidth(this.text);
                switch (this.position) {
                    case 2: {
                        this.y = this.taskBar.y - 3;
                        this.x = this.taskBar.x + this.taskBar.width / 2 - textWidth / 2;
                        break;
                    }
                    case 3: {
                        this.x = this.taskBar.x + this.taskBar.width / 2 - textWidth / 2;
                        this.y = this.taskBar.y + this.taskBar.height + textHeight - 3;
                        break;
                    }
                    case 0: {
                        this.y = this.taskBar.y + this.taskBar.height / 2 + textHeight / 2 - 3;
                        this.x = this.taskBar.x - 3 - textWidth;
                        break;
                    }
                    case 1: {
                        this.y = this.taskBar.y + this.taskBar.height / 2 + textHeight / 2 - 3;
                        this.x = this.taskBar.x + this.taskBar.width + 3;
                    }
                }
            }
        }

        class TaskBar {
            int width = 100;
            int height = 12;
            int x;
            int y;
            Color color;

            TaskBar() {
                this.x = (int)(ChartOptionsPreviewPanel.this.getPreferredSize().getWidth() / 2.0 - (double)(this.width / 2));
                this.y = (int)(ChartOptionsPreviewPanel.this.getPreferredSize().getHeight() / 2.0 - (double)(this.height / 2));
                this.color = new Color(140, 182, 206);
            }

            void paintMe(Graphics g) {
                g.setColor(this.color);
                g.fillRect(this.x, this.y, this.width, this.height);
                g.setColor(Color.BLACK);
                g.drawRect(this.x, this.y, this.width, this.height);
            }
        }
    }

    private class OldMouseMotionListenerImpl
    extends ChartComponentBase.MouseMotionListenerBase {
        private MouseSupport myMouseSupport;
        int preX;
        int preY;
        boolean titleDisplay;

        private OldMouseMotionListenerImpl() {
            this.myMouseSupport = new MouseSupport();
            this.preX = 0;
            this.preY = 0;
            this.titleDisplay = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ChartComponentBase.MouseInteraction mi = GanttGraphicArea.this.myChartComponentImpl.getActiveInteraction();
            if ((mi instanceof ChangeTaskBoundaryInteraction || mi instanceof DrawDependencyInteraction) && ((GanttGraphicArea)GanttGraphicArea.this).appli.isOnlyViewer) {
                return;
            }
            super.mouseDragged(e);
            if (GanttGraphicArea.this.myUIConfiguration.isCriticalPathOn() && (mi instanceof ChangeTaskBoundaryInteraction || mi instanceof MoveTaskInteraction || mi instanceof MoveTaskInteractions)) {
                GanttGraphicArea.this.appli.recalculateCriticalPath();
            }
            GanttGraphicArea.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Task taskUnderPoint;
            super.mouseDragged(e);
            ChartItem itemUnderPoint = this.myMouseSupport.getChartItemUnderMousePoint(e.getX(), e.getY());
            Task task = taskUnderPoint = itemUnderPoint == null ? null : itemUnderPoint.getTask();
            if (taskUnderPoint == null) {
                GanttGraphicArea.this.setDefaultCursor();
                this.preX = 0;
                this.preY = 0;
                GanttGraphicArea.this.getChartImplementation().beginSetNull();
            } else if (itemUnderPoint instanceof TaskBoundaryChartItem) {
                Cursor cursor = ((TaskBoundaryChartItem)itemUnderPoint).isStartBoundary() ? W_RESIZE_CURSOR : E_RESIZE_CURSOR;
                TaskNode taskNode = (TaskNode)GanttGraphicArea.this.appli.getTree().getNode(itemUnderPoint.getTask().getTaskID());
                if (!taskNode.isLeaf()) {
                    cursor = ChartComponentBase.DEFAULT_CURSOR;
                }
                if (((GanttGraphicArea)GanttGraphicArea.this).appli.isOnlyViewer) {
                    cursor = ChartComponentBase.DEFAULT_CURSOR;
                }
                GanttGraphicArea.this.getChartImplementation().beginSetNull();
            } else if (itemUnderPoint instanceof TaskProgressChartItem) {
                GanttGraphicArea.this.getChartImplementation().beginSetNull();
            } else if (itemUnderPoint instanceof TaskRegularAreaChartItem) {
                GanttGraphicArea.this.setDefaultCursor();
                GanttGraphicArea.this.getChartImplementation().beginShowTaskToolTipInteraction(e, taskUnderPoint);
            } else {
                GanttGraphicArea.this.setDefaultCursor();
                GanttGraphicArea.this.getChartImplementation().beginSetNull();
            }
            ChartComponentBase.MouseInteraction activeInteraction = GanttGraphicArea.this.getImplementation().getActiveInteraction();
            if (activeInteraction != null) {
                activeInteraction.apply(e);
            }
            GanttGraphicArea.this.repaint();
        }
    }

    private class OldChartMouseListenerImpl
    extends ChartComponentBase.MouseListenerBase
    implements MouseListener {
        private MouseSupport myMouseSupport;

        private OldChartMouseListenerImpl() {
            this.myMouseSupport = new MouseSupport();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Task taskUnderPointer;
            if (e.getButton() == 1 && (taskUnderPointer = this.myMouseSupport.findTaskUnderMousePointer(e.getX(), e.getY())) == null) {
                GanttGraphicArea.this.tree.selectTreeRow(-1);
            }
            if (e.getClickCount() != 2 || e.getButton() == 1) {
                // empty if block
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
        }

        @Override
        protected Action[] getPopupMenuActions() {
            Action[] treeActions = GanttGraphicArea.this.tree.getPopupMenuActions();
            int sep = 0;
            if (treeActions.length != 0) {
                sep = 1;
            }
            Action[] chartActions = new Action[]{};
            Action[] result = new Action[treeActions.length + sep + chartActions.length];
            System.arraycopy(treeActions, 0, result, 0, treeActions.length);
            System.arraycopy(chartActions, 0, result, treeActions.length + sep, chartActions.length);
            return result;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            GanttGraphicArea.this.tree.stopEditing();
            if (e.getButton() == 3 && ((GanttGraphicArea)GanttGraphicArea.this).appli.isOnlyViewer) {
                if (!GanttGraphicArea.this.appli.getTaskSelectionManager().getSelectedTasks().isEmpty()) {
                    Action[] actions2 = new Action[]{GanttGraphicArea.this.tree.getTaskPropertiesAction(), GanttGraphicArea.this.appli.getSubNetViewAction(), new GraphicOptionsAction(GanttGraphicArea.this.getOptionGroups(), GanttGraphicArea.this.appli)};
                    this.menu = GanttGraphicArea.this.getUIFacade().showPopupMenu(GanttGraphicArea.this, actions2, e.getX(), e.getY());
                } else {
                    Action[] actions2 = new Action[]{new GraphicOptionsAction(GanttGraphicArea.this.getOptionGroups(), GanttGraphicArea.this.appli)};
                    this.menu = GanttGraphicArea.this.getUIFacade().showPopupMenu(GanttGraphicArea.this, actions2, e.getX(), e.getY());
                }
                return;
            }
            Task taskUnderPointer = this.myMouseSupport.findTaskUnderMousePointer(e.getX(), e.getY());
            if (taskUnderPointer != null) {
                boolean ctrl = (e.getModifiersEx() & 0x80) == 128;
                GanttGraphicArea.this.tree.selectTask(taskUnderPointer, ctrl);
                if (taskUnderPointer.getCompletionPercentage() > 0.0f && UIInstanceOf.isUI(GanttGraphicArea.this.appli, 4)) {
                    Date today = ModifyStandDate.getStandDate();
                    if (taskUnderPointer.getStart().getTime().before(today) || taskUnderPointer.getCompletionPercentage() > 0.0f) {
                        boolean enabled = true;
                        boolean deleteEnabled = true;
                        if (taskUnderPointer.getStart().getTime().before(today)) {
                            enabled = false;
                            deleteEnabled = false;
                        }
                        if (taskUnderPointer.getCompletionPercentage() > 0.0f) {
                            deleteEnabled = false;
                        }
                        ((GanttGraphicArea)GanttGraphicArea.this).appli.bCut.getAction().setEnabled(enabled);
                        ((GanttGraphicArea)GanttGraphicArea.this).appli.bDelete.getAction().setEnabled(deleteEnabled);
                        ((GanttGraphicArea)GanttGraphicArea.this).appli.bCopy.getAction().setEnabled(enabled);
                        GanttGraphicArea.this.tree.myDedentAction.setEnabled(deleteEnabled);
                        GanttGraphicArea.this.tree.myIndentAction.setEnabled(deleteEnabled);
                        GanttGraphicArea.this.tree.myLinkTasksAction.setEnabled(deleteEnabled);
                        GanttGraphicArea.this.tree.myUnlinkTasksAction.setEnabled(deleteEnabled);
                    }
                }
            }
            super.mousePressed(e);
            this.menu = this.menu;
            if (taskUnderPointer == null) {
                return;
            }
            if (e.getButton() == 1) {
                ChartItem itemUnderPoint = this.myMouseSupport.getChartItemUnderMousePoint(e.getX(), e.getY());
                if (itemUnderPoint instanceof TaskBoundaryChartItem) {
                    TaskBoundaryChartItem taskBoundary = (TaskBoundaryChartItem)itemUnderPoint;
                    if (taskBoundary.isStartBoundary()) {
                        GanttGraphicArea.this.getChartImplementation().beginChangeTaskStartInteraction(e, taskBoundary);
                    } else {
                        GanttGraphicArea.this.getChartImplementation().beginChangeTaskEndInteraction(e, taskBoundary);
                    }
                } else if (!(itemUnderPoint instanceof TaskProgressChartItem) && itemUnderPoint instanceof TaskRegularAreaChartItem) {
                    GanttGraphicArea.this.getChartImplementation().beginDrawDependencyInteraction(e, (TaskRegularAreaChartItem)itemUnderPoint, this.myMouseSupport);
                }
                GanttGraphicArea.this.repaint();
            } else if (e.getButton() == 2) {
                if (!GanttGraphicArea.this.appli.getTaskSelectionManager().isTaskSelected(taskUnderPointer)) {
                    GanttGraphicArea.this.tree.selectTask(taskUnderPointer, false);
                }
                List l = GanttGraphicArea.this.appli.getTaskSelectionManager().getSelectedTasks();
                GanttGraphicArea.this.getChartImplementation().beginMoveTaskInteractions(e, l);
            }
        }
    }

    protected class ScrollGanttChartCenterAction
    extends GPAction {
        private final ScrollingManager myScrollingManager;
        private final TaskSelectionManager myTaskSelectionManager;

        public ScrollGanttChartCenterAction(ScrollingManager scrollingManager, TaskSelectionManager taskSelectionManager, String iconSize) {
            super("ScrollCenter", iconSize);
            this.myScrollingManager = scrollingManager;
            this.myTaskSelectionManager = taskSelectionManager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GanttGraphicArea.this.getUIFacade().setStatusText(GanttLanguage.getInstance().getText("centerOnSelectedTasks"));
            this.scroll();
        }

        private void scroll() {
            GanttCalendar min = null;
            Calendar max = null;
            Date scrollDate = null;
            Iterator<Object> it = null;
            it = this.myTaskSelectionManager.getSelectedTasks().isEmpty() ? Arrays.asList(GanttGraphicArea.this.getTaskManager().getTasks()).iterator() : this.myTaskSelectionManager.getSelectedTasks().iterator();
            while (it.hasNext()) {
                Task t = (Task)it.next();
                GanttCalendar dStart = t.getStart();
                GanttCalendar dEnd = t.getEnd();
                GanttCalendar ganttCalendar = min == null ? dStart.Clone() : (min = min.compareTo(dStart) > 0 ? dStart.Clone() : min);
                max = max == null ? dEnd.Clone() : (((GanttCalendar)max).compareTo(dEnd) < 0 ? dEnd.Clone() : max);
            }
            if (min == null || max == null) {
                return;
            }
            TimeUnit defaultUnit = GanttGraphicArea.this.getTimeUnitStack().getDefaultTimeUnit();
            TaskLength selectionLength = GanttGraphicArea.this.getTaskManager().createLength(defaultUnit, min.getTime(), max.getTime());
            TaskLength viewLength = GanttGraphicArea.this.getChartModel().getVisibleLength();
            float viewLengthInDefaultUnits = viewLength.getLength(defaultUnit);
            float delta = (selectionLength.getValue() - viewLengthInDefaultUnits) / 2.0f;
            scrollDate = GPCalendar.PLAIN.shiftDate(min.getTime(), GanttGraphicArea.this.getTaskManager().createLength(defaultUnit, delta));
            this.myScrollingManager.scrollLeft(scrollDate);
        }

        @Override
        protected String getIconFilePrefix() {
            return "scrollcenter_";
        }

        @Override
        protected String getLocalizedName() {
            return GanttResourceUtil.getResource("Gantt_Center");
        }

        @Override
        protected String getTooltipText() {
            return GanttResourceUtil.getResource("Gantt_Center");
        }
    }

    private class NewChartComponentImpl
    extends ChartImplementationBase
    implements ChartImplementation {
        private OldChartMouseListenerImpl myMouseListener;
        private OldMouseMotionListenerImpl myMouseMotionListener;

        private NewChartComponentImpl() {
            this.myMouseListener = new OldChartMouseListenerImpl();
            this.myMouseMotionListener = new OldMouseMotionListenerImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g, List visibleTasks) {
            Object object = ChartModelBase.STATIC_MUTEX;
            synchronized (object) {
                GanttGraphicArea.super.paintComponent(g);
                ChartModelImpl model = GanttGraphicArea.this.myChartModel;
                model.setTaskContainment(GanttGraphicArea.this.appli.getTaskContainment());
                model.setBottomUnitWidth(GanttGraphicArea.this.getViewState().getBottomUnitWidth());
                model.setRowHeight(GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.setTopTimeUnit(GanttGraphicArea.this.getViewState().getTopTimeUnit());
                model.setBottomTimeUnit(GanttGraphicArea.this.getViewState().getBottomTimeUnit());
                model.setVisibleTasks(visibleTasks);
                model.paint(g);
                if (this.getActiveInteraction() != null) {
                    this.getActiveInteraction().paint(g);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Object object = ChartModelBase.STATIC_MUTEX;
            synchronized (object) {
                GanttGraphicArea.super.paintComponent(g);
                ChartModelImpl model = GanttGraphicArea.this.myChartModel;
                model.setTaskContainment(GanttGraphicArea.this.appli.getTaskContainment());
                model.setBottomUnitWidth(GanttGraphicArea.this.getViewState().getBottomUnitWidth());
                model.setRowHeight(GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.setTopTimeUnit(GanttGraphicArea.this.getViewState().getTopTimeUnit());
                model.setBottomTimeUnit(GanttGraphicArea.this.getViewState().getBottomTimeUnit());
                VisibleNodesFilter visibleNodesFilter = new VisibleNodesFilter();
                List visibleTasks = visibleNodesFilter.getVisibleNodes(GanttGraphicArea.this.tree.getJTree(), GanttGraphicArea.this.getScrollBar(), GanttGraphicArea.this.getHeight(), GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.setVisibleTasks(visibleTasks);
                model.setVerticalOffset(GanttGraphicArea.this.getScrollBar() % GanttGraphicArea.this.tree.getTreeTable().getRowHeight());
                model.paint(g);
                if (this.getActiveInteraction() != null) {
                    this.getActiveInteraction().paint(g);
                }
                ((GanttGraphicArea)GanttGraphicArea.this).appli.forwardLineAction.draw();
            }
        }

        @Override
        public MouseListener getMouseListener() {
            return this.myMouseListener;
        }

        @Override
        public MouseMotionListener getMouseMotionListener() {
            return this.myMouseMotionListener;
        }

        @Override
        public IStatus canPaste(ChartSelection selection) {
            return Status.OK_STATUS;
        }

        @Override
        public ChartSelection getSelection() {
            ChartComponentBase.ChartSelectionImpl result = new ChartComponentBase.ChartSelectionImpl(){

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public void startCopyClipboardTransaction() {
                    super.startCopyClipboardTransaction();
                    GanttGraphicArea.this.tree.copySelectedNode();
                }

                @Override
                public void startMoveClipboardTransaction() {
                    super.startMoveClipboardTransaction();
                    GanttGraphicArea.this.tree.cutSelectedNode();
                }
            };
            return result;
        }

        @Override
        public void paste(ChartSelection selection) {
            GanttGraphicArea.this.tree.pasteNode();
        }

        public void beginShowTaskToolTip(MouseEvent initiatingEvent, Task task) {
        }
    }

    private class ChartImplementationBase
    extends ChartComponentBase.AbstractChartImplementation {
        private ChartImplementationBase() {
        }

        public void beginChangeTaskEndInteraction(MouseEvent initiatingEvent, TaskBoundaryChartItem taskBoundary) {
            this.setActiveInteraction(new ChangeTaskEndInteraction(initiatingEvent, taskBoundary));
        }

        public void beginChangeTaskStartInteraction(MouseEvent e, TaskBoundaryChartItem taskBoundary) {
            this.setActiveInteraction(new ChangeTaskStartInteraction(e, taskBoundary));
        }

        public void beginChangeTaskProgressInteraction(MouseEvent e, TaskProgressChartItem taskProgress) {
            this.setActiveInteraction(new ChangeTaskProgressInteraction(e, taskProgress));
        }

        public void beginDrawDependencyInteraction(MouseEvent initiatingEvent, TaskRegularAreaChartItem taskArea, MouseSupport mouseSupport) {
            this.setActiveInteraction(new DrawDependencyInteraction(initiatingEvent, taskArea, mouseSupport));
        }

        public void beginMoveTaskInteraction(MouseEvent e, Task task) {
            this.setActiveInteraction(new MoveTaskInteraction(e, task));
        }

        public void beginMoveTaskInteractions(MouseEvent e, List tasks) {
            this.setActiveInteraction(new MoveTaskInteractions(e, tasks));
        }

        public void beginShowTaskToolTipInteraction(MouseEvent e, Task task) {
            this.setActiveInteraction(new DisTaskToolTipInteraction(e, task));
        }

        public void beginSetNull() {
            this.setActiveInteraction(null);
        }
    }

    public static interface ChartImplementation
    extends ZoomListener {
        public void paintComponent(Graphics var1);

        public void paintComponent(Graphics var1, List var2);

        public MouseListener getMouseListener();

        public MouseMotionListener getMouseMotionListener();

        public void beginChangeTaskEndInteraction(MouseEvent var1, TaskBoundaryChartItem var2);

        public ChartComponentBase.MouseInteraction getActiveInteraction();

        public void beginChangeTaskStartInteraction(MouseEvent var1, TaskBoundaryChartItem var2);

        public ChartComponentBase.MouseInteraction finishInteraction();

        public void beginChangeTaskProgressInteraction(MouseEvent var1, TaskProgressChartItem var2);

        public void beginDrawDependencyInteraction(MouseEvent var1, TaskRegularAreaChartItem var2, MouseSupport var3);

        public void beginMoveTaskInteraction(MouseEvent var1, Task var2);

        public void beginMoveTaskInteractions(MouseEvent var1, List var2);

        public void beginScrollViewInteraction(MouseEvent var1);

        public void beginShowTaskToolTipInteraction(MouseEvent var1, Task var2);

        public void beginSetNull();
    }

    class MoveTaskInteractions
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private List myTasks;
        private List myMutators;
        private List myInitialStarts;

        MoveTaskInteractions(MouseEvent e, List tasks) {
            super(e);
            this.myTasks = tasks;
            this.myMutators = new ArrayList(this.myTasks.size());
            this.myInitialStarts = new ArrayList(this.myTasks.size());
            for (Task t : this.myTasks) {
                this.myMutators.add(t.createMutator());
                this.myInitialStarts.add(t.getStart());
            }
        }

        @Override
        public void apply(MouseEvent event) {
            float diff = this.getLengthDiff(event);
            TaskLength bottomUnitLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), diff);
            for (int i = 0; i < this.myTasks.size(); ++i) {
                Task task = (Task)this.myTasks.get(i);
                TaskLength taskLength = task.translateDuration(bottomUnitLength);
                int dayDiff = (int)taskLength.getValue();
                if (dayDiff == 0) continue;
                ((TaskMutator)this.myMutators.get(i)).shift(dayDiff);
            }
        }

        @Override
        public void finish() {
            Iterator itMutators = this.myMutators.iterator();
            while (itMutators.hasNext()) {
                ((TaskMutator)itMutators.next()).setIsolationLevel(1);
            }
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task moved", new Runnable(){

                @Override
                public void run() {
                    MoveTaskInteractions.this.doFinish();
                }
            });
        }

        private void doFinish() {
            Iterator itMutators = this.myMutators.iterator();
            while (itMutators.hasNext()) {
                ((TaskMutator)itMutators.next()).commit();
            }
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            for (Task t : this.myTasks) {
                t.applyThirdDateConstraint();
            }
            GanttGraphicArea.this.repaint();
        }
    }

    class MoveTaskInteraction
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private Task myTask;
        private TaskMutator myMutator;
        private GanttCalendar myInitialStart;

        MoveTaskInteraction(MouseEvent e, Task task) {
            super(e);
            this.myTask = task;
            this.myMutator = task.createMutator();
            this.myInitialStart = this.myTask.getStart();
        }

        @Override
        public void apply(MouseEvent event) {
            float diff = GanttGraphicArea.this.getChartModel().calculateLengthNoWeekends(this.getStartX(), event.getX());
            TaskLength bottomUnitLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), diff);
            TaskLength taskLength = this.myTask.translateDuration(bottomUnitLength);
            int dayDiff = (int)taskLength.getValue();
            if (dayDiff != 0) {
                this.myMutator.shift(dayDiff);
            }
        }

        @Override
        public void finish() {
            this.myMutator.setIsolationLevel(1);
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task moved", new Runnable(){

                @Override
                public void run() {
                    MoveTaskInteraction.this.doFinish();
                }
            });
        }

        private void doFinish() {
            this.myMutator.commit();
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            GanttGraphicArea.this.repaint();
        }
    }

    class DrawDependencyInteraction
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private final Task myTask;
        private Point myStartPoint;
        private DependencyInteractionRenderer myArrow;
        private MouseSupport myMouseSupport;
        private Task myDependant;

        public DrawDependencyInteraction(MouseEvent initiatingEvent, TaskRegularAreaChartItem taskArea, MouseSupport mouseSupport) {
            super(initiatingEvent);
            this.myStartPoint = initiatingEvent.getPoint();
            this.myTask = taskArea.getTask();
            this.myArrow = new DependencyInteractionRenderer(this.myStartPoint.x, this.myStartPoint.y, this.myStartPoint.x, this.myStartPoint.y);
            this.myMouseSupport = mouseSupport;
        }

        @Override
        public void apply(MouseEvent event) {
            this.myArrow.changePoint2(event.getX(), event.getY());
            GanttGraphicArea.this.myLastMouseEvent = event;
        }

        @Override
        public void finish() {
            if (!GanttGraphicArea.this.appli.isLinkVisible()) {
                return;
            }
            if (GanttGraphicArea.this.myLastMouseEvent != null) {
                this.myDependant = this.myMouseSupport.findTaskUnderMousePointer(GanttGraphicArea.this.myLastMouseEvent.getX(), GanttGraphicArea.this.myLastMouseEvent.getY());
                final Task dependee = this.myTask;
                if (this.myDependant != null) {
                    if (GanttGraphicArea.this.getTaskManager().getDependencyCollection().canCreateDependency(this.myDependant, dependee) && this.myDependant != null) {
                        TaskNode myDependantNode = (TaskNode)GanttGraphicArea.this.appli.getTree().getNode(this.myDependant.getTaskID());
                        TaskNode dependeeNode = (TaskNode)GanttGraphicArea.this.appli.getTree().getNode(dependee.getTaskID());
                        if (myDependantNode.getParent().equals(dependeeNode.getParent()) || dependeeNode.isLeaf() && myDependantNode.getLevel() == dependeeNode.getLevel()) {
                            GanttGraphicArea.this.getUndoManager().undoableEdit("Draw dependency", new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        if (UIInstanceOf.isUI(GanttGraphicArea.this.appli, 4)) {
                                            if (dependee.getEnd().getTime().before(ModifyStandDate.getStandDate())) {
                                                if (DrawDependencyInteraction.this.myDependant.getStart().getTime().after(ModifyStandDate.getStandDate())) {
                                                    Task temp = DrawDependencyInteraction.this.myDependant.unpluggedClone();
                                                    temp.setStart(dependee.getEnd());
                                                    temp.setEnd(new GanttCalendar(ModifyStandDate.getStandDate()));
                                                    GanttGraphicArea.this.getTaskManager().getDependencyCollection().createDependency(DrawDependencyInteraction.this.myDependant, dependee, new FinishStartConstraintImpl(), (int)temp.getDuration().getLength(), TaskDependenciesPanel.getTaskDependencyHardness()[0]);
                                                } else {
                                                    Task temp = DrawDependencyInteraction.this.myDependant.unpluggedClone();
                                                    temp.setStart(dependee.getEnd());
                                                    temp.setEnd(DrawDependencyInteraction.this.myDependant.getStart());
                                                    GanttGraphicArea.this.getTaskManager().getDependencyCollection().createDependency(DrawDependencyInteraction.this.myDependant, dependee, new FinishStartConstraintImpl(), (int)temp.getDuration().getLength(), TaskDependenciesPanel.getTaskDependencyHardness()[0]);
                                                }
                                                return;
                                            }
                                            if (DrawDependencyInteraction.this.myDependant.getStart().getTime().before(ModifyStandDate.getStandDate()) && DrawDependencyInteraction.this.myDependant.getCompletionPercentage() > 0.0f) {
                                                return;
                                            }
                                        }
                                        GanttGraphicArea.this.getTaskManager().getDependencyCollection().createDependency(DrawDependencyInteraction.this.myDependant, dependee, new FinishStartConstraintImpl());
                                    }
                                    catch (TaskDependencyException e1) {
                                        e1.printStackTrace();
                                    }
                                    GanttGraphicArea.this.appli.setAskForSave(true);
                                }
                            });
                        }
                    }
                } else {
                    this.myArrow = new DependencyInteractionRenderer();
                    GanttGraphicArea.this.repaint();
                }
                GanttGraphicArea.this.myLastMouseEvent = null;
                GanttGraphicArea.this.appli.recalculateCriticalPath();
            }
        }

        @Override
        public void paint(Graphics g) {
        }
    }

    class ChangeTaskProgressInteraction
    extends ChartComponentBase.MouseInteractionBase
    implements ChartComponentBase.MouseInteraction {
        private TaskProgressChartItem myTaskProgrssItem;
        private TaskMutator myMutator;
        private TaskInteractionHintRenderer myLastNotes;
        private float myProgressWas;
        private float myProgressIs;

        public ChangeTaskProgressInteraction(MouseEvent e, TaskProgressChartItem taskProgress) {
            super(e);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            try {
                GanttGraphicArea.this.setCursor(CHANGE_PROGRESS_CURSOR);
            }
            catch (Exception exept) {
                GanttGraphicArea.this.setCursor(E_RESIZE_CURSOR);
            }
            this.myTaskProgrssItem = taskProgress;
            this.myMutator = this.myTaskProgrssItem.getTask().createMutator();
            this.myProgressWas = this.myTaskProgrssItem.getTask().getCompletionPercentage();
            this.myLastNotes = new TaskInteractionHintRenderer(this.myProgressWas + "%", e.getX(), e.getY() - 30);
        }

        @Override
        public void apply(MouseEvent event) {
        }

        @Override
        public void finish() {
            this.myMutator.setIsolationLevel(1);
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task progress changed", new Runnable(){

                @Override
                public void run() {
                    ChangeTaskProgressInteraction.this.doFinish(ChangeTaskProgressInteraction.this.myMutator);
                }
            });
            GanttGraphicArea.this.repaint();
        }

        private void doFinish(TaskMutator mutator) {
            mutator.commit();
            this.myLastNotes = null;
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            if (this.myProgressIs == this.myProgressWas) {
                this.myMutator.commit();
                GanttGraphicArea.this.repaint();
                float myProgressIs = this.myTaskProgrssItem.getTask().getCompletionPercentage();
                if (myProgressIs != this.myProgressWas) {
                    // empty if block
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            if (this.myLastNotes != null) {
                // empty if block
            }
        }
    }

    class DisTaskToolTipInteraction
    extends ChangeTaskBoundaryInteraction
    implements ChartComponentBase.MouseInteraction {
        String[] title;

        public DisTaskToolTipInteraction(MouseEvent initiatingEvent, Task task) {
            super(initiatingEvent, task);
            this.title = new String[5];
        }

        @Override
        protected String getNotesText() {
            String taskName = this.myTask.getName();
            if (taskName != null && taskName.length() > 12) {
                taskName = taskName.substring(0, 12);
                taskName = taskName + "...";
            }
            if (taskName == null) {
                taskName = "";
            }
            String wbs = (String)this.myTask.getCustomValues().getValue(ProjectUtil.getResource("com.kingdee.eas.mm.project.WBSResource", "COL_WBSNUMBER"));
            String moMaterialNumber = (String)this.myTask.getCustomValues().getValue(EASResource.getString((String)"com.kingdee.eas.mm.mo.MOSheduleResource.materialNumber"));
            if (moMaterialNumber != null) {
                String moPlanBeginDate = (String)this.myTask.getCustomValues().getValue(EASResource.getString((String)"com.kingdee.eas.mm.mo.MOSheduleResource.planWorkDate"));
                this.title[0] = moPlanBeginDate == null || "".equals(moPlanBeginDate) ? EASResource.getString((String)"com.kingdee.eas.mm.mo.MOSheduleResource.technicsNumber") + ":" + taskName : EASResource.getString((String)"com.kingdee.eas.mm.mo.MOSheduleResource.moNumber") + ":" + taskName;
                this.title[1] = GanttResourceUtil.getResource("Gantt_TaskTime") + this.myTask.getStart() + " / " + this.myTask.getEnd();
                this.title[2] = "";
                return "";
            }
            this.title[0] = wbs == null || wbs.equalsIgnoreCase("") || wbs.length() == 0 ? GanttResourceUtil.getResource("GANTT_PROJECT_NAME") + taskName : GanttResourceUtil.getResource("Gantt_TaskName") + taskName;
            this.title[1] = GanttResourceUtil.getResource("Gantt_TaskTime") + this.myTask.getStart() + " / " + this.myTask.getEnd();
            BigDecimal completePercentage = new BigDecimal(this.myTask.getCompletionPercentage());
            BigDecimal percentage = completePercentage.setScale(2, 4);
            this.title[2] = GanttResourceUtil.getResource("Gantt_Completed") + percentage + "%";
            return "";
        }

        @Override
        protected void apply(float diff) {
        }

        @Override
        public void finish() {
        }

        void doFinish(TaskMutator myMutator) {
        }

        @Override
        public void paint(Graphics g) {
            if (this.myLastNotes != null) {
                this.myLastNotes.paintTaskToolTip(g, GanttGraphicArea.this.getWidth(), GanttGraphicArea.this.getHeight(), this.title);
            }
        }
    }

    class ChangeTaskStartInteraction
    extends ChangeTaskBoundaryInteraction
    implements ChartComponentBase.MouseInteraction {
        private TaskLength myInitialLength;
        private TaskMutator myMutator;
        private GanttCalendar myInitialStart;
        private TaskLength lastestTranslated;

        ChangeTaskStartInteraction(MouseEvent e, TaskBoundaryChartItem taskBoundary) {
            super(e, taskBoundary);
            this.myInitialLength = this.getTask().getDuration();
            this.myMutator = this.getTask().getMutator();
            if (this.myMutator == null) {
                this.myMutator = this.getTask().createMutator();
            }
            this.myInitialStart = this.getTask().getStart();
        }

        @Override
        protected void apply(float diff) {
            if (this.getTask().getCompletionPercentage() == 100.0f) {
                return;
            }
            TaskNode taskNode = (TaskNode)GanttGraphicArea.this.appli.getTree().getNode(this.getTask().getTaskID());
            if (!taskNode.isLeaf()) {
                return;
            }
            TaskLength newLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), this.getInitialDuration() + diff);
            TaskLength translated = this.getTask().translateDuration(newLength);
            int dayDiff = (int)(translated.getValue() - this.myInitialLength.getValue());
            GanttCalendar newStart = this.myInitialStart.newAdd(dayDiff);
            if (UIInstanceOf.isUI(GanttGraphicArea.this.appli, 4)) {
                if (newStart.getTime().before(ModifyStandDate.getStandDate())) {
                    return;
                }
                if (this.getTask().getCompletionPercentage() != 0.0f) {
                    return;
                }
            }
            if (this.getTask().getEnd().after(newStart)) {
                this.myMutator.setStart(newStart);
                if (this.getTask().getThird() != null && this.getTask().getThirdDateConstraint() == 1) {
                    this.myMutator.setEnd(this.getTask().getEnd().Clone());
                }
            }
            this.lastestTranslated = translated;
        }

        @Override
        public void finish() {
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task boundary changed", new Runnable(){

                @Override
                public void run() {
                    ChangeTaskStartInteraction.this.doFinish(ChangeTaskStartInteraction.this.myMutator);
                }
            });
        }

        void doFinish(TaskMutator myMutator) {
            Task myUnpluggedClone = GanttGraphicArea.this.appli.getTaskManager().getRootTask().unpluggedClone();
            if (myUnpluggedClone.getDuration().getLength() >= 3652L) {
                TaskLengthImpl taskLengthImpl = (TaskLengthImpl)myMutator.getDuration();
                taskLengthImpl.setLength(taskLengthImpl.getTimeUnit(), 3652L);
                myMutator.setDuration(taskLengthImpl);
            }
            super.finish(myMutator);
            this.getTask().applyThirdDateConstraint();
        }

        @Override
        protected String getNotesText() {
            return this.getTask().getStart().toString();
        }
    }

    class ChangeTaskEndInteraction
    extends ChangeTaskBoundaryInteraction
    implements ChartComponentBase.MouseInteraction {
        private TaskLength myInitialLength;
        private TaskMutator myMutator;
        private GanttCalendar myInitialEnd;

        public ChangeTaskEndInteraction(MouseEvent initiatingEvent, TaskBoundaryChartItem taskBoundary) {
            super(initiatingEvent, taskBoundary);
            this.myMutator = this.getTask().createMutator();
            this.myInitialEnd = this.getTask().getEnd();
            this.myInitialLength = this.getTask().getDuration();
        }

        @Override
        protected void apply(float diff) {
            if (this.getTask().getCompletionPercentage() == 100.0f) {
                return;
            }
            TaskNode taskNode = (TaskNode)GanttGraphicArea.this.appli.getTree().getNode(this.getTask().getTaskID());
            if (!taskNode.isLeaf()) {
                return;
            }
            TaskLength newLength = GanttGraphicArea.this.getTaskManager().createLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit(), this.getInitialDuration() + diff);
            TaskLength translated = this.getTask().translateDuration(newLength);
            if (translated.getLength() <= 3652L && this.getTask().getEnd().after(this.getTask().getStart())) {
                int dayDiff = (int)(translated.getValue() - this.myInitialLength.getValue());
                GanttCalendar newEnd = this.myInitialEnd.newAdd(dayDiff);
                this.myMutator.setEnd(newEnd);
            }
        }

        @Override
        protected String getNotesText() {
            return this.getTask().getEnd().toString();
        }

        @Override
        public void finish() {
            GanttGraphicArea.this.getUndoManager().undoableEdit("Task boundary changed", new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        void doFinish(TaskMutator myMutator) {
            if (myMutator.getDuration().getLength() >= 3652L) {
                TaskLengthImpl taskLengthImpl = (TaskLengthImpl)myMutator.getDuration();
                taskLengthImpl.setLength(taskLengthImpl.getTimeUnit(), 3652L);
                myMutator.setDuration(taskLengthImpl);
            }
            super.finish(myMutator);
        }
    }

    abstract class ChangeTaskBoundaryInteraction
    extends ChartComponentBase.MouseInteractionBase {
        public TaskInteractionHintRenderer myLastNotes;
        public final Task myTask;
        private final float myInitialDuration;
        private GanttCalendar myInitialEnd;
        private GanttCalendar myInitialStart;

        protected ChangeTaskBoundaryInteraction(MouseEvent initiatingEvent, TaskBoundaryChartItem taskBoundary) {
            super(initiatingEvent);
            this.myTask = taskBoundary.getTask();
            this.myInitialDuration = this.myTask.getDuration().getLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit());
            this.myInitialEnd = this.getTask().getEnd();
            this.myInitialStart = this.getTask().getStart();
        }

        protected ChangeTaskBoundaryInteraction(MouseEvent initiatingEvent, Task task) {
            super(initiatingEvent);
            this.myTask = task;
            this.myInitialDuration = this.myTask.getDuration().getLength(GanttGraphicArea.this.getViewState().getBottomTimeUnit());
            this.myInitialEnd = this.getTask().getEnd();
            this.myInitialStart = this.getTask().getStart();
        }

        public void apply(MouseEvent e) {
            if (this.myLastNotes == null) {
                this.myLastNotes = new TaskInteractionHintRenderer("", e.getX(), e.getY());
            }
            float diff = this.getLengthDiff(e);
            this.apply(diff);
            this.myLastNotes.setString(this.getNotesText());
            this.myLastNotes.setX(e.getX());
        }

        protected Task getTask() {
            return this.myTask;
        }

        protected float getInitialDuration() {
            return this.myInitialDuration;
        }

        public void finish(TaskMutator mutator) {
            mutator.setIsolationLevel(1);
            this.doFinish(mutator);
        }

        private void doFinish(TaskMutator mutator) {
            mutator.commit();
            this.myLastNotes = null;
            try {
                GanttGraphicArea.this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
            }
            catch (TaskDependencyException e) {
                e.printStackTrace();
            }
            GanttGraphicArea.this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            if (this.myLastNotes != null) {
                this.myLastNotes.paint(g);
            }
        }

        protected abstract void apply(float var1);

        protected abstract String getNotesText();
    }

    class MouseSupport {
        MouseSupport() {
        }

        protected Task findTaskUnderMousePointer(int xpos, int ypos) {
            ChartItem chartItem = GanttGraphicArea.this.myChartModel.getChartItemWithCoordinates(xpos, ypos);
            return chartItem == null ? null : chartItem.getTask();
        }

        protected ChartItem getChartItemUnderMousePoint(int xpos, int ypos) {
            ChartItem result = GanttGraphicArea.this.myChartModel.getChartItemWithCoordinates(xpos, ypos);
            return result;
        }
    }
}

