/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttPreviousStateTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTree2;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.DocumentManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParserFactory;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.PreviousStateTasksTagHandler;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class GanttPreviousState {
    private final String myName;
    private DocumentManager myManager;
    private ParserFactory myFactory;
    private File myFile;
    private OutputStreamWriter os;
    private GanttTree2 myTree;
    private GanttProject myProject;
    private GanttLanguage lang = GanttLanguage.getInstance();
    private String s = "    ";

    public GanttPreviousState(String name, GanttProject project) throws IOException {
        this.myName = name;
        this.myTree = project.getTree();
        this.myProject = project;
        this.myFile = this.createTemporaryFile();
        this.myFile.deleteOnExit();
        this.os = new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), "UTF-8");
        this.saveFile();
    }

    public GanttPreviousState(String name) throws IOException {
        this.myName = name;
        this.myFile = this.createTemporaryFile();
        this.myFile.deleteOnExit();
        this.os = new OutputStreamWriter((OutputStream)new FileOutputStream(this.myFile), "UTF-8");
    }

    public void saveFile() {
        try {
            AttributesImpl attrs = new AttributesImpl();
            StreamResult result = new StreamResult(this.os);
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            handler.setResult(result);
            handler.startDocument();
            handler.endDocument();
            this.writeTasks();
            this.os.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void writeTasks() {
        Enumeration<TreeNode> children = ((DefaultMutableTreeNode)this.myTree.getJTree().getModel().getRoot()).children();
        this.write(this.s + "<previous-tasks name=\"" + this.myName + "\">\n");
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode element = (DefaultMutableTreeNode)children.nextElement();
            this.writeTask(this.os, element);
        }
        this.write(this.s + "</previous-tasks>");
    }

    public void saveFilesFromLoaded(ArrayList tasks) {
        try {
            AttributesImpl attrs = new AttributesImpl();
            StreamResult result = new StreamResult(this.os);
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            handler.setResult(result);
            handler.startDocument();
            handler.endDocument();
            this.writeTasksFromLoaded(tasks);
            this.os.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void writeTasksFromLoaded(ArrayList tasks) throws IOException {
        this.write(this.s + "<previous-tasks name=\"" + this.myName + "\">\n");
        for (int i = 0; i < tasks.size(); ++i) {
            this.os.write(this.s + this.s + "<previous-task id=\"" + ((GanttPreviousStateTask)tasks.get(i)).getId() + "\"");
            this.os.write(" start=\"" + ((GanttPreviousStateTask)tasks.get(i)).getStart().toXMLString() + "\"");
            this.os.write(" duration=\"" + ((GanttPreviousStateTask)tasks.get(i)).getDuration() + "\"");
            this.os.write(" meeting=\"" + ((GanttPreviousStateTask)tasks.get(i)).isMilestone() + "\"");
            this.os.write(" super=\"" + ((GanttPreviousStateTask)tasks.get(i)).hasNested() + "\"");
            this.os.write("/>\n");
        }
        this.write(this.s + "</previous-tasks>");
    }

    public void write(String s) {
        try {
            this.os.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File createTemporaryFile() throws IOException {
        SecureRandom scrdom = new SecureRandom();
        String fileName = "_GanttProject_ps_" + (int)(10000.0 * (double)scrdom.nextInt());
        return File.createTempFile(fileName, ".gan");
    }

    public String getName() {
        return this.myName;
    }

    public File getFile() {
        return this.myFile;
    }

    public void remove() {
        this.myFile.delete();
    }

    public void writeTask(Writer fout, DefaultMutableTreeNode node) {
        ArrayList lot = new ArrayList();
        try {
            GanttTask task = (GanttTask)node.getUserObject();
            if (task.getTaskID() == -1) {
                throw new RuntimeException("A task can not has a number equal to -1");
            }
            int id = task.getTaskID();
            boolean haschild = false;
            ArrayList child = this.myTree.getAllChildTask(node);
            if (child.size() != 0) {
                haschild = true;
            }
            fout.write(this.s + this.s + "<previous-task id=\"" + task.getTaskID() + "\"");
            fout.write(" start=\"" + task.getStart().toXMLString() + "\"");
            fout.write(" duration=\"" + task.getLength() + "\"");
            fout.write(" meeting=\"" + task.isMilestone() + "\"");
            fout.write(" super=\"" + haschild + "\"");
            fout.write("/>\n");
            if (haschild) {
                for (int i = 0; i < child.size(); ++i) {
                    Task task2 = (Task)((DefaultMutableTreeNode)child.get(i)).getUserObject();
                    int newid = -1;
                    for (int j = 0; j < lot.size(); ++j) {
                        String b;
                        String a = task2.toString();
                        if (a == null) {
                            System.out.println("nul");
                        }
                        if (!a.equals(b = lot.get(j).toString())) continue;
                        newid = j;
                    }
                    this.writeTask(fout, (DefaultMutableTreeNode)child.get(i));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String correct(String s) {
        String res;
        if (s != null) {
            res = s.replaceAll("&", "&#38;");
            res = res.replaceAll("<", "&#60;");
            res = res.replaceAll(">", "&#62;");
            res = res.replaceAll("/", "&#47;");
            res = res.replaceAll("\"", "&#34;");
        } else {
            res = s;
        }
        return res;
    }

    public String replaceAll(String notes, String s1, String s2) {
        return notes.replaceAll(s1, s2);
    }

    public ArrayList load() throws ParserConfigurationException, SAXException, IOException {
        ArrayList tasks = null;
        PreviousStateTasksTagHandler handler = new PreviousStateTasksTagHandler(null);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(this.myFile, (DefaultHandler)handler);
        tasks = handler.getTasks();
        return tasks;
    }
}

