/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GPView;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GPViewManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTree2;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ProjectEventListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.UIFacadeImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.UIInstanceOf;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.GPAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.calendar.GPCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Chart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartSelection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartSelectionListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.Document;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.DocumentCreator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.document.DocumentManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IAdaptable;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GanttStatusBar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.MMGanttTablePane;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.ProjectUIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.ProjectUIFacadeImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIConfiguration;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.options.model.GPOptionChangeListener;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.scrolling.ScrollingManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.parser.ParserFactory;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.roles.RoleManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.TimeUnitStack;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.GPTimeUnitStack;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.GPUndoManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.UndoManagerImpl;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

abstract class GanttProjectBase
extends JFrame
implements IGanttProject,
UIFacade {
    private final ViewManagerImpl myViewManager;
    private final List myModifiedStateChangeListeners = new ArrayList();
    private final UIFacadeImpl myUIFacade;
    private final GanttStatusBar statusBar = new GanttStatusBar(this);
    private final TimeUnitStack myTimeUnitStack;
    private ProjectUIFacade myProjectUIFacade;
    private final DocumentManager myDocumentManager;
    private MMGanttTablePane myTabPane = new MMGanttTablePane();
    private final GPUndoManager myUndoManager;

    protected GanttProjectBase() {
        this.myViewManager = new ViewManagerImpl(this.myTabPane, this);
        this.addProjectEventListener(this.myViewManager);
        this.myTimeUnitStack = new GPTimeUnitStack(this.getLanguage());
        this.myUIFacade = new UIFacadeImpl(this, this.statusBar, this.getProject(), this);
        this.myDocumentManager = new DocumentCreator(this, this.getUIFacade(), null){

            @Override
            public ParserFactory getParserFactory() {
                return GanttProjectBase.this.getParserFactory();
            }
        };
        this.myUndoManager = new UndoManagerImpl(this, null, this.myDocumentManager){

            @Override
            protected ParserFactory getParserFactory() {
                return GanttProjectBase.this.getParserFactory();
            }
        };
        this.createProjectUIFacade();
    }

    public void createProjectUIFacade() {
        this.myProjectUIFacade = new ProjectUIFacadeImpl(this.myUIFacade, this.myDocumentManager, this.myUndoManager, (GanttProject)this);
    }

    private GanttLanguage getLanguage() {
        return GanttLanguage.getInstance();
    }

    @Override
    public void addProjectEventListener(ProjectEventListener listener) {
        this.myModifiedStateChangeListeners.add(listener);
    }

    @Override
    public void removeProjectEventListener(ProjectEventListener listener) {
        this.myModifiedStateChangeListeners.remove(listener);
    }

    protected void fireProjectModified(boolean isModified) {
        for (int i = 0; i < this.myModifiedStateChangeListeners.size(); ++i) {
            ProjectEventListener next = (ProjectEventListener)this.myModifiedStateChangeListeners.get(i);
            try {
                if (isModified) {
                    next.projectModified();
                    continue;
                }
                next.projectSaved();
                continue;
            }
            catch (Exception e) {
                this.showErrorDialog(e);
            }
        }
    }

    protected void fireProjectClosed() {
        for (int i = 0; i < this.myModifiedStateChangeListeners.size(); ++i) {
            ProjectEventListener next = (ProjectEventListener)this.myModifiedStateChangeListeners.get(i);
            next.projectClosed();
        }
    }

    public ProjectUIFacade getProjectUIFacade() {
        return this.myProjectUIFacade;
    }

    public void setProjectUIFacade(ProjectUIFacade myProjectUIFacade) {
        this.myProjectUIFacade = myProjectUIFacade;
    }

    @Override
    public UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    @Override
    public JFrame getMainFrame() {
        return this.myUIFacade.getMainFrame();
    }

    @Override
    public ScrollingManager getScrollingManager() {
        return this.myUIFacade.getScrollingManager();
    }

    @Override
    public ZoomManager getZoomManager() {
        return this.myUIFacade.getZoomManager();
    }

    @Override
    public GPUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    @Override
    public void setStatusText(String text) {
        this.myUIFacade.setStatusText(text);
    }

    @Override
    public void showDialog(Component content, Action[] actions) {
        this.myUIFacade.showDialog(content, actions);
    }

    @Override
    public void showDialog(Component content, Action[] actions, String title) {
        this.myUIFacade.showDialog(content, actions, title);
    }

    @Override
    public UIFacade.Choice showConfirmationDialog(String message, String title) {
        return this.myUIFacade.showConfirmationDialog(message, title);
    }

    @Override
    public void showErrorDialog(String message) {
        this.myUIFacade.showErrorDialog(message);
    }

    @Override
    public void showErrorDialog(Throwable e) {
        this.myUIFacade.showErrorDialog(e);
    }

    @Override
    public void logErrorMessage(Exception e) {
        this.myUIFacade.logErrorMessage(e);
    }

    @Override
    public JPopupMenu showPopupMenu(Component invoker, Action[] actions, int x, int y) {
        return this.myUIFacade.showPopupMenu(invoker, actions, x, y);
    }

    @Override
    public void setWorkbenchTitle(String title) {
        this.myUIFacade.setWorkbenchTitle(title);
    }

    protected GPViewManager getViewManager() {
        return this.myViewManager;
    }

    public MMGanttTablePane getTabs() {
        return this.myTabPane;
    }

    protected IGanttProject getProject() {
        return this;
    }

    @Override
    public TimeUnitStack getTimeUnitStack() {
        return this.myTimeUnitStack;
    }

    @Override
    public abstract String getProjectName();

    @Override
    public abstract void setProjectName(String var1);

    @Override
    public abstract String getDescription();

    @Override
    public abstract void setDescription(String var1);

    @Override
    public abstract String getOrganization();

    @Override
    public abstract void setOrganization(String var1);

    @Override
    public abstract String getWebLink();

    @Override
    public abstract void setWebLink(String var1);

    @Override
    public abstract Task newTask();

    @Override
    public abstract GanttLanguage getI18n();

    @Override
    public abstract UIConfiguration getUIConfiguration();

    @Override
    public abstract ResourceManager getHumanResourceManager();

    @Override
    public abstract RoleManager getRoleManager();

    @Override
    public abstract TaskManager getTaskManager();

    @Override
    public abstract TaskContainmentHierarchyFacade getTaskContainment();

    @Override
    public abstract GPCalendar getActiveCalendar();

    @Override
    public abstract void setModified();

    @Override
    public abstract void close();

    @Override
    public abstract Document getDocument();

    public GanttStatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public DocumentManager getDocumentManager() {
        return this.myDocumentManager;
    }

    protected abstract ParserFactory getParserFactory();

    @Override
    public GPUndoManager getMyUndoManager() {
        return this.myUndoManager;
    }

    protected static class RowHeightAligner
    implements GPOptionChangeListener {
        private ChartModelImpl myGanttViewModel;
        private GanttTree2 myTreeView;

        public RowHeightAligner(GanttTree2 treeView, ChartModelImpl ganttViewModel) {
            this.myGanttViewModel = ganttViewModel;
            this.myTreeView = treeView;
        }

        @Override
        public void optionsChanged() {
            this.myTreeView.getTable().setRowHeight(this.myGanttViewModel.setRowHeight());
            AbstractTableModel model = (AbstractTableModel)this.myTreeView.getTable().getModel();
            model.fireTableStructureChanged();
            this.myTreeView.updateUI();
        }
    }

    private class GPViewImpl
    implements GPView,
    ChartSelectionListener {
        private final MMGanttTablePane myTabs;
        private int myIndex;
        private Container myComponent;
        private boolean isVisible;
        private final Icon myIcon;
        private final Chart myChart;
        private final ViewManagerImpl myManager;

        GPViewImpl(ViewManagerImpl manager, MMGanttTablePane tabs, Container component, Chart chart, Icon icon) {
            this.myManager = manager;
            this.myTabs = tabs;
            this.myComponent = component;
            this.myIcon = icon;
            this.myChart = chart;
            if (this.myChart == null) {
                // empty if block
            }
        }

        public void setActive(boolean active) {
            if (active) {
                this.myChart.addSelectionListener(this);
            } else {
                this.myChart.removeSelectionListener(this);
            }
        }

        public void reset() {
            this.myChart.reset();
        }

        @Override
        public void setVisible(boolean isVisible) {
            String tabName = "New view";
            JScrollPane jsp = new JScrollPane();
            if (isVisible) {
                this.myChart.setTaskManager(GanttProjectBase.this.getTaskManager());
                tabName = this.myChart.getName();
                jsp.getViewport().add(this.myComponent);
                this.myTabs.add(jsp, new KDLayout.Constraints(0, 0, 958, 600, 15));
            } else {
                this.myTabs.remove(this.myIndex);
            }
            this.isVisible = isVisible;
        }

        @Override
        public boolean isVisible() {
            return this.isVisible;
        }

        @Override
        public void selectionChanged() {
            this.myManager.updateActions();
        }
    }

    private class ViewManagerImpl
    implements GPViewManager,
    ProjectEventListener {
        private MMGanttTablePane myTabs;
        private GanttProjectBase project;
        private List myViews = new ArrayList();
        private GPViewImpl mySelectedView;
        private final GPAction myCopyAction;
        private final GPAction myCutAction;
        private final GPAction myPasteAction;

        ViewManagerImpl(MMGanttTablePane tabs, GanttProjectBase myProject) {
            this.myTabs = tabs;
            this.project = myProject;
            this.myCopyAction = new GPAction(){
                {
                    if (!UIInstanceOf.isUI(ViewManagerImpl.this.project, 2) && !UIInstanceOf.isUI(ViewManagerImpl.this.project, 3)) {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
                    }
                }

                @Override
                protected String getIconFilePrefix() {
                    return "copy_";
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ViewManagerImpl.this.mySelectedView != null && ViewManagerImpl.this.mySelectedView.myChart != null && ViewManagerImpl.this.mySelectedView.myChart.getSelection() != null) {
                        ViewManagerImpl.this.mySelectedView.myChart.getSelection().startCopyClipboardTransaction();
                    }
                }

                @Override
                protected String getLocalizedName() {
                    return this.getI18n("copy");
                }
            };
            this.myCutAction = new GPAction(){
                {
                    if (!UIInstanceOf.isUI(ViewManagerImpl.this.project, 2) && !UIInstanceOf.isUI(ViewManagerImpl.this.project, 3)) {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 128));
                    }
                }

                @Override
                protected String getIconFilePrefix() {
                    return "cut_";
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ViewManagerImpl.this.mySelectedView != null && ViewManagerImpl.this.mySelectedView.myChart != null && ViewManagerImpl.this.mySelectedView.myChart.getSelection() != null) {
                        ViewManagerImpl.this.mySelectedView.myChart.getSelection().startMoveClipboardTransaction();
                    }
                }

                @Override
                protected String getLocalizedName() {
                    return this.getI18n("cut");
                }
            };
            this.myPasteAction = new GPAction(){
                {
                    if (!UIInstanceOf.isUI(ViewManagerImpl.this.project, 2) && !UIInstanceOf.isUI(ViewManagerImpl.this.project, 3)) {
                        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 128));
                    }
                }

                @Override
                protected String getIconFilePrefix() {
                    return "paste_";
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ViewManagerImpl.this.mySelectedView != null && ViewManagerImpl.this.mySelectedView.myChart != null && ViewManagerImpl.this.mySelectedView.myChart.getSelection() != null) {
                        ChartSelection selection = ViewManagerImpl.this.mySelectedView.myChart.getSelection();
                        ViewManagerImpl.this.mySelectedView.myChart.paste(selection);
                        selection.commitClipboardTransaction();
                    }
                }

                @Override
                protected String getLocalizedName() {
                    return this.getI18n("paste");
                }
            };
        }

        @Override
        public GPView createView(IAdaptable adaptable, Icon icon) {
            GPViewImpl view = new GPViewImpl(this, this.myTabs, (Container)adaptable.getAdapter(Container.class), (Chart)adaptable.getAdapter(Chart.class), icon);
            this.myViews.add(view);
            return view;
        }

        @Override
        public Action getCopyAction() {
            return this.myCopyAction;
        }

        @Override
        public Action getCutAction() {
            return this.myCutAction;
        }

        @Override
        public Action getPasteAction() {
            return this.myPasteAction;
        }

        @Override
        public void projectModified() {
        }

        @Override
        public void projectSaved() {
        }

        @Override
        public void projectClosed() {
            for (int i = 0; i < this.myViews.size(); ++i) {
                GPViewImpl nextView = (GPViewImpl)this.myViews.get(i);
                nextView.reset();
            }
        }

        private void updateActions() {
            ChartSelection selection = this.mySelectedView.myChart.getSelection();
            this.myCopyAction.setEnabled(false == selection.isEmpty());
            this.myCutAction.setEnabled(false == selection.isEmpty() && selection.isDeletable().isOK());
        }
    }
}

