/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskMutator;
import java.io.Serializable;

public class GanttTask
extends TaskImpl
implements Serializable {
    public static int LOW = 0;
    public static int NORMAL = 1;
    public static int HIGHT = 2;

    public GanttTask(String name, GanttCalendar start, long length, TaskManager taskManager, int taskID, GanttProject myProject) {
        super(taskManager, taskID, myProject);
        TaskMutator mutator = this.createMutator();
        mutator.setName(name);
        mutator.setStart(start);
        mutator.setDuration(taskManager.createLength(length));
        mutator.commit();
        this.enableEvents(true);
    }

    public GanttTask(GanttTask copy) {
        super(copy, false);
        this.enableEvents(true);
    }

    public GanttTask Clone() {
        return new GanttTask(this);
    }

    public int getLength() {
        return (int)this.getDuration().getLength();
    }

    public void setLength(int l) {
        if (l <= 0) {
            throw new IllegalArgumentException("Length of task must be >=0. You've passed length=" + l + " to task=" + this);
        }
        TaskMutator mutator = this.createMutator();
        mutator.setDuration(this.getManager().createLength(this.getDuration().getTimeUnit(), l));
        mutator.commit();
    }

    public void setTaskID(int taskID) {
        this.setTaskIDHack(taskID);
    }
}

