/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GPTreeTableBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTreeTableModel;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ModifyStandDate;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.UIInstanceOf;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.YesOrNoEnumDIY;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.delay.Delay;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GanttDialogCustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.TableHeaderRenderer;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumn;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.jdesktop.swing.decorator.AlternateRowHighlighter;
import org.jdesktop.swing.decorator.HierarchicalColumnHighlighter;
import org.jdesktop.swing.decorator.Highlighter;
import org.jdesktop.swing.decorator.HighlighterPipeline;
import org.jdesktop.swing.table.TableColumnExt;
import org.jdesktop.swing.treetable.TreeTableModel;

public class GanttTreeTable
extends GPTreeTableBase
implements GanttLanguage.Listener {
    private static GanttLanguage language = GanttLanguage.getInstance();
    private JPopupMenu popupMenu;
    private Map mapColNameMenuItem;
    private Point clickPoint = null;
    private final GanttTreeTableModel ttModel;
    private final Map mapTableColumnColumnKeeper = new LinkedHashMap();
    DisplayedColumnsList listDisplayedColumns = null;
    private GanttLanguage.Listener myLanguageListener;
    private CustomColumnsManager customColumnsManager;

    public GanttTreeTable(GanttTreeTableModel model, GanttProject myProject, int[] hidedColumnIndex) {
        super((TreeTableModel)model, myProject);
        this.project = myProject;
        GanttLanguage.getInstance().addListener(this);
        this.initTreeTable(hidedColumnIndex);
        this.ttModel = model;
    }

    void setAction(Action action) {
        this.addAction(action, (KeyStroke)action.getValue("AcceleratorKey"));
    }

    void addAction(Action action, KeyStroke keyStroke) {
        InputMap inputMap = this.getInputMap();
        inputMap.put(keyStroke, action.getValue("Name"));
        this.getActionMap().put(action.getValue("Name"), action);
    }

    private void updateDisplayedColumnsOrder() {
        for (DisplayedColumn dc : this.listDisplayedColumns) {
            if (!dc.isDisplayed()) continue;
            String id = dc.getID();
            String name = this.getNameForId(id);
            int viewIndex = this.getTable().convertColumnIndexToView(this.getColumn(name).getModelIndex());
            dc.setOrder(viewIndex);
            dc.setWidth(this.getColumn(name).getPreferredWidth());
        }
    }

    public DisplayedColumnsList getDisplayColumns() {
        this.updateDisplayedColumnsOrder();
        return this.listDisplayedColumns;
    }

    public void setDisplayedColumns(DisplayedColumnsList displayedColumns) {
        DisplayedColumnsList l = (DisplayedColumnsList)displayedColumns.clone();
        if (displayedColumns.size() != 0) {
            this.listDisplayedColumns = displayedColumns;
            this.displayAllColumns();
            this.hideAllColumns();
            this.listDisplayedColumns = l;
        }
        Collections.sort(this.listDisplayedColumns);
        for (DisplayedColumn dc : this.listDisplayedColumns) {
            String id = dc.getID();
            String name = this.getNameForId(id);
            if (dc.displayed) {
                this.displayColumn(name);
                continue;
            }
            this.hideColumn(name);
        }
    }

    void reloadColumns(int[] hidedColumnIndex) {
        ArrayList<TableColumn> columns = Collections.list(this.getTable().getColumnModel().getColumns());
        for (int i = 0; i < columns.size(); ++i) {
            this.getTable().removeColumn((TableColumn)columns.get(i));
        }
        if (this.myLanguageListener != null) {
            GanttLanguage.getInstance().removeListener(this.myLanguageListener);
        }
        final TableColumnExt tce1 = this.newTableColumnExt(0);
        final TableColumnExt tce2 = this.newTableColumnExt(1);
        final TableColumnExt tce3 = this.newTableColumnExt(2);
        final TableColumnExt tce4 = this.newTableColumnExt(3);
        final TableColumnExt tce5 = this.newTableColumnExt(4);
        final TableColumnExt tce6 = this.newTableColumnExt(5);
        final TableColumnExt tce7 = this.newTableColumnExt(6);
        final TableColumnExt tce8 = this.newTableColumnExt(7);
        final TableColumnExt tce9 = this.newTableColumnExt(8);
        final TableColumnExt tce10 = this.newTableColumnExt(9);
        final TableColumnExt tce11 = this.newTableColumnExt(10);
        this.myLanguageListener = new GanttLanguage.Listener(){

            @Override
            public void languageChanged(GanttLanguage.Event event) {
                if (GanttTreeTable.this.ttModel != null) {
                    GanttTreeTable.this.ttModel.languageChanged(event);
                }
                tce1.setTitle(GanttTreeTableModel.strColType);
                tce2.setTitle(GanttTreeTableModel.strColPriority);
                tce3.setTitle(GanttTreeTableModel.strColInfo);
                tce4.setTitle(GanttTreeTableModel.strColID);
                tce5.setTitle(GanttTreeTableModel.strColName);
                tce6.setTitle(GanttTreeTableModel.strColBegDate);
                tce7.setTitle(GanttTreeTableModel.strColEndDate);
                tce8.setTitle(GanttTreeTableModel.strColDuration);
                tce9.setTitle(GanttTreeTableModel.strColCompletion);
                tce10.setTitle(GanttTreeTableModel.strColCoordinator);
                tce11.setTitle(GanttTreeTableModel.strColPredecessors);
            }
        };
        GanttLanguage.getInstance().addListener(this.myLanguageListener);
        this.addColumn(tce1);
        this.addColumn(tce2);
        this.addColumn(tce3);
        this.addColumn(tce4);
        this.addColumn(tce5);
        this.addColumn(tce6);
        this.addColumn(tce7);
        this.addColumn(tce8);
        this.addColumn(tce9);
        this.addColumn(tce10);
        this.addColumn(tce11);
        int length = hidedColumnIndex.length;
        for (int i = 0; i < length; ++i) {
            ((TableColumnExt)columns.get(hidedColumnIndex[i])).setVisible(false);
        }
        TableColumnExt startDate = (TableColumnExt)columns.get(5);
        TableColumnExt endDate = (TableColumnExt)columns.get(6);
        TableColumnExt cmpPer = (TableColumnExt)columns.get(8);
        TableColumnExt preTask = (TableColumnExt)columns.get(10);
        this.listDisplayedColumns = new DisplayedColumnsList();
        DisplayedColumn dc1 = new DisplayedColumn(this.getIdForName(tce1.getTitle()));
        dc1.setDisplayed(false);
        dc1.setOrder(this.getTable().convertColumnIndexToView(tce1.getModelIndex()));
        dc1.setWidth(tce1.getPreferredWidth());
        this.listDisplayedColumns.add(dc1);
        DisplayedColumn dc2 = new DisplayedColumn(this.getIdForName(tce2.getTitle()));
        dc2.setDisplayed(false);
        dc2.setOrder(this.getTable().convertColumnIndexToView(tce2.getModelIndex()));
        dc2.setWidth(tce2.getPreferredWidth());
        this.listDisplayedColumns.add(dc2);
        DisplayedColumn dc3 = new DisplayedColumn(this.getIdForName(tce3.getTitle()));
        dc3.setDisplayed(false);
        dc3.setOrder(this.getTable().convertColumnIndexToView(tce3.getModelIndex()));
        dc3.setWidth(tce3.getPreferredWidth());
        this.listDisplayedColumns.add(dc3);
        DisplayedColumn dc4 = new DisplayedColumn(this.getIdForName(tce4.getTitle()));
        dc4.setDisplayed(true);
        dc4.setOrder(this.getTable().convertColumnIndexToView(tce4.getModelIndex()));
        dc4.setWidth(45);
        this.listDisplayedColumns.add(dc4);
        DisplayedColumn dc5 = new DisplayedColumn(this.getIdForName(tce5.getTitle()));
        dc5.setDisplayed(true);
        dc5.setOrder(this.getTable().convertColumnIndexToView(tce5.getModelIndex()));
        dc5.setWidth(150);
        this.listDisplayedColumns.add(dc5);
        DisplayedColumn dc6 = new DisplayedColumn(this.getIdForName(tce6.getTitle()));
        if (startDate.isVisible()) {
            dc6.setDisplayed(true);
        } else {
            dc6.setDisplayed(false);
        }
        dc6.setOrder(this.getTable().convertColumnIndexToView(tce6.getModelIndex()));
        dc6.setWidth(75);
        this.listDisplayedColumns.add(dc6);
        DisplayedColumn dc7 = new DisplayedColumn(this.getIdForName(tce7.getTitle()));
        if (endDate.isVisible()) {
            dc7.setDisplayed(true);
        } else {
            dc7.setDisplayed(false);
        }
        dc7.setOrder(this.getTable().convertColumnIndexToView(tce7.getModelIndex()));
        dc7.setWidth(75);
        this.listDisplayedColumns.add(dc7);
        DisplayedColumn dc8 = new DisplayedColumn(this.getIdForName(tce8.getTitle()));
        dc8.setDisplayed(true);
        dc8.setOrder(this.getTable().convertColumnIndexToView(tce8.getModelIndex()));
        dc8.setWidth(45);
        this.listDisplayedColumns.add(dc8);
        DisplayedColumn dc9 = new DisplayedColumn(this.getIdForName(tce9.getTitle()));
        if (cmpPer.isVisible()) {
            dc9.setDisplayed(true);
        } else {
            dc9.setDisplayed(false);
        }
        dc9.setOrder(this.getTable().convertColumnIndexToView(tce9.getModelIndex()));
        dc9.setWidth(55);
        this.listDisplayedColumns.add(dc9);
        DisplayedColumn dc10 = new DisplayedColumn(this.getIdForName(tce10.getTitle()));
        dc10.setDisplayed(false);
        dc10.setOrder(this.getTable().convertColumnIndexToView(tce10.getModelIndex()));
        dc10.setWidth(tce10.getPreferredWidth());
        this.listDisplayedColumns.add(dc10);
        DisplayedColumn dc11 = new DisplayedColumn(this.getIdForName(tce11.getTitle()));
        if (preTask.isVisible()) {
            dc11.setDisplayed(true);
        } else {
            dc11.setDisplayed(false);
        }
        dc11.setOrder(this.getTable().convertColumnIndexToView(tce11.getModelIndex()));
        dc11.setWidth(75);
        this.listDisplayedColumns.add(dc11);
        this.mapTableColumnColumnKeeper.clear();
        this.mapTableColumnColumnKeeper.put(tce1, new ColumnKeeper((TableColumn)tce1, true));
        this.mapTableColumnColumnKeeper.put(tce2, new ColumnKeeper((TableColumn)tce2, true));
        this.mapTableColumnColumnKeeper.put(tce3, new ColumnKeeper((TableColumn)tce3, true));
        this.mapTableColumnColumnKeeper.put(tce4, new ColumnKeeper((TableColumn)tce4, true));
        this.mapTableColumnColumnKeeper.put(tce5, new ColumnKeeper((TableColumn)tce5, true));
        if (startDate.isVisible()) {
            this.mapTableColumnColumnKeeper.put(tce6, new ColumnKeeper((TableColumn)tce6));
        } else {
            this.mapTableColumnColumnKeeper.put(tce6, new ColumnKeeper((TableColumn)tce6, true));
        }
        if (endDate.isVisible()) {
            this.mapTableColumnColumnKeeper.put(tce7, new ColumnKeeper((TableColumn)tce7));
        } else {
            this.mapTableColumnColumnKeeper.put(tce7, new ColumnKeeper((TableColumn)tce7, true));
        }
        this.mapTableColumnColumnKeeper.put(tce8, new ColumnKeeper((TableColumn)tce8));
        if (cmpPer.isVisible()) {
            this.mapTableColumnColumnKeeper.put(tce9, new ColumnKeeper((TableColumn)tce9));
        } else {
            this.mapTableColumnColumnKeeper.put(tce9, new ColumnKeeper((TableColumn)tce9, true));
        }
        this.mapTableColumnColumnKeeper.put(tce10, new ColumnKeeper((TableColumn)tce10, true));
        if (preTask.isVisible()) {
            this.mapTableColumnColumnKeeper.put(tce11, new ColumnKeeper((TableColumn)tce11));
        } else {
            this.mapTableColumnColumnKeeper.put(tce11, new ColumnKeeper((TableColumn)tce11, true));
        }
        this.initColumnsAlignements();
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColBegDate).setCellEditor((TableCellEditor)new GPTreeTableBase.StartDateCellEditor());
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColEndDate).setCellEditor((TableCellEditor)new GPTreeTableBase.EndDateCellEditor());
        NameCellEditor nameCellEditor = new NameCellEditor();
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColName).setCellEditor((TableCellEditor)nameCellEditor);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColDuration).setCellEditor((TableCellEditor)new DurationCellEditor());
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColPredecessors).setCellEditor((TableCellEditor)new NullCellEditor(0));
        JComboBox<YesOrNoEnumDIY> comboBox = new JComboBox<YesOrNoEnumDIY>();
        comboBox.addItem(YesOrNoEnumDIY.noEnum);
        comboBox.addItem(YesOrNoEnumDIY.yesEnum);
        if (this.listDisplayedColumns != null) {
            this.setDisplayedColumns(this.listDisplayedColumns);
        } else {
            this.displayAllColumns();
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                GanttTreeTable.this.calculateWidth();
                GanttTreeTable.this.revalidate();
            }
        };
        SwingUtilities.invokeLater(t);
    }

    void initTreeTable(int[] hidedColumnIndex) {
        this.clickPoint = null;
        this.customColumnsManager = new CustomColumnsManager(this);
        this.mapColNameMenuItem = new HashMap();
        this.getTreeTableModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent arg0) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent arg0) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent arg0) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent arg0) {
            }
        });
        this.getTable().setAutoCreateColumnsFromModel(false);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setOpenIcon(null);
        this.setClosedIcon(null);
        this.setCollapsedIcon(new ImageIcon(this.getClass().getResource("/icons/plus.gif")));
        this.setExpandedIcon(new ImageIcon(this.getClass().getResource("/icons/minus.gif")));
        this.setLeafIcon(null);
        this.setHasColumnControl(false);
        this.getTreeTable().getParent().setBackground(Color.WHITE);
        this.getTreeTable().getParent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                if (e.getClickCount() == 1) {
                    GanttTreeTable.this.project.getTree().selectTreeRow(-1);
                } else if (e.getClickCount() != 2 || e.getButton() == 1) {
                    // empty if block
                }
            }
        });
        InputMap inputMap = this.getInputMap();
        inputMap.setParent(this.getTreeTable().getInputMap(0));
        this.getTreeTable().setInputMap(0, inputMap);
        ActionMap actionMap = this.getActionMap();
        actionMap.setParent(this.getTreeTable().getActionMap());
        this.getTreeTable().setActionMap(actionMap);
        this.getTable().getColumnModel().addColumnModelListener((TableColumnModelListener)this.getTreeTableModel());
        this.getTable().getModel().addTableModelListener(new ModelListener());
        this.getTable().getTableHeader().addMouseListener(new HeaderMouseListener());
        this.getTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                DefaultTableColumnModel o = (DefaultTableColumnModel)e.getSource();
                TableColumn tc = o.getColumn(e.getFromIndex());
                ColumnKeeper ck = (ColumnKeeper)GanttTreeTable.this.mapTableColumnColumnKeeper.get(tc);
                if (ck != null) {
                    ck.setInitIndex(e.getToIndex());
                }
                if (GanttTreeTable.this.project != null) {
                    GanttTreeTable.this.project.setAskForSave(true);
                }
                GanttTreeTable.this.updateDisplayedColumnsOrder();
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        Highlighter[] highlighters = new Highlighter[]{AlternateRowHighlighter.quickSilver, new HierarchicalColumnHighlighter(new Color(140, 182, 206), Color.BLACK)};
        this.setHighlighters(new HighlighterPipeline(highlighters));
        this.getTable().setColumnMargin(1);
        BasicTableHeaderUI headerUI = new BasicTableHeaderUI(){

            @Override
            public Dimension getPreferredSize(JComponent arg0) {
                Dimension dimension = super.getPreferredSize(arg0);
                dimension.setSize(dimension.getWidth(), 45.0);
                return dimension;
            }
        };
        JTableHeader header = this.getTable().getTableHeader();
        header.setUI(headerUI);
        header.setDefaultRenderer(new TableHeaderRenderer());
        header.getDefaultRenderer();
        this.getTable().getTableHeader().getDefaultRenderer();
        this.reloadColumns(hidedColumnIndex);
    }

    void addScrollPaneMouseListener(MouseListener ml) {
        this.getTreeTable().getParent().addMouseListener(ml);
    }

    private void initColumnsAlignements() {
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColType, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColPriority, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColInfo, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColBegDate, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColEndDate, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColDuration, 4);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColCompletion, 4);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColCoordinator, 0);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColPredecessors, 4);
        this.setColumnHorizontalAlignment(GanttTreeTableModel.strColID, 0);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColID).setPreferredWidth(45);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColType).setPreferredWidth(32);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColPriority).setPreferredWidth(42);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColInfo).setPreferredWidth(32);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColName).setPreferredWidth(150);
        this.getTable().getColumnExt((Object)GanttTreeTableModel.strColDuration).setPreferredWidth(45);
    }

    void calculateWidth() {
        int width = 0;
        int nbCol = this.getTable().getColumnCount();
        for (int i = 0; i < nbCol; ++i) {
            TableColumnExt tce = this.getTable().getColumnExt(i);
            if (!tce.isVisible()) continue;
            width += tce.getPreferredWidth();
        }
        this.getTable().setPreferredScrollableViewportSize(new Dimension(width, 0));
    }

    private void createPopupMenu() throws Exception {
        this.mapColNameMenuItem.clear();
        this.popupMenu = new JPopupMenu();
        TableColumnModel tcModel = this.getTable().getColumnModel();
        for (Map.Entry nextEntry : this.mapTableColumnColumnKeeper.entrySet()) {
            ColumnKeeper ck = (ColumnKeeper)nextEntry.getValue();
            if (ck == null) {
                throw new Exception(" ColumnKeeper ck == null");
            }
            if (ck.isDisable()) continue;
            TableColumn column = (TableColumn)nextEntry.getKey();
            JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(column.getHeaderValue().toString());
            jcbmi.setSelected(ck.isShown);
            jcbmi.addActionListener(ck);
            this.mapColNameMenuItem.put(column.getHeaderValue().toString(), jcbmi);
            this.popupMenu.add(jcbmi);
        }
        this.popupMenu.addSeparator();
        JMenuItem jmiDisplayAll = new JMenuItem(language.getText("displayAll"));
        jmiDisplayAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GanttTreeTable.this.project.getUndoManager().undoableEdit("displayAllColumns", new Runnable(){

                    @Override
                    public void run() {
                        GanttTreeTable.this.displayAllColumns();
                    }
                });
            }
        });
        this.popupMenu.add(jmiDisplayAll);
        JMenuItem jmiHiddenAll = new JMenuItem(GanttResourceUtil.getResource("Gantt_HideAll"));
        jmiHiddenAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GanttTreeTable.this.project.getUndoManager().undoableEdit("hiddenAllColumns", new Runnable(){

                    @Override
                    public void run() {
                        GanttTreeTable.this.hiddenAllColumns();
                    }
                });
            }
        });
        this.popupMenu.add(jmiHiddenAll);
    }

    private void renameMenuItem(String oldName, String newName) {
        Component[] t = this.popupMenu.getComponents();
        JCheckBoxMenuItem jcbmi = null;
        for (int i = 0; i < t.length; ++i) {
            if (!(t[i] instanceof JCheckBoxMenuItem) || !(jcbmi = (JCheckBoxMenuItem)t[i]).getText().equals(oldName)) continue;
            jcbmi.setText(newName);
            break;
        }
        if (jcbmi != null) {
            this.mapColNameMenuItem.remove(oldName);
            this.mapColNameMenuItem.put(newName, jcbmi);
        }
    }

    private void displayAllColumns() {
        for (ColumnKeeper ck : this.mapTableColumnColumnKeeper.values()) {
            if (ck.isShown || ck.isDisable()) continue;
            ck.show();
        }
    }

    private void hiddenAllColumns() {
        for (ColumnKeeper ck : this.mapTableColumnColumnKeeper.values()) {
            if (!ck.isShown || ck.isDisable()) continue;
            ck.hide();
        }
    }

    private void hideAllColumns() {
        for (ColumnKeeper ck : this.mapTableColumnColumnKeeper.values()) {
            if (!ck.isShown) continue;
            ck.hide();
        }
    }

    private void displayColumn(String name) {
        int indexView = -1;
        int width = -1;
        for (DisplayedColumn dc : this.listDisplayedColumns) {
            if (!this.getNameForId(dc.getID()).equals(name)) continue;
            indexView = dc.getOrder();
            width = dc.getWidth();
        }
        for (TableColumn c : this.mapTableColumnColumnKeeper.keySet()) {
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            ColumnKeeper ck = (ColumnKeeper)this.mapTableColumnColumnKeeper.get(c);
            if (indexView != -1) {
                ck.index = indexView;
            }
            if (ck.isShown) break;
            ck.show();
            break;
        }
        this.getTable().getColumnExt((Object)name).setPreferredWidth(width);
    }

    private void hideColumn(String name) {
        for (TableColumn c : this.mapTableColumnColumnKeeper.keySet()) {
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            ColumnKeeper ck = (ColumnKeeper)this.mapTableColumnColumnKeeper.get(c);
            if (!ck.isShown) break;
            ck.hide();
            break;
        }
    }

    public void addNewCustomColumn(CustomColumn customColumn) {
        this.addNewCustomColumn(customColumn, null, false);
    }

    public void addNewCustomColumn(CustomColumn customColumn, DefaultCellEditor defaultCellEditor, boolean disable) {
        if (customColumn == null) {
            customColumn = new CustomColumn();
            GanttDialogCustomColumn d = new GanttDialogCustomColumn(this.project.getUIFacade(), customColumn, this.project);
            d.setVisible(true);
        }
        if (customColumn.getName() != null) {
            GanttTreeTableModel treeTableModel = (GanttTreeTableModel)this.getTreeTableModel();
            int nbCol = treeTableModel.getColumnCountTotal();
            String newName = customColumn.getName();
            this.ttModel.addCustomColumn(newName);
            try {
                this.project.getTaskManager().getCustomColumnsStorage().addCustomColumn(customColumn);
            }
            catch (CustomColumnsException ex) {
                if (ex.getType() == 0) {
                    this.addNewCustomColumn(null);
                }
                return;
            }
            TaskContainmentHierarchyFacade tchf = this.project.getTaskManager().getTaskHierarchy();
            this.setCustomColumnValueToAllNestedTask(tchf, tchf.getRootTask(), customColumn.getName(), customColumn.getDefaultValue());
            TableColumnExt t = this.newTableColumnExt(nbCol);
            t.setTitle(newName);
            t.setMaxWidth(500);
            t.setHeaderValue((Object)newName);
            if (defaultCellEditor != null) {
                t.setCellEditor((TableCellEditor)defaultCellEditor);
            }
            this.getTable().getColumnModel().addColumn((TableColumn)t);
            try {
                if (this.clickPoint != null) {
                    this.getTable().getColumnModel().moveColumn(this.getTable().getColumnCount() - 1, this.getTable().columnAtPoint(this.clickPoint));
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            int align = 0;
            if (customColumn.getType().equals(GregorianCalendar.class)) {
                align = 4;
            } else if (customColumn.getType().equals(String.class)) {
                align = 2;
            }
            if (defaultCellEditor.getComponent() instanceof JTextField) {
                align = ((JTextField)defaultCellEditor.getComponent()).getHorizontalAlignment();
            }
            this.setColumnHorizontalAlignment(newName, align);
            DisplayedColumn dc = new DisplayedColumn(this.project.getTaskManager().getCustomColumnsStorage().getIdFromName(newName));
            dc.setOrder(this.getColumn(newName).getModelIndex());
            dc.setWidth(this.getColumn(newName).getPreferredWidth());
            dc.setDisplayed(true);
            this.listDisplayedColumns.add(dc);
            if (GregorianCalendar.class.isAssignableFrom(customColumn.getType())) {
                this.getTable().getColumnExt((Object)newName).setCellEditor(this.newDateCellEditor());
            }
            JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(newName);
            jcbmi.setSelected(true);
            ColumnKeeper ck = new ColumnKeeper((TableColumn)t, disable);
            jcbmi.addActionListener(ck);
            this.mapColNameMenuItem.put(newName, jcbmi);
            if (!disable) {
                this.mapTableColumnColumnKeeper.put(t, ck);
            }
            this.project.setAskForSave(true);
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                GanttTreeTable.this.calculateWidth();
                GanttTreeTable.this.revalidate();
            }
        };
        SwingUtilities.invokeLater(t);
    }

    public void deleteCustomColumn(String name) {
        try {
            this.project.getTaskManager().getCustomColumnsStorage().getCustomColumn(name);
        }
        catch (CustomColumnsException e) {
            return;
        }
        this.displayColumn(name);
        DisplayedColumn toDel = null;
        for (DisplayedColumn dc : this.listDisplayedColumns) {
            if (!this.getNameForId(dc.getID()).equals(name)) continue;
            toDel = dc;
        }
        if (toDel != null) {
            this.listDisplayedColumns.remove(toDel);
        }
        int index = this.getTable().getColumnModel().getColumnIndex(name);
        int modelIndex = this.getTable().convertColumnIndexToModel(index);
        TableColumnModelEvent tcme = new TableColumnModelEvent(this.getTable().getColumnModel(), modelIndex, modelIndex);
        this.getTable().removeColumn((TableColumn)this.getTable().getColumnExt((Object)name));
        this.getTable().columnRemoved(tcme);
        this.ttModel.deleteCustomColumn(name);
        this.project.getTaskManager().getCustomColumnsStorage().removeCustomColumn(name);
        TaskContainmentHierarchyFacade tchf = this.project.getTaskManager().getTaskHierarchy();
        tchf.getRootTask().getCustomValues().removeCustomColumn(name);
        this.removeCustomColumnToAllNestedTask(tchf, tchf.getRootTask(), name);
        this.popupMenu.remove(this.popupMenu.getComponentIndex((Component)this.mapColNameMenuItem.get(name)));
        this.mapColNameMenuItem.remove(name);
        for (TableColumn c : this.mapTableColumnColumnKeeper.keySet()) {
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            this.mapTableColumnColumnKeeper.remove(c);
            break;
        }
        this.project.setAskForSave(true);
    }

    public void renameCustomcolumn(String name, String newName) {
        this.project.setAskForSave(true);
        this.displayColumn(name);
        TableColumnExt tc = (TableColumnExt)this.getTable().getColumn((Object)name);
        tc.setTitle(newName);
        this.project.repaint();
        this.renameMenuItem(name, newName);
        TaskContainmentHierarchyFacade tchf = this.project.getTaskManager().getTaskHierarchy();
        tchf.getRootTask().getCustomValues().renameCustomColumn(name, newName);
        this.renameCustomColumnForAllNestedTask(tchf, tchf.getRootTask(), name, newName);
        this.ttModel.renameCustomColumn(name, newName);
        for (TableColumn c : this.mapTableColumnColumnKeeper.keySet()) {
            String n = (String)c.getHeaderValue();
            if (!n.equals(name)) continue;
            ColumnKeeper ck = (ColumnKeeper)this.mapTableColumnColumnKeeper.get(c);
            ((TableColumnExt)c).setTitle(newName);
            break;
        }
    }

    private void setCustomColumnValueToAllNestedTask(TaskContainmentHierarchyFacade facade, Task root, String colName, Object value) {
        try {
            root.getCustomValues().setValue(colName, value);
        }
        catch (CustomColumnsException e) {
            e.printStackTrace();
        }
        Task[] tt = facade.getNestedTasks(root);
        for (int i = 0; i < tt.length; ++i) {
            try {
                tt[i].getCustomValues().setValue(colName, value);
            }
            catch (CustomColumnsException e1) {
                e1.printStackTrace();
            }
            this.setCustomColumnValueToAllNestedTask(facade, tt[i], colName, value);
        }
    }

    private void removeCustomColumnToAllNestedTask(TaskContainmentHierarchyFacade facade, Task root, String colName) {
        Task[] tt = facade.getNestedTasks(root);
        for (int i = 0; i < tt.length; ++i) {
            tt[i].getCustomValues().removeCustomColumn(colName);
            this.removeCustomColumnToAllNestedTask(facade, tt[i], colName);
        }
    }

    private void renameCustomColumnForAllNestedTask(TaskContainmentHierarchyFacade facade, Task root, String oldName, String newName) {
        Task[] tt = facade.getNestedTasks(root);
        for (int i = 0; i < tt.length; ++i) {
            tt[i].getCustomValues().renameCustomColumn(oldName, newName);
            this.renameCustomColumnForAllNestedTask(facade, tt[i], oldName, newName);
        }
    }

    @Override
    public void languageChanged(GanttLanguage.Event changeEvent) {
    }

    String getIdForName(String colName) {
        String id = null;
        id = colName.equals(GanttTreeTableModel.strColType) ? "tpd0" : (colName.equals(GanttTreeTableModel.strColPriority) ? "tpd1" : (colName.equals(GanttTreeTableModel.strColInfo) ? "tpd2" : (colName.equals(GanttTreeTableModel.strColName) ? "tpd3" : (colName.equals(GanttTreeTableModel.strColBegDate) || colName.equals(GanttResourceUtil.getResource("Gantt_StartDay")) || colName.equals(GanttResourceUtil.getResource("Gantt_StartDay1")) ? "tpd4" : (colName.equals(GanttTreeTableModel.strColEndDate) || colName.equals(GanttResourceUtil.getResource("Gantt_EndDay")) || colName.equals(GanttResourceUtil.getResource("Gantt_EndDay1")) ? "tpd5" : (colName.equals(GanttTreeTableModel.strColDuration) || colName.equals(GanttResourceUtil.getResource("Gantt_Work")) || colName.equals(GanttResourceUtil.getResource("Gantt_LastDays")) ? "tpd6" : (colName.equals(GanttTreeTableModel.strColCompletion) ? "tpd7" : (colName.equals(GanttTreeTableModel.strColCoordinator) ? "tpd8" : (colName.equals(GanttTreeTableModel.strColPredecessors) ? "tpd9" : (colName.equals(GanttTreeTableModel.strColID) ? "tpd10" : this.project.getTaskManager().getCustomColumnsStorage().getIdFromName(colName)))))))))));
        return id;
    }

    private String getNameForId(String id) {
        String name = null;
        name = id.equals("tpd0") ? GanttTreeTableModel.strColType : (id.equals("tpd1") ? GanttTreeTableModel.strColPriority : (id.equals("tpd2") ? GanttTreeTableModel.strColInfo : (id.equals("tpd3") ? GanttTreeTableModel.strColName : (id.equals("tpd4") ? GanttTreeTableModel.strColBegDate : (id.equals("tpd5") ? GanttTreeTableModel.strColEndDate : (id.equals("tpd6") ? GanttTreeTableModel.strColDuration : (id.equals("tpd7") ? GanttTreeTableModel.strColCompletion : (id.equals("tpd8") ? GanttTreeTableModel.strColCoordinator : (id.equals("tpd9") ? GanttTreeTableModel.strColPredecessors : (id.equals("tpd10") ? GanttTreeTableModel.strColID : this.project.getTaskManager().getCustomColumnsStorage().getNameFromId(id)))))))))));
        return name;
    }

    public JTree getTree() {
        return this.getTreeTable().getTree();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane.getVerticalScrollBar();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void centerViewOnSelectedCell() {
        int row = this.getTable().getSelectedRow();
        int col = this.getTable().getEditingColumn();
        if (col == -1) {
            col = this.getTable().getSelectedColumn();
        }
        Rectangle rect = this.getTable().getCellRect(row, col, true);
        this.scrollPane.getHorizontalScrollBar().scrollRectToVisible(rect);
        this.scrollPane.getViewport().scrollRectToVisible(rect);
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.getTable().addMouseListener(mouseListener);
        this.getTree().addMouseListener(mouseListener);
        this.getTreeTable().getParent().addMouseListener(mouseListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.getTable().addKeyListener(keyListener);
        this.getTree().addKeyListener(keyListener);
    }

    void setDelay(TaskNode taskNode, Delay delay) {
        try {
            int indexInfo = this.getTable().getColumnModel().getColumnIndex(GanttTreeTableModel.strColInfo);
            indexInfo = this.getTable().convertColumnIndexToModel(indexInfo);
            this.ttModel.setValueAt(delay, taskNode, indexInfo);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void editNewTask(Task t) {
        TreePath selectedPath = this.getTree().getSelectionPath();
        int c = this.getTable().convertColumnIndexToView(this.getTable().getColumn((Object)GanttTreeTableModel.strColName).getModelIndex());
        NameCellEditor nameCellEditor = (NameCellEditor)this.getTable().getCellEditor(-1, c);
        this.getTreeTable().editCellAt(this.getTree().getRowForPath(selectedPath), c);
        nameCellEditor.requestFocus();
    }

    public CustomColumnsManager getCustomColumnsManager() {
        return this.customColumnsManager;
    }

    @Override
    public GanttProject getGanttProject() {
        return this.project;
    }

    class NullCellEditor
    extends DefaultCellEditor {
        int type;
        Object value;
        private static final long serialVersionUID = -2218243367823738265L;

        public NullCellEditor() {
            super((JTextField)new KDTextField());
            this.type = -1;
        }

        public NullCellEditor(int myType) {
            super((JTextField)new KDTextField());
            this.type = -1;
            this.type = myType;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            int taskIdColumnIndex = -1;
            for (int i = 0; i < arg0.getColumnCount(); ++i) {
                if (!arg0.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                taskIdColumnIndex = i;
                break;
            }
            int taskId = Integer.parseInt(arg0.getValueAt(arg3, taskIdColumnIndex).toString());
            GanttTask task = GanttTreeTable.this.project.getTaskManager().getTask(taskId);
            if (UIInstanceOf.isUI(GanttTreeTable.this.getGanttProject(), 4) && task.getCompletionPercentage() == 100.0f) {
                return null;
            }
            Object taskNode = null;
            switch (this.type) {
                case 0: {
                    GanttTreeTable.this.project.propertiesTask(1);
                    break;
                }
                case 1: {
                    GanttTreeTable.this.project.propertiesTask(0);
                }
            }
            return null;
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }
    }

    class CombCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 4557936360974398501L;
        private JComboBox field;

        public CombCellEditor(JComboBox comboBox) {
            super(comboBox);
            this.field = null;
            this.field = (JComboBox)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            int taskIdColumnIndex = -1;
            for (int i = 0; i < arg0.getColumnCount(); ++i) {
                if (!arg0.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                taskIdColumnIndex = i;
                break;
            }
            int taskId = Integer.parseInt(arg0.getValueAt(arg3, taskIdColumnIndex).toString());
            GanttTask task = GanttTreeTable.this.project.getTaskManager().getTask(taskId);
            if (UIInstanceOf.isUI(GanttTreeTable.this.getGanttProject(), 4) && task.getCompletionPercentage() == 100.0f) {
                return null;
            }
            GanttTreeTable.this.project.currentEditCell = this;
            return super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
        }

        public void requestFocus() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CombCellEditor.this.field.requestFocus();
                }
            });
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }
    }

    class NumberCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 4557936360974398501L;
        private KDTextField field;
        private BigDecimal value;

        public NumberCellEditor() {
            super((JTextField)new KDTextField());
            this.field = null;
            this.value = new BigDecimal("0");
            this.field = (KDTextField)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            int taskIdColumnIndex = -1;
            for (int i = 0; i < arg0.getColumnCount(); ++i) {
                if (!arg0.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                taskIdColumnIndex = i;
                break;
            }
            int taskId = Integer.parseInt(arg0.getValueAt(arg3, taskIdColumnIndex).toString());
            GanttTask task = GanttTreeTable.this.project.getTaskManager().getTask(taskId);
            TaskNode taskNode = (TaskNode)GanttTreeTable.this.project.getTree().getNode(task.getTaskID());
            if (!taskNode.isLeaf()) {
                return null;
            }
            if (UIInstanceOf.isUI(GanttTreeTable.this.getGanttProject(), 4) && (task.getCompletionPercentage() == 100.0f || task.getCompletionPercentage() > 0.0f)) {
                return null;
            }
            KDTextField result = (KDTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            GanttTreeTable.this.project.currentEditCell = this;
            try {
                this.value = new BigDecimal(((JTextComponent)this.getComponent()).getText());
            }
            catch (Exception e) {
                this.value = new BigDecimal("0");
            }
            return result;
        }

        public void requestFocus() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NumberCellEditor.this.field.requestFocus();
                    NumberCellEditor.this.field.selectAll();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            try {
                BigDecimal temp = new BigDecimal(((JTextComponent)this.getComponent()).getText());
                if (temp.floatValue() < 0.0f) {
                    throw new Exception("");
                }
                this.value = temp.setScale(2, 4);
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
            }
            return this.value;
        }

        @Override
        public boolean stopCellEditing() {
            boolean res = true;
            try {
                this.value = new BigDecimal(((JTextComponent)this.getComponent()).getText());
                if (this.value.floatValue() < 0.0f) {
                    throw new Exception("");
                }
                this.value = this.value.setScale(2, 4);
                super.fireEditingStopped();
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
                Color colorError = new Color(255, 125, 125);
                this.getComponent().setBackground(colorError);
                res = false;
            }
            return res;
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }
    }

    class DurationCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 4557936360974398501L;
        private KDTextField field;
        Integer value;
        private final Color colorError;

        public DurationCellEditor() {
            super((JTextField)new KDTextField());
            this.field = null;
            this.colorError = new Color(255, 125, 125);
            this.field = (KDTextField)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            int taskIdColumnIndex = -1;
            for (int i = 0; i < arg0.getColumnCount(); ++i) {
                if (!arg0.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                taskIdColumnIndex = i;
                break;
            }
            int taskId = Integer.parseInt(arg0.getValueAt(arg3, taskIdColumnIndex).toString());
            GanttTask task = GanttTreeTable.this.project.getTaskManager().getTask(taskId);
            TaskNode taskNode = (TaskNode)GanttTreeTable.this.project.getTree().getNode(task.getTaskID());
            if (!taskNode.isLeaf()) {
                return null;
            }
            if (UIInstanceOf.isUI(GanttTreeTable.this.getGanttProject(), 4) && task.getCompletionPercentage() == 100.0f) {
                return null;
            }
            KDTextField result = (KDTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            GanttTreeTable.this.project.currentEditCell = this;
            this.value = Integer.valueOf(this.field.getText());
            return result;
        }

        public void requestFocus() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DurationCellEditor.this.field.requestFocus();
                    DurationCellEditor.this.field.selectAll();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            try {
                Integer temp = Integer.valueOf(((JTextComponent)this.getComponent()).getText());
                if (temp <= 0) {
                    throw new Exception(GanttResourceUtil.getResource("Gantt_LastDay1"));
                }
                if (temp > 3652) {
                    MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_WorkDayTooLong"));
                    throw new Exception(GanttResourceUtil.getResource("Gantt_WorkDayTooLong"));
                }
                this.value = temp;
            }
            catch (Exception e) {
                GanttTreeTable.this.project.setStatusText(e.getMessage());
            }
            return this.value;
        }

        @Override
        public boolean stopCellEditing() {
            boolean res = true;
            try {
                Integer value = Integer.valueOf(((JTextComponent)this.getComponent()).getText());
                if (value <= 0) {
                    throw new Exception(GanttResourceUtil.getResource("Gantt_LastDay1"));
                }
                if (value > 3652) {
                    MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_WorkDayTooLong"));
                    throw new Exception(GanttResourceUtil.getResource("Gantt_LastDayRang"));
                }
                super.fireEditingStopped();
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
                this.getComponent().setBackground(this.colorError);
                res = false;
            }
            return res;
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }
    }

    class ModelListener
    implements TableModelListener {
        ModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            GanttTreeTable.this.project.repaint();
        }
    }

    class NameCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 9114618678312870415L;
        private KDTextField field;
        private String temp;

        public NameCellEditor() {
            super((JTextField)new KDTextField());
            this.field = null;
            this.field = (KDTextField)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable arg0, Object arg1, boolean arg2, int arg3, int arg4) {
            if (UIInstanceOf.isUI(GanttTreeTable.this.getGanttProject(), 4)) {
                JTable table = arg0;
                int row = arg3;
                int taskIdColumnIndex = -1;
                for (int i = 0; i < table.getColumnCount(); ++i) {
                    if (!table.getColumnName(i).equals(GanttTreeTableModel.strColID)) continue;
                    taskIdColumnIndex = i;
                    break;
                }
                if (taskIdColumnIndex == -1) {
                    return null;
                }
                int taskId = Integer.parseInt(table.getValueAt(row, taskIdColumnIndex).toString());
                GanttTask task = GanttTreeTable.this.project.getTaskManager().getTask(taskId);
                Date date = task.getStart().getTime();
                if (date.before(ModifyStandDate.getStandDate())) {
                    return null;
                }
            }
            KDTextField result = (KDTextField)super.getTableCellEditorComponent(arg0, arg1, arg2, arg3, arg4);
            result.selectAll();
            GanttTreeTable.this.project.currentEditCell = this;
            this.temp = result.getText();
            return result;
        }

        public void requestFocus() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NameCellEditor.this.field.requestFocus();
                    NameCellEditor.this.field.selectAll();
                }
            });
        }

        @Override
        public boolean stopCellEditing() {
            boolean res = true;
            try {
                String value = ((JTextComponent)this.getComponent()).getText();
                if ("".equals(value.trim())) {
                    throw new Exception(GanttResourceUtil.getResource("Gantt_NameNotNull"));
                }
                super.fireEditingStopped();
            }
            catch (Exception e) {
                Toolkit.getDefaultToolkit().beep();
                Color colorError = new Color(255, 125, 125);
                this.getComponent().setBackground(colorError);
                this.field.setText(this.temp);
                res = false;
            }
            return res;
        }

        public void loseFoucs() {
            super.fireEditingStopped();
        }
    }

    class HeaderMouseListener
    extends MouseAdapter {
        boolean first = false;

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopupTrigger(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopupTrigger(e);
        }

        private void handlePopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                try {
                    GanttTreeTable.this.createPopupMenu();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                Component c = (Component)e.getSource();
                GanttTreeTable.this.popupMenu.show(c, e.getX(), e.getY());
                GanttTreeTable.this.clickPoint = e.getPoint();
                CustomColumn cc = null;
                try {
                    cc = GanttTreeTable.this.project.getTaskManager().getCustomColumnsStorage().getCustomColumn(GanttTreeTable.this.getTable().getColumnName(GanttTreeTable.this.getTable().columnAtPoint(e.getPoint())));
                }
                catch (CustomColumnsException customColumnsException) {
                    // empty catch block
                }
            }
        }
    }

    class ColumnKeeper
    implements ActionListener {
        private int index;
        private boolean disable = false;
        private boolean isShown = true;
        protected TableColumn column;

        public ColumnKeeper(TableColumn tc) {
            this.column = tc;
            this.index = this.column.getModelIndex();
        }

        public ColumnKeeper(TableColumn tc, boolean myDisable) {
            this.column = tc;
            this.index = this.column.getModelIndex();
            this.disable = myDisable;
        }

        public void setInitIndex(int initIndex) {
            this.index = initIndex;
        }

        public int getInitIndex() {
            return this.index;
        }

        void hide() {
            GanttTreeTable.this.getTable().getColumnModel().removeColumn(this.column);
            this.isShown = false;
            String name = (String)this.column.getHeaderValue();
            String id = GanttTreeTable.this.getIdForName(name);
            for (DisplayedColumn dc : GanttTreeTable.this.listDisplayedColumns) {
                if (!dc.getID().equals(id)) continue;
                dc.setDisplayed(false);
            }
            GanttTreeTable.this.calculateWidth();
            GanttTreeTable.this.revalidate();
        }

        void show() {
            boolean reloadInfo = false;
            GanttTreeTable.this.getTable().getColumnModel().addColumn(this.column);
            try {
                int columnViewIndexOld = this.index;
                int columnModelIndexActual = this.column.getModelIndex();
                if (this.column.getIdentifier().equals(GanttTreeTableModel.strColInfo)) {
                    reloadInfo = true;
                }
                int columnViewIndexActual = GanttTreeTable.this.getTable().convertColumnIndexToView(columnModelIndexActual);
                GanttTreeTable.this.getTable().moveColumn(columnViewIndexActual, columnViewIndexOld);
            }
            catch (IllegalArgumentException e) {
                this.index = GanttTreeTable.this.getTable().getModel().getColumnCount() - 1;
            }
            this.isShown = true;
            String name = (String)this.column.getHeaderValue();
            String id = GanttTreeTable.this.getIdForName(name);
            boolean found = false;
            for (DisplayedColumn dc : GanttTreeTable.this.listDisplayedColumns) {
                if (!dc.getID().equals(id)) continue;
                dc.setDisplayed(true);
                found = true;
            }
            if (!found && id != null) {
                DisplayedColumn dc;
                dc = new DisplayedColumn(id);
                dc.setDisplayed(true);
                GanttTreeTable.this.listDisplayedColumns.add(dc);
            }
            if (reloadInfo && GanttTreeTable.this.project.getMyDelayManager() != null) {
                GanttTreeTable.this.project.getMyDelayManager().fireDelayObservation();
            }
            GanttTreeTable.this.calculateWidth();
            GanttTreeTable.this.revalidate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GanttTreeTable.this.project.getUndoManager().undoableEdit("HIDE OR SHOW A COLUMN", new Runnable(){

                @Override
                public void run() {
                    if (!ColumnKeeper.this.isShown) {
                        ColumnKeeper.this.show();
                    } else {
                        ColumnKeeper.this.hide();
                    }
                    GanttTreeTable.this.getTable().repaint();
                }
            });
        }

        public boolean isDisable() {
            return this.disable;
        }

        public void setDisable(boolean disable) {
            this.disable = disable;
        }
    }

    public class DisplayedColumn
    implements Comparable {
        private String id = null;
        private boolean displayed = false;
        private int order = -1;
        private int width = 0;

        public DisplayedColumn(String id) {
            this.id = id;
        }

        public void setID(String id) {
            this.id = id;
        }

        public void setDisplayed(boolean disp) {
            this.displayed = disp;
        }

        public boolean isDisplayed() {
            return this.displayed;
        }

        public String getID() {
            return this.id;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public Object clone() {
            DisplayedColumn dc = new DisplayedColumn(this.id);
            dc.setDisplayed(this.isDisplayed());
            dc.setOrder(this.getOrder());
            dc.setWidth(this.getWidth());
            return dc;
        }

        public String toString() {
            return "[ID = " + this.id + ", displayed = " + this.displayed + ", order = " + this.order + "]";
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 0;
            }
            if (o instanceof DisplayedColumn) {
                DisplayedColumn dc = (DisplayedColumn)o;
                if (this.order != dc.order) {
                    return this.order - dc.order;
                }
                return this.id.compareTo(dc.id);
            }
            return 0;
        }
    }

    public class DisplayedColumnsList
    extends ArrayList {
        public boolean isDisplayed(String name) {
            for (DisplayedColumn dc : this) {
                if (!GanttTreeTable.this.getNameForId(dc.getID()).equals(name)) continue;
                return dc.isDisplayed();
            }
            return false;
        }

        public int getOrderForName(String name) {
            for (DisplayedColumn dc : this) {
                if (!GanttTreeTable.this.getNameForId(dc.getID()).equals(name)) continue;
                return dc.getOrder();
            }
            return -1;
        }

        public String getNameForOrder(int order) {
            for (DisplayedColumn dc : this) {
                if (dc.getOrder() != order) continue;
                return GanttTreeTable.this.getNameForId(dc.getID());
            }
            return null;
        }

        @Override
        public boolean add(Object o) {
            if (o instanceof DisplayedColumn) {
                DisplayedColumn dc1 = (DisplayedColumn)o;
                for (DisplayedColumn dc : this) {
                    if (dc.getID() != null && !dc.getID().equals(dc1.getID())) continue;
                    this.remove(dc);
                    return super.add(dc1);
                }
                return super.add(dc1);
            }
            return false;
        }

        @Override
        public Object clone() {
            DisplayedColumnsList l = new DisplayedColumnsList();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                l.add(((DisplayedColumn)it.next()).clone());
            }
            return l;
        }
    }
}

