/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.ProjectUtil;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.delay.Delay;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.CustomColumnsException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskInfo;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdesktop.swing.treetable.DefaultTreeTableModel;

public class GanttTreeTableModel
extends DefaultTreeTableModel
implements TableColumnModelListener,
TaskContainmentHierarchyFacade,
GanttLanguage.Listener {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTreeTableModel");
    private static GanttLanguage language = GanttLanguage.getInstance();
    public static String strColType = null;
    public static String strColPriority = null;
    public static String strColInfo = null;
    public static String strColNumber = null;
    public static String strColName = null;
    public static String strColBegDate = null;
    public static String strColEndDate = null;
    public static String strColDuration = null;
    public static String strColCompletion = null;
    public static String strColCoordinator = null;
    public static String strColPredecessors = null;
    public static String strColID = null;
    public List titles = null;
    private Vector customColumns = null;
    private int nbCol;
    private int nbColTot = this.nbCol = 11;
    private GanttProject appli;

    public GanttTreeTableModel(TreeNode root, GanttProject project) {
        super(root);
        this.titles = new ArrayList();
        this.customColumns = new Vector();
        this.appli = project;
        this.changeLanguage(language);
    }

    public void changeLanguage(GanttLanguage ganttLanguage) {
        strColType = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_TYPE");
        strColPriority = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_PRIORITY");
        strColInfo = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_MSG");
        strColName = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_NAME");
        strColBegDate = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_BEGIN");
        strColEndDate = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_END");
        strColDuration = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "Gantt_Work");
        strColCompletion = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_COMPLETEPERCENTEGE");
        strColCoordinator = language.getText("tableColCoordinator");
        strColPredecessors = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_PRETASK");
        strColID = ProjectUtil.getResource("com.kingdee.eas.mm.project.GanttProjectResource", "GANTT_TABLE_COL_ID");
        this.titles.clear();
        String[] cols = new String[]{strColType, strColPriority, strColInfo, strColID, strColName, strColBegDate, strColEndDate, strColDuration, strColCompletion, strColCoordinator, strColPredecessors};
        for (int i = 0; i < cols.length; ++i) {
            this.titles.add(new String(cols[i]));
        }
    }

    public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
        parent.insert(newChild, index);
        int[] newIndexs = new int[]{index};
        this.nodesWereInserted(parent, newIndexs);
    }

    public void removeNodeFromParent(MutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("node does not have a parent.");
        }
        int[] childIndex = new int[1];
        Object[] removedArray = new Object[1];
        childIndex[0] = parent.getIndex(node);
        parent.remove(childIndex[0]);
        removedArray[0] = node;
        this.nodesWereRemoved(parent, childIndex, removedArray);
    }

    public void addCustomColumn(String title) {
        this.customColumns.add(title);
        ++this.nbColTot;
    }

    public void deleteCustomColumn(String title) {
        this.customColumns.remove(title);
        this.columnRemoved(null);
        --this.nbColTot;
    }

    public void renameCustomColumn(String oldName, String newName) {
        this.customColumns.set(this.customColumns.indexOf(oldName), newName);
    }

    public int getColumnCount() {
        return this.nbCol;
    }

    public int getColumnCountTotal() {
        return this.nbColTot;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 2: {
                return Icon.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return hierarchicalColumnClass;
            }
            case 5: 
            case 6: {
                return GregorianCalendar.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Integer.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return String.class;
            }
        }
        TaskNode tn = (TaskNode)this.getRoot();
        Object o = this.getValueAt(tn, column);
        if (o == null) {
            o = "erreur";
            System.err.println("!!!!!!!!!!!!!!!!!");
        }
        return o.getClass();
    }

    public String getColumnName(int column) {
        if (column < this.titles.size()) {
            return (String)this.titles.get(column);
        }
        try {
            return (String)this.customColumns.get(column - this.titles.size());
        }
        catch (IndexOutOfBoundsException e) {
            return (String)this.customColumns.get(column - this.titles.size() - 1);
        }
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public Object getValueAt(Object node, int column) {
        Object res = null;
        if (!(node instanceof TaskNode)) {
            return null;
        }
        TaskNode tn = (TaskNode)node;
        Task t = (Task)tn.getUserObject();
        switch (column) {
            case 0: {
                if (((Task)tn.getUserObject()).isProjectTask()) {
                    res = new ImageIcon(this.getClass().getResource("/icons/mproject.gif"));
                    break;
                }
                if (!tn.isLeaf()) {
                    res = new ImageIcon(this.getClass().getResource("/icons/mtask.gif"));
                    break;
                }
                if (t.isMilestone()) {
                    res = new ImageIcon(this.getClass().getResource("/icons/meeting.gif"));
                    break;
                }
                res = new ImageIcon(this.getClass().getResource("/icons/tasks2.png"));
                break;
            }
            case 1: {
                Task task = (Task)tn.getUserObject();
                String path = task.getPriority() == 0 ? "/icons/task1.gif" : (task.getPriority() == 1 ? "/icons/task.gif" : "/icons/task2.gif");
                res = new ImageIcon(this.getClass().getResource(path));
                break;
            }
            case 2: {
                TaskInfo info = t.getTaskInfo();
                if (info == null || !(info instanceof Delay)) break;
                int type = ((Delay)info).getType();
                if (type == 0) {
                    res = new ImageIcon(this.getClass().getResource("/icons/alert1_16.gif"));
                    break;
                }
                if (type != 1) break;
                res = new ImageIcon(this.getClass().getResource("/icons/alert2_16.gif"));
                break;
            }
            case 3: {
                res = new Integer(t.getTaskID());
                break;
            }
            case 4: {
                res = tn.getName();
                break;
            }
            case 5: {
                res = tn.getStart();
                break;
            }
            case 6: {
                res = tn.getEnd();
                break;
            }
            case 7: {
                res = new Integer(tn.getDuration());
                break;
            }
            case 8: {
                BigDecimal completePercentage = new BigDecimal(tn.getCompletionPercentage());
                res = completePercentage.setScale(2, 4);
                break;
            }
            case 9: {
                ResourceAssignment[] tAssign = t.getAssignments();
                StringBuffer sb = new StringBuffer();
                int nb = 0;
                for (int i = 0; i < tAssign.length; ++i) {
                    ResourceAssignment resAss = tAssign[i];
                    if (!resAss.isCoordinator()) continue;
                    sb.append(nb++ == 0 ? "" : ", ").append(resAss.getResource().getName());
                }
                res = sb.toString();
                break;
            }
            case 10: {
                String resStr = "";
                TaskDependency[] dep = t.getDependenciesAsDependant().toArray();
                int i = 0;
                if (dep != null && dep.length > 0) {
                    for (i = 0; i < dep.length - 1; ++i) {
                        resStr = resStr + dep[i].getDependee().getTaskID() + ", ";
                    }
                    resStr = resStr + dep[i].getDependee().getTaskID() + "";
                }
                res = resStr;
                break;
            }
            default: {
                String colName = this.getColumnName(column);
                res = t.getCustomValues().getValue(colName);
            }
        }
        return res;
    }

    public void setValueAt(final Object value, final Object node, final int column) {
        if (value == null) {
            return;
        }
        if (this.isCellEditable(node, column)) {
            this.appli.getUndoManager().undoableEdit("Change properties column", new Runnable(){

                @Override
                public void run() {
                    GanttTreeTableModel.this.setValue(value, node, column);
                }
            });
        } else {
            this.setValue(value, node, column);
        }
        this.appli.repaint();
        this.appli.setAskForSave(true);
    }

    private void setValue(Object value, Object node, int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 2: {
                ((TaskNode)node).setTaskInfo((TaskInfo)value);
            }
            case 8: {
                break;
            }
            case 3: {
                ((TaskNode)node).setName(value.toString());
                break;
            }
            case 4: {
                ((TaskNode)node).setStart((GanttCalendar)value);
                ((TaskNode)node).applyThirdDateConstraint();
                break;
            }
            case 5: {
                ((TaskNode)node).setEnd((GanttCalendar)value);
                break;
            }
            case 6: {
                Task task = (Task)((TaskNode)node).getUserObject();
                TaskLength tl = task.getDuration();
                ((TaskNode)node).setDuration(task.getManager().createLength(tl.getTimeUnit(), ((Integer)value).intValue()));
                break;
            }
            case 7: {
                ((TaskNode)node).setCompletionPercentage((Integer)value);
                break;
            }
            default: {
                try {
                    ((Task)((TaskNode)node).getUserObject()).getCustomValues().setValue(this.getColumnName(column), value);
                    break;
                }
                catch (CustomColumnsException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent arg0) {
        ++this.nbCol;
    }

    @Override
    public void columnRemoved(TableColumnModelEvent arg0) {
        --this.nbCol;
    }

    @Override
    public void columnMoved(TableColumnModelEvent arg0) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent arg0) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent arg0) {
    }

    @Override
    public Task[] getNestedTasks(Task container) {
        TaskNode r = (TaskNode)this.root;
        Enumeration<TreeNode> e = r.children();
        Vector<TaskNode> v = new Vector<TaskNode>();
        while (e.hasMoreElements()) {
            v.add((TaskNode)e.nextElement());
        }
        Task[] res = new Task[v.size()];
        v.toArray(res);
        return res;
    }

    @Override
    public boolean hasNestedTasks(Task container) {
        TaskNode r = (TaskNode)this.root;
        return r.getChildCount() > 0;
    }

    @Override
    public Task getRootTask() {
        return (Task)((TaskNode)this.getRoot()).getUserObject();
    }

    public TaskNode getTaskNodeForTask(Task task) {
        Enumeration<TreeNode> enumeration = ((TaskNode)this.getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            TaskNode tn;
            Task t;
            TreeNode next = enumeration.nextElement();
            if (!(next instanceof TaskNode) || !(t = (Task)(tn = (TaskNode)next).getUserObject()).equals(task)) continue;
            return tn;
        }
        return null;
    }

    @Override
    public Task getContainer(Task nestedTask) {
        return null;
    }

    @Override
    public void move(Task whatMove, Task whereMove) {
    }

    @Override
    public boolean areUnrelated(Task dependant, Task dependee) {
        return false;
    }

    @Override
    public int getDepth(Task task) {
        return 0;
    }

    @Override
    public void languageChanged(GanttLanguage.Event event) {
        this.changeLanguage(event.getLanguage());
    }

    @Override
    public int compareDocumentOrder(Task next, Task dependeeTask) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Task task) {
        throw new UnsupportedOperationException();
    }

    public static void setStrColName(String string) {
        strColName = string;
    }
}

