/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ChartComponentBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttCalendar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttExportSettings;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ResourceTreeImageGenerator;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelBase;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartModelResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ChartSelection;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.RenderedChartImage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.RenderedResourceChartImage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.ResourceChart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IStatus;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.Status;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.font.Fonts;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.AssignmentNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResourceManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.ResourceAssignment;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskLength;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.time.gregorian.GregorianCalendar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Icon;

public class ResourceLoadGraphicArea
extends ChartComponentBase
implements ResourceChart {
    private int margY;
    private boolean drawVersion = false;
    private GanttProject appli;
    private ChartModelResource myChartModel;
    private MouseMotionListener myMouseMotionListener;
    private MouseListener myMouseListener;
    private ChartComponentBase.AbstractChartImplementation myChartImplementation = new ChartComponentBase.AbstractChartImplementation(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Object object = ChartModelBase.STATIC_MUTEX;
            synchronized (object) {
                super.paintComponent(g);
                ResourceLoadGraphicArea.super.paintComponent(g);
                ResourceLoadGraphicArea.this.myChartModel.setHeaderHeight(ResourceLoadGraphicArea.this.getHeaderHeight());
                ResourceLoadGraphicArea.this.myChartModel.setBottomUnitWidth(ResourceLoadGraphicArea.this.getViewState().getBottomUnitWidth());
                ResourceLoadGraphicArea.this.myChartModel.setRowHeight(ResourceLoadGraphicArea.this.getRowHeight());
                ResourceLoadGraphicArea.this.myChartModel.setTopTimeUnit(ResourceLoadGraphicArea.this.getViewState().getTopTimeUnit());
                ResourceLoadGraphicArea.this.myChartModel.setBottomTimeUnit(ResourceLoadGraphicArea.this.getViewState().getBottomTimeUnit());
                ResourceLoadGraphicArea.this.myChartModel.paint(g);
                if (ResourceLoadGraphicArea.this.drawVersion) {
                    ResourceLoadGraphicArea.this.drawGPVersion(g);
                }
            }
        }

        @Override
        public ChartSelection getSelection() {
            ChartComponentBase.ChartSelectionImpl result = new ChartComponentBase.ChartSelectionImpl(){

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public void startCopyClipboardTransaction() {
                    super.startCopyClipboardTransaction();
                    ResourceLoadGraphicArea.this.appli.getResourcePanel().copySelection();
                }

                @Override
                public void startMoveClipboardTransaction() {
                    super.startMoveClipboardTransaction();
                    ResourceLoadGraphicArea.this.appli.getResourcePanel().cutSelection();
                }
            };
            return result;
        }

        @Override
        public IStatus canPaste(ChartSelection selection) {
            return Status.OK_STATUS;
        }

        @Override
        public void paste(ChartSelection selection) {
            ResourceLoadGraphicArea.this.appli.getResourcePanel().pasteSelection();
        }
    };

    public ResourceLoadGraphicArea(GanttProject app, ZoomManager zoomManager) {
        super(app, app, zoomManager);
        this.setBackground(Color.WHITE);
        this.myChartModel = new ChartModelResource(this.getTaskManager(), (HumanResourceManager)app.getHumanResourceManager(), this.getTimeUnitStack(), this.getUIConfiguration(), this, app);
        this.getViewState().addStateListener(this.myChartModel);
        this.getViewState().setStartDate(GregorianCalendar.getInstance().getTime());
        this.margY = 0;
        this.appli = app;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(465, 600);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.myChartModel.setBounds(this.getSize());
        this.myChartImplementation.paintComponent(g);
    }

    protected int getHeaderHeight() {
        return 0;
    }

    protected int getRowHeight() {
        return 20;
    }

    public void drawGPVersion(Graphics g) {
        g.setColor(Color.black);
        g.setFont(Fonts.GP_VERSION_FONT);
        g.drawString("GanttProject (2.0.2)", 3, this.getHeight() - 8);
    }

    public int indexOf(ArrayList listOfParam, String coef) {
        for (int i = 0; i < listOfParam.size(); ++i) {
            if (coef != listOfParam.get(i).toString()) continue;
            return i;
        }
        return -1;
    }

    public void setScrollBar(int v) {
        this.margY = v;
        this.getChartModel().getChartUIConfiguration().setYOffSet(v);
    }

    @Override
    public BufferedImage getChart(GanttExportSettings settings) {
        RenderedChartImage renderedImage = (RenderedChartImage)this.getRenderedImage(settings);
        BufferedImage result = renderedImage.getWholeImage();
        this.repaint();
        return result;
    }

    @Override
    public RenderedImage getRenderedImage(GanttExportSettings settings) {
        TaskLength printedLength;
        int chartWidth;
        Date dateEnd;
        Date dateStart = settings.getStartDate() == null ? this.getStartDate() : settings.getStartDate();
        Date date = dateEnd = settings.getEndDate() == null ? this.getEndDate() : settings.getEndDate();
        if (dateStart.after(dateEnd)) {
            Date tmp = (Date)dateStart.clone();
            dateStart = (Date)dateEnd.clone();
            dateEnd = tmp;
        }
        if ((chartWidth = (int)(((printedLength = this.getTaskManager().createLength(this.getViewState().getBottomTimeUnit(), dateStart, dateEnd)).getLength(this.getViewState().getBottomTimeUnit()) + 1.0f) * (float)this.getViewState().getBottomUnitWidth())) < this.getWidth()) {
            chartWidth = this.getWidth();
        }
        ResourceTreeImageGenerator resourceTreeGenerator = new ResourceTreeImageGenerator(this.getHumanResourceManager()){

            @Override
            protected boolean isAssignmentVisible(ResourceAssignment assignment) {
                AssignmentNode an = ResourceLoadGraphicArea.this.appli.getResourcePanel().getResourceTreeTableModel().getNodeForAssigment(assignment);
                return ResourceLoadGraphicArea.this.appli.getResourcePanel().getResourceTreeTable().isVisible(an);
            }

            @Override
            protected int getRowHeight() {
                return ResourceLoadGraphicArea.this.getRowHeight();
            }
        };
        BufferedImage resourceTreeImage = resourceTreeGenerator.createImage();
        int chartHeight = resourceTreeImage.getHeight();
        RenderedResourceChartImage renderedImage = new RenderedResourceChartImage(this.myChartModel, this.myChartImplementation, resourceTreeImage, chartWidth, chartHeight);
        return renderedImage;
    }

    private HumanResourceManager getHumanResourceManager() {
        return (HumanResourceManager)this.appli.getHumanResourceManager();
    }

    @Override
    public String getName() {
        return GanttLanguage.getInstance().getText("resourcesChart");
    }

    @Override
    public Date getStartDate() {
        return this.getTaskManager().getProjectStart();
    }

    @Override
    public Date getEndDate() {
        TaskLength projectLength = this.getTaskManager().getProjectLength();
        GanttCalendar pstart = new GanttCalendar(this.getTaskManager().getProjectStart());
        pstart.add((int)projectLength.getLength());
        GanttCalendar end = pstart.Clone();
        return end.getTime();
    }

    @Override
    protected ChartModelBase getChartModel() {
        return this.myChartModel;
    }

    @Override
    protected MouseListener getMouseListener() {
        if (this.myMouseListener == null) {
            this.myMouseListener = new ChartComponentBase.MouseListenerBase(){

                @Override
                protected Action[] getPopupMenuActions() {
                    return new Action[]{ResourceLoadGraphicArea.this.getOptionsDialogAction()};
                }
            };
        }
        return this.myMouseListener;
    }

    @Override
    protected MouseMotionListener getMouseMotionListener() {
        if (this.myMouseMotionListener == null) {
            this.myMouseMotionListener = new ChartComponentBase.MouseMotionListenerBase();
        }
        return this.myMouseMotionListener;
    }

    @Override
    protected ChartComponentBase.AbstractChartImplementation getImplementation() {
        return this.myChartImplementation;
    }

    @Override
    public boolean isExpanded(ProjectResource resource) {
        return true;
    }

    @Override
    public void setTaskManager(TaskManager taskManager) {
    }

    @Override
    public void reset() {
    }

    @Override
    public Icon getIcon() {
        return null;
    }
}

