/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttExportSettings;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTableConst;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTree2;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.font.Fonts;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIConfiguration;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.BlankLineNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.TextLengthCalculatorImpl;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;

class TaskTreeImageGenerator {
    private GanttTree2 myTreeView;
    private UIConfiguration myUIConfiguration;
    private int myWidth;
    private static final int HEADER_OFFSET = 0;

    TaskTreeImageGenerator(GanttTree2 treeView, UIConfiguration uiConfiguration) {
        this.myTreeView = treeView;
        this.myUIConfiguration = uiConfiguration;
    }

    private GanttTree2 getTree() {
        return this.myTreeView;
    }

    List getPrintableNodes(GanttExportSettings settings) {
        List<DefaultMutableTreeNode> myItemsToConsider = settings.isOnlySelectedItem() ? Arrays.asList(this.getTree().getSelectedNodes()) : this.getTree().getAllVisibleNodes();
        for (int i = 0; i < myItemsToConsider.size(); ++i) {
            if (!myItemsToConsider.get(i).isRoot()) continue;
            myItemsToConsider.remove(i);
            break;
        }
        return myItemsToConsider;
    }

    Image createImage(List myItemsToConsider) {
        BufferedImage tmpImage = new BufferedImage(10, 10, 1);
        FontMetrics fmetric = tmpImage.getGraphics().getFontMetrics(this.myUIConfiguration.getChartMainFont().deriveFont(15.0f));
        int fourEmWidth = fmetric.stringWidth("mmmm");
        int width = 0;
        int nameWidth = 150;
        int height = this.getTree().getTreeTable().getRowHeight() * 3 + 6;
        for (DefaultMutableTreeNode nextTreeNode : myItemsToConsider) {
            int nbchar;
            if (nextTreeNode instanceof BlankLineNode) {
                height += this.getTree().getTreeTable().getRowHeight();
                continue;
            }
            Task next = (Task)nextTreeNode.getUserObject();
            if ("None".equals(next.toString()) || !this.isVisible(next)) continue;
            height += this.getTree().getTreeTable().getRowHeight();
            String name = next.getName();
            if (name == null) {
                name = "";
            }
            if ((nbchar = fmetric.stringWidth(name) + next.getManager().getTaskHierarchy().getDepth(next) * fourEmWidth) <= nameWidth) continue;
            nameWidth = nbchar;
        }
        width += 50;
        width += nameWidth;
        width += 80;
        width += 120;
        width += 120;
        this.myWidth = width += 60;
        BufferedImage image2 = new BufferedImage(width, height, 1);
        Graphics g2 = image2.getGraphics();
        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, width, height);
        g2.setColor(Color.black);
        g2.setFont(Fonts.PRINT_CHART_FONT);
        int y = this.printTask(g2, myItemsToConsider, nameWidth);
        g2.setColor(Color.GRAY);
        g2.drawLine(width - 1, y - 1, width - 1, this.getTree().getTable().getTableHeader().getHeight() + 4);
        return image2;
    }

    private int getWidth() {
        return this.myWidth;
    }

    private void printTasks(Graphics g, List taskNodes, int nameWidth) {
        g.setColor(Color.black);
        g.setFont(Fonts.PRINT_CHART_FONT);
        this.printTask(g, taskNodes, nameWidth);
    }

    private int printTask(Graphics g, List child, int nameWidth) {
        int y;
        int rowCount = 0;
        int h = this.getTree().getTreeTable().getRowHeight();
        Stack<DefaultMutableTreeNode> nestingStack = new Stack<DefaultMutableTreeNode>();
        int fourEmWidth = new TextLengthCalculatorImpl(g).getTextLength("mmmm");
        int headerHeight = y = this.getTree().getTable().getTableHeader().getHeight() + 4;
        g.setColor(GanttTableConst.headerBgColor_1);
        g.fillRect(0, 0, this.getWidth(), y);
        g.setColor(Color.GRAY);
        g.drawRect(0, 0, 50, y);
        g.setColor(Color.black);
        g.drawString(GanttResourceUtil.getResource("GANTT_SERISE_NUM"), 10, y - 20);
        g.setColor(Color.GRAY);
        g.drawRect(50, 0, nameWidth, y);
        g.setColor(Color.black);
        g.drawString(GanttResourceUtil.getResource("GANTT_TASK_NAME"), 70, y - 20);
        g.setColor(Color.GRAY);
        g.drawRect(nameWidth + 50, 0, 80, y);
        g.setColor(Color.black);
        g.drawString(GanttResourceUtil.getResource("Gantt_Work"), nameWidth + 70, y - 20);
        g.setColor(Color.GRAY);
        g.drawRect(nameWidth + 130, 0, 120, y);
        g.setColor(Color.black);
        g.drawString(GanttResourceUtil.getResource("GANTT_PLAN_BEGIN_TIME"), nameWidth + 150, y - 20);
        g.setColor(Color.GRAY);
        g.drawRect(nameWidth + 250, 0, 120, y);
        g.setColor(Color.black);
        g.drawString(GanttResourceUtil.getResource("GANTT_PLAN_END_TIME"), nameWidth + 270, y - 20);
        g.setColor(Color.GRAY);
        g.drawRect(nameWidth + 370, 0, 60, y);
        g.setColor(Color.black);
        g.drawString(GanttResourceUtil.getResource("GANTT_COMPLETEPERCENTEGE"), nameWidth + 380, y - 20);
        for (DefaultMutableTreeNode nextTreeNode : child) {
            boolean blankline = nextTreeNode instanceof BlankLineNode;
            Task next = null;
            if (!blankline) {
                next = (Task)nextTreeNode.getUserObject();
                while (!nestingStack.isEmpty()) {
                    DefaultMutableTreeNode topStackNode = (DefaultMutableTreeNode)nestingStack.pop();
                    if (nextTreeNode.getParent() != topStackNode) continue;
                    nestingStack.push(topStackNode);
                    break;
                }
                nestingStack.push(nextTreeNode);
            }
            if (!blankline && !this.isVisible(next)) continue;
            if (rowCount % 2 == 1) {
                g.setColor(new Color(0.933f, 0.933f, 0.933f));
                g.fillRect(0, y, this.getWidth(), h);
            }
            g.setColor(Color.black);
            if (!blankline) {
                String name = null;
                if (next != null) {
                    name = next.getName();
                }
                if (name == null) {
                    name = "";
                }
                int charH = (int)g.getFontMetrics().getLineMetrics(name, g).getAscent();
                int x = (nestingStack.size() - 1) * fourEmWidth + 5;
                g.drawString("" + (rowCount + 1), 10, y + charH + (h - charH) / 2);
                g.drawString(name, 60 + x, y + charH + (h - charH) / 2);
                if (next != null) {
                    g.drawString(next.getDuration().getLength() + GanttResourceUtil.getResource("GANTT_WORKDATE"), nameWidth + 60, y + charH + (h - charH) / 2);
                    Date start = next.getStart().getTime();
                    Date end = next.getEnd().getTime();
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    g.drawString(format.format(start), nameWidth + 140, y + charH + (h - charH) / 2);
                    g.drawString(format.format(end), nameWidth + 260, y + charH + (h - charH) / 2);
                    BigDecimal completePercentage = new BigDecimal(next.getCompletionPercentage());
                    BigDecimal res = completePercentage.setScale(2, 4);
                    g.drawString(res.toString(), nameWidth + 380, y + charH + (h - charH) / 2);
                }
            }
            g.setColor(new Color(0.807f, 0.807f, 0.807f));
            g.setColor(Color.GRAY);
            g.drawLine(1, y + h - 1, this.getWidth(), y + h - 1);
            g.setColor(Color.black);
            y += h;
            ++rowCount;
        }
        g.setColor(Color.GRAY);
        g.drawLine(50, headerHeight, 50, y - 1);
        g.drawLine(nameWidth + 50, headerHeight, nameWidth + 50, y - 1);
        g.drawLine(nameWidth + 130, headerHeight, nameWidth + 130, y - 1);
        g.drawLine(nameWidth + 250, headerHeight, nameWidth + 250, y - 1);
        g.drawLine(nameWidth + 370, headerHeight, nameWidth + 370, y - 1);
        return y;
    }

    private boolean isVisible(Task thetask) {
        boolean res = true;
        DefaultMutableTreeNode father = this.getTree().getFatherNode(thetask);
        if (father == null) {
            return false;
        }
        while (father != null) {
            Task taskFather = (Task)father.getUserObject();
            if (!taskFather.getExpand()) {
                res = false;
            }
            father = (DefaultMutableTreeNode)father.getParent();
        }
        return res;
    }
}

