/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject;

import com.kingdee.eas.mm.mo.client.ManufactureOrderScheduleUI;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.ErrorNotifier;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.CancelAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.OkAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.Chart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.chart.GanttChart;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.IProgressMonitor;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.jobs.Job;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.eclipseito.jobs.ProgressProvider;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.DialogAligner;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GanttDialogInfo;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GanttStatusBar;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.scrolling.ScrollingManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.scrolling.ScrollingManagerImpl;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.zoom.ZoomManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.undo.GPUndoManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

class UIFacadeImpl
extends ProgressProvider
implements UIFacade {
    private final JFrame myMainFrame;
    private final ScrollingManager myScrollingManager;
    private final ZoomManager myZoomManager;
    private final GanttStatusBar myStatusBar;
    private final UIFacade myFallbackDelegate;
    private final GanttLanguage i18n = GanttLanguage.getInstance();
    private final ErrorNotifier myErrorNotifier;

    UIFacadeImpl(JFrame mainFrame, GanttStatusBar statusBar, IGanttProject project, UIFacade fallbackDelegate) {
        this.myMainFrame = mainFrame;
        this.myScrollingManager = new ScrollingManagerImpl();
        this.myZoomManager = new ZoomManager(project.getTimeUnitStack());
        this.myStatusBar = statusBar;
        this.myFallbackDelegate = fallbackDelegate;
        this.myErrorNotifier = new ErrorNotifier(this);
    }

    @Override
    public ScrollingManager getScrollingManager() {
        return this.myScrollingManager;
    }

    @Override
    public ZoomManager getZoomManager() {
        return this.myZoomManager;
    }

    @Override
    public GPUndoManager getUndoManager() {
        return this.myFallbackDelegate.getUndoManager();
    }

    @Override
    public UIFacade.Choice showConfirmationDialog(String message, String title) {
        String yes = GanttLanguage.getInstance().getText("yes");
        String no = GanttLanguage.getInstance().getText("no");
        String cancel = GanttLanguage.getInstance().getText("cancel");
        int result = JOptionPane.showOptionDialog(this.myMainFrame, message, title, 1, 3, null, new String[]{yes, no, cancel}, yes);
        switch (result) {
            case 0: {
                return UIFacade.Choice.YES;
            }
            case 1: {
                return UIFacade.Choice.NO;
            }
            case 2: {
                return UIFacade.Choice.CANCEL;
            }
            case -1: {
                return UIFacade.Choice.CANCEL;
            }
        }
        return UIFacade.Choice.CANCEL;
    }

    @Override
    public JPopupMenu showPopupMenu(Component invoker, Action[] actions, int x, int y) {
        if (this.myFallbackDelegate instanceof ManufactureOrderScheduleUI) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        for (int i = 0; i < actions.length; ++i) {
            Action next = actions[i];
            if (next == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(next);
        }
        menu.applyComponentOrientation(UIFacadeImpl.getLanguage().getComponentOrientation());
        menu.show(invoker, x, y);
        return menu;
    }

    @Override
    public void showDialog(Component content, Action[] buttonActions) {
        this.showDialog(content, buttonActions, "");
    }

    @Override
    public void showDialog(Component content, Action[] buttonActions, String title) {
        JDialog result = new JDialog((Frame)this.myMainFrame, true);
        result.setTitle(title);
        final Commiter commiter = new Commiter();
        Action okAction = null;
        Action cancelAction = null;
        Box buttonBox = Box.createHorizontalBox();
        for (int i = 0; i < buttonActions.length; ++i) {
            Action nextAction = buttonActions[i];
            JButton nextButton = null;
            if (nextAction instanceof OkAction) {
                okAction = nextAction = this.createOkAction(nextAction, result, commiter);
                nextButton = new JButton(nextAction);
                result.getRootPane().setDefaultButton(nextButton);
            }
            if (nextAction instanceof CancelAction) {
                cancelAction = nextAction = this.createCancelAction(nextAction, result, commiter);
                result.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), nextAction.getValue("Name"));
                result.getRootPane().getActionMap().put(nextAction.getValue("Name"), nextAction);
            }
            if (nextButton == null) {
                nextButton = new JButton(nextAction);
            }
            buttonBox.add(nextButton);
            if (i >= buttonActions.length - 1) continue;
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        result.getContentPane().setLayout(new BorderLayout());
        result.getContentPane().add(content, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        buttonPanel.add((Component)buttonBox, "East");
        result.getContentPane().add((Component)buttonPanel, "South");
        result.setDefaultCloseOperation(2);
        Action localOkAction = okAction;
        final Action localCancelAction = cancelAction;
        result.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (localCancelAction != null && !commiter.isCommited()) {
                    localCancelAction.actionPerformed(null);
                }
            }
        });
        result.pack();
        DialogAligner.center(result, this.myMainFrame);
        result.setVisible(true);
    }

    @Override
    public void setStatusText(String text) {
        this.myStatusBar.setFirstText(text, 2000);
    }

    @Override
    public void showErrorDialog(String errorMessage) {
        if (this.myMainFrame.isVisible()) {
            GanttDialogInfo gdi = new GanttDialogInfo(this.myMainFrame, 0, 0, errorMessage, UIFacadeImpl.getLanguage().getText("error"));
            gdi.show();
        } else {
            System.err.println("[GanttProjectBase] showErrorDialog:\n message");
        }
    }

    @Override
    public void showErrorDialog(Throwable e) {
        this.showErrorDialog(UIFacadeImpl.getExceptionReport(e));
    }

    @Override
    public void logErrorMessage(Exception e) {
        this.myErrorNotifier.add(e);
        this.myStatusBar.setErrorNotifier(this.myErrorNotifier);
    }

    void resetErrorLog() {
        this.myStatusBar.setErrorNotifier(null);
    }

    private Component createDialogContentComponent(int dialogType, String message) {
        JLabel label;
        switch (dialogType) {
            case 0: {
                label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/error.png")));
                break;
            }
            case 1: {
                label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/warning.png")));
                break;
            }
            case 2: {
                label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/info.png")));
                break;
            }
            case 3: {
                label = new JLabel(new ImageIcon(this.getClass().getResource("/icons/question.png")));
                break;
            }
            default: {
                throw new IllegalStateException("We should not be here");
            }
        }
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.add((Component)label, "North");
        JTextArea textArea = new JTextArea(message);
        textArea.setEditable(false);
        textArea.setBackground(new JLabel().getBackground());
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)imagePanel, "West");
        result.add((Component)textArea, "Center");
        return result;
    }

    @Override
    public GanttChart getGanttChart() {
        return this.myFallbackDelegate.getGanttChart();
    }

    @Override
    public Chart getResourceChart() {
        return this.myFallbackDelegate.getResourceChart();
    }

    @Override
    public Chart getActiveChart() {
        return this.myFallbackDelegate.getActiveChart();
    }

    @Override
    public int getViewIndex() {
        return this.myFallbackDelegate.getViewIndex();
    }

    @Override
    public void setViewIndex(int viewIndex) {
        this.myFallbackDelegate.setViewIndex(viewIndex);
    }

    @Override
    public int getGanttDividerLocation() {
        return this.myFallbackDelegate.getGanttDividerLocation();
    }

    @Override
    public void setGanttDividerLocation(int location) {
        this.myFallbackDelegate.setGanttDividerLocation(location);
    }

    @Override
    public int getResourceDividerLocation() {
        return this.myFallbackDelegate.getResourceDividerLocation();
    }

    @Override
    public void setResourceDividerLocation(int location) {
        this.myFallbackDelegate.setResourceDividerLocation(location);
    }

    @Override
    public void refresh() {
        this.myFallbackDelegate.refresh();
    }

    @Override
    public JFrame getMainFrame() {
        return this.myMainFrame;
    }

    private Action createOkAction(Action realAction, JDialog dialog, Commiter commiter) {
        return new ProxyOkAction(realAction, dialog, commiter);
    }

    private Action createCancelAction(final Action realAction, final JDialog result, final Commiter commiter) {
        return new CancelAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                realAction.actionPerformed(e);
                commiter.commit();
                result.setVisible(false);
                result.dispose();
            }
        };
    }

    private static GanttLanguage getLanguage() {
        return GanttLanguage.getInstance();
    }

    static String getExceptionReport(Throwable e) {
        StringBuffer result = new StringBuffer();
        result.append(e.getMessage() + "\n\n");
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        writer.close();
        result.append(stringWriter.getBuffer().toString());
        return result.toString();
    }

    @Override
    public void setWorkbenchTitle(String title) {
        this.myMainFrame.setTitle(title);
    }

    @Override
    public IProgressMonitor createMonitor(Job job) {
        return this.myStatusBar.createProgressMonitor();
    }

    @Override
    public IProgressMonitor createProgressGroup() {
        return this.myStatusBar.createProgressMonitor();
    }

    @Override
    public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
        return group;
    }

    @Override
    public IProgressMonitor getDefaultMonitor() {
        return null;
    }

    private class ProxyOkAction
    extends OkAction
    implements PropertyChangeListener {
        private Action myRealAction;
        private JDialog myDialog;
        private Commiter myCommiter;

        private ProxyOkAction(Action realAction, JDialog dialog, Commiter commiter) {
            realAction.addPropertyChangeListener(this);
            this.myRealAction = realAction;
            this.myDialog = dialog;
            this.myCommiter = commiter;
            this.setEnabled(realAction.isEnabled());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myRealAction.removePropertyChangeListener(this);
            this.myRealAction.actionPerformed(e);
            this.myCommiter.commit();
            if (this.myDialog.isVisible()) {
                this.myDialog.setVisible(false);
                this.myDialog.dispose();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(this.myRealAction.isEnabled());
        }
    }

    private static class Commiter {
        private boolean isCommited;

        private Commiter() {
        }

        void commit() {
            this.isCommited = true;
        }

        boolean isCommited() {
            return this.isCommited;
        }
    }

    class MyDialog {
        boolean result;
        final Component contentComponent;
        final OkAction okAction = new OkAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyDialog.this.result = true;
            }
        };
        final CancelAction cancelAction = new CancelAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };

        MyDialog(int dialogType, String message) {
            this.contentComponent = UIFacadeImpl.this.createDialogContentComponent(dialogType, message);
        }

        void show() {
            UIFacadeImpl.this.showDialog(this.contentComponent, new Action[]{this.okAction, this.cancelAction});
        }
    }
}

