/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.RolloverAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class GPAction
extends AbstractAction
implements RolloverAction,
GanttLanguage.Listener {
    public static final int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected boolean iconVisible = true;
    protected Icon myIcon = null;
    private static Properties ourProperties;

    protected GPAction() {
        this(null, "16");
    }

    protected GPAction(String name, String iconSize) {
        super(name);
        this.setIconSize(iconSize);
        this.updateName();
        this.updateTooltip();
        GanttLanguage.getInstance().addListener(this);
    }

    public GPAction(String name) {
        this(name, "16");
    }

    @Override
    public Icon getIconOnMouseOver() {
        return (Icon)this.getValue("SmallIcon");
    }

    @Override
    public void setIconSize(String iconSize) {
        Icon icon = this.createIcon(iconSize);
        if (icon != null) {
            this.putValue("SmallIcon", icon);
            this.myIcon = icon;
        }
    }

    protected Icon createIcon(String iconSize) {
        if (iconSize == null || !this.iconVisible) {
            return null;
        }
        URL resource = this.getClass().getResource(this.getIconFileDirectory() + "/" + this.getIconFilePrefix() + iconSize + ".gif");
        return resource == null ? null : new ImageIcon(resource);
    }

    protected String getIconFileDirectory() {
        return "/icons";
    }

    protected String getLocalizedName() {
        return "";
    }

    protected String getTooltipText() {
        String localizedName = this.getLocalizedName();
        return localizedName == null ? "" : GanttLanguage.getInstance().correctLabel(this.getLocalizedName());
    }

    protected String getI18n(String key) {
        return GanttLanguage.getInstance().getText(key);
    }

    protected abstract String getIconFilePrefix();

    public void setIconVisible(boolean isVisible) {
        this.iconVisible = isVisible;
        this.putValue("SmallIcon", this.iconVisible ? this.myIcon : null);
    }

    private void updateName() {
        String localizedName = this.getLocalizedName();
        if (localizedName == null) {
            localizedName = String.valueOf(this.getValue("Name"));
        }
        if (localizedName != null) {
            int bucksPos = localizedName.indexOf(36);
            if (bucksPos >= 0) {
                localizedName = new StringBuffer(localizedName).deleteCharAt(bucksPos).toString();
            }
            this.putValue("Name", localizedName);
            if (bucksPos >= 0) {
                this.putValue("MnemonicKey", new Integer(Character.toLowerCase(localizedName.charAt(bucksPos))));
            }
        }
    }

    private void updateTooltip() {
        this.putValue("ShortDescription", this.getTooltipText());
    }

    @Override
    public void isIconVisible(boolean isNull) {
        this.setIconVisible(isNull);
    }

    @Override
    public void languageChanged(GanttLanguage.Event event) {
        this.updateName();
        this.updateTooltip();
    }
}

