/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.GanttTask;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.GPAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.Task;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskNode;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.TaskSelectionManager;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.AdjustTaskBoundsAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.algorithm.RecalculateTaskScheduleAlgorithm;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.task.dependency.TaskDependencyException;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.util.GanttResourceUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SubNetViewAction
extends GPAction {
    GanttProject mainFrame;

    public SubNetViewAction(GanttProject myFainFrame) {
        super("saveProject", "");
        this.mainFrame = myFainFrame;
    }

    @Override
    protected String getLocalizedName() {
        return GanttResourceUtil.getResource("Gantt_SubView");
    }

    @Override
    protected String getTooltipText() {
        return GanttResourceUtil.getResource("Gantt_SubView");
    }

    @Override
    protected String getIconFilePrefix() {
        return "tbtn_View";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            TaskSelectionManager selectionManager = this.mainFrame.getTaskSelectionManager();
            int i = selectionManager.getSelectedTasks().size();
            if (i == 0) {
                return;
            }
            if (i > 1) {
                MsgBox.showWarning((String)GanttResourceUtil.getResource("Gantt_MoreTask"));
            }
            this.mainFrame.gatherAction.actionPerformed(null);
            Task task = (Task)selectionManager.getSelectedTasks().get(0);
            GanttProject project = new GanttProject(true);
            TaskNode rootNode = (TaskNode)project.getTree().getTreeTable().getTreeTableModel().getRoot();
            TaskNode[] cdmtn = new TaskNode[1];
            int taskID = task.getTaskID();
            Enumeration<TreeNode> em = rootNode.preorderEnumeration();
            while (em.hasMoreElements()) {
                DefaultMutableTreeNode res = (DefaultMutableTreeNode)em.nextElement();
                if (!(res instanceof TaskNode) || ((Task)res.getUserObject()).getTaskID() != taskID) continue;
                cdmtn[0] = (TaskNode)res;
                break;
            }
            while (cdmtn[0].getLevel() != 1 && cdmtn[0].getLevel() != 0) {
                this.nodeLeftMove(project, cdmtn);
            }
            ArrayList deleteNodes = new ArrayList();
            this.addDeleteNode(rootNode, deleteNodes, taskID);
            this.deleteNode(project, deleteNodes);
            project.getTree().getTreetable().expandAll();
            project.show();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void addDeleteNode(TaskNode rootNode, List deleteNodes, int taskID) {
        Enumeration<TreeNode> em = rootNode.preorderEnumeration();
        int level = -1;
        while (em.hasMoreElements()) {
            TaskNode temp;
            DefaultMutableTreeNode res = (DefaultMutableTreeNode)em.nextElement();
            if (!(res instanceof TaskNode) || (temp = (TaskNode)res).isRoot()) continue;
            if (((Task)res.getUserObject()).getTaskID() == taskID) {
                level = temp.getLevel();
                continue;
            }
            if (level >= temp.getLevel()) {
                level = -1;
            }
            if (level != -1) continue;
            deleteNodes.add(res);
        }
    }

    public void deleteNode(GanttProject project, List deleteNodes) {
        int i;
        ArrayList<DefaultMutableTreeNode> fathers = new ArrayList<DefaultMutableTreeNode>();
        for (i = 0; i < deleteNodes.size(); ++i) {
            if (deleteNodes.get(i) == null || !(deleteNodes.get(i) instanceof TaskNode)) continue;
            Task ttask = (Task)((TaskNode)deleteNodes.get(i)).getUserObject();
            project.getTaskManager().deleteTask(ttask);
            ttask.delete();
            DefaultMutableTreeNode father = project.getTree().getFatherNode(ttask);
            project.getTree().removeCurrentNode((DefaultMutableTreeNode)deleteNodes.get(i));
            if (father == null) continue;
            GanttTask taskFather = (GanttTask)father.getUserObject();
            AdjustTaskBoundsAlgorithm alg = project.getTaskManager().getAlgorithmCollection().getAdjustTaskBoundsAlgorithm();
            alg.run(taskFather);
            father.setUserObject(taskFather);
            fathers.add(father);
        }
        for (i = 0; i < fathers.size(); ++i) {
            DefaultMutableTreeNode father = (DefaultMutableTreeNode)fathers.get(i);
            if (father.getChildCount() != 0) continue;
            ((Task)father.getUserObject()).setProjectTask(false);
        }
    }

    public void nodeLeftMove(GanttProject project, TaskNode[] cdmtn) {
        TreePath[] selectedPaths = new TreePath[cdmtn.length];
        for (int i = 0; i < cdmtn.length; ++i) {
            TreePath path;
            DefaultMutableTreeNode father = project.getTree().getFatherNode(cdmtn[i]);
            DefaultMutableTreeNode newFather = project.getTree().getFatherNode(father);
            if (newFather == null) {
                return;
            }
            int oldIndex = father.getIndex(cdmtn[i]);
            cdmtn[i].removeFromParent();
            project.getTree().getTreeModel().nodesWereRemoved(father, new int[]{oldIndex}, new Object[]{cdmtn});
            project.getTree().getTreeModel().insertNodeInto(cdmtn[i], newFather, newFather.getIndex(father) + 1);
            Object[] treepath = cdmtn[i].getPath();
            selectedPaths[i] = path = new TreePath(treepath);
            this.expandRefresh(cdmtn[i]);
            this.forwardScheduling();
            if (father.getChildCount() != 0) continue;
            ((Task)father.getUserObject()).setProjectTask(false);
        }
    }

    public void expandRefresh(DefaultMutableTreeNode moved) {
        if (moved instanceof TaskNode) {
            Task movedTask = (Task)moved.getUserObject();
            if (movedTask.getExpand()) {
                this.mainFrame.getTree().getTreetable().getTree().expandPath(new TreePath(moved.getPath()));
            }
            Enumeration<TreeNode> children = moved.children();
            while (children.hasMoreElements()) {
                this.expandRefresh((DefaultMutableTreeNode)children.nextElement());
            }
        }
    }

    public void forwardScheduling() {
        RecalculateTaskScheduleAlgorithm alg = this.mainFrame.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm();
        try {
            alg.run();
        }
        catch (TaskDependencyException e) {
            e.printStackTrace();
        }
    }

    public void projectModified() {
        this.setEnabled(true);
    }

    public void projectSaved() {
        this.setEnabled(false);
    }

    public void projectClosed() {
        this.setEnabled(false);
    }
}

