/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.resource;

import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.IGanttProject;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.action.GPAction;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.GanttDialogPerson;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.gui.UIFacade;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.language.GanttLanguage;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.HumanResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ProjectResource;
import com.kingdee.eas.mm.project.client.gantt.net.sourceforge.ganttproject.resource.ResourceContext;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ResourcePropertiesAction
extends GPAction {
    private final IGanttProject myProject;
    private final UIFacade myUIFacade;
    private HumanResource mySelectedResource;

    public ResourcePropertiesAction(IGanttProject project, UIFacade uiFacade) {
        this.myProject = project;
        this.myUIFacade = uiFacade;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 512));
    }

    @Override
    protected String getLocalizedName() {
        return this.getI18n("propertiesHuman");
    }

    @Override
    protected String getTooltipText() {
        return this.getI18n("propertiesHuman");
    }

    @Override
    protected String getIconFilePrefix() {
        return "properties_";
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.getSelectedResource() != null) {
            GanttDialogPerson dp = new GanttDialogPerson(this.getUIFacade(), GanttLanguage.getInstance(), this.getSelectedResource());
            dp.setVisible(true);
            if (dp.result()) {
                this.getProject().setModified(true);
            }
        }
    }

    private IGanttProject getProject() {
        return this.myProject;
    }

    private UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    private HumanResource getSelectedResource() {
        return this.mySelectedResource;
    }

    public void setContext(ResourceContext context) {
        ProjectResource[] resources = context.getResources();
        if (resources.length == 1) {
            this.mySelectedResource = (HumanResource)resources[0];
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

